/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.repositories.InactiveSessionException;
import org.mozilla.gecko.sync.repositories.InvalidSessionTransitionException;
import org.mozilla.gecko.sync.repositories.NoStoreDelegateException;
import org.mozilla.gecko.sync.repositories.Repository;
import org.mozilla.gecko.sync.repositories.RepositorySessionBundle;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionBeginDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionFetchRecordsDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionFinishDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionGuidsSinceDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionStoreDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionWipeDelegate;
import org.mozilla.gecko.sync.repositories.domain.Record;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RepositorySession {
    private static final String LOG_TAG = "RepositorySession";
    private SessionStatus status = SessionStatus.UNSTARTED;
    protected Repository repository;
    protected RepositorySessionStoreDelegate delegate;
    protected ExecutorService delegateQueue = Executors.newSingleThreadExecutor();
    protected ExecutorService storeWorkQueue = Executors.newSingleThreadExecutor();
    private long lastSyncTimestamp = 0L;

    protected static void trace(String string2) {
        Logger.trace(LOG_TAG, string2);
    }

    public long getLastSyncTimestamp() {
        return this.lastSyncTimestamp;
    }

    public static long now() {
        return System.currentTimeMillis();
    }

    public RepositorySession(Repository repository) {
        this.repository = repository;
    }

    public abstract void guidsSince(long var1, RepositorySessionGuidsSinceDelegate var3);

    public abstract void fetchSince(long var1, RepositorySessionFetchRecordsDelegate var3);

    public abstract void fetch(String[] var1, RepositorySessionFetchRecordsDelegate var2) throws InactiveSessionException;

    public abstract void fetchAll(RepositorySessionFetchRecordsDelegate var1);

    public boolean dataAvailable() {
        return true;
    }

    public boolean shouldSkip() {
        return false;
    }

    public void setStoreDelegate(RepositorySessionStoreDelegate repositorySessionStoreDelegate) {
        Logger.debug(LOG_TAG, "Setting store delegate to " + repositorySessionStoreDelegate);
        this.delegate = repositorySessionStoreDelegate;
    }

    public abstract void store(Record var1) throws NoStoreDelegateException;

    public void storeDone() {
        this.storeDone(RepositorySession.now());
    }

    public void storeDone(final long l) {
        Logger.debug(LOG_TAG, "Scheduling onStoreCompleted for after storing is done: " + l);
        Runnable runnable = new Runnable(){

            public void run() {
                RepositorySession.this.delegate.onStoreCompleted(l);
            }
        };
        this.storeWorkQueue.execute(runnable);
    }

    public abstract void wipe(RepositorySessionWipeDelegate var1);

    protected void sharedBegin() throws InvalidSessionTransitionException {
        Logger.debug(LOG_TAG, "Shared begin.");
        if (this.delegateQueue.isShutdown()) {
            throw new InvalidSessionTransitionException(null);
        }
        if (this.storeWorkQueue.isShutdown()) {
            throw new InvalidSessionTransitionException(null);
        }
        this.transitionFrom(SessionStatus.UNSTARTED, SessionStatus.ACTIVE);
    }

    public void begin(RepositorySessionBeginDelegate repositorySessionBeginDelegate) throws InvalidSessionTransitionException {
        this.sharedBegin();
        repositorySessionBeginDelegate.deferredBeginDelegate(this.delegateQueue).onBeginSucceeded(this);
    }

    public void unbundle(RepositorySessionBundle repositorySessionBundle) {
        this.lastSyncTimestamp = repositorySessionBundle == null ? 0L : repositorySessionBundle.getTimestamp();
    }

    protected RepositorySessionBundle getBundle() {
        long l = this.getLastSyncTimestamp();
        RepositorySessionBundle repositorySessionBundle = new RepositorySessionBundle(l);
        Logger.debug(LOG_TAG, "Setting bundle timestamp to " + l + ".");
        return repositorySessionBundle;
    }

    public void abort(RepositorySessionFinishDelegate repositorySessionFinishDelegate) {
        this.abort();
        repositorySessionFinishDelegate.deferredFinishDelegate(this.delegateQueue).onFinishSucceeded(this, this.getBundle());
    }

    public void abort() {
        this.setStatus(SessionStatus.ABORTED);
        try {
            this.storeWorkQueue.shutdownNow();
        }
        catch (Exception exception) {
            Logger.error(LOG_TAG, "Caught exception shutting down store work queue.", exception);
        }
        try {
            this.delegateQueue.shutdown();
        }
        catch (Exception exception) {
            Logger.error(LOG_TAG, "Caught exception shutting down delegate queue.", exception);
        }
    }

    public void finish(RepositorySessionFinishDelegate repositorySessionFinishDelegate) throws InactiveSessionException {
        try {
            this.transitionFrom(SessionStatus.ACTIVE, SessionStatus.DONE);
            repositorySessionFinishDelegate.deferredFinishDelegate(this.delegateQueue).onFinishSucceeded(this, this.getBundle());
        }
        catch (InvalidSessionTransitionException invalidSessionTransitionException) {
            Logger.error(LOG_TAG, "Tried to finish() an unstarted or already finished session");
            throw new InactiveSessionException(invalidSessionTransitionException);
        }
        Logger.trace(LOG_TAG, "Shutting down work queues.");
        this.storeWorkQueue.shutdown();
        this.delegateQueue.shutdown();
    }

    protected synchronized void executeDelegateCommand(Runnable runnable) throws InactiveSessionException {
        if (!this.isActive() || this.delegateQueue.isShutdown()) {
            throw new InactiveSessionException(null);
        }
        this.delegateQueue.execute(runnable);
    }

    public synchronized void ensureActive() throws InactiveSessionException {
        if (!this.isActive()) {
            throw new InactiveSessionException(null);
        }
    }

    public synchronized boolean isActive() {
        return this.status == SessionStatus.ACTIVE;
    }

    public synchronized SessionStatus getStatus() {
        return this.status;
    }

    public synchronized void setStatus(SessionStatus sessionStatus) {
        this.status = sessionStatus;
    }

    public synchronized void transitionFrom(SessionStatus sessionStatus, SessionStatus sessionStatus2) throws InvalidSessionTransitionException {
        if (sessionStatus == null || this.status == sessionStatus) {
            Logger.trace(LOG_TAG, "Successfully transitioning from " + (Object)((Object)this.status) + " to " + (Object)((Object)sessionStatus2));
            this.status = sessionStatus2;
            return;
        }
        Logger.warn(LOG_TAG, "Wanted to transition from " + (Object)((Object)sessionStatus) + " but in state " + (Object)((Object)this.status));
        throw new InvalidSessionTransitionException(null);
    }

    protected Record reconcileRecords(Record record, Record record2, long l, long l2) {
        Logger.debug(LOG_TAG, "Reconciling remote " + record.guid + " against local " + record2.guid);
        if (record2.equalPayloads(record)) {
            if (record.lastModified > record2.lastModified) {
                Logger.debug(LOG_TAG, "Records are equal. No record application needed.");
                return null;
            }
            return null;
        }
        boolean bl = record2.lastModified > record.lastModified;
        Logger.debug(LOG_TAG, "Local record is more recent? " + bl);
        Record record3 = bl ? record2 : record;
        Record record4 = record3.copyWithIDs(record.guid, record2.androidID);
        if (!bl) {
            this.trackGUID(record4.guid);
        }
        return record4;
    }

    protected void trackGUID(String string2) {
    }

    protected synchronized void untrackGUIDs(Collection<String> collection) {
    }

    protected void untrackGUID(String string2) {
    }

    public Iterator<String> getTrackedRecordIDs() {
        return new ArrayList().iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SessionStatus {
        UNSTARTED,
        ACTIVE,
        ABORTED,
        DONE;

    }
}

