/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.android;

import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteConstraintException;
import android.net.Uri;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.json.simple.JSONArray;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.repositories.InactiveSessionException;
import org.mozilla.gecko.sync.repositories.InvalidSessionTransitionException;
import org.mozilla.gecko.sync.repositories.NoGuidForIdException;
import org.mozilla.gecko.sync.repositories.NullCursorException;
import org.mozilla.gecko.sync.repositories.ParentNotFoundException;
import org.mozilla.gecko.sync.repositories.Repository;
import org.mozilla.gecko.sync.repositories.android.AndroidBrowserBookmarksDataAccessor;
import org.mozilla.gecko.sync.repositories.android.AndroidBrowserRepositorySession;
import org.mozilla.gecko.sync.repositories.android.BookmarksDeletionManager;
import org.mozilla.gecko.sync.repositories.android.BookmarksInsertionManager;
import org.mozilla.gecko.sync.repositories.android.BrowserContractHelpers;
import org.mozilla.gecko.sync.repositories.android.RepoUtils;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionBeginDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionFinishDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionStoreDelegate;
import org.mozilla.gecko.sync.repositories.delegates.RepositorySessionWipeDelegate;
import org.mozilla.gecko.sync.repositories.domain.BookmarkRecord;
import org.mozilla.gecko.sync.repositories.domain.Record;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndroidBrowserBookmarksRepositorySession
extends AndroidBrowserRepositorySession
implements BookmarksInsertionManager.BookmarkInserter {
    public static final int DEFAULT_DELETION_FLUSH_THRESHOLD = 50;
    public static final int DEFAULT_INSERTION_FLUSH_THRESHOLD = 50;
    private HashMap<String, Long> parentGuidToIDMap = new HashMap();
    private HashMap<Long, String> parentIDToGuidMap = new HashMap();
    private HashMap<String, ArrayList<String>> missingParentToChildren = new HashMap();
    private HashMap<String, JSONArray> parentToChildArray = new HashMap();
    private int needsReparenting = 0;
    private AndroidBrowserBookmarksDataAccessor dataAccessor;
    protected BookmarksDeletionManager deletionManager;
    protected BookmarksInsertionManager insertionManager;
    public static String[] SPECIAL_GUIDS = new String[]{"places", "mobile", "toolbar", "menu", "unfiled"};
    public static final Map<String, String> SPECIAL_GUID_PARENTS;
    public static Map<String, String> SPECIAL_GUIDS_MAP;

    public static boolean forbiddenGUID(String string2) {
        return string2 == null || "readinglist".equals(string2) || "pinned".equals(string2) || "places".equals(string2) || "tags".equals(string2);
    }

    public static boolean forbiddenParent(String string2) {
        return string2 == null || "readinglist".equals(string2) || "pinned".equals(string2);
    }

    public AndroidBrowserBookmarksRepositorySession(Repository repository, Context context) {
        super(repository);
        if (SPECIAL_GUIDS_MAP == null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("mobile", "mobile");
            hashMap.put("menu", context.getString(R.string.bookmarks_folder_menu));
            hashMap.put("places", context.getString(R.string.bookmarks_folder_places));
            hashMap.put("toolbar", context.getString(R.string.bookmarks_folder_toolbar));
            hashMap.put("unfiled", context.getString(R.string.bookmarks_folder_unfiled));
            SPECIAL_GUIDS_MAP = Collections.unmodifiableMap(hashMap);
        }
        this.dbHelper = new AndroidBrowserBookmarksDataAccessor(context);
        this.dataAccessor = (AndroidBrowserBookmarksDataAccessor)this.dbHelper;
    }

    private static int getTypeFromCursor(Cursor cursor) {
        return RepoUtils.getIntFromCursor(cursor, "type");
    }

    private static boolean rowIsFolder(Cursor cursor) {
        return AndroidBrowserBookmarksRepositorySession.getTypeFromCursor(cursor) == 0;
    }

    private String getGUIDForID(long l) {
        String string2 = this.parentIDToGuidMap.get(l);
        AndroidBrowserBookmarksRepositorySession.trace("  " + l + " => " + string2);
        return string2;
    }

    private long getIDForGUID(String string2) {
        Long l = this.parentGuidToIDMap.get(string2);
        if (l == null) {
            Logger.warn("BrowserRepoSession", "Couldn't find local ID for GUID " + string2);
            return -1L;
        }
        return l;
    }

    private String getGUID(Cursor cursor) {
        return RepoUtils.getStringFromCursor(cursor, "guid");
    }

    private long getParentID(Cursor cursor) {
        return RepoUtils.getLongFromCursor(cursor, "parent");
    }

    private long getPosition(Cursor cursor, int n) {
        return cursor.getLong(n);
    }

    private long getPosition(Cursor cursor) {
        return RepoUtils.getLongFromCursor(cursor, "position");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getParentName(String string2) throws ParentNotFoundException, NullCursorException {
        String string3;
        block6: {
            if (string2 == null) {
                return "";
            }
            if (SPECIAL_GUIDS_MAP.containsKey(string2)) {
                return SPECIAL_GUIDS_MAP.get(string2);
            }
            string3 = "";
            Cursor cursor = this.dataAccessor.fetch(new String[]{string2});
            try {
                cursor.moveToFirst();
                if (!cursor.isAfterLast()) {
                    string3 = RepoUtils.getStringFromCursor(cursor, "title");
                    break block6;
                }
                Logger.error("BrowserRepoSession", "Couldn't find record with guid '" + string2 + "' when looking for parent name.");
                throw new ParentNotFoundException(null);
            }
            finally {
                cursor.close();
            }
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getChildrenArray(long l, boolean bl, JSONArray jSONArray) throws NullCursorException {
        AndroidBrowserBookmarksRepositorySession.trace("Calling getChildren for androidID " + l);
        Cursor cursor = this.dataAccessor.getChildren(l);
        try {
            if (!cursor.moveToFirst()) {
                AndroidBrowserBookmarksRepositorySession.trace("No children: empty cursor.");
                boolean bl2 = true;
                return bl2;
            }
            int n = cursor.getColumnIndex("position");
            int n2 = cursor.getCount();
            Logger.debug("BrowserRepoSession", "Expecting " + n2 + " children.");
            TreeMap<Long, ArrayList<String>> treeMap = new TreeMap<Long, ArrayList<String>>();
            while (!cursor.isAfterLast()) {
                String string2 = this.getGUID(cursor);
                long l2 = this.getPosition(cursor, n);
                AndroidBrowserBookmarksRepositorySession.trace("  Child GUID: " + string2);
                AndroidBrowserBookmarksRepositorySession.trace("  Child position: " + l2);
                Utils.addToIndexBucketMap(treeMap, Math.abs(l2), string2);
                cursor.moveToNext();
            }
            boolean bl3 = false;
            int n3 = 0;
            for (Map.Entry entry : treeMap.entrySet()) {
                long l3 = (Long)entry.getKey();
                int n4 = ((ArrayList)entry.getValue()).size();
                if (n4 > 1 || l3 != (long)n3) {
                    bl3 = true;
                }
                ++n3;
                for (String string3 : (ArrayList)entry.getValue()) {
                    if (AndroidBrowserBookmarksRepositorySession.forbiddenGUID(string3)) continue;
                    jSONArray.add((Object)string3);
                }
            }
            if (Logger.shouldLogVerbose("BrowserRepoSession")) {
                Logger.trace("BrowserRepoSession", "Output child array: " + jSONArray.toJSONString());
            }
            if (!bl3) {
                Logger.debug("BrowserRepoSession", "Nothing moved! Database reflects child array.");
                boolean bl4 = true;
                return bl4;
            }
            if (!bl) {
                Logger.debug("BrowserRepoSession", "Returned array does not match database, and not persisting.");
                boolean bl5 = false;
                return bl5;
            }
            Logger.debug("BrowserRepoSession", "Generating child array required moving records. Updating DB.");
            long l4 = AndroidBrowserBookmarksRepositorySession.now();
            if (0 < this.dataAccessor.updatePositions((ArrayList<String>)jSONArray)) {
                Logger.debug("BrowserRepoSession", "Bumping parent time to " + l4 + ".");
                this.dataAccessor.bumpModified(l, l4);
            }
            boolean bl6 = true;
            return bl6;
        }
        finally {
            cursor.close();
        }
    }

    protected static boolean isDeleted(Cursor cursor) {
        return RepoUtils.getLongFromCursor(cursor, "deleted") != 0L;
    }

    @Override
    protected Record retrieveDuringStore(Cursor cursor) throws NoGuidForIdException, NullCursorException, ParentNotFoundException {
        return this.retrieveRecord(cursor, false);
    }

    @Override
    protected Record retrieveDuringFetch(Cursor cursor) throws NoGuidForIdException, NullCursorException, ParentNotFoundException {
        return this.retrieveRecord(cursor, true);
    }

    protected BookmarkRecord retrieveRecord(Cursor cursor, boolean bl) throws NoGuidForIdException, NullCursorException, ParentNotFoundException {
        String string2 = this.getGUID(cursor);
        Logger.trace("BrowserRepoSession", "Record from mirror cursor: " + string2);
        if (AndroidBrowserBookmarksRepositorySession.forbiddenGUID(string2)) {
            Logger.debug("BrowserRepoSession", "Ignoring " + string2 + " record in recordFromMirrorCursor.");
            return null;
        }
        if (AndroidBrowserBookmarksRepositorySession.isDeleted(cursor)) {
            return AndroidBrowserBookmarksRepositorySession.bookmarkFromMirrorCursor(cursor, null, null, null);
        }
        long l = this.getParentID(cursor);
        String string3 = SPECIAL_GUID_PARENTS.get(string2);
        if (string3 == null) {
            string3 = this.getGUIDForID(l);
        }
        boolean bl2 = false;
        if (string3 == null) {
            Logger.debug("BrowserRepoSession", "No parent GUID for record " + string2 + " with parent " + l);
            if (this.parentIDToGuidMap.containsKey(l)) {
                Logger.error("BrowserRepoSession", "Have the parent android ID for the record but the parent's GUID wasn't found.");
                throw new NoGuidForIdException(null);
            }
            bl2 = true;
        }
        JSONArray jSONArray = bl ? this.getChildrenArrayForRecordCursor(cursor, string2, true) : null;
        String string4 = this.getParentName(string3);
        BookmarkRecord bookmarkRecord = AndroidBrowserBookmarksRepositorySession.bookmarkFromMirrorCursor(cursor, string3, string4, jSONArray);
        if (bookmarkRecord == null) {
            Logger.warn("BrowserRepoSession", "Unable to extract bookmark from cursor. Record GUID " + string2 + ", parent " + string3 + "/" + l);
            return null;
        }
        if (bl2) {
            Logger.warn("BrowserRepoSession", "Bookmark record " + string2 + " has a bad parent pointer. Reparenting now.");
            String string5 = bookmarkRecord.deleted ? "unfiled" : "mobile";
            bookmarkRecord.androidParentID = this.getIDForGUID(string5);
            bookmarkRecord.androidPosition = this.getPosition(cursor);
            bookmarkRecord.parentID = string5;
            bookmarkRecord.parentName = this.getParentName(string5);
            if (!bookmarkRecord.deleted) {
                this.relocateBookmark(bookmarkRecord);
            }
        }
        return bookmarkRecord;
    }

    private void relocateBookmark(BookmarkRecord bookmarkRecord) {
        this.dataAccessor.updateParentAndPosition(bookmarkRecord.guid, bookmarkRecord.androidParentID, bookmarkRecord.androidPosition);
    }

    protected JSONArray getChildrenArrayForRecordCursor(Cursor cursor, String string2, boolean bl) throws NullCursorException {
        boolean bl2 = AndroidBrowserBookmarksRepositorySession.rowIsFolder(cursor);
        if (!bl2) {
            return null;
        }
        long l = this.parentGuidToIDMap.get(string2);
        JSONArray jSONArray = new JSONArray();
        this.getChildrenArray(l, bl, jSONArray);
        Logger.debug("BrowserRepoSession", "Fetched " + jSONArray.size() + " children for " + string2);
        return jSONArray;
    }

    @Override
    public boolean shouldIgnore(Record record) {
        if (!(record instanceof BookmarkRecord)) {
            return true;
        }
        if (record.deleted) {
            return false;
        }
        BookmarkRecord bookmarkRecord = (BookmarkRecord)record;
        if (AndroidBrowserBookmarksRepositorySession.forbiddenGUID(bookmarkRecord.guid)) {
            Logger.debug("BrowserRepoSession", "Ignoring forbidden record with guid: " + bookmarkRecord.guid);
            return true;
        }
        if (AndroidBrowserBookmarksRepositorySession.forbiddenParent(bookmarkRecord.parentID)) {
            Logger.debug("BrowserRepoSession", "Ignoring child " + bookmarkRecord.guid + " of forbidden parent folder " + bookmarkRecord.parentID);
            return true;
        }
        if (BrowserContractHelpers.isSupportedType(bookmarkRecord.type)) {
            return false;
        }
        Logger.debug("BrowserRepoSession", "Ignoring record with guid: " + bookmarkRecord.guid + " and type: " + bookmarkRecord.type);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void begin(RepositorySessionBeginDelegate repositorySessionBeginDelegate) throws InvalidSessionTransitionException {
        Cursor cursor;
        try {
            Logger.debug("BrowserRepoSession", "Check and build special GUIDs.");
            this.dataAccessor.checkAndBuildSpecialGuids();
            cursor = this.dataAccessor.getGuidsIDsForFolders();
            Logger.debug("BrowserRepoSession", "Got GUIDs for folders.");
        }
        catch (SQLiteConstraintException sQLiteConstraintException) {
            Logger.error("BrowserRepoSession", "Got sqlite constraint exception working with Fennec bookmark DB.", sQLiteConstraintException);
            repositorySessionBeginDelegate.onBeginFailed((Exception)((Object)sQLiteConstraintException));
            return;
        }
        catch (NullCursorException nullCursorException) {
            repositorySessionBeginDelegate.onBeginFailed(nullCursorException);
            return;
        }
        catch (Exception exception) {
            repositorySessionBeginDelegate.onBeginFailed(exception);
            return;
        }
        Logger.debug("BrowserRepoSession", "Preparing folder ID mappings.");
        Logger.debug("BrowserRepoSession", "Tracking places root as ID 0.");
        this.parentIDToGuidMap.put(0L, "places");
        this.parentGuidToIDMap.put("places", 0L);
        try {
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                String string2 = this.getGUID(cursor);
                long l = RepoUtils.getLongFromCursor(cursor, "_id");
                this.parentGuidToIDMap.put(string2, l);
                this.parentIDToGuidMap.put(l, string2);
                Logger.debug("BrowserRepoSession", "GUID " + string2 + " maps to " + l);
                cursor.moveToNext();
            }
        }
        finally {
            cursor.close();
        }
        this.deletionManager = new BookmarksDeletionManager(this.dataAccessor, 50);
        this.insertionManager = new BookmarksInsertionManager(50, this.parentGuidToIDMap.keySet(), this);
        Logger.debug("BrowserRepoSession", "Done with initial setup of bookmarks session.");
        super.begin(repositorySessionBeginDelegate);
    }

    @Override
    public boolean insertFolder(BookmarkRecord bookmarkRecord) {
        Record record = this.prepareRecord(bookmarkRecord);
        try {
            Uri uri = this.dbHelper.insert(record);
            if (uri == null) {
                this.delegate.onRecordStoreFailed(new RuntimeException("Got null URI inserting folder with guid " + record.guid + "."), bookmarkRecord.guid);
                return false;
            }
            record.androidID = ContentUris.parseId((Uri)uri);
            Logger.debug("BrowserRepoSession", "Inserted folder with guid " + record.guid + " as androidID " + record.androidID);
            this.updateBookkeeping(record);
        }
        catch (Exception exception) {
            this.delegate.onRecordStoreFailed(exception, bookmarkRecord.guid);
            return false;
        }
        this.trackRecord(record);
        this.delegate.onRecordStoreSucceeded(bookmarkRecord.guid);
        return true;
    }

    @Override
    public void bulkInsertNonFolders(Collection<BookmarkRecord> collection) {
        ArrayList<Record> arrayList = new ArrayList<Record>(collection.size());
        for (BookmarkRecord object : collection) {
            arrayList.add(this.prepareRecord(object));
        }
        try {
            int n = this.dataAccessor.bulkInsert(arrayList);
            if (n != arrayList.size()) {
                for (Record record : arrayList) {
                    this.delegate.onRecordStoreFailed(new RuntimeException("Possibly failed to bulkInsert non-folder with guid " + record.guid + "."), record.guid);
                }
                return;
            }
        }
        catch (NullCursorException nullCursorException) {
            for (Record record : arrayList) {
                this.delegate.onRecordStoreFailed(nullCursorException, record.guid);
            }
            return;
        }
        for (Record record : arrayList) {
            try {
                this.updateBookkeeping(record);
            }
            catch (Exception exception) {
                Logger.warn("BrowserRepoSession", "Got exception updating bookkeeping of non-folder with guid " + record.guid + ".", exception);
            }
            this.trackRecord(record);
            this.delegate.onRecordStoreSucceeded(record.guid);
        }
    }

    @Override
    public void finish(RepositorySessionFinishDelegate repositorySessionFinishDelegate) throws InactiveSessionException {
        this.deletionManager = null;
        this.insertionManager = null;
        if (this.needsReparenting != 0) {
            Logger.error("BrowserRepoSession", "Finish called but " + this.needsReparenting + " bookmark(s) have been placed in unsorted bookmarks and not been reparented.");
        }
        super.finish(repositorySessionFinishDelegate);
    }

    @Override
    public void setStoreDelegate(RepositorySessionStoreDelegate repositorySessionStoreDelegate) {
        super.setStoreDelegate(repositorySessionStoreDelegate);
        if (this.deletionManager != null) {
            this.deletionManager.setDelegate(repositorySessionStoreDelegate);
        }
    }

    @Override
    protected Record reconcileRecords(Record record, Record record2, long l, long l2) {
        BookmarkRecord bookmarkRecord = (BookmarkRecord)super.reconcileRecords(record, record2, l, l2);
        bookmarkRecord.children = ((BookmarkRecord)record).children;
        if (bookmarkRecord.isFolder()) {
            this.trackRecord(bookmarkRecord);
        }
        return bookmarkRecord;
    }

    @Override
    protected void fixupRecord(Record record) {
        BookmarkRecord bookmarkRecord = (BookmarkRecord)record;
        String string2 = SPECIAL_GUIDS_MAP.get(bookmarkRecord.parentID);
        if (string2 == null) {
            return;
        }
        if (Logger.shouldLogVerbose("BrowserRepoSession")) {
            Logger.trace("BrowserRepoSession", "Replacing parent name \"" + bookmarkRecord.parentName + "\" with \"" + string2 + "\".");
        }
        bookmarkRecord.parentName = string2;
    }

    @Override
    protected Record prepareRecord(Record record) {
        if (record.deleted) {
            Logger.debug("BrowserRepoSession", "No need to prepare deleted record " + record.guid);
            return record;
        }
        BookmarkRecord bookmarkRecord = (BookmarkRecord)record;
        if (!this.isSpecialRecord(record)) {
            this.handleParenting(bookmarkRecord);
        }
        if (Logger.LOG_PERSONAL_INFORMATION) {
            if (bookmarkRecord.isFolder()) {
                Logger.pii("BrowserRepoSession", "Inserting folder " + bookmarkRecord.guid + ", " + bookmarkRecord.title + " with parent " + bookmarkRecord.androidParentID + " (" + bookmarkRecord.parentID + ", " + bookmarkRecord.parentName + ", " + bookmarkRecord.androidPosition + ")");
            } else {
                Logger.pii("BrowserRepoSession", "Inserting bookmark " + bookmarkRecord.guid + ", " + bookmarkRecord.title + ", " + bookmarkRecord.bookmarkURI + " with parent " + bookmarkRecord.androidParentID + " (" + bookmarkRecord.parentID + ", " + bookmarkRecord.parentName + ", " + bookmarkRecord.androidPosition + ")");
            }
        } else if (bookmarkRecord.isFolder()) {
            Logger.debug("BrowserRepoSession", "Inserting folder " + bookmarkRecord.guid + ", parent " + bookmarkRecord.androidParentID + " (" + bookmarkRecord.parentID + ", " + bookmarkRecord.androidPosition + ")");
        } else {
            Logger.debug("BrowserRepoSession", "Inserting bookmark " + bookmarkRecord.guid + " with parent " + bookmarkRecord.androidParentID + " (" + bookmarkRecord.parentID + ", " + ", " + bookmarkRecord.androidPosition + ")");
        }
        return bookmarkRecord;
    }

    private void handleParenting(BookmarkRecord bookmarkRecord) {
        if (this.parentGuidToIDMap.containsKey(bookmarkRecord.parentID)) {
            int n;
            bookmarkRecord.androidParentID = this.parentGuidToIDMap.get(bookmarkRecord.parentID);
            JSONArray jSONArray = this.parentToChildArray.get(bookmarkRecord.parentID);
            if (jSONArray != null && (n = jSONArray.indexOf((Object)bookmarkRecord.guid)) >= 0) {
                bookmarkRecord.androidPosition = n;
            }
        } else {
            bookmarkRecord.androidParentID = this.parentGuidToIDMap.get("unfiled");
            ArrayList<String> arrayList = this.missingParentToChildren.containsKey(bookmarkRecord.parentID) ? this.missingParentToChildren.get(bookmarkRecord.parentID) : new ArrayList<String>();
            arrayList.add(bookmarkRecord.guid);
            ++this.needsReparenting;
            this.missingParentToChildren.put(bookmarkRecord.parentID, arrayList);
        }
    }

    private boolean isSpecialRecord(Record record) {
        return SPECIAL_GUID_PARENTS.containsKey(record.guid);
    }

    @Override
    protected void updateBookkeeping(Record record) throws NoGuidForIdException, NullCursorException, ParentNotFoundException {
        super.updateBookkeeping(record);
        BookmarkRecord bookmarkRecord = (BookmarkRecord)record;
        if (!bookmarkRecord.isFolder()) {
            Logger.debug("BrowserRepoSession", "Not a folder. No bookkeeping.");
            return;
        }
        Logger.debug("BrowserRepoSession", "Updating bookkeeping for folder " + record.guid);
        this.parentGuidToIDMap.put(bookmarkRecord.guid, bookmarkRecord.androidID);
        this.parentIDToGuidMap.put(bookmarkRecord.androidID, bookmarkRecord.guid);
        JSONArray jSONArray = bookmarkRecord.children;
        if (Logger.shouldLogVerbose("BrowserRepoSession")) {
            Logger.trace("BrowserRepoSession", bookmarkRecord.guid + " has children " + jSONArray.toJSONString());
        }
        this.parentToChildArray.put(bookmarkRecord.guid, jSONArray);
        if (this.missingParentToChildren.containsKey(bookmarkRecord.guid)) {
            for (String string2 : this.missingParentToChildren.get(bookmarkRecord.guid)) {
                long l = jSONArray.indexOf((Object)string2);
                this.dataAccessor.updateParentAndPosition(string2, bookmarkRecord.androidID, l);
                --this.needsReparenting;
            }
            this.missingParentToChildren.remove(bookmarkRecord.guid);
        }
    }

    @Override
    protected void insert(Record record) throws NoGuidForIdException, NullCursorException, ParentNotFoundException {
        try {
            this.insertionManager.enqueueRecord((BookmarkRecord)record);
        }
        catch (Exception exception) {
            throw new NullCursorException(exception);
        }
    }

    @Override
    protected void storeRecordDeletion(Record record, Record record2) {
        if (SPECIAL_GUIDS_MAP.containsKey(record.guid)) {
            Logger.debug("BrowserRepoSession", "Told to delete record " + record.guid + ". Ignoring.");
            return;
        }
        BookmarkRecord bookmarkRecord = (BookmarkRecord)record;
        BookmarkRecord bookmarkRecord2 = (BookmarkRecord)record2;
        boolean bl = bookmarkRecord2.isFolder();
        String string2 = bookmarkRecord2.parentID;
        this.deletionManager.deleteRecord(bookmarkRecord.guid, bl, string2);
    }

    protected void flushQueues() {
        long l = AndroidBrowserBookmarksRepositorySession.now();
        Logger.debug("BrowserRepoSession", "Applying remaining insertions.");
        try {
            this.insertionManager.finishUp();
            Logger.debug("BrowserRepoSession", "Done applying remaining insertions.");
        }
        catch (Exception exception) {
            Logger.warn("BrowserRepoSession", "Unable to apply remaining insertions.", exception);
        }
        Logger.debug("BrowserRepoSession", "Applying deletions.");
        try {
            this.untrackGUIDs(this.deletionManager.flushAll(this.getIDForGUID("unfiled"), l));
            Logger.debug("BrowserRepoSession", "Done applying deletions.");
        }
        catch (Exception exception) {
            Logger.error("BrowserRepoSession", "Unable to apply deletions.", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishUp() {
        try {
            this.flushQueues();
            Logger.debug("BrowserRepoSession", "Have " + this.parentToChildArray.size() + " folders whose children might need repositioning.");
            for (Map.Entry<String, JSONArray> entry : this.parentToChildArray.entrySet()) {
                String string2 = entry.getKey();
                JSONArray jSONArray = entry.getValue();
                try {
                    long l = this.getIDForGUID(string2);
                    JSONArray jSONArray2 = new JSONArray();
                    boolean bl = this.getChildrenArray(l, false, jSONArray2);
                    boolean bl2 = Utils.sameArrays(jSONArray, jSONArray2);
                    if (!bl2) {
                        int n = 0;
                        for (Object e : jSONArray2) {
                            if (jSONArray.contains(e)) continue;
                            jSONArray.add(e);
                            ++n;
                        }
                        Logger.debug("BrowserRepoSession", "Added " + n + " items locally.");
                        Logger.debug("BrowserRepoSession", "Untracking and bumping " + string2 + "(" + l + ")");
                        this.dataAccessor.bumpModified(l, AndroidBrowserBookmarksRepositorySession.now());
                        this.untrackGUID(string2);
                    }
                    if (bl2 && bl) continue;
                    this.dataAccessor.updatePositions(new ArrayList<String>((Collection<String>)jSONArray));
                }
                catch (Exception exception) {
                    Logger.warn("BrowserRepoSession", "Error repositioning children for " + string2, exception);
                }
            }
        }
        finally {
            super.storeDone();
        }
    }

    @Override
    protected AndroidBrowserRepositorySession.WipeRunnable getWipeRunnable(RepositorySessionWipeDelegate repositorySessionWipeDelegate) {
        return new BookmarkWipeRunnable(repositorySessionWipeDelegate);
    }

    @Override
    public void storeDone() {
        Runnable runnable = new Runnable(){

            public void run() {
                AndroidBrowserBookmarksRepositorySession.this.finishUp();
            }
        };
        this.storeWorkQueue.execute(runnable);
    }

    @Override
    protected String buildRecordString(Record record) {
        BookmarkRecord bookmarkRecord = (BookmarkRecord)record;
        String string2 = bookmarkRecord.parentName + "/";
        if (bookmarkRecord.isBookmark()) {
            return "b" + string2 + bookmarkRecord.bookmarkURI + ":" + bookmarkRecord.title;
        }
        if (bookmarkRecord.isFolder()) {
            return "f" + string2 + bookmarkRecord.title;
        }
        if (bookmarkRecord.isSeparator()) {
            return "s" + string2 + bookmarkRecord.androidPosition;
        }
        if (bookmarkRecord.isQuery()) {
            return "q" + string2 + bookmarkRecord.bookmarkURI;
        }
        return null;
    }

    public static BookmarkRecord computeParentFields(BookmarkRecord bookmarkRecord, String string2, String string3) {
        String string4 = bookmarkRecord.guid;
        if (string4 == null) {
            Logger.error("BrowserRepoSession", "No guid in computeParentFields!");
            return null;
        }
        String string5 = SPECIAL_GUID_PARENTS.get(string4);
        if (string5 == null) {
            string5 = string2;
        } else {
            Logger.debug("BrowserRepoSession", "Ignoring suggested parent ID " + string2 + " for " + string4 + "; using " + string5);
        }
        if (string5 == null) {
            Logger.error("BrowserRepoSession", "No parent for record " + string4);
            return null;
        }
        String string6 = SPECIAL_GUIDS_MAP.get(string5);
        if (string6 == null) {
            string6 = string3;
        }
        bookmarkRecord.parentID = string5;
        bookmarkRecord.parentName = string6;
        return bookmarkRecord;
    }

    private static BookmarkRecord logBookmark(BookmarkRecord bookmarkRecord) {
        try {
            Logger.debug("BrowserRepoSession", "Returning " + (bookmarkRecord.deleted ? "deleted " : "") + "bookmark record " + bookmarkRecord.guid + " (" + bookmarkRecord.androidID + ", parent " + bookmarkRecord.parentID + ")");
            if (!bookmarkRecord.deleted && Logger.LOG_PERSONAL_INFORMATION) {
                Logger.pii("BrowserRepoSession", "> Parent name:      " + bookmarkRecord.parentName);
                Logger.pii("BrowserRepoSession", "> Title:            " + bookmarkRecord.title);
                Logger.pii("BrowserRepoSession", "> Type:             " + bookmarkRecord.type);
                Logger.pii("BrowserRepoSession", "> URI:              " + bookmarkRecord.bookmarkURI);
                Logger.pii("BrowserRepoSession", "> Position:         " + bookmarkRecord.androidPosition);
                if (bookmarkRecord.isFolder()) {
                    Logger.pii("BrowserRepoSession", "FOLDER: Children are " + (bookmarkRecord.children == null ? "null" : bookmarkRecord.children.toJSONString()));
                }
            }
        }
        catch (Exception exception) {
            Logger.debug("BrowserRepoSession", "Exception logging bookmark record " + bookmarkRecord, exception);
        }
        return bookmarkRecord;
    }

    public static BookmarkRecord bookmarkFromMirrorCursor(Cursor cursor, String string2, String string3, JSONArray jSONArray) {
        String string4 = RepoUtils.getStringFromCursor(cursor, "guid");
        long l = RepoUtils.getLongFromCursor(cursor, "modified");
        boolean bl = AndroidBrowserBookmarksRepositorySession.isDeleted(cursor);
        BookmarkRecord bookmarkRecord = new BookmarkRecord(string4, "bookmarks", l, bl);
        if (bl) {
            return AndroidBrowserBookmarksRepositorySession.logBookmark(bookmarkRecord);
        }
        int n = AndroidBrowserBookmarksRepositorySession.getTypeFromCursor(cursor);
        String string5 = BrowserContractHelpers.typeStringForCode(n);
        if (string5 == null) {
            Logger.warn("BrowserRepoSession", "Unsupported type code " + n);
            return null;
        }
        Logger.trace("BrowserRepoSession", "Record " + string4 + " has type " + string5);
        bookmarkRecord.type = string5;
        bookmarkRecord.title = RepoUtils.getStringFromCursor(cursor, "title");
        bookmarkRecord.bookmarkURI = RepoUtils.getStringFromCursor(cursor, "url");
        bookmarkRecord.description = RepoUtils.getStringFromCursor(cursor, "description");
        bookmarkRecord.tags = RepoUtils.getJSONArrayFromCursor(cursor, "tags");
        bookmarkRecord.keyword = RepoUtils.getStringFromCursor(cursor, "keyword");
        bookmarkRecord.androidID = RepoUtils.getLongFromCursor(cursor, "_id");
        bookmarkRecord.androidPosition = RepoUtils.getLongFromCursor(cursor, "position");
        bookmarkRecord.children = jSONArray;
        BookmarkRecord bookmarkRecord2 = AndroidBrowserBookmarksRepositorySession.computeParentFields(bookmarkRecord, string2, string3);
        if (bookmarkRecord2 == null) {
            return null;
        }
        return AndroidBrowserBookmarksRepositorySession.logBookmark(bookmarkRecord2);
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("places", null);
        hashMap.put("menu", "places");
        hashMap.put("toolbar", "places");
        hashMap.put("tags", "places");
        hashMap.put("unfiled", "places");
        hashMap.put("mobile", "places");
        SPECIAL_GUID_PARENTS = Collections.unmodifiableMap(hashMap);
    }

    class BookmarkWipeRunnable
    extends AndroidBrowserRepositorySession.WipeRunnable {
        public BookmarkWipeRunnable(RepositorySessionWipeDelegate repositorySessionWipeDelegate) {
            super(AndroidBrowserBookmarksRepositorySession.this, repositorySessionWipeDelegate);
        }

        public void run() {
            try {
                AndroidBrowserBookmarksRepositorySession.this.deletionManager.clear();
                AndroidBrowserBookmarksRepositorySession.this.insertionManager.clear();
                super.run();
            }
            catch (Exception exception) {
                this.delegate.onWipeFailed(exception);
                return;
            }
        }
    }
}

