/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.setup;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.CredentialException;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.ThreadPool;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.config.AccountPickler;
import org.mozilla.gecko.sync.repositories.android.RepoUtils;

public class SyncAccounts {
    private static final String LOG_TAG = "SyncAccounts";
    private static final String MOTO_BLUR_SETTINGS_ACTIVITY = "com.motorola.blur.settings.AccountsAndServicesPreferenceActivity";
    private static final String MOTO_BLUR_PACKAGE = "com.motorola.blur.setup";

    public static Account[] syncAccounts(Context context) {
        return AccountManager.get((Context)context).getAccountsByType("org.mozilla.fennec_sync");
    }

    public static boolean syncAccountsExist(Context context) {
        boolean bl;
        boolean bl2 = bl = AccountManager.get((Context)context).getAccountsByType("org.mozilla.fennec_sync").length > 0;
        if (bl) {
            return true;
        }
        File file = context.getFileStreamPath("sync.account.json");
        if (!file.exists()) {
            return false;
        }
        Account account = AccountPickler.unpickle(context, "sync.account.json");
        return account != null;
    }

    public static Account createSyncAccount(SyncAccountParameters syncAccountParameters) {
        return SyncAccounts.createSyncAccount(syncAccountParameters, true, true);
    }

    public static Account createSyncAccount(SyncAccountParameters syncAccountParameters, boolean bl) {
        return SyncAccounts.createSyncAccount(syncAccountParameters, bl, true);
    }

    public static Account createSyncAccountPreservingExistingPreferences(SyncAccountParameters syncAccountParameters, boolean bl) {
        return SyncAccounts.createSyncAccount(syncAccountParameters, bl, false);
    }

    protected static Account createSyncAccount(SyncAccountParameters syncAccountParameters, boolean bl, boolean bl2) {
        Context context = syncAccountParameters.context;
        AccountManager accountManager = syncAccountParameters.accountManager == null ? AccountManager.get((Context)syncAccountParameters.context) : syncAccountParameters.accountManager;
        String string2 = syncAccountParameters.username;
        String string3 = syncAccountParameters.syncKey;
        String string4 = syncAccountParameters.password;
        String string5 = syncAccountParameters.serverURL == null ? "https://auth.services.mozilla.com/" : syncAccountParameters.serverURL;
        Logger.debug(LOG_TAG, "Using account manager " + accountManager);
        if (!RepoUtils.stringsEqual(syncAccountParameters.serverURL, "https://auth.services.mozilla.com/")) {
            Logger.info(LOG_TAG, "Setting explicit server URL: " + string5);
        }
        Account account = new Account(string2, "org.mozilla.fennec_sync");
        Bundle bundle = new Bundle();
        bundle.putString("option.synckey", string3);
        bundle.putString("option.serverUrl", string5);
        Logger.debug(LOG_TAG, "Adding account for org.mozilla.fennec_sync");
        boolean bl3 = false;
        try {
            bl3 = accountManager.addAccountExplicitly(account, string4, bundle);
        }
        catch (SecurityException securityException) {
            String string6 = securityException.getMessage();
            if (string6 != null && string6.indexOf("is different than the authenticator's uid") > 0) {
                Log.wtf((String)"FxSync", (String)"Unable to create account. If you have more than one version of Firefox/Beta/Aurora/Nightly/Fennec installed, that's why.", (Throwable)securityException);
            }
            Log.e((String)"FxSync", (String)"Unable to create account.", (Throwable)securityException);
        }
        if (!bl3) {
            Logger.error(LOG_TAG, "Failed to add account " + account + "!");
            return null;
        }
        Logger.debug(LOG_TAG, "Account " + account + " added successfully.");
        SyncAccounts.setSyncAutomatically(account, bl);
        SyncAccounts.setIsSyncable(account, bl);
        Logger.debug(LOG_TAG, "Set account to sync automatically? " + bl + ".");
        try {
            SharedPreferences.Editor editor = Utils.getSharedPreferences(context, "org.mozilla.fennec", string2, string5, "default", 1L).edit();
            if (bl2) {
                String string7 = Utils.getPrefsPath("org.mozilla.fennec", string2, string5, "default", 1L);
                Logger.info(LOG_TAG, "Clearing preferences path " + string7 + " for this account.");
                editor.clear();
            }
            if (syncAccountParameters.clusterURL != null) {
                editor.putString("clusterURL", syncAccountParameters.clusterURL);
            }
            if (syncAccountParameters.clientName != null && syncAccountParameters.clientGuid != null) {
                Logger.debug(LOG_TAG, "Setting client name to " + syncAccountParameters.clientName + " and client GUID to " + syncAccountParameters.clientGuid + ".");
                editor.putString("account.clientName", syncAccountParameters.clientName);
                editor.putString("account.guid", syncAccountParameters.clientGuid);
            } else {
                Logger.debug(LOG_TAG, "Client name and guid not both non-null, so not setting client data.");
            }
            editor.commit();
        }
        catch (Exception exception) {
            Logger.error(LOG_TAG, "Could not clear prefs path!", exception);
        }
        return account;
    }

    public static void setIsSyncable(Account account, boolean bl) {
        String string2 = "org.mozilla.fennec.db.browser";
        ContentResolver.setIsSyncable((Account)account, (String)string2, (int)(bl ? 1 : 0));
    }

    public static void setSyncAutomatically(Account account, boolean bl) {
        if (bl) {
            ContentResolver.setMasterSyncAutomatically((boolean)true);
        }
        String string2 = "org.mozilla.fennec.db.browser";
        Logger.debug(LOG_TAG, "Setting authority " + string2 + " to " + (bl ? "" : "not ") + "sync automatically.");
        ContentResolver.setSyncAutomatically((Account)account, (String)string2, (boolean)bl);
    }

    public static void backgroundSetSyncAutomatically(final Account account, final boolean bl) {
        ThreadPool.run(new Runnable(){

            public void run() {
                SyncAccounts.setSyncAutomatically(account, bl);
            }
        });
    }

    protected static Intent openVendorSyncSettings(Context context, String string2, String string3) {
        try {
            Context context2 = context.createPackageContext(string2, 3);
            Class<?> clazz = context2.getClassLoader().loadClass(string3);
            Intent intent = new Intent(context2, clazz);
            context.startActivity(intent);
            Logger.info(LOG_TAG, "Vendor package " + string2 + " and class " + string3 + " found, and activity launched.");
            return intent;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Logger.debug(LOG_TAG, "Vendor package " + string2 + " not found. Skipping.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.debug(LOG_TAG, "Vendor package " + string2 + " found but class " + string3 + " not found. Skipping.", classNotFoundException);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            Logger.warn(LOG_TAG, "Vendor package " + string2 + " and class " + string3 + " found, but activity not launched. Skipping.", activityNotFoundException);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Caught exception launching activity from vendor package " + string2 + " and class " + string3 + ". Ignoring.", exception);
        }
        return null;
    }

    public static Intent openSyncSettings(Context context) {
        Intent intent = SyncAccounts.openVendorSyncSettings(context, MOTO_BLUR_PACKAGE, MOTO_BLUR_SETTINGS_ACTIVITY);
        if (intent != null) {
            return intent;
        }
        intent = new Intent("android.settings.SYNC_SETTINGS");
        try {
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            return null;
        }
        return intent;
    }

    public static SyncAccountParameters blockingFromAndroidAccountV0(Context context, AccountManager accountManager, Account account) throws CredentialException {
        String string2;
        String string3;
        String string4;
        String string5;
        try {
            string5 = Utils.usernameFromAccount(account.name);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CredentialException.MissingCredentialException("username");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CredentialException.MissingCredentialException("username");
        }
        try {
            string4 = accountManager.getPassword(account);
            string3 = accountManager.getUserData(account, "option.synckey");
            string2 = accountManager.getUserData(account, "option.serverUrl");
        }
        catch (SecurityException securityException) {
            Logger.warn(LOG_TAG, "Got security exception fetching Sync account parameters; throwing.");
            throw new CredentialException.MissingAllCredentialsException(securityException);
        }
        if (string4 == null && string5 == null && string3 == null && string2 == null) {
            throw new CredentialException.MissingAllCredentialsException();
        }
        if (string4 == null) {
            throw new CredentialException.MissingCredentialException("password");
        }
        if (string3 == null) {
            throw new CredentialException.MissingCredentialException("syncKey");
        }
        if (string2 == null) {
            throw new CredentialException.MissingCredentialException("serverURL");
        }
        try {
            return new SyncAccountParameters(context, accountManager, string5, string3, string4, string2);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception fetching Sync account parameters; throwing.");
            throw new CredentialException.MissingAllCredentialsException(exception);
        }
    }

    public static Intent makeSyncAccountDeletedIntent(Context context, AccountManager accountManager, Account account) {
        Intent intent = new Intent("org.mozilla.fennec_sync.accounts.SYNC_ACCOUNT_DELETED_ACTION");
        intent.putExtra("version", (Serializable)Long.valueOf(1L));
        intent.putExtra("timestamp", (Serializable)Long.valueOf(System.currentTimeMillis()));
        intent.putExtra("account", account.name);
        SyncAccountParameters syncAccountParameters = null;
        try {
            syncAccountParameters = SyncAccounts.blockingFromAndroidAccountV0(context, accountManager, account);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Caught exception fetching account parameters.", exception);
        }
        if (syncAccountParameters != null) {
            ExtendedJSONObject extendedJSONObject = syncAccountParameters.asJSON();
            extendedJSONObject.put("synckey", "");
            intent.putExtra("payload", extendedJSONObject.toJSONString());
        }
        return intent;
    }

    public static SharedPreferences blockingPrefsFromAndroidAccountV0(Context context, AccountManager accountManager, Account account, String string2, String string3, long l) throws CredentialException, NoSuchAlgorithmException, UnsupportedEncodingException {
        SyncAccountParameters syncAccountParameters = SyncAccounts.blockingFromAndroidAccountV0(context, accountManager, account);
        String string4 = Utils.getPrefsPath(string2, syncAccountParameters.username, syncAccountParameters.serverURL, string3, l);
        return context.getSharedPreferences(string4, 0);
    }

    public static SharedPreferences blockingPrefsFromDefaultProfileV0(Context context, AccountManager accountManager, Account account) throws CredentialException, NoSuchAlgorithmException, UnsupportedEncodingException {
        return SyncAccounts.blockingPrefsFromAndroidAccountV0(context, accountManager, account, "org.mozilla.fennec", "default", 1L);
    }

    public static class SyncAccountParameters {
        public final Context context;
        public final AccountManager accountManager;
        public final String username;
        public final String syncKey;
        public final String password;
        public final String serverURL;
        public final String clusterURL;
        public final String clientName;
        public final String clientGuid;

        public SyncAccountParameters(Context context, AccountManager accountManager, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
            if (context == null) {
                throw new IllegalArgumentException("Null context passed to SyncAccountParameters constructor.");
            }
            if (string2 == null) {
                throw new IllegalArgumentException("Null username passed to SyncAccountParameters constructor.");
            }
            if (string3 == null) {
                throw new IllegalArgumentException("Null syncKey passed to SyncAccountParameters constructor.");
            }
            if (string4 == null) {
                throw new IllegalArgumentException("Null password passed to SyncAccountParameters constructor.");
            }
            this.context = context;
            this.accountManager = accountManager;
            this.username = string2;
            this.syncKey = string3;
            this.password = string4;
            this.serverURL = string5;
            this.clusterURL = string6;
            this.clientName = string7;
            this.clientGuid = string8;
        }

        public SyncAccountParameters(Context context, AccountManager accountManager, String string2, String string3, String string4, String string5) {
            this(context, accountManager, string2, string3, string4, string5, null, null, null);
        }

        public SyncAccountParameters(Context context, AccountManager accountManager, ExtendedJSONObject extendedJSONObject) {
            this(context, accountManager, extendedJSONObject.getString("account"), extendedJSONObject.getString("synckey"), extendedJSONObject.getString("password"), extendedJSONObject.getString("serverURL"), extendedJSONObject.getString("clusterURL"), extendedJSONObject.getString("clientName"), extendedJSONObject.getString("clientGUID"));
        }

        public ExtendedJSONObject asJSON() {
            ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
            extendedJSONObject.put("account", this.username);
            extendedJSONObject.put("password", this.password);
            extendedJSONObject.put("serverURL", this.serverURL);
            extendedJSONObject.put("synckey", this.syncKey);
            extendedJSONObject.put("clusterURL", this.clusterURL);
            extendedJSONObject.put("clientName", this.clientName);
            extendedJSONObject.put("clientGUID", this.clientGuid);
            return extendedJSONObject;
        }
    }
}

