/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.setup.auth;

import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.client.ClientProtocolException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.BaseResourceDelegate;
import org.mozilla.gecko.sync.setup.auth.AccountAuthenticator;
import org.mozilla.gecko.sync.setup.auth.AuthenticationResult;
import org.mozilla.gecko.sync.setup.auth.AuthenticatorStage;

public class EnsureUserExistenceStage
implements AuthenticatorStage {
    private final String LOG_TAG = "EnsureUserExistence";

    public void execute(final AccountAuthenticator accountAuthenticator) throws URISyntaxException, UnsupportedEncodingException {
        final EnsureUserExistenceStageDelegate ensureUserExistenceStageDelegate = new EnsureUserExistenceStageDelegate(){

            public void handleSuccess() {
                Logger.debug("EnsureUserExistence", "handleSuccess()");
                accountAuthenticator.runNextStage();
            }

            public void handleFailure(AuthenticationResult authenticationResult) {
                accountAuthenticator.abort(authenticationResult, new Exception("Failure in EnsureUser"));
            }

            public void handleError(Exception exception) {
                Logger.info("EnsureUserExistence", "Error checking for user existence.");
                accountAuthenticator.abort(AuthenticationResult.FAILURE_SERVER, exception);
            }
        };
        String string2 = accountAuthenticator.nodeServer + "user/1.0/" + accountAuthenticator.username;
        final BaseResource baseResource = new BaseResource(string2);
        baseResource.delegate = new BaseResourceDelegate(baseResource){

            public String getUserAgent() {
                return "Firefox AndroidSync 1.33.0a1.0 (Nightly)";
            }

            public void handleHttpResponse(HttpResponse httpResponse) {
                int n = httpResponse.getStatusLine().getStatusCode();
                switch (n) {
                    case 200: {
                        try {
                            InputStream inputStream = httpResponse.getEntity().getContent();
                            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"), 1024);
                            String string2 = bufferedReader.readLine();
                            BaseResource.consumeReader(bufferedReader);
                            bufferedReader.close();
                            if (string2.equals("1")) {
                                ensureUserExistenceStageDelegate.handleSuccess();
                                break;
                            }
                            Logger.info("EnsureUserExistence", "No such user.");
                            ensureUserExistenceStageDelegate.handleFailure(AuthenticationResult.FAILURE_USERNAME);
                        }
                        catch (Exception exception) {
                            Logger.error("EnsureUserExistence", "Failure in content parsing.", exception);
                            ensureUserExistenceStageDelegate.handleFailure(AuthenticationResult.FAILURE_OTHER);
                        }
                        break;
                    }
                    default: {
                        ensureUserExistenceStageDelegate.handleFailure(AuthenticationResult.FAILURE_OTHER);
                    }
                }
                Logger.debug("EnsureUserExistence", "Consuming entity.");
                BaseResource.consumeEntity(httpResponse.getEntity());
            }

            public void handleHttpProtocolException(ClientProtocolException clientProtocolException) {
                ensureUserExistenceStageDelegate.handleError((Exception)clientProtocolException);
            }

            public void handleHttpIOException(IOException iOException) {
                ensureUserExistenceStageDelegate.handleError(iOException);
            }

            public void handleTransportException(GeneralSecurityException generalSecurityException) {
                ensureUserExistenceStageDelegate.handleError(generalSecurityException);
            }
        };
        AccountAuthenticator.runOnThread(new Runnable(){

            public void run() {
                baseResource.get();
            }
        });
    }

    public static interface EnsureUserExistenceStageDelegate {
        public void handleSuccess();

        public void handleFailure(AuthenticationResult var1);

        public void handleError(Exception var1);
    }
}

