/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabspanel;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import org.mozilla.gecko.R;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.fxa.login.State;
import org.mozilla.gecko.sync.setup.SyncAccounts;
import org.mozilla.gecko.tabspanel.RemoteTabsSetupPanel;
import org.mozilla.gecko.tabspanel.RemoteTabsVerificationPanel;
import org.mozilla.gecko.tabspanel.TabsPanel;

class RemoteTabsPanel
extends FrameLayout
implements TabsPanel.PanelView {
    private TabsPanel.PanelView currentPanel;
    private RemotePanelType currentPanelType;
    private TabsPanel tabsPanel;

    public RemoteTabsPanel(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.updateCurrentPanel();
    }

    public void setTabsPanel(TabsPanel tabsPanel) {
        this.tabsPanel = tabsPanel;
        this.currentPanel.setTabsPanel(tabsPanel);
    }

    public void show() {
        this.updateCurrentPanel();
        this.currentPanel.show();
        this.setVisibility(0);
    }

    public void hide() {
        this.setVisibility(8);
        this.currentPanel.hide();
    }

    public boolean shouldExpand() {
        return this.currentPanel.shouldExpand();
    }

    private void updateCurrentPanel() {
        RemotePanelType remotePanelType = this.getPanelTypeFromAccountState();
        if (remotePanelType != this.currentPanelType) {
            if (this.currentPanel != null) {
                this.currentPanel.hide();
            }
            this.removeAllViews();
            this.currentPanelType = remotePanelType;
            this.currentPanel = this.inflatePanel(this.currentPanelType);
            this.currentPanel.setTabsPanel(this.tabsPanel);
            this.addView((View)this.currentPanel);
        }
    }

    private RemotePanelType getPanelTypeFromAccountState() {
        Context context = this.getContext();
        State state = FirefoxAccounts.getFirefoxAccountState(context);
        if (state == null) {
            if (SyncAccounts.syncAccountsExist(context)) {
                return RemotePanelType.CONTAINER;
            }
            return RemotePanelType.SETUP;
        }
        if (state.getNeededAction() == State.Action.NeedsVerification) {
            return RemotePanelType.VERIFICATION;
        }
        return RemotePanelType.CONTAINER;
    }

    private TabsPanel.PanelView inflatePanel(RemotePanelType remotePanelType) {
        TabsPanel.PanelView panelView;
        switch (remotePanelType) {
            case SETUP: {
                panelView = new RemoteTabsSetupPanel(this.getContext());
                break;
            }
            case VERIFICATION: {
                panelView = new RemoteTabsVerificationPanel(this.getContext());
                break;
            }
            case CONTAINER: {
                LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
                panelView = (TabsPanel.PanelView)layoutInflater.inflate(R.layout.remote_tabs_container_panel, null);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown panelType, " + (Object)((Object)remotePanelType));
            }
        }
        return panelView;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RemotePanelType {
        SETUP,
        VERIFICATION,
        CONTAINER;

    }
}

