/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib;

import ch.boye.httpclientandroidlib.util.CharArrayBuffer;
import ch.boye.httpclientandroidlib.util.LangUtils;
import java.io.Serializable;
import java.util.Locale;

public final class HttpHost
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -7529410654042457626L;
    public static final String DEFAULT_SCHEME_NAME = "http";
    protected final String hostname;
    protected final String lcHostname;
    protected final int port;
    protected final String schemeName;

    public HttpHost(String string, int n, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Host name may not be null");
        }
        this.hostname = string;
        this.lcHostname = string.toLowerCase(Locale.ENGLISH);
        this.schemeName = string2 != null ? string2.toLowerCase(Locale.ENGLISH) : DEFAULT_SCHEME_NAME;
        this.port = n;
    }

    public HttpHost(String string, int n) {
        this(string, n, null);
    }

    public HttpHost(String string) {
        this(string, -1, null);
    }

    public HttpHost(HttpHost httpHost) {
        this(httpHost.hostname, httpHost.port, httpHost.schemeName);
    }

    public String getHostName() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getSchemeName() {
        return this.schemeName;
    }

    public String toURI() {
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(32);
        charArrayBuffer.append(this.schemeName);
        charArrayBuffer.append("://");
        charArrayBuffer.append(this.hostname);
        if (this.port != -1) {
            charArrayBuffer.append(':');
            charArrayBuffer.append(Integer.toString(this.port));
        }
        return charArrayBuffer.toString();
    }

    public String toHostString() {
        if (this.port != -1) {
            CharArrayBuffer charArrayBuffer = new CharArrayBuffer(this.hostname.length() + 6);
            charArrayBuffer.append(this.hostname);
            charArrayBuffer.append(":");
            charArrayBuffer.append(Integer.toString(this.port));
            return charArrayBuffer.toString();
        }
        return this.hostname;
    }

    public String toString() {
        return this.toURI();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HttpHost) {
            HttpHost httpHost = (HttpHost)object;
            return this.lcHostname.equals(httpHost.lcHostname) && this.port == httpHost.port && this.schemeName.equals(httpHost.schemeName);
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = LangUtils.hashCode(n, this.lcHostname);
        n = LangUtils.hashCode(n, this.port);
        n = LangUtils.hashCode(n, this.schemeName);
        return n;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

