/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.entity;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HeaderElement;
import ch.boye.httpclientandroidlib.HttpException;
import ch.boye.httpclientandroidlib.HttpMessage;
import ch.boye.httpclientandroidlib.ParseException;
import ch.boye.httpclientandroidlib.ProtocolException;
import ch.boye.httpclientandroidlib.entity.ContentLengthStrategy;
import ch.boye.httpclientandroidlib.params.HttpParams;

public class LaxContentLengthStrategy
implements ContentLengthStrategy {
    public long determineLength(HttpMessage httpMessage) throws HttpException {
        if (httpMessage == null) {
            throw new IllegalArgumentException("HTTP message may not be null");
        }
        HttpParams httpParams = httpMessage.getParams();
        boolean bl = httpParams.isParameterTrue("http.protocol.strict-transfer-encoding");
        Header header = httpMessage.getFirstHeader("Transfer-Encoding");
        Header header2 = httpMessage.getFirstHeader("Content-Length");
        if (header != null) {
            int n;
            HeaderElement[] headerElementArray = null;
            try {
                headerElementArray = header.getElements();
            }
            catch (ParseException parseException) {
                throw new ProtocolException("Invalid Transfer-Encoding header value: " + header, parseException);
            }
            if (bl) {
                for (n = 0; n < headerElementArray.length; ++n) {
                    String string = headerElementArray[n].getName();
                    if (string == null || string.length() <= 0 || string.equalsIgnoreCase("chunked") || string.equalsIgnoreCase("identity")) continue;
                    throw new ProtocolException("Unsupported transfer encoding: " + string);
                }
            }
            n = headerElementArray.length;
            if ("identity".equalsIgnoreCase(header.getValue())) {
                return -1L;
            }
            if (n > 0 && "chunked".equalsIgnoreCase(headerElementArray[n - 1].getName())) {
                return -2L;
            }
            if (bl) {
                throw new ProtocolException("Chunk-encoding must be the last one applied");
            }
            return -1L;
        }
        if (header2 != null) {
            long l = -1L;
            Header[] headerArray = httpMessage.getHeaders("Content-Length");
            if (bl && headerArray.length > 1) {
                throw new ProtocolException("Multiple content length headers");
            }
            for (int i = headerArray.length - 1; i >= 0; --i) {
                Header header3 = headerArray[i];
                try {
                    l = Long.parseLong(header3.getValue());
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    if (!bl) continue;
                    throw new ProtocolException("Invalid content length: " + header3.getValue());
                }
            }
            if (l >= 0L) {
                return l;
            }
            return -1L;
        }
        return -1L;
    }
}

