/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.util.Log;
import java.io.File;
import java.util.Map;
import org.mozilla.gecko.GeckoProfileDirectories;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeckoProfilesProvider
extends ContentProvider {
    private static final String LOG_TAG = "GeckoProfilesProvider";
    private static final UriMatcher URI_MATCHER = new UriMatcher(-1);
    private static final int PROFILES = 100;
    private static final int PROFILES_NAME = 101;
    private static final int PROFILES_DEFAULT = 200;
    private static final String[] DEFAULT_ARGS = new String[]{"name", "path"};

    public String getType(Uri uri) {
        return null;
    }

    public boolean onCreate() {
        return true;
    }

    private String[] profileValues(String string2, String string3, int n, int n2, int n3) {
        String[] stringArray = new String[n];
        if (n2 >= 0) {
            stringArray[n2] = string2;
        }
        if (n3 >= 0) {
            stringArray[n3] = string3;
        }
        return stringArray;
    }

    protected void addRowForProfile(MatrixCursor matrixCursor, int n, int n2, int n3, String string2, String string3) {
        if (string3 == null || string2 == null) {
            return;
        }
        String[] stringArray = new String[n];
        if (n2 >= 0) {
            stringArray[n2] = string2;
        }
        if (n3 >= 0) {
            stringArray[n3] = string3;
        }
        matrixCursor.addRow((Object[])this.profileValues(string2, string3, n, n2, n3));
    }

    protected Cursor getCursorForProfiles(String[] stringArray, Map<String, String> map) {
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if ("name".equals(stringArray[i])) {
                n = i;
                continue;
            }
            if (!"path".equals(stringArray[i])) continue;
            n2 = i;
        }
        MatrixCursor matrixCursor = new MatrixCursor(stringArray);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.addRowForProfile(matrixCursor, stringArray.length, n, n2, entry.getKey(), entry.getValue());
        }
        return matrixCursor;
    }

    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        Map<String, String> map;
        File file;
        String[] stringArray3 = stringArray == null ? DEFAULT_ARGS : stringArray;
        try {
            file = GeckoProfileDirectories.getMozillaDirectory(this.getContext());
        }
        catch (GeckoProfileDirectories.NoMozillaDirectoryException noMozillaDirectoryException) {
            Log.d((String)LOG_TAG, (String)"No Mozilla directory; cannot query for profiles. Assuming there are none.");
            return new MatrixCursor(stringArray);
        }
        int n = URI_MATCHER.match(uri);
        switch (n) {
            case 100: {
                map = GeckoProfileDirectories.getAllProfiles(file);
                break;
            }
            case 101: {
                String string4 = uri.getLastPathSegment();
                map = GeckoProfileDirectories.getProfilesNamed(file, string4);
                break;
            }
            case 200: {
                map = GeckoProfileDirectories.getDefaultProfile(file);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown query URI " + uri);
            }
        }
        return this.getCursorForProfiles(stringArray3, map);
    }

    public Uri insert(Uri uri, ContentValues contentValues) {
        throw new IllegalStateException("Inserts not supported.");
    }

    public int delete(Uri uri, String string2, String[] stringArray) {
        throw new IllegalStateException("Deletes not supported.");
    }

    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        throw new IllegalStateException("Updates not supported.");
    }

    static {
        URI_MATCHER.addURI("org.mozilla.fennec.profiles", "profiles", 100);
        URI_MATCHER.addURI("org.mozilla.fennec.profiles", "profiles/*", 101);
        URI_MATCHER.addURI("org.mozilla.fennec.profiles", "default", 200);
    }
}

