/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.R;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.util.GeckoEventListener;

public final class NotificationHelper
implements GeckoEventListener {
    public static final String HELPER_BROADCAST_ACTION = "org.mozilla.fennec.helperBroadcastAction";
    public static final String NOTIFICATION_ID = "NotificationHelper_ID";
    private static final String LOGTAG = "GeckoNotificationHelper";
    private static final String HELPER_NOTIFICATION = "helperNotif";
    private static final String TITLE_ATTR = "title";
    private static final String TEXT_ATTR = "text";
    private static final String ID_ATTR = "id";
    private static final String SMALLICON_ATTR = "smallIcon";
    private static final String PROGRESS_VALUE_ATTR = "progress_value";
    private static final String PROGRESS_MAX_ATTR = "progress_max";
    private static final String PROGRESS_INDETERMINATE_ATTR = "progress_indeterminate";
    private static final String LIGHT_ATTR = "light";
    private static final String ONGOING_ATTR = "ongoing";
    private static final String WHEN_ATTR = "when";
    private static final String PRIORITY_ATTR = "priority";
    private static final String LARGE_ICON_ATTR = "largeIcon";
    private static final String EVENT_TYPE_ATTR = "eventType";
    private static final String ACTIONS_ATTR = "actions";
    private static final String ACTION_ID_ATTR = "buttonId";
    private static final String ACTION_TITLE_ATTR = "title";
    private static final String ACTION_ICON_ATTR = "icon";
    private static final String PERSISTENT_ATTR = "persistent";
    private static final String HANDLER_ATTR = "handlerKey";
    private static final String COOKIE_ATTR = "cookie";
    private static final String NOTIFICATION_SCHEME = "moz-notification";
    private static final String BUTTON_EVENT = "notification-button-clicked";
    private static final String CLICK_EVENT = "notification-clicked";
    private static final String CLEARED_EVENT = "notification-cleared";
    private static final String CLOSED_EVENT = "notification-closed";
    private Context mContext;
    private HashMap<String, String> mClearableNotifications;
    private boolean mInitialized = false;
    private static NotificationHelper sInstance;

    private NotificationHelper(Context context) {
        this.mContext = context;
    }

    public void init() {
        this.mClearableNotifications = new HashMap();
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "Notification:Show", "Notification:Hide");
        this.mInitialized = true;
    }

    public static NotificationHelper getInstance(Context context) {
        if (sInstance != null && !NotificationHelper.sInstance.mInitialized) {
            throw new IllegalStateException("NotificationHelper was created by someone else but not initialized");
        }
        if (sInstance == null) {
            sInstance = new NotificationHelper(context.getApplicationContext());
        }
        return sInstance;
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        if (string2.equals("Notification:Show")) {
            this.showNotification(jSONObject);
        } else if (string2.equals("Notification:Hide")) {
            this.hideNotification(jSONObject);
        }
    }

    public boolean isHelperIntent(Intent intent) {
        return intent.getBooleanExtra(HELPER_NOTIFICATION, false);
    }

    public void handleNotificationIntent(Intent intent) {
        Uri uri = intent.getData();
        if (uri == null) {
            Log.e((String)LOGTAG, (String)"handleNotificationEvent: empty data");
            return;
        }
        String string2 = uri.getQueryParameter(ID_ATTR);
        String string3 = uri.getQueryParameter(EVENT_TYPE_ATTR);
        if (string2 == null || string3 == null) {
            Log.e((String)LOGTAG, (String)"handleNotificationEvent: invalid intent parameters");
            return;
        }
        if (CLEARED_EVENT.equals(string3)) {
            this.mClearableNotifications.remove(string2);
            if (!GeckoThread.checkLaunchState(GeckoThread.LaunchState.GeckoRunning)) {
                return;
            }
        }
        JSONObject jSONObject = new JSONObject();
        String string4 = uri.getQueryParameter(HANDLER_ATTR);
        String string5 = intent.getStringExtra(COOKIE_ATTR);
        try {
            jSONObject.put(ID_ATTR, (Object)string2);
            jSONObject.put(EVENT_TYPE_ATTR, (Object)string3);
            jSONObject.put(HANDLER_ATTR, (Object)string4);
            jSONObject.put(COOKIE_ATTR, (Object)string5);
            if (BUTTON_EVENT.equals(string3)) {
                String string6 = uri.getQueryParameter(ACTION_ID_ATTR);
                jSONObject.put(ACTION_ID_ATTR, (Object)string6);
            }
            Log.i((String)LOGTAG, (String)("Send " + jSONObject.toString()));
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Notification:Event", jSONObject.toString()));
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"Error building JSON notification arguments.", (Throwable)jSONException);
        }
        if (CLICK_EVENT.equals(string3) && !intent.getBooleanExtra(ONGOING_ATTR, false)) {
            this.hideNotification(string2, string4, string5);
        }
    }

    private Uri.Builder getNotificationBuilder(JSONObject jSONObject, String string2) {
        String string3;
        Uri.Builder builder = new Uri.Builder();
        builder.scheme(NOTIFICATION_SCHEME).appendQueryParameter(EVENT_TYPE_ATTR, string2);
        try {
            string3 = jSONObject.getString(ID_ATTR);
            builder.appendQueryParameter(ID_ATTR, string3);
        }
        catch (JSONException jSONException) {
            Log.i((String)LOGTAG, (String)"buildNotificationPendingIntent, error parsing", (Throwable)jSONException);
        }
        try {
            string3 = jSONObject.getString(HANDLER_ATTR);
            builder.appendQueryParameter(HANDLER_ATTR, string3);
        }
        catch (JSONException jSONException) {
            Log.i((String)LOGTAG, (String)"Notification doesn't have a handler");
        }
        return builder;
    }

    private Intent buildNotificationIntent(JSONObject jSONObject, Uri.Builder builder) {
        Intent intent = new Intent(HELPER_BROADCAST_ACTION);
        boolean bl = jSONObject.optBoolean(ONGOING_ATTR);
        intent.putExtra(ONGOING_ATTR, bl);
        Uri uri = builder.build();
        intent.setData(uri);
        intent.putExtra(HELPER_NOTIFICATION, true);
        intent.putExtra(COOKIE_ATTR, jSONObject.optString(COOKIE_ATTR));
        return intent;
    }

    private PendingIntent buildNotificationPendingIntent(JSONObject jSONObject, String string2) {
        Uri.Builder builder = this.getNotificationBuilder(jSONObject, string2);
        Intent intent = this.buildNotificationIntent(jSONObject, builder);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)intent, (int)0x8000000);
        return pendingIntent;
    }

    private PendingIntent buildButtonClickPendingIntent(JSONObject jSONObject, JSONObject jSONObject2) {
        Uri.Builder builder = this.getNotificationBuilder(jSONObject, BUTTON_EVENT);
        try {
            if (jSONObject2.has(ACTION_ID_ATTR)) {
                builder.appendQueryParameter(ACTION_ID_ATTR, jSONObject2.getString(ACTION_ID_ATTR));
            } else {
                Log.i((String)LOGTAG, (String)"button event with no name");
            }
        }
        catch (JSONException jSONException) {
            Log.i((String)LOGTAG, (String)"buildNotificationPendingIntent, error parsing", (Throwable)jSONException);
        }
        Intent intent = this.buildNotificationIntent(jSONObject, builder);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)intent, (int)0x8000000);
        return pendingIntent;
    }

    private void showNotification(JSONObject jSONObject) {
        JSONArray jSONArray;
        int n;
        String string2;
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.mContext);
        try {
            builder.setContentTitle((CharSequence)jSONObject.getString("title"));
            builder.setContentText((CharSequence)jSONObject.getString(TEXT_ATTR));
            string2 = jSONObject.getString(ID_ATTR);
        }
        catch (JSONException jSONException) {
            Log.i((String)LOGTAG, (String)"Error parsing", (Throwable)jSONException);
            return;
        }
        Uri uri = Uri.parse((String)jSONObject.optString(SMALLICON_ATTR));
        builder.setSmallIcon(BitmapUtils.getResource(uri, R.drawable.ic_status_logo));
        JSONArray jSONArray2 = jSONObject.optJSONArray(LIGHT_ATTR);
        if (jSONArray2 != null && jSONArray2.length() == 3) {
            try {
                builder.setLights(jSONArray2.getInt(0), jSONArray2.getInt(1), jSONArray2.getInt(2));
            }
            catch (JSONException jSONException) {
                Log.i((String)LOGTAG, (String)"Error parsing", (Throwable)jSONException);
            }
        }
        boolean bl = jSONObject.optBoolean(ONGOING_ATTR);
        builder.setOngoing(bl);
        if (jSONObject.has(WHEN_ATTR)) {
            long l = jSONObject.optLong(WHEN_ATTR);
            builder.setWhen(l);
        }
        if (jSONObject.has(PRIORITY_ATTR)) {
            int n2 = jSONObject.optInt(PRIORITY_ATTR);
            builder.setPriority(n2);
        }
        if (jSONObject.has(LARGE_ICON_ATTR)) {
            Bitmap bitmap = BitmapUtils.getBitmapFromDataURI(jSONObject.optString(LARGE_ICON_ATTR));
            builder.setLargeIcon(bitmap);
        }
        if (jSONObject.has(PROGRESS_VALUE_ATTR) && jSONObject.has(PROGRESS_MAX_ATTR) && jSONObject.has(PROGRESS_INDETERMINATE_ATTR)) {
            try {
                int n3 = jSONObject.getInt(PROGRESS_VALUE_ATTR);
                n = jSONObject.getInt(PROGRESS_MAX_ATTR);
                boolean bl2 = jSONObject.getBoolean(PROGRESS_INDETERMINATE_ATTR);
                builder.setProgress(n, n3, bl2);
            }
            catch (JSONException jSONException) {
                Log.i((String)LOGTAG, (String)"Error parsing", (Throwable)jSONException);
            }
        }
        if ((jSONArray = jSONObject.optJSONArray(ACTIONS_ATTR)) != null) {
            try {
                for (n = 0; n < jSONArray.length(); ++n) {
                    JSONObject jSONObject2 = jSONArray.getJSONObject(n);
                    PendingIntent pendingIntent = this.buildButtonClickPendingIntent(jSONObject, jSONObject2);
                    String string3 = jSONObject2.getString("title");
                    Uri uri2 = Uri.parse((String)jSONObject2.optString(ACTION_ICON_ATTR));
                    builder.addAction(BitmapUtils.getResource(uri2, R.drawable.ic_status_logo), (CharSequence)string3, pendingIntent);
                }
            }
            catch (JSONException jSONException) {
                Log.i((String)LOGTAG, (String)"Error parsing", (Throwable)jSONException);
            }
        }
        PendingIntent pendingIntent = this.buildNotificationPendingIntent(jSONObject, CLICK_EVENT);
        builder.setContentIntent(pendingIntent);
        PendingIntent pendingIntent2 = this.buildNotificationPendingIntent(jSONObject, CLEARED_EVENT);
        builder.setDeleteIntent(pendingIntent2);
        GeckoAppShell.notificationClient.add(string2.hashCode(), builder.build());
        boolean bl3 = jSONObject.optBoolean(PERSISTENT_ATTR);
        if (!bl3 && !this.mClearableNotifications.containsKey(string2)) {
            this.mClearableNotifications.put(string2, jSONObject.toString());
        }
    }

    private void hideNotification(JSONObject jSONObject) {
        String string2;
        String string3;
        String string4;
        try {
            string4 = jSONObject.getString(ID_ATTR);
            string3 = jSONObject.optString(HANDLER_ATTR);
            string2 = jSONObject.optString(COOKIE_ATTR);
        }
        catch (JSONException jSONException) {
            Log.i((String)LOGTAG, (String)"Error parsing", (Throwable)jSONException);
            return;
        }
        this.hideNotification(string4, string3, string2);
    }

    private void sendNotificationWasClosed(String string2, String string3, String string4) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(ID_ATTR, (Object)string2);
            jSONObject.put(HANDLER_ATTR, (Object)string3);
            jSONObject.put(COOKIE_ATTR, (Object)string4);
            jSONObject.put(EVENT_TYPE_ATTR, (Object)CLOSED_EVENT);
            Log.i((String)LOGTAG, (String)("Send " + jSONObject.toString()));
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Notification:Event", jSONObject.toString()));
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"sendNotificationWasClosed: error building JSON notification arguments.", (Throwable)jSONException);
        }
    }

    private void closeNotification(String string2, String string3, String string4) {
        GeckoAppShell.notificationClient.remove(string2.hashCode());
        this.sendNotificationWasClosed(string2, string3, string4);
    }

    public void hideNotification(String string2, String string3, String string4) {
        this.mClearableNotifications.remove(string2);
        this.closeNotification(string2, string3, string4);
    }

    private void clearAll() {
        Iterator<String> iterator = this.mClearableNotifications.keySet().iterator();
        while (iterator.hasNext()) {
            JSONObject jSONObject;
            String string2 = iterator.next();
            String string3 = this.mClearableNotifications.get(string2);
            iterator.remove();
            try {
                jSONObject = new JSONObject(string3);
            }
            catch (JSONException jSONException) {
                jSONObject = new JSONObject();
            }
            this.closeNotification(string2, jSONObject.optString(HANDLER_ATTR), jSONObject.optString(COOKIE_ATTR));
        }
    }

    public static void destroy() {
        if (sInstance != null) {
            sInstance.clearAll();
        }
    }
}

