/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.util.GeckoEventListener;

public final class SharedPreferencesHelper
implements GeckoEventListener {
    public static final String LOGTAG = "GeckoAndSharedPrefs";
    protected final Context mContext;
    protected final Map<String, SharedPreferences.OnSharedPreferenceChangeListener> mListeners;

    public SharedPreferencesHelper(Context context) {
        this.mContext = context;
        this.mListeners = new HashMap<String, SharedPreferences.OnSharedPreferenceChangeListener>();
        EventDispatcher eventDispatcher = EventDispatcher.getInstance();
        if (eventDispatcher == null) {
            Log.e((String)LOGTAG, (String)"Gecko event dispatcher must not be null", (Throwable)new RuntimeException());
            return;
        }
        eventDispatcher.registerGeckoThreadListener(this, "SharedPreferences:Set", "SharedPreferences:Get", "SharedPreferences:Observe");
    }

    public synchronized void uninit() {
        EventDispatcher eventDispatcher = EventDispatcher.getInstance();
        if (eventDispatcher == null) {
            Log.e((String)LOGTAG, (String)"Gecko event dispatcher must not be null", (Throwable)new RuntimeException());
            return;
        }
        eventDispatcher.unregisterGeckoThreadListener(this, "SharedPreferences:Set", "SharedPreferences:Get", "SharedPreferences:Observe");
    }

    private SharedPreferences getSharedPreferences(JSONObject jSONObject) throws JSONException {
        Scope scope = Scope.forKey(jSONObject.getString("scope"));
        switch (scope) {
            case APP: {
                return GeckoSharedPrefs.forApp(this.mContext);
            }
            case PROFILE: {
                String string2 = jSONObject.optString("profileName", null);
                if (string2 == null) {
                    return GeckoSharedPrefs.forProfile(this.mContext);
                }
                return GeckoSharedPrefs.forProfileName(this.mContext, string2);
            }
            case GLOBAL: {
                String string3 = jSONObject.optString("branch", null);
                if (string3 == null) {
                    return PreferenceManager.getDefaultSharedPreferences((Context)this.mContext);
                }
                return this.mContext.getSharedPreferences(string3, 0);
            }
        }
        return null;
    }

    private String getBranch(Scope scope, String string2, String string3) {
        switch (scope) {
            case APP: {
                return "GeckoApp";
            }
            case PROFILE: {
                if (string2 == null) {
                    string2 = GeckoProfile.get(this.mContext).getName();
                }
                return "GeckoProfile-" + string2;
            }
            case GLOBAL: {
                return string3;
            }
        }
        return null;
    }

    private void handleSet(JSONObject jSONObject) throws JSONException {
        SharedPreferences.Editor editor = this.getSharedPreferences(jSONObject).edit();
        JSONArray jSONArray = jSONObject.getJSONArray("preferences");
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            String string2 = jSONObject2.getString("name");
            String string3 = jSONObject2.getString("type");
            if ("bool".equals(string3)) {
                editor.putBoolean(string2, jSONObject2.getBoolean("value"));
            } else if ("int".equals(string3)) {
                editor.putInt(string2, jSONObject2.getInt("value"));
            } else if ("string".equals(string3)) {
                editor.putString(string2, jSONObject2.getString("value"));
            } else {
                Log.w((String)LOGTAG, (String)("Unknown pref value type [" + string3 + "] for pref [" + string2 + "]"));
            }
            editor.commit();
        }
    }

    private JSONArray handleGet(JSONObject jSONObject) throws JSONException {
        SharedPreferences sharedPreferences = this.getSharedPreferences(jSONObject);
        JSONArray jSONArray = jSONObject.getJSONArray("preferences");
        JSONArray jSONArray2 = new JSONArray();
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            String string2 = jSONObject2.getString("name");
            String string3 = jSONObject2.getString("type");
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("name", (Object)string2);
            jSONObject3.put("type", (Object)string3);
            try {
                if ("bool".equals(string3)) {
                    boolean bl = sharedPreferences.getBoolean(string2, false);
                    jSONObject3.put("value", bl);
                } else if ("int".equals(string3)) {
                    int n = sharedPreferences.getInt(string2, 0);
                    jSONObject3.put("value", n);
                } else if ("string".equals(string3)) {
                    String string4 = sharedPreferences.getString(string2, "");
                    jSONObject3.put("value", (Object)string4);
                } else {
                    Log.w((String)LOGTAG, (String)("Unknown pref value type [" + string3 + "] for pref [" + string2 + "]"));
                }
            }
            catch (ClassCastException classCastException) {
                Log.w((String)LOGTAG, (String)("Wrong pref value type [" + string3 + "] for pref [" + string2 + "]"));
            }
            jSONArray2.put((Object)jSONObject3);
        }
        return jSONArray2;
    }

    private void handleObserve(JSONObject jSONObject) throws JSONException {
        ChangeListener changeListener;
        String string2;
        SharedPreferences sharedPreferences = this.getSharedPreferences(jSONObject);
        boolean bl = jSONObject.getBoolean("enable");
        Scope scope = Scope.forKey(jSONObject.getString("scope"));
        String string3 = this.getBranch(scope, string2 = jSONObject.optString("profileName", null), jSONObject.optString("branch", null));
        if (string3 == null) {
            Log.e((String)LOGTAG, (String)"No branch specified for SharedPreference:Observe; aborting.");
            return;
        }
        if (bl && !this.mListeners.containsKey(string3)) {
            changeListener = new ChangeListener(scope, string3, string2);
            this.mListeners.put(string3, changeListener);
            sharedPreferences.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)changeListener);
        }
        if (!bl && this.mListeners.containsKey(string3)) {
            changeListener = this.mListeners.remove(string3);
            sharedPreferences.unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)changeListener);
        }
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        block8: {
            try {
                if (string2.equals("SharedPreferences:Set")) {
                    if (Log.isLoggable((String)LOGTAG, (int)2)) {
                        Log.v((String)LOGTAG, (String)"Got SharedPreferences:Set message.");
                    }
                    this.handleSet(jSONObject);
                    break block8;
                }
                if (string2.equals("SharedPreferences:Get")) {
                    if (Log.isLoggable((String)LOGTAG, (int)2)) {
                        Log.v((String)LOGTAG, (String)"Got SharedPreferences:Get message.");
                    }
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("values", (Object)this.handleGet(jSONObject));
                    EventDispatcher.sendResponse(jSONObject, jSONObject2);
                    break block8;
                }
                if (string2.equals("SharedPreferences:Observe")) {
                    if (Log.isLoggable((String)LOGTAG, (int)2)) {
                        Log.v((String)LOGTAG, (String)"Got SharedPreferences:Observe message.");
                    }
                    this.handleObserve(jSONObject);
                    break block8;
                }
                Log.e((String)LOGTAG, (String)("SharedPreferencesHelper got unexpected message " + string2));
                return;
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)("Got exception in handleMessage handling event " + string2), (Throwable)jSONException);
                return;
            }
        }
    }

    private static class ChangeListener
    implements SharedPreferences.OnSharedPreferenceChangeListener {
        public final Scope scope;
        public final String branch;
        public final String profileName;

        public ChangeListener(Scope scope, String string2, String string3) {
            this.scope = scope;
            this.branch = string2;
            this.profileName = string3;
        }

        public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String string2) {
            if (Log.isLoggable((String)SharedPreferencesHelper.LOGTAG, (int)2)) {
                Log.v((String)SharedPreferencesHelper.LOGTAG, (String)"Got onSharedPreferenceChanged");
            }
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("scope", (Object)this.scope.key);
                jSONObject.put("branch", (Object)this.branch);
                jSONObject.put("profileName", (Object)this.profileName);
                jSONObject.put("key", (Object)string2);
                jSONObject.put("value", sharedPreferences.getAll().get(string2));
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("SharedPreferences:Changed", jSONObject.toString()));
            }
            catch (JSONException jSONException) {
                Log.e((String)SharedPreferencesHelper.LOGTAG, (String)"Got exception creating JSON object", (Throwable)jSONException);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Scope {
        APP("app"),
        PROFILE("profile"),
        GLOBAL("global");

        public final String key;

        private Scope(String string3) {
            this.key = string3;
        }

        public static Scope forKey(String string2) {
            for (Scope scope : Scope.values()) {
                if (!scope.key.equals(string2)) continue;
                return scope;
            }
            throw new IllegalStateException("SharedPreferences scope must be valid.");
        }
    }
}

