/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.webapp;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import java.util.ArrayList;
import org.mozilla.gecko.GeckoAppShell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Allocator {
    private final String LOGTAG = "GeckoWebappAllocator";
    private static final String PREFIX_ORIGIN = "webapp-origin-";
    private static final String PREFIX_PACKAGE_NAME = "webapp-package-name-";
    private static final String PREFIX_OLD_APP = "app";
    private static final String PREFIX_OLD_ICON = "icon";
    private static final int MAX_WEB_APPS = 100;
    protected static Allocator sInstance = null;
    SharedPreferences mPrefs;

    public static Allocator getInstance() {
        return Allocator.getInstance(GeckoAppShell.getContext());
    }

    public static synchronized Allocator getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new Allocator(context);
        }
        return sInstance;
    }

    protected Allocator(Context context) {
        this.mPrefs = context.getSharedPreferences("webapps", 4);
    }

    private static String appKey(int n) {
        return PREFIX_PACKAGE_NAME + n;
    }

    public static String iconKey(int n) {
        return "web-app-color-" + n;
    }

    public static String originKey(int n) {
        return PREFIX_ORIGIN + n;
    }

    private static String oldAppKey(int n) {
        return PREFIX_OLD_APP + n;
    }

    private static String oldIconKey(int n) {
        return PREFIX_OLD_ICON + n;
    }

    public ArrayList<String> getInstalledPackageNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < 100; ++i) {
            if (!this.mPrefs.contains(Allocator.appKey(i))) continue;
            arrayList.add(this.mPrefs.getString(Allocator.appKey(i), ""));
        }
        return arrayList;
    }

    public synchronized int findOrAllocatePackage(String string2) {
        int n = this.getIndexForApp(string2);
        if (n != -1) {
            return n;
        }
        for (int i = 0; i < 100; ++i) {
            if (this.mPrefs.contains(Allocator.appKey(i))) continue;
            this.putPackageName(i, string2);
            return i;
        }
        return -1;
    }

    public synchronized void putPackageName(int n, String string2) {
        this.mPrefs.edit().putString(Allocator.appKey(n), string2).apply();
    }

    public void updateColor(int n, int n2) {
        this.mPrefs.edit().putInt(Allocator.iconKey(n), n2).apply();
    }

    public synchronized int getIndexForApp(String string2) {
        return this.findSlotForPrefix(PREFIX_PACKAGE_NAME, string2);
    }

    public synchronized int getIndexForOrigin(String string2) {
        return this.findSlotForPrefix(PREFIX_ORIGIN, string2);
    }

    protected int findSlotForPrefix(String string2, String string3) {
        for (int i = 0; i < 100; ++i) {
            if (!this.mPrefs.getString(string2 + i, "").equals(string3)) continue;
            return i;
        }
        return -1;
    }

    public synchronized String getAppForIndex(int n) {
        return this.mPrefs.getString(Allocator.appKey(n), null);
    }

    public synchronized int releaseIndexForApp(String string2) {
        int n = this.getIndexForApp(string2);
        if (n == -1) {
            return -1;
        }
        this.releaseIndex(n);
        return n;
    }

    public synchronized void releaseIndex(int n) {
        this.mPrefs.edit().remove(Allocator.appKey(n)).remove(Allocator.iconKey(n)).remove(Allocator.originKey(n)).apply();
    }

    public void putOrigin(int n, String string2) {
        this.mPrefs.edit().putString(Allocator.originKey(n), string2).apply();
    }

    public String getOrigin(int n) {
        return this.mPrefs.getString(Allocator.originKey(n), null);
    }

    public int getColor(int n) {
        return this.mPrefs.getInt(Allocator.iconKey(n), -1);
    }

    public void maybeMigrateOldPrefs(int n) {
        if (!this.mPrefs.contains(Allocator.oldAppKey(n))) {
            return;
        }
        Log.i((String)"GeckoWebappAllocator", (String)"migrating old prefs");
        this.putOrigin(n, this.mPrefs.getString(Allocator.oldAppKey(n), null));
        this.updateColor(n, this.mPrefs.getInt(Allocator.oldIconKey(n), -1));
        this.mPrefs.edit().remove(Allocator.oldAppKey(n)).remove(Allocator.oldIconKey(n)).apply();
    }
}

