/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.message;

import ch.boye.httpclientandroidlib.HttpRequest;
import ch.boye.httpclientandroidlib.ProtocolVersion;
import ch.boye.httpclientandroidlib.RequestLine;
import ch.boye.httpclientandroidlib.message.AbstractHttpMessage;
import ch.boye.httpclientandroidlib.message.BasicRequestLine;
import ch.boye.httpclientandroidlib.params.HttpProtocolParams;

public class BasicHttpRequest
extends AbstractHttpMessage
implements HttpRequest {
    private final String method;
    private final String uri;
    private RequestLine requestline;

    public BasicHttpRequest(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Method name may not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Request URI may not be null");
        }
        this.method = string;
        this.uri = string2;
        this.requestline = null;
    }

    public BasicHttpRequest(String string, String string2, ProtocolVersion protocolVersion) {
        this(new BasicRequestLine(string, string2, protocolVersion));
    }

    public BasicHttpRequest(RequestLine requestLine) {
        if (requestLine == null) {
            throw new IllegalArgumentException("Request line may not be null");
        }
        this.requestline = requestLine;
        this.method = requestLine.getMethod();
        this.uri = requestLine.getUri();
    }

    public ProtocolVersion getProtocolVersion() {
        return this.getRequestLine().getProtocolVersion();
    }

    public RequestLine getRequestLine() {
        if (this.requestline == null) {
            ProtocolVersion protocolVersion = HttpProtocolParams.getVersion(this.getParams());
            this.requestline = new BasicRequestLine(this.method, this.uri, protocolVersion);
        }
        return this.requestline;
    }

    public String toString() {
        return this.method + " " + this.uri + " " + this.headergroup;
    }
}

