/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.provider.MediaStore;
import com.squareup.picasso.Action;
import com.squareup.picasso.Cache;
import com.squareup.picasso.ContentStreamBitmapHunter;
import com.squareup.picasso.Dispatcher;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.picasso.Stats;
import java.io.IOException;

class MediaStoreBitmapHunter
extends ContentStreamBitmapHunter {
    private static final String[] CONTENT_ORIENTATION = new String[]{"orientation"};

    MediaStoreBitmapHunter(Context context, Picasso picasso, Dispatcher dispatcher, Cache cache, Stats stats, Action action) {
        super(context, picasso, dispatcher, cache, stats, action);
    }

    Bitmap decode(Request request) throws IOException {
        ContentResolver contentResolver = this.context.getContentResolver();
        this.setExifRotation(MediaStoreBitmapHunter.getExitOrientation(contentResolver, request.uri));
        if (request.hasSize()) {
            PicassoKind picassoKind = MediaStoreBitmapHunter.getPicassoKind(request.targetWidth, request.targetHeight);
            if (picassoKind == PicassoKind.FULL) {
                return super.decode(request);
            }
            long l = ContentUris.parseId((Uri)request.uri);
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            MediaStoreBitmapHunter.calculateInSampleSize(request.targetWidth, request.targetHeight, picassoKind.width, picassoKind.height, options);
            Bitmap bitmap = MediaStore.Images.Thumbnails.getThumbnail((ContentResolver)contentResolver, (long)l, (int)picassoKind.androidKind, (BitmapFactory.Options)options);
            if (bitmap != null) {
                return bitmap;
            }
        }
        return super.decode(request);
    }

    static PicassoKind getPicassoKind(int n, int n2) {
        if (n <= PicassoKind.MICRO.width && n2 <= PicassoKind.MICRO.height) {
            return PicassoKind.MICRO;
        }
        if (n <= PicassoKind.MINI.width && n2 <= PicassoKind.MINI.height) {
            return PicassoKind.MINI;
        }
        return PicassoKind.FULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getExitOrientation(ContentResolver contentResolver, Uri uri) {
        Cursor cursor = null;
        try {
            cursor = contentResolver.query(uri, CONTENT_ORIENTATION, null, null, null);
            if (cursor == null || !cursor.moveToFirst()) {
                int n = 0;
                return n;
            }
            int n = cursor.getInt(0);
            return n;
        }
        catch (RuntimeException runtimeException) {
            int n = 0;
            return n;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PicassoKind {
        MICRO(3, 96, 96),
        MINI(1, 512, 384),
        FULL(2, -1, -1);

        final int androidKind;
        final int width;
        final int height;

        private PicassoKind(int n2, int n3, int n4) {
            this.androidKind = n2;
            this.width = n3;
            this.height = n4;
        }
    }
}

