/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.NetworkInfo;
import com.squareup.picasso.Action;
import com.squareup.picasso.BitmapHunter;
import com.squareup.picasso.Cache;
import com.squareup.picasso.Dispatcher;
import com.squareup.picasso.Downloader;
import com.squareup.picasso.MarkableInputStream;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.picasso.Stats;
import com.squareup.picasso.Utils;
import java.io.IOException;
import java.io.InputStream;

class NetworkBitmapHunter
extends BitmapHunter {
    static final int DEFAULT_RETRY_COUNT = 2;
    private static final int MARKER = 65536;
    private final Downloader downloader;
    int retryCount;

    public NetworkBitmapHunter(Picasso picasso, Dispatcher dispatcher, Cache cache, Stats stats, Action action, Downloader downloader) {
        super(picasso, dispatcher, cache, stats, action);
        this.downloader = downloader;
        this.retryCount = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bitmap decode(Request request) throws IOException {
        boolean bl = this.retryCount == 0;
        Downloader.Response response = this.downloader.load(request.uri, bl);
        if (response == null) {
            return null;
        }
        this.loadedFrom = response.cached ? Picasso.LoadedFrom.DISK : Picasso.LoadedFrom.NETWORK;
        Bitmap bitmap = response.getBitmap();
        if (bitmap != null) {
            return bitmap;
        }
        InputStream inputStream = response.getInputStream();
        try {
            Bitmap bitmap2 = this.decodeStream(inputStream, request);
            return bitmap2;
        }
        finally {
            Utils.closeQuietly(inputStream);
        }
    }

    boolean shouldRetry(boolean bl, NetworkInfo networkInfo) {
        boolean bl2;
        boolean bl3 = bl2 = this.retryCount > 0;
        if (!bl2) {
            return false;
        }
        --this.retryCount;
        return networkInfo == null || networkInfo.isConnectedOrConnecting();
    }

    private Bitmap decodeStream(InputStream inputStream, Request request) throws IOException {
        if (inputStream == null) {
            return null;
        }
        MarkableInputStream markableInputStream = new MarkableInputStream(inputStream);
        inputStream = markableInputStream;
        long l = markableInputStream.savePosition(65536);
        boolean bl = Utils.isWebPFile(inputStream);
        markableInputStream.reset(l);
        if (bl) {
            byte[] byArray = Utils.toByteArray(inputStream);
            BitmapFactory.Options options = null;
            if (request.hasSize()) {
                options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options);
                NetworkBitmapHunter.calculateInSampleSize(request.targetWidth, request.targetHeight, options);
            }
            return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options);
        }
        BitmapFactory.Options options = null;
        if (request.hasSize()) {
            options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            NetworkBitmapHunter.calculateInSampleSize(request.targetWidth, request.targetHeight, options);
            markableInputStream.reset(l);
        }
        return BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
    }
}

