/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.io;

import ch.boye.httpclientandroidlib.impl.io.AbstractSessionInputBuffer;
import ch.boye.httpclientandroidlib.io.EofSensor;
import ch.boye.httpclientandroidlib.params.HttpParams;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;

public class SocketInputBuffer
extends AbstractSessionInputBuffer
implements EofSensor {
    private static final Class SOCKET_TIMEOUT_CLASS = SocketInputBuffer.SocketTimeoutExceptionClass();
    private final Socket socket;
    private boolean eof;

    private static Class SocketTimeoutExceptionClass() {
        try {
            return Class.forName("java.net.SocketTimeoutException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static boolean isSocketTimeoutException(InterruptedIOException interruptedIOException) {
        if (SOCKET_TIMEOUT_CLASS != null) {
            return SOCKET_TIMEOUT_CLASS.isInstance(interruptedIOException);
        }
        return true;
    }

    public SocketInputBuffer(Socket socket, int n, HttpParams httpParams) throws IOException {
        if (socket == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        this.socket = socket;
        this.eof = false;
        if (n < 0) {
            n = socket.getReceiveBufferSize();
        }
        if (n < 1024) {
            n = 1024;
        }
        this.init(socket.getInputStream(), n, httpParams);
    }

    protected int fillBuffer() throws IOException {
        int n = super.fillBuffer();
        this.eof = n == -1;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDataAvailable(int n) throws IOException {
        boolean bl = this.hasBufferedData();
        if (!bl) {
            int n2 = this.socket.getSoTimeout();
            try {
                this.socket.setSoTimeout(n);
                this.fillBuffer();
                bl = this.hasBufferedData();
            }
            catch (InterruptedIOException interruptedIOException) {
                if (!SocketInputBuffer.isSocketTimeoutException(interruptedIOException)) {
                    throw interruptedIOException;
                }
            }
            finally {
                this.socket.setSoTimeout(n2);
            }
        }
        return bl;
    }

    public boolean isEof() {
        return this.eof;
    }
}

