/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.R;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrashReporter
extends Activity {
    private static final String LOGTAG = "GeckoCrashReporter";
    private static final String PASSED_MINI_DUMP_KEY = "minidumpPath";
    private static final String MINI_DUMP_PATH_KEY = "upload_file_minidump";
    private static final String PAGE_URL_KEY = "URL";
    private static final String NOTES_KEY = "Notes";
    private static final String SERVER_URL_KEY = "ServerURL";
    private static final String CRASH_REPORT_SUFFIX = "/mozilla/Crash Reports/";
    private static final String PENDING_SUFFIX = "/mozilla/Crash Reports/pending";
    private static final String SUBMITTED_SUFFIX = "/mozilla/Crash Reports/submitted";
    private static final String PREFS_SEND_REPORT = "sendReport";
    private static final String PREFS_INCLUDE_URL = "includeUrl";
    private static final String PREFS_ALLOW_CONTACT = "allowContact";
    private static final String PREFS_CONTACT_EMAIL = "contactEmail";
    private Handler mHandler;
    private ProgressDialog mProgressDialog;
    private File mPendingMinidumpFile;
    private File mPendingExtrasFile;
    private HashMap<String, String> mExtrasStringMap;

    private boolean moveFile(File file, File file2) {
        Log.i((String)LOGTAG, (String)("moving " + file + " to " + file2));
        if (file.renameTo(file2)) {
            return true;
        }
        try {
            file2.createNewFile();
            Log.i((String)LOGTAG, (String)"couldn't rename minidump file");
            FileChannel fileChannel = new FileInputStream(file).getChannel();
            FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
            long l = fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
            fileChannel.close();
            fileChannel2.close();
            if (l > 0L) {
                file.delete();
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"exception while copying minidump file: ", (Throwable)exception);
            return false;
        }
        return true;
    }

    private void doFinish() {
        if (this.mHandler != null) {
            this.mHandler.post(new Runnable(){

                public void run() {
                    CrashReporter.this.finish();
                }
            });
        }
    }

    public void finish() {
        try {
            if (this.mProgressDialog.isShowing()) {
                this.mProgressDialog.dismiss();
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"exception while closing progress dialog: ", (Throwable)exception);
        }
        super.finish();
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.mHandler = new Handler();
        this.setContentView(R.layout.crash_reporter);
        this.mProgressDialog = new ProgressDialog((Context)this);
        this.mProgressDialog.setMessage((CharSequence)this.getString(R.string.sending_crash_report));
        String string2 = this.getIntent().getStringExtra(PASSED_MINI_DUMP_KEY);
        File file = new File(string2);
        File file2 = new File(this.getFilesDir(), PENDING_SUFFIX);
        file2.mkdirs();
        this.mPendingMinidumpFile = new File(file2, file.getName());
        this.moveFile(file, this.mPendingMinidumpFile);
        File file3 = new File(string2.replaceAll(".dmp", ".extra"));
        this.mPendingExtrasFile = new File(file2, file3.getName());
        this.moveFile(file3, this.mPendingExtrasFile);
        this.mExtrasStringMap = new HashMap();
        this.readStringsFromFile(this.mPendingExtrasFile.getPath(), this.mExtrasStringMap);
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp((Context)this);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean("wasStopped", true);
        editor.putBoolean("crashed", true);
        editor.commit();
        final CheckBox checkBox = (CheckBox)this.findViewById(R.id.allow_contact);
        final CheckBox checkBox2 = (CheckBox)this.findViewById(R.id.include_url);
        final CheckBox checkBox3 = (CheckBox)this.findViewById(R.id.send_report);
        final EditText editText = (EditText)this.findViewById(R.id.comment);
        final EditText editText2 = (EditText)this.findViewById(R.id.email);
        boolean bl = sharedPreferences.getBoolean(PREFS_SEND_REPORT, true);
        boolean bl2 = sharedPreferences.getBoolean(PREFS_INCLUDE_URL, false);
        boolean bl3 = sharedPreferences.getBoolean(PREFS_ALLOW_CONTACT, false);
        String string3 = sharedPreferences.getString(PREFS_CONTACT_EMAIL, "");
        checkBox.setChecked(bl3);
        checkBox2.setChecked(bl2);
        checkBox3.setChecked(bl);
        editText2.setText((CharSequence)string3);
        checkBox3.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton compoundButton, boolean bl) {
                editText.setEnabled(bl);
                editText.requestFocus();
                checkBox2.setEnabled(bl);
                checkBox.setEnabled(bl);
                editText2.setEnabled(bl && checkBox.isChecked());
            }
        });
        checkBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton compoundButton, boolean bl) {
                editText2.setEnabled(compoundButton.isEnabled() && bl);
                editText2.requestFocus();
            }
        });
        editText2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (checkBox3.isChecked() && !view.isEnabled()) {
                    checkBox.setChecked(true);
                    view.setEnabled(true);
                    view.requestFocus();
                }
            }
        });
    }

    public void onBackPressed() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setMessage(R.string.crash_closing_alert);
        builder.setNegativeButton(R.string.button_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                dialogInterface.dismiss();
            }
        });
        builder.setPositiveButton(R.string.button_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                CrashReporter.this.finish();
            }
        });
        builder.show();
    }

    private void backgroundSendReport() {
        CheckBox checkBox = (CheckBox)this.findViewById(R.id.send_report);
        if (!checkBox.isChecked()) {
            this.doFinish();
            return;
        }
        this.savePrefs();
        this.mProgressDialog.show();
        new Thread(new Runnable(){

            public void run() {
                CrashReporter.this.sendReport(CrashReporter.this.mPendingMinidumpFile, CrashReporter.this.mExtrasStringMap, CrashReporter.this.mPendingExtrasFile);
            }
        }, "CrashReporter Thread").start();
    }

    private void savePrefs() {
        SharedPreferences.Editor editor = GeckoSharedPrefs.forApp((Context)this).edit();
        boolean bl = ((CheckBox)this.findViewById(R.id.allow_contact)).isChecked();
        boolean bl2 = ((CheckBox)this.findViewById(R.id.include_url)).isChecked();
        boolean bl3 = ((CheckBox)this.findViewById(R.id.send_report)).isChecked();
        String string2 = ((EditText)this.findViewById(R.id.email)).getText().toString();
        editor.putBoolean(PREFS_ALLOW_CONTACT, bl);
        editor.putBoolean(PREFS_INCLUDE_URL, bl2);
        editor.putBoolean(PREFS_SEND_REPORT, bl3);
        editor.putString(PREFS_CONTACT_EMAIL, string2);
        editor.apply();
    }

    public void onCloseClick(View view) {
        this.backgroundSendReport();
    }

    public void onRestartClick(View view) {
        this.doRestart();
        this.backgroundSendReport();
    }

    private boolean readStringsFromFile(String string2, Map<String, String> map) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
            return this.readStringsFromReader(bufferedReader, map);
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"exception while reading strings: ", (Throwable)exception);
            return false;
        }
    }

    private boolean readStringsFromReader(BufferedReader bufferedReader, Map<String, String> map) throws IOException {
        String string2;
        while ((string2 = bufferedReader.readLine()) != null) {
            int n = -1;
            n = string2.indexOf(61);
            if (n == -1) continue;
            String string3 = string2.substring(0, n);
            String string4 = this.unescape(string2.substring(n + 1));
            map.put(string3, string4);
        }
        bufferedReader.close();
        return true;
    }

    private String generateBoundary() {
        int n = (int)(2.147483647E9 * Math.random());
        int n2 = (int)(2.147483647E9 * Math.random());
        return String.format("---------------------------%08X%08X", n, n2);
    }

    private void sendPart(OutputStream outputStream, String string2, String string3, String string4) {
        try {
            outputStream.write(("--" + string2 + "\r\n" + "Content-Disposition: form-data; name=\"" + string3 + "\"\r\n" + "\r\n" + string4 + "\r\n").getBytes());
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("Exception when sending \"" + string3 + "\""), (Throwable)exception);
        }
    }

    private void sendFile(OutputStream outputStream, String string2, String string3, File file) throws IOException {
        outputStream.write(("--" + string2 + "\r\n" + "Content-Disposition: form-data; name=\"" + string3 + "\"; " + "filename=\"" + file.getName() + "\"\r\n" + "Content-Type: application/octet-stream\r\n" + "\r\n").getBytes());
        FileChannel fileChannel = new FileInputStream(file).getChannel();
        fileChannel.transferTo(0L, fileChannel.size(), Channels.newChannel(outputStream));
        fileChannel.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readLogcat() {
        BufferedReader bufferedReader = null;
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"logcat", "-v", "threadtime", "-t", "200", "-d", "*:D"});
            StringBuilder stringBuilder = new StringBuilder();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                stringBuilder.append(string2).append('\n');
                string2 = bufferedReader.readLine();
            }
            string2 = stringBuilder.toString();
            return string2;
        }
        catch (Exception exception) {
            String string3 = "Unable to get logcat: " + exception.toString();
            return string3;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void sendReport(File file, Map<String, String> map, File file2) {
        Log.i((String)LOGTAG, (String)("sendReport: " + file.getPath()));
        CheckBox checkBox = (CheckBox)this.findViewById(R.id.include_url);
        String string2 = map.get(SERVER_URL_KEY);
        if (string2 == null) {
            this.doFinish();
            return;
        }
        Log.i((String)LOGTAG, (String)("server url: " + string2));
        try {
            Object object;
            String string32;
            URL uRL = new URL(string2);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            String string4 = this.generateBoundary();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + string4);
            httpURLConnection.setRequestProperty("Content-Encoding", "gzip");
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(httpURLConnection.getOutputStream());
            for (String string32 : map.keySet()) {
                if (string32.equals(PAGE_URL_KEY)) {
                    if (!checkBox.isChecked()) continue;
                    this.sendPart(gZIPOutputStream, string4, string32, map.get(string32));
                    continue;
                }
                if (string32.equals(SERVER_URL_KEY) || string32.equals(NOTES_KEY)) continue;
                this.sendPart(gZIPOutputStream, string4, string32, map.get(string32));
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(map.containsKey(NOTES_KEY) ? map.get(NOTES_KEY) + "\n" : "");
            stringBuilder.append(Build.MANUFACTURER).append(' ').append(Build.MODEL).append('\n').append(Build.FINGERPRINT);
            this.sendPart(gZIPOutputStream, string4, NOTES_KEY, stringBuilder.toString());
            this.sendPart(gZIPOutputStream, string4, "Min_ARM_Version", Integer.toString(7));
            this.sendPart(gZIPOutputStream, string4, "Android_Manufacturer", Build.MANUFACTURER);
            this.sendPart(gZIPOutputStream, string4, "Android_Model", Build.MODEL);
            this.sendPart(gZIPOutputStream, string4, "Android_Board", Build.BOARD);
            this.sendPart(gZIPOutputStream, string4, "Android_Brand", Build.BRAND);
            this.sendPart(gZIPOutputStream, string4, "Android_Device", Build.DEVICE);
            this.sendPart(gZIPOutputStream, string4, "Android_Display", Build.DISPLAY);
            this.sendPart(gZIPOutputStream, string4, "Android_Fingerprint", Build.FINGERPRINT);
            this.sendPart(gZIPOutputStream, string4, "Android_CPU_ABI", Build.CPU_ABI);
            try {
                this.sendPart(gZIPOutputStream, string4, "Android_CPU_ABI2", Build.CPU_ABI2);
                this.sendPart(gZIPOutputStream, string4, "Android_Hardware", Build.HARDWARE);
            }
            catch (Exception exception) {
                Log.e((String)LOGTAG, (String)"Exception while sending SDK version 8 keys", (Throwable)exception);
            }
            this.sendPart(gZIPOutputStream, string4, "Android_Version", Build.VERSION.SDK_INT + " (" + Build.VERSION.CODENAME + ")");
            if (Build.VERSION.SDK_INT >= 16 && checkBox.isChecked()) {
                this.sendPart(gZIPOutputStream, string4, "Android_Logcat", this.readLogcat());
            }
            if (!TextUtils.isEmpty((CharSequence)(string32 = ((EditText)this.findViewById(R.id.comment)).getText().toString()))) {
                this.sendPart(gZIPOutputStream, string4, "Comments", string32);
            }
            if (((CheckBox)this.findViewById(R.id.allow_contact)).isChecked()) {
                object = ((EditText)this.findViewById(R.id.email)).getText().toString();
                this.sendPart(gZIPOutputStream, string4, "Email", (String)object);
            }
            this.sendFile(gZIPOutputStream, string4, MINI_DUMP_PATH_KEY, file);
            ((OutputStream)gZIPOutputStream).write(("\r\n--" + string4 + "--\r\n").getBytes());
            ((OutputStream)gZIPOutputStream).flush();
            ((OutputStream)gZIPOutputStream).close();
            object = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            HashMap<String, String> hashMap = new HashMap<String, String>();
            this.readStringsFromReader((BufferedReader)object, hashMap);
            if (httpURLConnection.getResponseCode() == 200) {
                File file3 = new File(this.getFilesDir(), SUBMITTED_SUFFIX);
                file3.mkdirs();
                file.delete();
                file2.delete();
                String string5 = hashMap.get("CrashID");
                File file4 = new File(file3, string5 + ".txt");
                FileOutputStream fileOutputStream = new FileOutputStream(file4);
                fileOutputStream.write("Crash ID: ".getBytes());
                fileOutputStream.write(string5.getBytes());
                fileOutputStream.close();
            } else {
                Log.i((String)LOGTAG, (String)("Received failure HTTP response code from server: " + httpURLConnection.getResponseCode()));
            }
        }
        catch (IOException iOException) {
            Log.e((String)LOGTAG, (String)"exception during send: ", (Throwable)iOException);
        }
        this.doFinish();
    }

    private void doRestart() {
        try {
            String string2 = "android.intent.action.MAIN";
            Intent intent = new Intent(string2);
            intent.setClassName("org.mozilla.fennec", "org.mozilla.gecko.BrowserApp");
            intent.putExtra("didRestart", true);
            Log.i((String)LOGTAG, (String)intent.toString());
            this.startActivity(intent);
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"error while trying to restart", (Throwable)exception);
        }
    }

    private String unescape(String string2) {
        return string2.replaceAll("\\\\\\\\", "\\").replaceAll("\\\\n", "\n").replaceAll("\\\\t", "\t");
    }
}

