/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.healthreport.prune;

import android.content.SharedPreferences;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.healthreport.prune.PrunePolicyStorage;

public class PrunePolicy {
    public static final String LOG_TAG = PrunePolicy.class.getSimpleName();
    protected final PrunePolicyStorage storage;
    protected final SharedPreferences sharedPreferences;
    protected final Editor editor;

    public PrunePolicy(PrunePolicyStorage prunePolicyStorage, SharedPreferences sharedPreferences) {
        this.storage = prunePolicyStorage;
        this.sharedPreferences = sharedPreferences;
        this.editor = new Editor(this.sharedPreferences.edit());
    }

    protected SharedPreferences getSharedPreferences() {
        return this.sharedPreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick(long l) {
        try {
            try {
                boolean bl = this.attemptPruneBySize(l);
                boolean bl2 = bl = this.attemptExpiration(l) ? true : bl;
                if (bl) {
                    this.attemptStorageCleanup(l);
                }
            }
            catch (Exception exception) {
                Logger.error(LOG_TAG, "Got exception pruning document.", exception);
            }
            finally {
                this.editor.commit();
            }
        }
        catch (Exception exception) {
            Logger.error(LOG_TAG, "Got exception committing to SharedPreferences.", exception);
        }
        finally {
            this.storage.close();
        }
    }

    protected boolean attemptPruneBySize(long l) {
        int n;
        long l2 = this.getNextPruneBySizeTime();
        if (l2 < 0L) {
            Logger.debug(LOG_TAG, "Initializing prune-by-size time.");
            this.editor.setNextPruneBySizeTime(l + this.getMinimumTimeBetweenPruneBySizeChecks());
            return false;
        }
        if (l2 > this.getMinimumTimeBetweenPruneBySizeChecks() + l) {
            Logger.debug(LOG_TAG, "Clock skew detected - resetting prune-by-size time.");
            this.editor.setNextPruneBySizeTime(l + this.getMinimumTimeBetweenPruneBySizeChecks());
            return false;
        }
        if (l2 > l) {
            Logger.debug(LOG_TAG, "Skipping prune-by-size - wait period has not yet elapsed.");
            return false;
        }
        Logger.debug(LOG_TAG, "Attempting prune-by-size.");
        int n2 = this.storage.getEnvironmentCount();
        if (n2 > this.getMaxEnvironmentCount()) {
            n = n2 - this.getEnvironmentCountAfterPrune();
            Logger.debug(LOG_TAG, "Pruning " + n + " environments.");
            this.storage.pruneEnvironments(n);
        }
        if ((n = this.storage.getEventCount()) > this.getMaxEventCount()) {
            int n3 = n - this.getEventCountAfterPrune();
            Logger.debug(LOG_TAG, "Pruning up to " + n3 + " events.");
            this.storage.pruneEvents(n3);
        }
        this.editor.setNextPruneBySizeTime(l + this.getMinimumTimeBetweenPruneBySizeChecks());
        return true;
    }

    protected boolean attemptExpiration(long l) {
        long l2 = this.getNextExpirationTime();
        if (l2 < 0L) {
            Logger.debug(LOG_TAG, "Initializing expiration time.");
            this.editor.setNextExpirationTime(l + this.getMinimumTimeBetweenExpirationChecks());
            return false;
        }
        if (l2 > this.getMinimumTimeBetweenExpirationChecks() + l) {
            Logger.debug(LOG_TAG, "Clock skew detected - resetting expiration time.");
            this.editor.setNextExpirationTime(l + this.getMinimumTimeBetweenExpirationChecks());
            return false;
        }
        if (l2 > l) {
            Logger.debug(LOG_TAG, "Skipping expiration - wait period has not yet elapsed.");
            return false;
        }
        long l3 = l - this.getEventExistenceDuration();
        Logger.debug(LOG_TAG, "Pruning data older than " + l3 + ".");
        this.storage.deleteDataBefore(l3);
        this.editor.setNextExpirationTime(l + this.getMinimumTimeBetweenExpirationChecks());
        return true;
    }

    protected boolean attemptStorageCleanup(long l) {
        long l2 = this.getNextCleanupTime();
        if (l2 < 0L) {
            Logger.debug(LOG_TAG, "Initializing cleanup time.");
            this.editor.setNextCleanupTime(l + this.getMinimumTimeBetweenCleanupChecks());
            return false;
        }
        if (l2 > this.getMinimumTimeBetweenCleanupChecks() + l) {
            Logger.debug(LOG_TAG, "Clock skew detected - resetting cleanup time.");
            this.editor.setNextCleanupTime(l + this.getMinimumTimeBetweenCleanupChecks());
            return false;
        }
        if (l2 > l) {
            Logger.debug(LOG_TAG, "Skipping cleanup - wait period has not yet elapsed.");
            return false;
        }
        this.editor.setNextCleanupTime(l + this.getMinimumTimeBetweenCleanupChecks());
        Logger.debug(LOG_TAG, "Cleaning up storage.");
        this.storage.cleanup();
        return true;
    }

    private long getNextExpirationTime() {
        return this.getSharedPreferences().getLong("healthreport_expiration_time", -1L);
    }

    private long getEventExistenceDuration() {
        return 15552000000L;
    }

    private long getMinimumTimeBetweenExpirationChecks() {
        return 604800000L;
    }

    private long getNextPruneBySizeTime() {
        return this.getSharedPreferences().getLong("healthreport_prune_by_size_time", -1L);
    }

    private long getMinimumTimeBetweenPruneBySizeChecks() {
        return 86400000L;
    }

    private int getMaxEnvironmentCount() {
        return 50;
    }

    private int getEnvironmentCountAfterPrune() {
        return 35;
    }

    private int getMaxEventCount() {
        return 10000;
    }

    private int getEventCountAfterPrune() {
        return 8000;
    }

    private long getNextCleanupTime() {
        return this.getSharedPreferences().getLong("healthreport_cleanup_time", -1L);
    }

    private long getMinimumTimeBetweenCleanupChecks() {
        return 2592000000L;
    }

    protected static class Editor {
        protected final SharedPreferences.Editor editor;

        public Editor(SharedPreferences.Editor editor) {
            this.editor = editor;
        }

        public void commit() {
            this.editor.commit();
        }

        public Editor setNextExpirationTime(long l) {
            this.editor.putLong("healthreport_expiration_time", l);
            return this;
        }

        public Editor setNextPruneBySizeTime(long l) {
            this.editor.putLong("healthreport_prune_by_size_time", l);
            return this;
        }

        public Editor setNextCleanupTime(long l) {
            this.editor.putLong("healthreport_cleanup_time", l);
            return this;
        }
    }
}

