/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.graphics.Bitmap;
import android.util.Log;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.mozilla.gecko.gfx.CairoImage;
import org.mozilla.gecko.gfx.CairoUtils;
import org.mozilla.gecko.gfx.IntSize;
import org.mozilla.gecko.mozglue.DirectBufferAllocator;

public class BufferedCairoImage
extends CairoImage {
    private ByteBuffer mBuffer;
    private IntSize mSize;
    private int mFormat;
    private static String LOGTAG = "GeckoBufferedCairoImage";

    public BufferedCairoImage(ByteBuffer byteBuffer, int n, int n2, int n3) {
        this.setBuffer(byteBuffer, n, n2, n3);
    }

    public BufferedCairoImage(Bitmap bitmap) {
        this.setBitmap(bitmap);
    }

    private synchronized void freeBuffer() {
        this.mBuffer = DirectBufferAllocator.free((ByteBuffer)this.mBuffer);
    }

    public void destroy() {
        try {
            this.freeBuffer();
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)"error clearing buffer: ", (Throwable)exception);
        }
    }

    public ByteBuffer getBuffer() {
        return this.mBuffer;
    }

    public IntSize getSize() {
        return this.mSize;
    }

    public int getFormat() {
        return this.mFormat;
    }

    public void setBuffer(ByteBuffer byteBuffer, int n, int n2, int n3) {
        this.freeBuffer();
        this.mBuffer = byteBuffer;
        this.mSize = new IntSize(n, n2);
        this.mFormat = n3;
    }

    public void setBitmap(Bitmap bitmap) {
        this.mFormat = CairoUtils.bitmapConfigToCairoFormat(bitmap.getConfig());
        this.mSize = new IntSize(bitmap.getWidth(), bitmap.getHeight());
        int n = CairoUtils.bitsPerPixelForCairoFormat(this.mFormat);
        this.mBuffer = DirectBufferAllocator.allocate((int)(this.mSize.getArea() * n));
        bitmap.copyPixelsToBuffer((Buffer)this.mBuffer.asIntBuffer());
    }
}

