/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.content.res.TypedArray;
import android.preference.DialogPreference;
import android.util.AttributeSet;
import java.util.HashSet;
import java.util.Set;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.R;
import org.mozilla.gecko.util.PrefUtils;
import org.mozilla.gecko.util.ThreadUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultiChoicePreference
extends DialogPreference
implements DialogInterface.OnMultiChoiceClickListener {
    private static final String LOGTAG = "GeckoMultiChoicePreference";
    private boolean[] mValues;
    private boolean[] mPrevValues;
    private CharSequence[] mEntryValues;
    private CharSequence[] mEntries;
    private CharSequence[] mInitialValues;

    public MultiChoicePreference(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.MultiChoicePreference);
        this.mEntries = typedArray.getTextArray(0);
        this.mEntryValues = typedArray.getTextArray(1);
        this.mInitialValues = typedArray.getTextArray(2);
        typedArray.recycle();
        this.loadPersistedValues();
    }

    public MultiChoicePreference(Context context) {
        this(context, null);
    }

    public void setEntries(CharSequence[] charSequenceArray) {
        this.mEntries = (CharSequence[])charSequenceArray.clone();
    }

    public void setEntries(int n) {
        this.setEntries(this.getContext().getResources().getTextArray(n));
    }

    public void setEntryValues(CharSequence[] charSequenceArray) {
        this.mEntryValues = (CharSequence[])charSequenceArray.clone();
        this.loadPersistedValues();
    }

    public void setEntryValues(int n) {
        this.setEntryValues(this.getContext().getResources().getTextArray(n));
    }

    public void setInitialValues(CharSequence[] charSequenceArray) {
        this.mInitialValues = (CharSequence[])charSequenceArray.clone();
        this.loadPersistedValues();
    }

    public void setInitialValues(int n) {
        this.setInitialValues(this.getContext().getResources().getTextArray(n));
    }

    public CharSequence[] getEntries() {
        return (CharSequence[])this.mEntries.clone();
    }

    public CharSequence[] getEntryValues() {
        return (CharSequence[])this.mEntryValues.clone();
    }

    public CharSequence[] getInitialValues() {
        return (CharSequence[])this.mInitialValues.clone();
    }

    public void setValue(int n, boolean bl) {
        this.mValues[n] = bl;
        this.mPrevValues = (boolean[])this.mValues.clone();
    }

    public Set<String> getValues() {
        HashSet<String> hashSet = new HashSet<String>();
        if (this.mValues == null) {
            return hashSet;
        }
        for (int i = 0; i < this.mValues.length; ++i) {
            if (!this.mValues[i]) continue;
            hashSet.add(((Object)this.mEntryValues[i]).toString());
        }
        return hashSet;
    }

    public void onClick(DialogInterface dialogInterface, int n, boolean bl) {
    }

    protected void onPrepareDialogBuilder(AlertDialog.Builder builder) {
        if (this.mEntries == null || this.mInitialValues == null || this.mEntryValues == null) {
            throw new IllegalStateException("MultiChoicePreference requires entries, entryValues, and initialValues arrays.");
        }
        if (this.mEntries.length != this.mEntryValues.length || this.mEntries.length != this.mInitialValues.length) {
            throw new IllegalStateException("MultiChoicePreference entries, entryValues, and initialValues arrays must be the same length");
        }
        builder.setMultiChoiceItems(this.mEntries, this.mValues, (DialogInterface.OnMultiChoiceClickListener)this);
    }

    protected void onDialogClosed(boolean bl) {
        if (this.mPrevValues == null || this.mInitialValues == null) {
            return;
        }
        if (!bl) {
            this.mValues = (boolean[])this.mPrevValues.clone();
            return;
        }
        this.mPrevValues = (boolean[])this.mValues.clone();
        if (!this.callChangeListener(this.getValues())) {
            return;
        }
        this.persist();
    }

    public boolean persist() {
        if (this.isPersistent()) {
            SharedPreferences.Editor editor = GeckoSharedPrefs.forProfile(this.getContext()).edit();
            boolean bl = this.persist(editor);
            editor.apply();
            return bl;
        }
        return false;
    }

    protected boolean persist(SharedPreferences.Editor editor) {
        if (this.isPersistent()) {
            Set<String> set = this.getValues();
            PrefUtils.putStringSet((SharedPreferences.Editor)editor, (String)this.getKey(), set);
            return true;
        }
        return false;
    }

    public Set<String> getPersistedStrings(Set<String> set) {
        if (!this.isPersistent()) {
            return set;
        }
        SharedPreferences sharedPreferences = GeckoSharedPrefs.forProfile(this.getContext());
        return PrefUtils.getStringSet((SharedPreferences)sharedPreferences, (String)this.getKey(), set);
    }

    protected void loadPersistedValues() {
        final int n = this.mInitialValues.length;
        this.mValues = new boolean[n];
        if (n != this.mEntries.length || n != this.mEntryValues.length) {
            throw new IllegalStateException("MultiChoicePreference entryValues and initialValues arrays must be the same length");
        }
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                Set<String> set = MultiChoicePreference.this.getPersistedStrings(null);
                for (int i = 0; i < n; ++i) {
                    boolean bl;
                    ((MultiChoicePreference)MultiChoicePreference.this).mValues[i] = set != null ? set.contains(MultiChoicePreference.this.mEntryValues[i]) : (bl = MultiChoicePreference.this.mInitialValues[i].equals("true"));
                }
                MultiChoicePreference.access$302(MultiChoicePreference.this, (boolean[])MultiChoicePreference.this.mValues.clone());
            }
        });
    }

    static /* synthetic */ boolean[] access$302(MultiChoicePreference multiChoicePreference, boolean[] blArray) {
        multiChoicePreference.mPrevValues = blArray;
        return blArray;
    }
}

