/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.prompts;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.prompts.IntentHandler;
import org.mozilla.gecko.prompts.Prompt;
import org.mozilla.gecko.prompts.PromptListItem;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.widget.GeckoActionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntentChooserPrompt {
    private static final String LOGTAG = "GeckoIntentChooser";
    private final ArrayList<PromptListItem> mItems;

    public IntentChooserPrompt(Context context, Intent[] intentArray) {
        this.mItems = this.getItems(context, intentArray);
    }

    public IntentChooserPrompt(Context context, GeckoActionProvider geckoActionProvider) {
        this.mItems = this.getItems(context, geckoActionProvider);
    }

    public void show(String string2, Context context, final IntentHandler intentHandler) {
        ThreadUtils.assertOnUiThread();
        if (this.mItems.isEmpty()) {
            Log.i((String)LOGTAG, (String)"No activities for the intent chooser!");
            intentHandler.onCancelled();
            return;
        }
        if (this.mItems.size() == 1) {
            intentHandler.onIntentSelected(this.mItems.get(0).getIntent(), 0);
            return;
        }
        Prompt prompt = new Prompt(context, new Prompt.PromptCallback(){

            public void onPromptFinished(String string2) {
                if (intentHandler == null) {
                    return;
                }
                int n = -1;
                try {
                    n = new JSONObject(string2).getInt("button");
                }
                catch (JSONException jSONException) {
                    Log.e((String)IntentChooserPrompt.LOGTAG, (String)"result from promptservice was invalid: ", (Throwable)jSONException);
                }
                if (n == -1) {
                    intentHandler.onCancelled();
                } else {
                    intentHandler.onIntentSelected(((PromptListItem)IntentChooserPrompt.this.mItems.get(n)).getIntent(), n);
                }
            }
        });
        PromptListItem[] promptListItemArray = new PromptListItem[this.mItems.size()];
        this.mItems.toArray(promptListItemArray);
        prompt.show(string2, "", promptListItemArray, 0);
    }

    public boolean hasActivities(Context context) {
        return this.mItems.isEmpty();
    }

    private ArrayList<PromptListItem> getItems(Context context, Intent[] intentArray) {
        ArrayList<PromptListItem> arrayList = new ArrayList<PromptListItem>();
        for (Intent intent : intentArray) {
            arrayList.addAll(this.getItemsForIntent(context, intent));
        }
        return arrayList;
    }

    private ArrayList<PromptListItem> getItems(Context context, GeckoActionProvider geckoActionProvider) {
        ArrayList<PromptListItem> arrayList = new ArrayList<PromptListItem>();
        PackageManager packageManager = context.getPackageManager();
        ArrayList<ResolveInfo> arrayList2 = geckoActionProvider.getSortedActivites();
        for (ResolveInfo resolveInfo : arrayList2) {
            arrayList.add(this.getItemForResolveInfo(resolveInfo, packageManager, geckoActionProvider.getIntent()));
        }
        return arrayList;
    }

    private PromptListItem getItemForResolveInfo(ResolveInfo resolveInfo, PackageManager packageManager, Intent intent) {
        PromptListItem promptListItem = new PromptListItem(((Object)resolveInfo.loadLabel(packageManager)).toString());
        promptListItem.setIcon(resolveInfo.loadIcon(packageManager));
        Intent intent2 = new Intent(intent);
        intent2.setComponent(new ComponentName(resolveInfo.activityInfo.applicationInfo.packageName, resolveInfo.activityInfo.name));
        promptListItem.setIntent(new Intent(intent2));
        return promptListItem;
    }

    private ArrayList<PromptListItem> getItemsForIntent(Context context, Intent intent) {
        ArrayList<PromptListItem> arrayList = new ArrayList<PromptListItem>();
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentActivityOptions(GeckoAppShell.getGeckoInterface().getActivity().getComponentName(), null, intent, 0);
        if (list == null) {
            return arrayList;
        }
        for (ResolveInfo resolveInfo : list) {
            arrayList.add(this.getItemForResolveInfo(resolveInfo, packageManager, intent));
        }
        return arrayList;
    }
}

