/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.mozilla.gecko.BrowserLocaleManager;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.CommandRunner;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.GlobalSession;
import org.mozilla.gecko.sync.NonArrayJSONException;
import org.mozilla.gecko.sync.repositories.NullCursorException;
import org.mozilla.gecko.sync.repositories.android.ClientsDatabaseAccessor;
import org.mozilla.gecko.sync.repositories.domain.ClientRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandProcessor {
    private static final String LOG_TAG = "Command";
    private static AtomicInteger currentId = new AtomicInteger();
    protected ConcurrentHashMap<String, CommandRunner> commands = new ConcurrentHashMap();
    private static final CommandProcessor processor = new CommandProcessor();
    private static volatile boolean didUpdateLocale = false;

    public static CommandProcessor getProcessor() {
        return processor;
    }

    public void registerCommand(String string2, CommandRunner commandRunner) {
        this.commands.put(string2, commandRunner);
    }

    public void processCommand(GlobalSession globalSession, ExtendedJSONObject extendedJSONObject) {
        Command command = CommandProcessor.parseCommand(extendedJSONObject);
        if (command == null) {
            Logger.debug(LOG_TAG, "Invalid command: " + extendedJSONObject + " will not be processed.");
            return;
        }
        CommandRunner commandRunner = this.commands.get(command.commandType);
        if (commandRunner == null) {
            Logger.debug(LOG_TAG, "Command \"" + command.commandType + "\" not registered and will not be processed.");
            return;
        }
        commandRunner.executeCommand(globalSession, command.getArgsList());
    }

    protected static Command parseCommand(ExtendedJSONObject extendedJSONObject) {
        String string2 = (String)extendedJSONObject.get("command");
        if (string2 == null) {
            return null;
        }
        try {
            JSONArray jSONArray = extendedJSONObject.getArray("args");
            if (jSONArray == null) {
                return null;
            }
            return new Command(string2, jSONArray);
        }
        catch (NonArrayJSONException nonArrayJSONException) {
            Logger.debug(LOG_TAG, "Unable to parse args array. Invalid command");
            return null;
        }
    }

    public void sendURIToClientForDisplay(String string2, String string3, String string4, String string5, Context context) {
        Logger.info(LOG_TAG, "Sending URI to client " + string3 + ".");
        if (Logger.LOG_PERSONAL_INFORMATION) {
            Logger.pii(LOG_TAG, "URI is " + string2 + "; title is '" + string4 + "'.");
        }
        JSONArray jSONArray = new JSONArray();
        jSONArray.add((Object)string2);
        jSONArray.add((Object)string5);
        jSONArray.add((Object)string4);
        Command command = new Command("displayURI", jSONArray);
        this.sendCommand(string3, command, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCommand(String string2, Command command, Context context) {
        Logger.debug(LOG_TAG, "In sendCommand.");
        CommandRunner commandRunner = this.commands.get(command.commandType);
        if (commandRunner == null) {
            Logger.error(LOG_TAG, "Unknown command to send: " + command);
            return;
        }
        if (!commandRunner.argumentsAreValid(command.getArgsList())) {
            Logger.error(LOG_TAG, "Expected " + commandRunner.argCount + " args for '" + command + "', but got " + command.args);
            return;
        }
        if (string2 != null) {
            this.sendCommandToClient(string2, command, context);
            return;
        }
        ClientsDatabaseAccessor clientsDatabaseAccessor = new ClientsDatabaseAccessor(context);
        try {
            Map<String, ClientRecord> map = clientsDatabaseAccessor.fetchAllClients();
            for (ClientRecord clientRecord : map.values()) {
                this.sendCommandToClient(clientRecord.guid, command, context);
            }
        }
        catch (NullCursorException nullCursorException) {
            Logger.error(LOG_TAG, "NullCursorException when fetching all GUIDs");
        }
        finally {
            clientsDatabaseAccessor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendCommandToClient(String string2, Command command, Context context) {
        Logger.info(LOG_TAG, "Sending " + command.commandType + " to " + string2);
        ClientsDatabaseAccessor clientsDatabaseAccessor = new ClientsDatabaseAccessor(context);
        try {
            clientsDatabaseAccessor.store(string2, command);
        }
        catch (NullCursorException nullCursorException) {
            Logger.error(LOG_TAG, "NullCursorException: Unable to send command.");
        }
        finally {
            clientsDatabaseAccessor.close();
        }
    }

    public static void displayURI(List<String> list, Context context) {
        String string2 = list.get(0);
        String string3 = list.get(1);
        Logger.pii(LOG_TAG, "Received a URI for display: " + string2 + " from " + string3);
        String string4 = null;
        if (list.size() == 3) {
            string4 = list.get(2);
        }
        if (!didUpdateLocale) {
            BrowserLocaleManager.getInstance().getAndApplyPersistedLocale(context);
            didUpdateLocale = true;
        }
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        int n = R.drawable.icon;
        String string5 = context.getString(R.string.sync_new_tab);
        if (string4 != null) {
            string5 = string5.concat(": " + string4);
        }
        long l = System.currentTimeMillis();
        Notification notification = new Notification(n, (CharSequence)string5, l);
        notification.flags = 16;
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0);
        notification.setLatestEventInfo(context, (CharSequence)string5, (CharSequence)string2, pendingIntent);
        notificationManager.notify(currentId.getAndIncrement(), notification);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Command {
        public final String commandType;
        public final JSONArray args;
        private List<String> argsList;

        public Command(String string2, JSONArray jSONArray) {
            this.commandType = string2;
            this.args = jSONArray;
        }

        public synchronized List<String> getArgsList() {
            if (this.argsList == null) {
                ArrayList<String> arrayList = new ArrayList<String>(this.args.size());
                for (int i = 0; i < this.args.size(); ++i) {
                    Object object = this.args.get(i);
                    if (object == null) {
                        arrayList.add(null);
                        continue;
                    }
                    arrayList.add(object.toString());
                }
                this.argsList = arrayList;
            }
            return this.argsList;
        }

        public JSONObject asJSONObject() {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put((Object)"command", (Object)this.commandType);
            jSONObject.put((Object)"args", (Object)this.args);
            return jSONObject;
        }
    }
}

