/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.stage;

import java.net.URISyntaxException;
import org.mozilla.gecko.sync.JSONRecordFetcher;
import org.mozilla.gecko.sync.MetaGlobalException;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;
import org.mozilla.gecko.sync.repositories.RecordFactory;
import org.mozilla.gecko.sync.repositories.Repository;
import org.mozilla.gecko.sync.repositories.android.AndroidBrowserBookmarksRepository;
import org.mozilla.gecko.sync.repositories.domain.BookmarkRecordFactory;
import org.mozilla.gecko.sync.stage.SafeConstrainedServer11Repository;
import org.mozilla.gecko.sync.stage.ServerSyncStage;

public class AndroidBrowserBookmarksServerSyncStage
extends ServerSyncStage {
    protected static final String LOG_TAG = "BookmarksStage";
    private static final String BOOKMARKS_SORT = "index";
    private static final long BOOKMARKS_REQUEST_LIMIT = 5000L;

    protected String getCollection() {
        return "bookmarks";
    }

    protected String getEngineName() {
        return "bookmarks";
    }

    public Integer getStorageVersion() {
        return 2;
    }

    protected Repository getRemoteRepository() throws URISyntaxException {
        AuthHeaderProvider authHeaderProvider = this.session.getAuthHeaderProvider();
        JSONRecordFetcher jSONRecordFetcher = new JSONRecordFetcher(this.session.config.infoCollectionCountsURL(), authHeaderProvider);
        String string2 = this.getCollection();
        return new SafeConstrainedServer11Repository(string2, this.session.config.storageURL(), this.session.getAuthHeaderProvider(), this.session.config.infoCollections, 5000L, BOOKMARKS_SORT, jSONRecordFetcher);
    }

    protected Repository getLocalRepository() {
        return new AndroidBrowserBookmarksRepository();
    }

    protected RecordFactory getRecordFactory() {
        return new BookmarkRecordFactory();
    }

    protected boolean isEnabled() throws MetaGlobalException {
        if (this.session == null || this.session.getContext() == null) {
            return false;
        }
        return super.isEnabled();
    }
}

