/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.v4.util.LongSparseArray;
import android.support.v4.util.SparseArrayCompat;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.KeyEventCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.VelocityTrackerCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.widget.EdgeEffectCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.ContextMenu;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SoundEffectConstants;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.AdapterView;
import android.widget.Checkable;
import android.widget.ListAdapter;
import android.widget.Scroller;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.gecko.R;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwoWayView
extends AdapterView<ListAdapter>
implements ViewTreeObserver.OnTouchModeChangeListener {
    private static final String LOGTAG = "TwoWayView";
    private static final int NO_POSITION = -1;
    private static final int INVALID_POINTER = -1;
    public static final int[] STATE_NOTHING = new int[]{0};
    private static final int TOUCH_MODE_REST = -1;
    private static final int TOUCH_MODE_DOWN = 0;
    private static final int TOUCH_MODE_TAP = 1;
    private static final int TOUCH_MODE_DONE_WAITING = 2;
    private static final int TOUCH_MODE_DRAGGING = 3;
    private static final int TOUCH_MODE_FLINGING = 4;
    private static final int TOUCH_MODE_OVERSCROLL = 5;
    private static final int TOUCH_MODE_UNKNOWN = -1;
    private static final int TOUCH_MODE_ON = 0;
    private static final int TOUCH_MODE_OFF = 1;
    private static final int LAYOUT_NORMAL = 0;
    private static final int LAYOUT_FORCE_TOP = 1;
    private static final int LAYOUT_SET_SELECTION = 2;
    private static final int LAYOUT_FORCE_BOTTOM = 3;
    private static final int LAYOUT_SPECIFIC = 4;
    private static final int LAYOUT_SYNC = 5;
    private static final int LAYOUT_MOVE_SELECTION = 6;
    private static final int SYNC_SELECTED_POSITION = 0;
    private static final int SYNC_FIRST_POSITION = 1;
    private static final int SYNC_MAX_DURATION_MILLIS = 100;
    private static final int CHECK_POSITION_SEARCH_DISTANCE = 20;
    private static final float MAX_SCROLL_FACTOR = 0.33f;
    private static final int MIN_SCROLL_PREVIEW_PIXELS = 10;
    private ListAdapter mAdapter;
    private boolean mIsVertical;
    private int mItemMargin;
    private boolean mInLayout;
    private boolean mBlockLayoutRequests;
    private boolean mIsAttached = false;
    private final RecycleBin mRecycler;
    private AdapterDataSetObserver mDataSetObserver;
    private boolean mItemsCanFocus;
    final boolean[] mIsScrap = new boolean[1];
    private boolean mDataChanged;
    private int mItemCount;
    private int mOldItemCount;
    private boolean mHasStableIds;
    private boolean mAreAllItemsSelectable;
    private int mFirstPosition;
    private int mSpecificStart;
    private SavedState mPendingSync;
    private final int mTouchSlop;
    private final int mMaximumVelocity;
    private final int mFlingVelocity;
    private float mLastTouchPos;
    private float mTouchRemainderPos;
    private int mActivePointerId;
    private final Rect mTempRect;
    private final ArrowScrollFocusResult mArrowScrollFocusResult;
    private Rect mTouchFrame;
    private int mMotionPosition;
    private CheckForTap mPendingCheckForTap;
    private CheckForLongPress mPendingCheckForLongPress;
    private CheckForKeyLongPress mPendingCheckForKeyLongPress;
    private PerformClick mPerformClick;
    private Runnable mTouchModeReset;
    private int mResurrectToPosition;
    private boolean mIsChildViewEnabled;
    private boolean mDrawSelectorOnTop;
    private Drawable mSelector;
    private int mSelectorPosition;
    private final Rect mSelectorRect;
    private int mOverScroll;
    private final int mOverscrollDistance;
    private boolean mDesiredFocusableState;
    private boolean mDesiredFocusableInTouchModeState;
    private SelectionNotifier mSelectionNotifier;
    private boolean mNeedSync = false;
    private int mSyncMode;
    private int mSyncPosition;
    private long mSyncRowId;
    private long mSyncHeight;
    private int mSelectedStart;
    private int mNextSelectedPosition;
    private long mNextSelectedRowId;
    private int mSelectedPosition;
    private long mSelectedRowId;
    private int mOldSelectedPosition;
    private long mOldSelectedRowId;
    private ChoiceMode mChoiceMode;
    private int mCheckedItemCount;
    private SparseBooleanArray mCheckStates;
    LongSparseArray<Integer> mCheckedIdStates;
    private ContextMenu.ContextMenuInfo mContextMenuInfo = null;
    private int mLayoutMode = 0;
    private int mTouchMode = -1;
    private int mLastTouchMode = -1;
    private VelocityTracker mVelocityTracker = null;
    private final Scroller mScroller;
    private EdgeEffectCompat mStartEdge;
    private EdgeEffectCompat mEndEdge;
    private OnScrollListener mOnScrollListener = null;
    private int mLastScrollState = 0;
    private View mEmptyView;
    private ListItemAccessibilityDelegate mAccessibilityDelegate;
    private int mLastAccessibilityScrollEventFromIndex;
    private int mLastAccessibilityScrollEventToIndex;

    public TwoWayView(Context context) {
        this(context, null);
    }

    public TwoWayView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public TwoWayView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        int n2;
        int n3;
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
        this.mMaximumVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        this.mFlingVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        this.mOverscrollDistance = this.getScaledOverscrollDistance(viewConfiguration);
        this.mOverScroll = 0;
        this.mScroller = new Scroller(context);
        this.mIsVertical = true;
        this.mItemsCanFocus = false;
        this.mTempRect = new Rect();
        this.mArrowScrollFocusResult = new ArrowScrollFocusResult();
        this.mSelectorPosition = -1;
        this.mSelectorRect = new Rect();
        this.mSelectedStart = 0;
        this.mResurrectToPosition = -1;
        this.mSelectedStart = 0;
        this.mNextSelectedPosition = -1;
        this.mNextSelectedRowId = Long.MIN_VALUE;
        this.mSelectedPosition = -1;
        this.mSelectedRowId = Long.MIN_VALUE;
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        this.mChoiceMode = ChoiceMode.NONE;
        this.mCheckedItemCount = 0;
        this.mCheckedIdStates = null;
        this.mCheckStates = null;
        this.mRecycler = new RecycleBin();
        this.mDataSetObserver = null;
        this.mAreAllItemsSelectable = true;
        this.mStartEdge = null;
        this.mEndEdge = null;
        this.setClickable(true);
        this.setFocusableInTouchMode(true);
        this.setWillNotDraw(false);
        this.setAlwaysDrawnWithCacheEnabled(false);
        this.setWillNotDraw(false);
        this.setClipToPadding(false);
        ViewCompat.setOverScrollMode((View)this, (int)1);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.TwoWayView, n, 0);
        this.mDrawSelectorOnTop = typedArray.getBoolean(2, false);
        Drawable drawable2 = typedArray.getDrawable(1);
        if (drawable2 != null) {
            this.setSelector(drawable2);
        }
        if ((n3 = typedArray.getInt(0, -1)) >= 0) {
            this.setOrientation(Orientation.values()[n3]);
        }
        if ((n2 = typedArray.getInt(3, -1)) >= 0) {
            this.setChoiceMode(ChoiceMode.values()[n2]);
        }
        typedArray.recycle();
    }

    public void setOrientation(Orientation orientation) {
        boolean bl;
        boolean bl2 = bl = orientation == Orientation.VERTICAL;
        if (this.mIsVertical == bl) {
            return;
        }
        this.mIsVertical = bl;
        this.resetState();
        this.mRecycler.clear();
        this.requestLayout();
    }

    public Orientation getOrientation() {
        return this.mIsVertical ? Orientation.VERTICAL : Orientation.HORIZONTAL;
    }

    public void setItemMargin(int n) {
        if (this.mItemMargin == n) {
            return;
        }
        this.mItemMargin = n;
        this.requestLayout();
    }

    public int getItemMargin() {
        return this.mItemMargin;
    }

    public void setItemsCanFocus(boolean bl) {
        this.mItemsCanFocus = bl;
        if (!bl) {
            this.setDescendantFocusability(393216);
        }
    }

    public boolean getItemsCanFocus() {
        return this.mItemsCanFocus;
    }

    public void setOnScrollListener(OnScrollListener onScrollListener) {
        this.mOnScrollListener = onScrollListener;
        this.invokeOnItemScrollListener();
    }

    public void setRecyclerListener(RecyclerListener recyclerListener) {
        this.mRecycler.mRecyclerListener = recyclerListener;
    }

    public void setDrawSelectorOnTop(boolean bl) {
        this.mDrawSelectorOnTop = bl;
    }

    public void setSelector(int n) {
        this.setSelector(this.getResources().getDrawable(n));
    }

    public void setSelector(Drawable drawable2) {
        if (this.mSelector != null) {
            this.mSelector.setCallback(null);
            this.unscheduleDrawable(this.mSelector);
        }
        this.mSelector = drawable2;
        Rect rect = new Rect();
        drawable2.getPadding(rect);
        drawable2.setCallback((Drawable.Callback)this);
        this.updateSelectorState();
    }

    public Drawable getSelector() {
        return this.mSelector;
    }

    public int getSelectedItemPosition() {
        return this.mNextSelectedPosition;
    }

    public long getSelectedItemId() {
        return this.mNextSelectedRowId;
    }

    public int getCheckedItemCount() {
        return this.mCheckedItemCount;
    }

    public boolean isItemChecked(int n) {
        if (this.mChoiceMode == ChoiceMode.NONE && this.mCheckStates != null) {
            return this.mCheckStates.get(n);
        }
        return false;
    }

    public int getCheckedItemPosition() {
        if (this.mChoiceMode == ChoiceMode.SINGLE && this.mCheckStates != null && this.mCheckStates.size() == 1) {
            return this.mCheckStates.keyAt(0);
        }
        return -1;
    }

    public SparseBooleanArray getCheckedItemPositions() {
        if (this.mChoiceMode != ChoiceMode.NONE) {
            return this.mCheckStates;
        }
        return null;
    }

    public long[] getCheckedItemIds() {
        if (this.mChoiceMode == ChoiceMode.NONE || this.mCheckedIdStates == null || this.mAdapter == null) {
            return new long[0];
        }
        LongSparseArray<Integer> longSparseArray = this.mCheckedIdStates;
        int n = longSparseArray.size();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = longSparseArray.keyAt(i);
        }
        return lArray;
    }

    public void setItemChecked(int n, boolean bl) {
        if (this.mChoiceMode == ChoiceMode.NONE) {
            return;
        }
        if (this.mChoiceMode == ChoiceMode.MULTIPLE) {
            boolean bl2 = this.mCheckStates.get(n);
            this.mCheckStates.put(n, bl);
            if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                if (bl) {
                    this.mCheckedIdStates.put(this.mAdapter.getItemId(n), (Object)n);
                } else {
                    this.mCheckedIdStates.delete(this.mAdapter.getItemId(n));
                }
            }
            if (bl2 != bl) {
                this.mCheckedItemCount = bl ? ++this.mCheckedItemCount : --this.mCheckedItemCount;
            }
        } else {
            boolean bl3;
            boolean bl4 = bl3 = this.mCheckedIdStates != null && this.mAdapter.hasStableIds();
            if (bl || this.isItemChecked(n)) {
                this.mCheckStates.clear();
                if (bl3) {
                    this.mCheckedIdStates.clear();
                }
            }
            if (bl) {
                this.mCheckStates.put(n, true);
                if (bl3) {
                    this.mCheckedIdStates.put(this.mAdapter.getItemId(n), (Object)n);
                }
                this.mCheckedItemCount = 1;
            } else if (this.mCheckStates.size() == 0 || !this.mCheckStates.valueAt(0)) {
                this.mCheckedItemCount = 0;
            }
        }
        if (!this.mInLayout && !this.mBlockLayoutRequests) {
            this.mDataChanged = true;
            this.rememberSyncState();
            this.requestLayout();
        }
    }

    public void clearChoices() {
        if (this.mCheckStates != null) {
            this.mCheckStates.clear();
        }
        if (this.mCheckedIdStates != null) {
            this.mCheckedIdStates.clear();
        }
        this.mCheckedItemCount = 0;
    }

    public ChoiceMode getChoiceMode() {
        return this.mChoiceMode;
    }

    public void setChoiceMode(ChoiceMode choiceMode) {
        this.mChoiceMode = choiceMode;
        if (this.mChoiceMode != ChoiceMode.NONE) {
            if (this.mCheckStates == null) {
                this.mCheckStates = new SparseBooleanArray();
            }
            if (this.mCheckedIdStates == null && this.mAdapter != null && this.mAdapter.hasStableIds()) {
                this.mCheckedIdStates = new LongSparseArray();
            }
        }
    }

    public ListAdapter getAdapter() {
        return this.mAdapter;
    }

    public void setAdapter(ListAdapter listAdapter) {
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mAdapter.unregisterDataSetObserver((DataSetObserver)this.mDataSetObserver);
        }
        this.resetState();
        this.mRecycler.clear();
        this.mAdapter = listAdapter;
        this.mDataChanged = true;
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        if (this.mCheckStates != null) {
            this.mCheckStates.clear();
        }
        if (this.mCheckedIdStates != null) {
            this.mCheckedIdStates.clear();
        }
        if (this.mAdapter != null) {
            this.mOldItemCount = this.mItemCount;
            this.mItemCount = listAdapter.getCount();
            this.mDataSetObserver = new AdapterDataSetObserver();
            this.mAdapter.registerDataSetObserver((DataSetObserver)this.mDataSetObserver);
            this.mRecycler.setViewTypeCount(listAdapter.getViewTypeCount());
            this.mHasStableIds = listAdapter.hasStableIds();
            this.mAreAllItemsSelectable = listAdapter.areAllItemsEnabled();
            if (this.mChoiceMode != ChoiceMode.NONE && this.mHasStableIds && this.mCheckedIdStates == null) {
                this.mCheckedIdStates = new LongSparseArray();
            }
            int n = this.lookForSelectablePosition(0);
            this.setSelectedPositionInt(n);
            this.setNextSelectedPositionInt(n);
            if (this.mItemCount == 0) {
                this.checkSelectionChanged();
            }
        } else {
            this.mItemCount = 0;
            this.mHasStableIds = false;
            this.mAreAllItemsSelectable = true;
            this.checkSelectionChanged();
        }
        this.checkFocus();
        this.requestLayout();
    }

    public int getFirstVisiblePosition() {
        return this.mFirstPosition;
    }

    public int getLastVisiblePosition() {
        return this.mFirstPosition + this.getChildCount() - 1;
    }

    public int getCount() {
        return this.mItemCount;
    }

    public int getPositionForView(View view) {
        View view2 = view;
        try {
            View view3;
            while (!(view3 = (View)view2.getParent()).equals((Object)this)) {
                view2 = view3;
            }
        }
        catch (ClassCastException classCastException) {
            return -1;
        }
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            if (!this.getChildAt(i).equals(view2)) continue;
            return this.mFirstPosition + i;
        }
        return -1;
    }

    public void getFocusedRect(Rect rect) {
        View view = this.getSelectedView();
        if (view != null && view.getParent() == this) {
            view.getFocusedRect(rect);
            this.offsetDescendantRectToMyCoords(view, rect);
        } else {
            super.getFocusedRect(rect);
        }
    }

    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        super.onFocusChanged(bl, n, rect);
        if (bl && this.mSelectedPosition < 0 && !this.isInTouchMode()) {
            if (!this.mIsAttached && this.mAdapter != null) {
                this.mDataChanged = true;
                this.mOldItemCount = this.mItemCount;
                this.mItemCount = this.mAdapter.getCount();
            }
            this.resurrectSelection();
        }
        ListAdapter listAdapter = this.mAdapter;
        int n2 = -1;
        int n3 = 0;
        if (listAdapter != null && bl && rect != null) {
            rect.offset(this.getScrollX(), this.getScrollY());
            if (listAdapter.getCount() < this.getChildCount() + this.mFirstPosition) {
                this.mLayoutMode = 0;
                this.layoutChildren();
            }
            Rect rect2 = this.mTempRect;
            int n4 = Integer.MAX_VALUE;
            int n5 = this.getChildCount();
            int n6 = this.mFirstPosition;
            for (int i = 0; i < n5; ++i) {
                if (!listAdapter.isEnabled(n6 + i)) continue;
                View view = this.getChildAt(i);
                view.getDrawingRect(rect2);
                this.offsetDescendantRectToMyCoords(view, rect2);
                int n7 = TwoWayView.getDistance(rect, rect2, n);
                if (n7 >= n4) continue;
                n4 = n7;
                n2 = i;
                n3 = this.mIsVertical ? view.getTop() : view.getLeft();
            }
        }
        if (n2 >= 0) {
            this.setSelectionFromOffset(n2 + this.mFirstPosition, n3);
        } else {
            this.requestLayout();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
        viewTreeObserver.addOnTouchModeChangeListener((ViewTreeObserver.OnTouchModeChangeListener)this);
        if (this.mAdapter != null && this.mDataSetObserver == null) {
            this.mDataSetObserver = new AdapterDataSetObserver();
            this.mAdapter.registerDataSetObserver((DataSetObserver)this.mDataSetObserver);
            this.mDataChanged = true;
            this.mOldItemCount = this.mItemCount;
            this.mItemCount = this.mAdapter.getCount();
        }
        this.mIsAttached = true;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mRecycler.clear();
        ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
        viewTreeObserver.removeOnTouchModeChangeListener((ViewTreeObserver.OnTouchModeChangeListener)this);
        if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver((DataSetObserver)this.mDataSetObserver);
            this.mDataSetObserver = null;
        }
        if (this.mPerformClick != null) {
            this.removeCallbacks(this.mPerformClick);
        }
        if (this.mTouchModeReset != null) {
            this.removeCallbacks(this.mTouchModeReset);
            this.mTouchModeReset.run();
        }
        this.mIsAttached = false;
    }

    public void onWindowFocusChanged(boolean bl) {
        int n;
        super.onWindowFocusChanged(bl);
        int n2 = n = this.isInTouchMode() ? 0 : 1;
        if (!bl) {
            if (n == 1) {
                this.mResurrectToPosition = this.mSelectedPosition;
            }
        } else if (n != this.mLastTouchMode && this.mLastTouchMode != -1) {
            if (n == 1) {
                this.resurrectSelection();
            } else {
                this.hideSelector();
                this.mLayoutMode = 0;
                this.layoutChildren();
            }
        }
        this.mLastTouchMode = n;
    }

    protected void onOverScrolled(int n, int n2, boolean bl, boolean bl2) {
        boolean bl3 = false;
        if (this.mIsVertical && this.mOverScroll != n2) {
            this.onScrollChanged(this.getScrollX(), n2, this.getScrollX(), this.mOverScroll);
            this.mOverScroll = n2;
            bl3 = true;
        } else if (!this.mIsVertical && this.mOverScroll != n) {
            this.onScrollChanged(n, this.getScrollY(), this.mOverScroll, this.getScrollY());
            this.mOverScroll = n;
            bl3 = true;
        }
        if (bl3) {
            this.invalidate();
            this.awakenScrollbarsInternal();
        }
    }

    @TargetApi(value=9)
    private boolean overScrollByInternal(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        if (Build.VERSION.SDK_INT < 9) {
            return false;
        }
        return super.overScrollBy(n, n2, n3, n4, n5, n6, n7, n8, bl);
    }

    @TargetApi(value=9)
    public void setOverScrollMode(int n) {
        if (Build.VERSION.SDK_INT < 9) {
            return;
        }
        if (n != 2) {
            if (this.mStartEdge == null) {
                Context context = this.getContext();
                this.mStartEdge = new EdgeEffectCompat(context);
                this.mEndEdge = new EdgeEffectCompat(context);
            }
        } else {
            this.mStartEdge = null;
            this.mEndEdge = null;
        }
        super.setOverScrollMode(n);
    }

    public int pointToPosition(int n, int n2) {
        Rect rect = this.mTouchFrame;
        if (rect == null) {
            rect = this.mTouchFrame = new Rect();
        }
        int n3 = this.getChildCount();
        for (int i = n3 - 1; i >= 0; --i) {
            View view = this.getChildAt(i);
            if (view.getVisibility() != 0) continue;
            view.getHitRect(rect);
            if (!rect.contains(n, n2)) continue;
            return this.mFirstPosition + i;
        }
        return -1;
    }

    protected int computeVerticalScrollExtent() {
        int n = this.getChildCount();
        if (n == 0) {
            return 0;
        }
        int n2 = n * 100;
        View view = this.getChildAt(0);
        int n3 = view.getTop();
        int n4 = view.getHeight();
        if (n4 > 0) {
            n2 += n3 * 100 / n4;
        }
        view = this.getChildAt(n - 1);
        int n5 = view.getBottom();
        n4 = view.getHeight();
        if (n4 > 0) {
            n2 -= (n5 - this.getHeight()) * 100 / n4;
        }
        return n2;
    }

    protected int computeHorizontalScrollExtent() {
        int n = this.getChildCount();
        if (n == 0) {
            return 0;
        }
        int n2 = n * 100;
        View view = this.getChildAt(0);
        int n3 = view.getLeft();
        int n4 = view.getWidth();
        if (n4 > 0) {
            n2 += n3 * 100 / n4;
        }
        view = this.getChildAt(n - 1);
        int n5 = view.getRight();
        n4 = view.getWidth();
        if (n4 > 0) {
            n2 -= (n5 - this.getWidth()) * 100 / n4;
        }
        return n2;
    }

    protected int computeVerticalScrollOffset() {
        int n = this.mFirstPosition;
        int n2 = this.getChildCount();
        if (n < 0 || n2 == 0) {
            return 0;
        }
        View view = this.getChildAt(0);
        int n3 = view.getTop();
        int n4 = view.getHeight();
        if (n4 > 0) {
            return Math.max(n * 100 - n3 * 100 / n4, 0);
        }
        return 0;
    }

    protected int computeHorizontalScrollOffset() {
        int n = this.mFirstPosition;
        int n2 = this.getChildCount();
        if (n < 0 || n2 == 0) {
            return 0;
        }
        View view = this.getChildAt(0);
        int n3 = view.getLeft();
        int n4 = view.getWidth();
        if (n4 > 0) {
            return Math.max(n * 100 - n3 * 100 / n4, 0);
        }
        return 0;
    }

    protected int computeVerticalScrollRange() {
        int n = Math.max(this.mItemCount * 100, 0);
        if (this.mIsVertical && this.mOverScroll != 0) {
            n += Math.abs((int)((float)this.mOverScroll / (float)this.getHeight() * (float)this.mItemCount * 100.0f));
        }
        return n;
    }

    protected int computeHorizontalScrollRange() {
        int n = Math.max(this.mItemCount * 100, 0);
        if (!this.mIsVertical && this.mOverScroll != 0) {
            n += Math.abs((int)((float)this.mOverScroll / (float)this.getWidth() * (float)this.mItemCount * 100.0f));
        }
        return n;
    }

    public boolean showContextMenuForChild(View view) {
        int n = this.getPositionForView(view);
        if (n >= 0) {
            long l = this.mAdapter.getItemId(n);
            boolean bl = false;
            AdapterView.OnItemLongClickListener onItemLongClickListener = this.getOnItemLongClickListener();
            if (onItemLongClickListener != null) {
                bl = onItemLongClickListener.onItemLongClick((AdapterView)this, view, n, l);
            }
            if (!bl) {
                this.mContextMenuInfo = this.createContextMenuInfo(this.getChildAt(n - this.mFirstPosition), n, l);
                bl = super.showContextMenuForChild(view);
            }
            return bl;
        }
        return false;
    }

    public void requestDisallowInterceptTouchEvent(boolean bl) {
        if (bl) {
            this.recycleVelocityTracker();
        }
        super.requestDisallowInterceptTouchEvent(bl);
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        if (!this.mIsAttached || this.mAdapter == null) {
            return false;
        }
        int n = motionEvent.getAction() & 0xFF;
        switch (n) {
            case 0: {
                this.initOrResetVelocityTracker();
                this.mVelocityTracker.addMovement(motionEvent);
                this.mScroller.abortAnimation();
                float f = motionEvent.getX();
                float f2 = motionEvent.getY();
                this.mLastTouchPos = this.mIsVertical ? f2 : f;
                int n2 = this.findMotionRowOrColumn((int)this.mLastTouchPos);
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)motionEvent, (int)0);
                this.mTouchRemainderPos = 0.0f;
                if (this.mTouchMode == 4) {
                    return true;
                }
                if (n2 < 0) break;
                this.mMotionPosition = n2;
                this.mTouchMode = 0;
                break;
            }
            case 2: {
                if (this.mTouchMode != 0) break;
                this.initVelocityTrackerIfNotExists();
                this.mVelocityTracker.addMovement(motionEvent);
                int n3 = MotionEventCompat.findPointerIndex((MotionEvent)motionEvent, (int)this.mActivePointerId);
                if (n3 < 0) {
                    Log.e((String)LOGTAG, (String)("onInterceptTouchEvent could not find pointer with id " + this.mActivePointerId + " - did TwoWayView receive an inconsistent " + "event stream?"));
                    return false;
                }
                float f = this.mIsVertical ? MotionEventCompat.getY((MotionEvent)motionEvent, (int)n3) : MotionEventCompat.getX((MotionEvent)motionEvent, (int)n3);
                float f3 = f - this.mLastTouchPos + this.mTouchRemainderPos;
                int n4 = (int)f3;
                this.mTouchRemainderPos = f3 - (float)n4;
                if (!this.maybeStartScrolling(n4)) break;
                return true;
            }
            case 1: 
            case 3: {
                this.mActivePointerId = -1;
                this.mTouchMode = -1;
                this.recycleVelocityTracker();
                this.reportScrollStateChange(0);
            }
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.isEnabled()) {
            return this.isClickable() || this.isLongClickable();
        }
        if (!this.mIsAttached || this.mAdapter == null) {
            return false;
        }
        boolean bl = false;
        this.initVelocityTrackerIfNotExists();
        this.mVelocityTracker.addMovement(motionEvent);
        int n = motionEvent.getAction() & 0xFF;
        switch (n) {
            case 0: {
                if (this.mDataChanged) break;
                this.mVelocityTracker.clear();
                this.mScroller.abortAnimation();
                float f = motionEvent.getX();
                float f2 = motionEvent.getY();
                this.mLastTouchPos = this.mIsVertical ? f2 : f;
                int n2 = this.pointToPosition((int)f, (int)f2);
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)motionEvent, (int)0);
                this.mTouchRemainderPos = 0.0f;
                if (this.mDataChanged) break;
                if (this.mTouchMode == 4) {
                    this.mTouchMode = 3;
                    this.reportScrollStateChange(1);
                    n2 = this.findMotionRowOrColumn((int)this.mLastTouchPos);
                    return true;
                }
                if (this.mMotionPosition >= 0 && this.mAdapter.isEnabled(this.mMotionPosition)) {
                    this.mTouchMode = 0;
                    this.triggerCheckForTap();
                }
                this.mMotionPosition = n2;
                break;
            }
            case 2: {
                int n3 = MotionEventCompat.findPointerIndex((MotionEvent)motionEvent, (int)this.mActivePointerId);
                if (n3 < 0) {
                    Log.e((String)LOGTAG, (String)("onInterceptTouchEvent could not find pointer with id " + this.mActivePointerId + " - did TwoWayView receive an inconsistent " + "event stream?"));
                    return false;
                }
                float f = this.mIsVertical ? MotionEventCompat.getY((MotionEvent)motionEvent, (int)n3) : MotionEventCompat.getX((MotionEvent)motionEvent, (int)n3);
                if (this.mDataChanged) {
                    this.layoutChildren();
                }
                float f3 = f - this.mLastTouchPos + this.mTouchRemainderPos;
                int n4 = (int)f3;
                this.mTouchRemainderPos = f3 - (float)n4;
                switch (this.mTouchMode) {
                    case 0: 
                    case 1: 
                    case 2: {
                        this.maybeStartScrolling(n4);
                        break;
                    }
                    case 3: 
                    case 5: {
                        this.mLastTouchPos = f;
                        this.maybeScroll(n4);
                    }
                }
                break;
            }
            case 3: {
                this.cancelCheckForTap();
                this.mTouchMode = -1;
                this.reportScrollStateChange(0);
                this.setPressed(false);
                View view = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
                if (view != null) {
                    view.setPressed(false);
                }
                if (this.mStartEdge != null && this.mEndEdge != null) {
                    bl = this.mStartEdge.onRelease() | this.mEndEdge.onRelease();
                }
                this.recycleVelocityTracker();
                break;
            }
            case 1: {
                switch (this.mTouchMode) {
                    case 0: 
                    case 1: 
                    case 2: {
                        boolean bl2;
                        int n5 = this.mMotionPosition;
                        final View view = this.getChildAt(n5 - this.mFirstPosition);
                        float f = motionEvent.getX();
                        float f4 = motionEvent.getY();
                        if (this.mIsVertical) {
                            bl2 = f > (float)this.getPaddingLeft() && f < (float)(this.getWidth() - this.getPaddingRight());
                        } else {
                            boolean bl3 = bl2 = f4 > (float)this.getPaddingTop() && f4 < (float)(this.getHeight() - this.getPaddingBottom());
                        }
                        if (view != null && !view.hasFocusable() && bl2) {
                            if (this.mTouchMode != 0) {
                                view.setPressed(false);
                            }
                            if (this.mPerformClick == null) {
                                this.mPerformClick = new PerformClick();
                            }
                            final PerformClick performClick = this.mPerformClick;
                            performClick.mClickMotionPosition = n5;
                            performClick.rememberWindowAttachCount();
                            this.mResurrectToPosition = n5;
                            if (this.mTouchMode == 0 || this.mTouchMode == 1) {
                                if (this.mTouchMode == 0) {
                                    this.cancelCheckForTap();
                                } else {
                                    this.cancelCheckForLongPress();
                                }
                                this.mLayoutMode = 0;
                                if (!this.mDataChanged && this.mAdapter.isEnabled(n5)) {
                                    Drawable drawable2;
                                    this.mTouchMode = 1;
                                    this.setPressed(true);
                                    this.positionSelector(this.mMotionPosition, view);
                                    view.setPressed(true);
                                    if (this.mSelector != null && (drawable2 = this.mSelector.getCurrent()) != null && drawable2 instanceof TransitionDrawable) {
                                        ((TransitionDrawable)drawable2).resetTransition();
                                    }
                                    if (this.mTouchModeReset != null) {
                                        this.removeCallbacks(this.mTouchModeReset);
                                    }
                                    this.mTouchModeReset = new Runnable(){

                                        public void run() {
                                            TwoWayView.this.mTouchMode = -1;
                                            TwoWayView.this.setPressed(false);
                                            view.setPressed(false);
                                            if (!TwoWayView.this.mDataChanged) {
                                                performClick.run();
                                            }
                                            TwoWayView.this.mTouchModeReset = null;
                                        }
                                    };
                                    this.postDelayed(this.mTouchModeReset, ViewConfiguration.getPressedStateDuration());
                                } else {
                                    this.mTouchMode = -1;
                                    this.updateSelectorState();
                                }
                            } else if (!this.mDataChanged && this.mAdapter.isEnabled(n5)) {
                                performClick.run();
                            }
                        }
                        this.mTouchMode = -1;
                        this.updateSelectorState();
                        break;
                    }
                    case 3: {
                        if (this.contentFits()) {
                            this.mTouchMode = -1;
                            this.reportScrollStateChange(0);
                            break;
                        }
                        this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                        float f = this.mIsVertical ? VelocityTrackerCompat.getYVelocity((VelocityTracker)this.mVelocityTracker, (int)this.mActivePointerId) : VelocityTrackerCompat.getXVelocity((VelocityTracker)this.mVelocityTracker, (int)this.mActivePointerId);
                        if (Math.abs(f) >= (float)this.mFlingVelocity) {
                            this.mTouchMode = 4;
                            this.reportScrollStateChange(2);
                            this.mScroller.fling(0, 0, (int)(this.mIsVertical ? 0.0f : f), (int)(this.mIsVertical ? f : 0.0f), this.mIsVertical ? 0 : Integer.MIN_VALUE, this.mIsVertical ? 0 : Integer.MAX_VALUE, this.mIsVertical ? Integer.MIN_VALUE : 0, this.mIsVertical ? Integer.MAX_VALUE : 0);
                            this.mLastTouchPos = 0.0f;
                            bl = true;
                            break;
                        }
                        this.mTouchMode = -1;
                        this.reportScrollStateChange(0);
                        break;
                    }
                    case 5: {
                        this.mTouchMode = -1;
                        this.reportScrollStateChange(0);
                    }
                }
                this.cancelCheckForTap();
                this.cancelCheckForLongPress();
                this.setPressed(false);
                if (this.mStartEdge != null && this.mEndEdge != null) {
                    bl |= this.mStartEdge.onRelease() | this.mEndEdge.onRelease();
                }
                this.recycleVelocityTracker();
            }
        }
        if (bl) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
        return true;
    }

    public void onTouchModeChanged(boolean bl) {
        if (bl) {
            this.hideSelector();
            if (this.getWidth() > 0 && this.getHeight() > 0 && this.getChildCount() > 0) {
                this.layoutChildren();
            }
            this.updateSelectorState();
        } else {
            int n = this.mTouchMode;
            if (n == 5 && this.mOverScroll != 0) {
                this.mOverScroll = 0;
                this.finishEdgeGlows();
                this.invalidate();
            }
        }
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return this.handleKeyEvent(n, 1, keyEvent);
    }

    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
        return this.handleKeyEvent(n, n2, keyEvent);
    }

    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return this.handleKeyEvent(n, 1, keyEvent);
    }

    public void sendAccessibilityEvent(int n) {
        if (n == 4096) {
            int n2 = this.getFirstVisiblePosition();
            int n3 = this.getLastVisiblePosition();
            if (this.mLastAccessibilityScrollEventFromIndex == n2 && this.mLastAccessibilityScrollEventToIndex == n3) {
                return;
            }
            this.mLastAccessibilityScrollEventFromIndex = n2;
            this.mLastAccessibilityScrollEventToIndex = n3;
        }
        super.sendAccessibilityEvent(n);
    }

    @TargetApi(value=14)
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName((CharSequence)TwoWayView.class.getName());
    }

    @TargetApi(value=14)
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName((CharSequence)TwoWayView.class.getName());
        AccessibilityNodeInfoCompat accessibilityNodeInfoCompat = new AccessibilityNodeInfoCompat((Object)accessibilityNodeInfo);
        if (this.isEnabled()) {
            if (this.getFirstVisiblePosition() > 0) {
                accessibilityNodeInfoCompat.addAction(8192);
            }
            if (this.getLastVisiblePosition() < this.getCount() - 1) {
                accessibilityNodeInfoCompat.addAction(4096);
            }
        }
    }

    @TargetApi(value=16)
    public boolean performAccessibilityAction(int n, Bundle bundle) {
        if (super.performAccessibilityAction(n, bundle)) {
            return true;
        }
        switch (n) {
            case 4096: {
                if (this.isEnabled() && this.getLastVisiblePosition() < this.getCount() - 1) {
                    int n2 = this.mIsVertical ? this.getHeight() - this.getPaddingTop() - this.getPaddingBottom() : this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
                    this.scrollListItemsBy(n2);
                    return true;
                }
                return false;
            }
            case 8192: {
                if (this.isEnabled() && this.mFirstPosition > 0) {
                    int n3 = this.mIsVertical ? this.getHeight() - this.getPaddingTop() - this.getPaddingBottom() : this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
                    this.scrollListItemsBy(-n3);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private boolean isViewAncestorOf(View view, View view2) {
        if (view == view2) {
            return true;
        }
        ViewParent viewParent = view.getParent();
        return viewParent instanceof ViewGroup && this.isViewAncestorOf((View)viewParent, view2);
    }

    private void forceValidFocusDirection(int n) {
        if (this.mIsVertical && n != 33 && n != 130) {
            throw new IllegalArgumentException("Focus direction must be one of {View.FOCUS_UP, View.FOCUS_DOWN} for vertical orientation");
        }
        if (!this.mIsVertical && n != 17 && n != 66) {
            throw new IllegalArgumentException("Focus direction must be one of {View.FOCUS_LEFT, View.FOCUS_RIGHT} for vertical orientation");
        }
    }

    private void forceValidInnerFocusDirection(int n) {
        if (this.mIsVertical && n != 17 && n != 66) {
            throw new IllegalArgumentException("Direction must be one of {View.FOCUS_LEFT, View.FOCUS_RIGHT} for vertical orientation");
        }
        if (!this.mIsVertical && n != 33 && n != 130) {
            throw new IllegalArgumentException("direction must be one of {View.FOCUS_UP, View.FOCUS_DOWN} for horizontal orientation");
        }
    }

    boolean pageScroll(int n) {
        this.forceValidFocusDirection(n);
        boolean bl = false;
        int n2 = -1;
        if (n == 33 || n == 17) {
            n2 = Math.max(0, this.mSelectedPosition - this.getChildCount() - 1);
        } else if (n == 130 || n == 66) {
            n2 = Math.min(this.mItemCount - 1, this.mSelectedPosition + this.getChildCount() - 1);
            bl = true;
        }
        if (n2 < 0) {
            return false;
        }
        int n3 = this.lookForSelectablePosition(n2, bl);
        if (n3 >= 0) {
            this.mLayoutMode = 4;
            int n4 = this.mSpecificStart = this.mIsVertical ? this.getPaddingTop() : this.getPaddingLeft();
            if (bl && n3 > this.mItemCount - this.getChildCount()) {
                this.mLayoutMode = 3;
            }
            if (!bl && n3 < this.getChildCount()) {
                this.mLayoutMode = 1;
            }
            this.setSelectionInt(n3);
            this.invokeOnItemScrollListener();
            if (!this.awakenScrollbarsInternal()) {
                this.invalidate();
            }
            return true;
        }
        return false;
    }

    boolean fullScroll(int n) {
        this.forceValidFocusDirection(n);
        boolean bl = false;
        if (n == 33 || n == 17) {
            if (this.mSelectedPosition != 0) {
                int n2 = this.lookForSelectablePosition(0, true);
                if (n2 >= 0) {
                    this.mLayoutMode = 1;
                    this.setSelectionInt(n2);
                    this.invokeOnItemScrollListener();
                }
                bl = true;
            }
        } else if ((n == 130 || n == 66) && this.mSelectedPosition < this.mItemCount - 1) {
            int n3 = this.lookForSelectablePosition(this.mItemCount - 1, true);
            if (n3 >= 0) {
                this.mLayoutMode = 3;
                this.setSelectionInt(n3);
                this.invokeOnItemScrollListener();
            }
            bl = true;
        }
        if (bl && !this.awakenScrollbarsInternal()) {
            this.awakenScrollbarsInternal();
            this.invalidate();
        }
        return bl;
    }

    private boolean handleFocusWithinItem(int n) {
        View view;
        this.forceValidInnerFocusDirection(n);
        int n2 = this.getChildCount();
        if (this.mItemsCanFocus && n2 > 0 && this.mSelectedPosition != -1 && (view = this.getSelectedView()) != null && view.hasFocus() && view instanceof ViewGroup) {
            View view2;
            View view3 = view.findFocus();
            View view4 = FocusFinder.getInstance().findNextFocus((ViewGroup)view, view3, n);
            if (view4 != null) {
                view3.getFocusedRect(this.mTempRect);
                this.offsetDescendantRectToMyCoords(view3, this.mTempRect);
                this.offsetRectIntoDescendantCoords(view4, this.mTempRect);
                if (view4.requestFocus(n, this.mTempRect)) {
                    return true;
                }
            }
            if ((view2 = FocusFinder.getInstance().findNextFocus((ViewGroup)this.getRootView(), view3, n)) != null) {
                return this.isViewAncestorOf(view2, (View)this);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean arrowScroll(int n) {
        this.forceValidFocusDirection(n);
        try {
            this.mInLayout = true;
            boolean bl = this.arrowScrollImpl(n);
            if (bl) {
                this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection((int)n));
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.mInLayout = false;
        }
    }

    private void handleNewSelectionChange(View view, int n, int n2, boolean bl) {
        View view2;
        View view3;
        int n3;
        int n4;
        this.forceValidFocusDirection(n);
        if (n2 == -1) {
            throw new IllegalArgumentException("newSelectedPosition needs to be valid");
        }
        int n5 = this.mSelectedPosition - this.mFirstPosition;
        int n6 = n2 - this.mFirstPosition;
        boolean bl2 = false;
        if (n == 33 || n == 17) {
            n4 = n6;
            n3 = n5;
            view3 = this.getChildAt(n4);
            view2 = view;
            bl2 = true;
        } else {
            n4 = n5;
            n3 = n6;
            view3 = view;
            view2 = this.getChildAt(n3);
        }
        int n7 = this.getChildCount();
        if (view3 != null) {
            view3.setSelected(!bl && bl2);
            this.measureAndAdjustDown(view3, n4, n7);
        }
        if (view2 != null) {
            view2.setSelected(!bl && !bl2);
            this.measureAndAdjustDown(view2, n3, n7);
        }
    }

    private void measureAndAdjustDown(View view, int n, int n2) {
        int n3 = view.getHeight();
        this.measureChild(view);
        if (view.getMeasuredHeight() == n3) {
            return;
        }
        this.relayoutMeasuredChild(view);
        int n4 = view.getMeasuredHeight() - n3;
        for (int i = n + 1; i < n2; ++i) {
            this.getChildAt(i).offsetTopAndBottom(n4);
        }
    }

    private ArrowScrollFocusResult arrowScrollFocused(int n) {
        int n2;
        View view;
        this.forceValidFocusDirection(n);
        View view2 = this.getSelectedView();
        if (view2 != null && view2.hasFocus()) {
            View view3 = view2.findFocus();
            view = FocusFinder.getInstance().findNextFocus((ViewGroup)this, view3, n);
        } else {
            int n3;
            int n4;
            if (n == 130 || n == 66) {
                n4 = this.getStartEdge();
                n2 = view2 != null ? (this.mIsVertical ? view2.getTop() : view2.getLeft()) : n4;
                n3 = Math.max(n2, n4);
            } else {
                n4 = this.getEndEdge();
                n2 = view2 != null ? this.getChildEndEdge(view2) : n4;
                n3 = Math.min(n2, n4);
            }
            n4 = this.mIsVertical ? 0 : n3;
            n2 = this.mIsVertical ? n3 : 0;
            this.mTempRect.set(n4, n2, n4, n2);
            view = FocusFinder.getInstance().findNextFocusFromRect((ViewGroup)this, this.mTempRect, n);
        }
        if (view != null) {
            int n5;
            int n6 = this.positionOfNewFocus(view);
            if (this.mSelectedPosition != -1 && n6 != this.mSelectedPosition) {
                boolean bl;
                n2 = this.lookForSelectablePositionOnScreen(n);
                n5 = n == 130 || n == 66 ? 1 : 0;
                boolean bl2 = bl = n == 33 || n == 17;
                if (n2 != -1 && (n5 != 0 && n2 < n6 || bl && n2 > n6)) {
                    return null;
                }
            }
            if ((n2 = this.amountToScrollToNewFocus(n, view, n6)) < (n5 = this.getMaxScrollAmount())) {
                view.requestFocus(n);
                this.mArrowScrollFocusResult.populate(n6, n2);
                return this.mArrowScrollFocusResult;
            }
            if (this.distanceToView(view) < n5) {
                view.requestFocus(n);
                this.mArrowScrollFocusResult.populate(n6, n5);
                return this.mArrowScrollFocusResult;
            }
        }
        return null;
    }

    public int getMaxScrollAmount() {
        return (int)(0.33f * (float)this.getHeight());
    }

    private int getArrowScrollPreviewLength() {
        int n = this.mIsVertical ? this.getVerticalFadingEdgeLength() : this.getHorizontalFadingEdgeLength();
        return this.mItemMargin + Math.max(10, n);
    }

    private int positionOfNewFocus(View view) {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view2 = this.getChildAt(i);
            if (!this.isViewAncestorOf(view, view2)) continue;
            return this.mFirstPosition + i;
        }
        throw new IllegalArgumentException("newFocus is not a child of any of the children of the list!");
    }

    private boolean arrowScrollImpl(int n) {
        View view;
        boolean bl;
        ArrowScrollFocusResult arrowScrollFocusResult;
        this.forceValidFocusDirection(n);
        if (this.getChildCount() <= 0) {
            return false;
        }
        View view2 = this.getSelectedView();
        int n2 = this.mSelectedPosition;
        int n3 = this.lookForSelectablePositionOnScreen(n);
        int n4 = this.amountToScroll(n, n3);
        ArrowScrollFocusResult arrowScrollFocusResult2 = arrowScrollFocusResult = this.mItemsCanFocus ? this.arrowScrollFocused(n) : null;
        if (arrowScrollFocusResult != null) {
            n3 = arrowScrollFocusResult.getSelectedPosition();
            n4 = arrowScrollFocusResult.getAmountToScroll();
        }
        boolean bl2 = bl = arrowScrollFocusResult != null;
        if (n3 != -1) {
            this.handleNewSelectionChange(view2, n, n3, arrowScrollFocusResult != null);
            this.setSelectedPositionInt(n3);
            this.setNextSelectedPositionInt(n3);
            view2 = this.getSelectedView();
            n2 = n3;
            if (this.mItemsCanFocus && arrowScrollFocusResult == null && (view = this.getFocusedChild()) != null) {
                view.clearFocus();
            }
            bl = true;
            this.checkSelectionChanged();
        }
        if (n4 > 0) {
            this.scrollListItemsBy(n == 33 || n == 17 ? n4 : -n4);
            bl = true;
        }
        if (this.mItemsCanFocus && arrowScrollFocusResult == null && view2 != null && view2.hasFocus() && (!this.isViewAncestorOf(view = view2.findFocus(), (View)this) || this.distanceToView(view) > 0)) {
            view.clearFocus();
        }
        if (n3 == -1 && view2 != null && !this.isViewAncestorOf(view2, (View)this)) {
            view2 = null;
            this.hideSelector();
            this.mResurrectToPosition = -1;
        }
        if (bl) {
            if (view2 != null) {
                this.positionSelector(n2, view2);
                this.mSelectedStart = view2.getTop();
            }
            if (!this.awakenScrollbarsInternal()) {
                this.invalidate();
            }
            this.invokeOnItemScrollListener();
            return true;
        }
        return false;
    }

    private int amountToScroll(int n, int n2) {
        this.forceValidFocusDirection(n);
        int n3 = this.getChildCount();
        if (n == 130 || n == 66) {
            int n4 = this.getEndEdge();
            int n5 = n3 - 1;
            if (n2 != -1) {
                n5 = n2 - this.mFirstPosition;
            }
            int n6 = this.mFirstPosition + n5;
            View view = this.getChildAt(n5);
            int n7 = n4;
            if (n6 < this.mItemCount - 1) {
                n7 -= this.getArrowScrollPreviewLength();
            }
            int n8 = this.getChildStartEdge(view);
            int n9 = this.getChildEndEdge(view);
            if (n9 <= n7) {
                return 0;
            }
            if (n2 != -1 && n7 - n8 >= this.getMaxScrollAmount()) {
                return 0;
            }
            int n10 = n9 - n7;
            if (this.mFirstPosition + n3 == this.mItemCount) {
                int n11 = this.getChildEndEdge(this.getChildAt(n3 - 1));
                int n12 = n11 - n4;
                n10 = Math.min(n10, n12);
            }
            return Math.min(n10, this.getMaxScrollAmount());
        }
        int n13 = this.getStartEdge();
        int n14 = 0;
        if (n2 != -1) {
            n14 = n2 - this.mFirstPosition;
        }
        int n15 = this.mFirstPosition + n14;
        View view = this.getChildAt(n14);
        int n16 = n13;
        if (n15 > 0) {
            n16 += this.getArrowScrollPreviewLength();
        }
        int n17 = this.getChildStartEdge(view);
        int n18 = this.getChildEndEdge(view);
        if (n17 >= n16) {
            return 0;
        }
        if (n2 != -1 && n18 - n16 >= this.getMaxScrollAmount()) {
            return 0;
        }
        int n19 = n16 - n17;
        if (this.mFirstPosition == 0) {
            int n20 = this.getChildStartEdge(this.getChildAt(0));
            int n21 = n13 - n20;
            n19 = Math.min(n19, n21);
        }
        return Math.min(n19, this.getMaxScrollAmount());
    }

    private int amountToScrollToNewFocus(int n, View view, int n2) {
        this.forceValidFocusDirection(n);
        int n3 = 0;
        view.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(view, this.mTempRect);
        if (n == 33 || n == 17) {
            int n4;
            int n5 = this.getStartEdge();
            int n6 = n4 = this.mIsVertical ? this.mTempRect.top : this.mTempRect.left;
            if (n4 < n5) {
                n3 = n5 - n4;
                if (n2 > 0) {
                    n3 += this.getArrowScrollPreviewLength();
                }
            }
        } else {
            int n7;
            int n8 = this.getEndEdge();
            int n9 = n7 = this.mIsVertical ? this.mTempRect.bottom : this.mTempRect.right;
            if (n7 > n8) {
                n3 = n7 - n8;
                if (n2 < this.mItemCount - 1) {
                    n3 += this.getArrowScrollPreviewLength();
                }
            }
        }
        return n3;
    }

    private int distanceToView(View view) {
        view.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(view, this.mTempRect);
        int n = this.getStartEdge();
        int n2 = this.getEndEdge();
        int n3 = this.mIsVertical ? this.mTempRect.top : this.mTempRect.left;
        int n4 = this.mIsVertical ? this.mTempRect.bottom : this.mTempRect.right;
        int n5 = 0;
        if (n4 < n) {
            n5 = n - n4;
        } else if (n3 > n2) {
            n5 = n3 - n2;
        }
        return n5;
    }

    private boolean handleKeyScroll(KeyEvent keyEvent, int n, int n2) {
        boolean bl = false;
        if (KeyEventCompat.hasNoModifiers((KeyEvent)keyEvent)) {
            bl = this.resurrectSelectionIfNeeded();
            if (!bl) {
                while (n-- > 0 && this.arrowScroll(n2)) {
                    bl = true;
                }
            }
        } else if (KeyEventCompat.hasModifiers((KeyEvent)keyEvent, (int)2)) {
            bl = this.resurrectSelectionIfNeeded() || this.fullScroll(n2);
        }
        return bl;
    }

    private boolean handleKeyEvent(int n, int n2, KeyEvent keyEvent) {
        if (this.mAdapter == null || !this.mIsAttached) {
            return false;
        }
        if (this.mDataChanged) {
            this.layoutChildren();
        }
        boolean bl = false;
        int n3 = keyEvent.getAction();
        if (n3 != 1) {
            switch (n) {
                case 19: {
                    if (this.mIsVertical) {
                        bl = this.handleKeyScroll(keyEvent, n2, 33);
                        break;
                    }
                    if (!KeyEventCompat.hasNoModifiers((KeyEvent)keyEvent)) break;
                    bl = this.handleFocusWithinItem(33);
                    break;
                }
                case 20: {
                    if (this.mIsVertical) {
                        bl = this.handleKeyScroll(keyEvent, n2, 130);
                        break;
                    }
                    if (!KeyEventCompat.hasNoModifiers((KeyEvent)keyEvent)) break;
                    bl = this.handleFocusWithinItem(130);
                    break;
                }
                case 21: {
                    if (!this.mIsVertical) {
                        bl = this.handleKeyScroll(keyEvent, n2, 17);
                        break;
                    }
                    if (!KeyEventCompat.hasNoModifiers((KeyEvent)keyEvent)) break;
                    bl = this.handleFocusWithinItem(17);
                    break;
                }
                case 22: {
                    if (!this.mIsVertical) {
                        bl = this.handleKeyScroll(keyEvent, n2, 66);
                        break;
                    }
                    if (!KeyEventCompat.hasNoModifiers((KeyEvent)keyEvent)) break;
                    bl = this.handleFocusWithinItem(66);
                    break;
                }
                case 23: 
                case 66: {
                    if (!KeyEventCompat.hasNoModifiers((KeyEvent)keyEvent) || (bl = this.resurrectSelectionIfNeeded()) || keyEvent.getRepeatCount() != 0 || this.getChildCount() <= 0) break;
                    this.keyPressed();
                    bl = true;
                    break;
                }
                case 62: {
                    if (KeyEventCompat.hasNoModifiers((KeyEvent)keyEvent)) {
                        bl = this.resurrectSelectionIfNeeded() || this.pageScroll(this.mIsVertical ? 130 : 66);
                    } else if (KeyEventCompat.hasModifiers((KeyEvent)keyEvent, (int)1)) {
                        bl = this.resurrectSelectionIfNeeded() || this.fullScroll(this.mIsVertical ? 33 : 17);
                    }
                    bl = true;
                    break;
                }
                case 92: {
                    if (KeyEventCompat.hasNoModifiers((KeyEvent)keyEvent)) {
                        bl = this.resurrectSelectionIfNeeded() || this.pageScroll(this.mIsVertical ? 33 : 17);
                        break;
                    }
                    if (!KeyEventCompat.hasModifiers((KeyEvent)keyEvent, (int)2)) break;
                    bl = this.resurrectSelectionIfNeeded() || this.fullScroll(this.mIsVertical ? 33 : 17);
                    break;
                }
                case 93: {
                    if (KeyEventCompat.hasNoModifiers((KeyEvent)keyEvent)) {
                        bl = this.resurrectSelectionIfNeeded() || this.pageScroll(this.mIsVertical ? 130 : 66);
                        break;
                    }
                    if (!KeyEventCompat.hasModifiers((KeyEvent)keyEvent, (int)2)) break;
                    bl = this.resurrectSelectionIfNeeded() || this.fullScroll(this.mIsVertical ? 130 : 66);
                    break;
                }
                case 122: {
                    if (!KeyEventCompat.hasNoModifiers((KeyEvent)keyEvent)) break;
                    bl = this.resurrectSelectionIfNeeded() || this.fullScroll(this.mIsVertical ? 33 : 17);
                    break;
                }
                case 123: {
                    if (!KeyEventCompat.hasNoModifiers((KeyEvent)keyEvent)) break;
                    boolean bl2 = this.resurrectSelectionIfNeeded() || this.fullScroll(this.mIsVertical ? 130 : 66) ? true : (bl = false);
                }
            }
        }
        if (bl) {
            return true;
        }
        switch (n3) {
            case 0: {
                return super.onKeyDown(n, keyEvent);
            }
            case 1: {
                if (!this.isEnabled()) {
                    return true;
                }
                if (this.isClickable() && this.isPressed() && this.mSelectedPosition >= 0 && this.mAdapter != null && this.mSelectedPosition < this.mAdapter.getCount()) {
                    View view = this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
                    if (view != null) {
                        this.performItemClick(view, this.mSelectedPosition, this.mSelectedRowId);
                        view.setPressed(false);
                    }
                    this.setPressed(false);
                    return true;
                }
                return false;
            }
            case 2: {
                return super.onKeyMultiple(n, n2, keyEvent);
            }
        }
        return false;
    }

    private void initOrResetVelocityTracker() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            this.mVelocityTracker.clear();
        }
    }

    private void initVelocityTrackerIfNotExists() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private void recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private void invokeOnItemScrollListener() {
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScroll(this, this.mFirstPosition, this.getChildCount(), this.mItemCount);
        }
        this.onScrollChanged(0, 0, 0, 0);
    }

    private void reportScrollStateChange(int n) {
        if (n == this.mLastScrollState) {
            return;
        }
        if (this.mOnScrollListener != null) {
            this.mLastScrollState = n;
            this.mOnScrollListener.onScrollStateChanged(this, n);
        }
    }

    private boolean maybeStartScrolling(int n) {
        boolean bl;
        boolean bl2 = bl = this.mOverScroll != 0;
        if (Math.abs(n) <= this.mTouchSlop && !bl) {
            return false;
        }
        this.mTouchMode = bl ? 5 : 3;
        ViewParent viewParent = this.getParent();
        if (viewParent != null) {
            viewParent.requestDisallowInterceptTouchEvent(true);
        }
        this.cancelCheckForLongPress();
        this.setPressed(false);
        View view = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
        if (view != null) {
            view.setPressed(false);
        }
        this.reportScrollStateChange(1);
        return true;
    }

    private void maybeScroll(int n) {
        if (this.mTouchMode == 3) {
            this.handleDragChange(n);
        } else if (this.mTouchMode == 5) {
            this.handleOverScrollChange(n);
        }
    }

    private void handleDragChange(int n) {
        ViewParent viewParent = this.getParent();
        if (viewParent != null) {
            viewParent.requestDisallowInterceptTouchEvent(true);
        }
        int n2 = this.mMotionPosition >= 0 ? this.mMotionPosition - this.mFirstPosition : this.getChildCount() / 2;
        int n3 = 0;
        View view = this.getChildAt(n2);
        if (view != null) {
            n3 = this.mIsVertical ? view.getTop() : view.getLeft();
        }
        boolean bl = this.scrollListItemsBy(n);
        view = this.getChildAt(n2);
        if (view != null) {
            int n4;
            int n5 = n4 = this.mIsVertical ? view.getTop() : view.getLeft();
            if (bl) {
                int n6 = -n - (n4 - n3);
                this.updateOverScrollState(n, n6);
            }
        }
    }

    private void updateOverScrollState(int n, int n2) {
        int n3;
        this.overScrollByInternal(this.mIsVertical ? 0 : n2, this.mIsVertical ? n2 : 0, this.mIsVertical ? 0 : this.mOverScroll, this.mIsVertical ? this.mOverScroll : 0, 0, 0, this.mIsVertical ? 0 : this.mOverscrollDistance, this.mIsVertical ? this.mOverscrollDistance : 0, true);
        if (Math.abs(this.mOverscrollDistance) == Math.abs(this.mOverScroll) && this.mVelocityTracker != null) {
            this.mVelocityTracker.clear();
        }
        if ((n3 = ViewCompat.getOverScrollMode((View)this)) == 0 || n3 == 1 && !this.contentFits()) {
            this.mTouchMode = 5;
            float f = (float)n2 / (float)(this.mIsVertical ? this.getHeight() : this.getWidth());
            if (n > 0) {
                this.mStartEdge.onPull(f);
                if (!this.mEndEdge.isFinished()) {
                    this.mEndEdge.onRelease();
                }
            } else if (n < 0) {
                this.mEndEdge.onPull(f);
                if (!this.mStartEdge.isFinished()) {
                    this.mStartEdge.onRelease();
                }
            }
            if (n != 0) {
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
        }
    }

    private void handleOverScrollChange(int n) {
        int n2 = this.mOverScroll;
        int n3 = n2 - n;
        int n4 = -n;
        if (n3 < 0 && n2 >= 0 || n3 > 0 && n2 <= 0) {
            n4 = -n2;
            n += n4;
        } else {
            n = 0;
        }
        if (n4 != 0) {
            this.updateOverScrollState(n, n4);
        }
        if (n != 0) {
            if (this.mOverScroll != 0) {
                this.mOverScroll = 0;
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
            this.scrollListItemsBy(n);
            this.mTouchMode = 3;
            this.mMotionPosition = this.findClosestMotionRowOrColumn((int)this.mLastTouchPos);
            this.mTouchRemainderPos = 0.0f;
        }
    }

    private static int getDistance(Rect rect, Rect rect2, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        switch (n) {
            case 66: {
                n5 = rect.right;
                n4 = rect.top + rect.height() / 2;
                n3 = rect2.left;
                n2 = rect2.top + rect2.height() / 2;
                break;
            }
            case 130: {
                n5 = rect.left + rect.width() / 2;
                n4 = rect.bottom;
                n3 = rect2.left + rect2.width() / 2;
                n2 = rect2.top;
                break;
            }
            case 17: {
                n5 = rect.left;
                n4 = rect.top + rect.height() / 2;
                n3 = rect2.right;
                n2 = rect2.top + rect2.height() / 2;
                break;
            }
            case 33: {
                n5 = rect.left + rect.width() / 2;
                n4 = rect.top;
                n3 = rect2.left + rect2.width() / 2;
                n2 = rect2.bottom;
                break;
            }
            case 1: 
            case 2: {
                n5 = rect.right + rect.width() / 2;
                n4 = rect.top + rect.height() / 2;
                n3 = rect2.left + rect2.width() / 2;
                n2 = rect2.top + rect2.height() / 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT, FOCUS_FORWARD, FOCUS_BACKWARD}.");
            }
        }
        int n6 = n3 - n5;
        int n7 = n2 - n4;
        return n7 * n7 + n6 * n6;
    }

    private int findMotionRowOrColumn(int n) {
        int n2 = this.getChildCount();
        if (n2 == 0) {
            return -1;
        }
        for (int i = 0; i < n2; ++i) {
            View view = this.getChildAt(i);
            if (n > this.getChildEndEdge(view)) continue;
            return this.mFirstPosition + i;
        }
        return -1;
    }

    private int findClosestMotionRowOrColumn(int n) {
        int n2 = this.getChildCount();
        if (n2 == 0) {
            return -1;
        }
        int n3 = this.findMotionRowOrColumn(n);
        if (n3 != -1) {
            return n3;
        }
        return this.mFirstPosition + n2 - 1;
    }

    @TargetApi(value=9)
    private int getScaledOverscrollDistance(ViewConfiguration viewConfiguration) {
        if (Build.VERSION.SDK_INT < 9) {
            return 0;
        }
        return viewConfiguration.getScaledOverscrollDistance();
    }

    private int getStartEdge() {
        return this.mIsVertical ? this.getPaddingTop() : this.getPaddingLeft();
    }

    private int getEndEdge() {
        if (this.mIsVertical) {
            return this.getHeight() - this.getPaddingBottom();
        }
        return this.getWidth() - this.getPaddingRight();
    }

    private int getChildStartEdge(View view) {
        return this.mIsVertical ? view.getTop() : view.getLeft();
    }

    private int getChildEndEdge(View view) {
        return this.mIsVertical ? view.getBottom() : view.getRight();
    }

    private boolean contentFits() {
        int n = this.getChildCount();
        if (n == 0) {
            return true;
        }
        if (n != this.mItemCount) {
            return false;
        }
        View view = this.getChildAt(0);
        View view2 = this.getChildAt(n - 1);
        return this.getChildStartEdge(view) >= this.getStartEdge() && this.getChildEndEdge(view2) <= this.getEndEdge();
    }

    private void triggerCheckForTap() {
        if (this.mPendingCheckForTap == null) {
            this.mPendingCheckForTap = new CheckForTap();
        }
        this.postDelayed(this.mPendingCheckForTap, ViewConfiguration.getTapTimeout());
    }

    private void cancelCheckForTap() {
        if (this.mPendingCheckForTap == null) {
            return;
        }
        this.removeCallbacks(this.mPendingCheckForTap);
    }

    private void triggerCheckForLongPress() {
        if (this.mPendingCheckForLongPress == null) {
            this.mPendingCheckForLongPress = new CheckForLongPress();
        }
        this.mPendingCheckForLongPress.rememberWindowAttachCount();
        this.postDelayed(this.mPendingCheckForLongPress, ViewConfiguration.getLongPressTimeout());
    }

    private void cancelCheckForLongPress() {
        if (this.mPendingCheckForLongPress == null) {
            return;
        }
        this.removeCallbacks(this.mPendingCheckForLongPress);
    }

    private boolean scrollListItemsBy(int n) {
        int n2;
        int n3;
        boolean bl;
        boolean bl2;
        int n4 = this.getChildCount();
        if (n4 == 0) {
            return true;
        }
        int n5 = this.getChildStartEdge(this.getChildAt(0));
        int n6 = this.getChildEndEdge(this.getChildAt(n4 - 1));
        int n7 = this.getPaddingTop();
        int n8 = this.getPaddingBottom();
        int n9 = this.getPaddingLeft();
        int n10 = this.getPaddingRight();
        int n11 = this.mIsVertical ? n7 : n9;
        int n12 = n11 - n5;
        int n13 = this.getEndEdge();
        int n14 = n6 - n13;
        int n15 = this.mIsVertical ? this.getHeight() - n8 - n7 : this.getWidth() - n10 - n9;
        n = n < 0 ? Math.max(-(n15 - 1), n) : Math.min(n15 - 1, n);
        int n16 = this.mFirstPosition;
        boolean bl3 = n16 == 0 && n5 >= n11 && n >= 0;
        boolean bl4 = bl2 = n16 + n4 == this.mItemCount && n6 <= n13 && n <= 0;
        if (bl3 || bl2) {
            return n != 0;
        }
        boolean bl5 = this.isInTouchMode();
        if (bl5) {
            this.hideSelector();
        }
        int n17 = 0;
        int n18 = 0;
        boolean bl6 = bl = n < 0;
        if (bl) {
            View view;
            int n19;
            n3 = -n + n11;
            for (n2 = 0; n2 < n4 && (n19 = this.getChildEndEdge(view = this.getChildAt(n2))) < n3; ++n2) {
                ++n18;
                this.mRecycler.addScrapView(view, n16 + n2);
            }
        } else {
            View view;
            int n20;
            n3 = n13 - n;
            for (n2 = n4 - 1; n2 >= 0 && (n20 = this.getChildStartEdge(view = this.getChildAt(n2))) > n3; --n2) {
                n17 = n2;
                ++n18;
                this.mRecycler.addScrapView(view, n16 + n2);
            }
        }
        this.mBlockLayoutRequests = true;
        if (n18 > 0) {
            this.detachViewsFromParent(n17, n18);
        }
        if (!this.awakenScrollbarsInternal()) {
            this.invalidate();
        }
        this.offsetChildren(n);
        if (bl) {
            this.mFirstPosition += n18;
        }
        if (n12 < (n3 = Math.abs(n)) || n14 < n3) {
            this.fillGap(bl);
        }
        if (!bl5 && this.mSelectedPosition != -1) {
            n2 = this.mSelectedPosition - this.mFirstPosition;
            if (n2 >= 0 && n2 < this.getChildCount()) {
                this.positionSelector(this.mSelectedPosition, this.getChildAt(n2));
            }
        } else if (this.mSelectorPosition != -1) {
            n2 = this.mSelectorPosition - this.mFirstPosition;
            if (n2 >= 0 && n2 < this.getChildCount()) {
                this.positionSelector(-1, this.getChildAt(n2));
            }
        } else {
            this.mSelectorRect.setEmpty();
        }
        this.mBlockLayoutRequests = false;
        this.invokeOnItemScrollListener();
        return false;
    }

    @TargetApi(value=14)
    private final float getCurrVelocity() {
        if (Build.VERSION.SDK_INT >= 14) {
            return this.mScroller.getCurrVelocity();
        }
        return 0.0f;
    }

    @TargetApi(value=5)
    private boolean awakenScrollbarsInternal() {
        return Build.VERSION.SDK_INT >= 5 && super.awakenScrollBars();
    }

    public void computeScroll() {
        if (!this.mScroller.computeScrollOffset()) {
            return;
        }
        int n = this.mIsVertical ? this.mScroller.getCurrY() : this.mScroller.getCurrX();
        int n2 = (int)((float)n - this.mLastTouchPos);
        this.mLastTouchPos = n;
        boolean bl = this.scrollListItemsBy(n2);
        if (!bl && !this.mScroller.isFinished()) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        } else {
            if (bl) {
                EdgeEffectCompat edgeEffectCompat;
                boolean bl2;
                int n3 = ViewCompat.getOverScrollMode((View)this);
                if (n3 != 2 && (bl2 = (edgeEffectCompat = n2 > 0 ? this.mStartEdge : this.mEndEdge).onAbsorb(Math.abs((int)this.getCurrVelocity())))) {
                    ViewCompat.postInvalidateOnAnimation((View)this);
                }
                this.mScroller.abortAnimation();
            }
            this.mTouchMode = -1;
            this.reportScrollStateChange(0);
        }
    }

    private void finishEdgeGlows() {
        if (this.mStartEdge != null) {
            this.mStartEdge.finish();
        }
        if (this.mEndEdge != null) {
            this.mEndEdge.finish();
        }
    }

    private boolean drawStartEdge(Canvas canvas) {
        if (this.mStartEdge.isFinished()) {
            return false;
        }
        if (this.mIsVertical) {
            return this.mStartEdge.draw(canvas);
        }
        int n = canvas.save();
        int n2 = this.getHeight();
        canvas.translate(0.0f, (float)n2);
        canvas.rotate(270.0f);
        boolean bl = this.mStartEdge.draw(canvas);
        canvas.restoreToCount(n);
        return bl;
    }

    private boolean drawEndEdge(Canvas canvas) {
        if (this.mEndEdge.isFinished()) {
            return false;
        }
        int n = canvas.save();
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        if (this.mIsVertical) {
            canvas.translate((float)(-n2), (float)n3);
            canvas.rotate(180.0f, (float)n2, 0.0f);
        } else {
            canvas.translate((float)n2, 0.0f);
            canvas.rotate(90.0f);
        }
        boolean bl = this.mEndEdge.draw(canvas);
        canvas.restoreToCount(n);
        return bl;
    }

    private void drawSelector(Canvas canvas) {
        if (!this.mSelectorRect.isEmpty()) {
            Drawable drawable2 = this.mSelector;
            drawable2.setBounds(this.mSelectorRect);
            drawable2.draw(canvas);
        }
    }

    private void useDefaultSelector() {
        this.setSelector(this.getResources().getDrawable(17301602));
    }

    private boolean shouldShowSelector() {
        return this.hasFocus() && !this.isInTouchMode() || this.touchModeDrawsInPressedState();
    }

    private void positionSelector(int n, View view) {
        if (n != -1) {
            this.mSelectorPosition = n;
        }
        this.mSelectorRect.set(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        boolean bl = this.mIsChildViewEnabled;
        if (view.isEnabled() != bl) {
            boolean bl2 = this.mIsChildViewEnabled = !bl;
            if (this.getSelectedItemPosition() != -1) {
                this.refreshDrawableState();
            }
        }
    }

    private void hideSelector() {
        if (this.mSelectedPosition != -1) {
            if (this.mLayoutMode != 4) {
                this.mResurrectToPosition = this.mSelectedPosition;
            }
            if (this.mNextSelectedPosition >= 0 && this.mNextSelectedPosition != this.mSelectedPosition) {
                this.mResurrectToPosition = this.mNextSelectedPosition;
            }
            this.setSelectedPositionInt(-1);
            this.setNextSelectedPositionInt(-1);
            this.mSelectedStart = 0;
        }
    }

    private void setSelectedPositionInt(int n) {
        this.mSelectedPosition = n;
        this.mSelectedRowId = this.getItemIdAtPosition(n);
    }

    private void setSelectionInt(int n) {
        this.setNextSelectedPositionInt(n);
        boolean bl = false;
        int n2 = this.mSelectedPosition;
        if (n2 >= 0) {
            if (n == n2 - 1) {
                bl = true;
            } else if (n == n2 + 1) {
                bl = true;
            }
        }
        this.layoutChildren();
        if (bl) {
            this.awakenScrollbarsInternal();
        }
    }

    private void setNextSelectedPositionInt(int n) {
        this.mNextSelectedPosition = n;
        this.mNextSelectedRowId = this.getItemIdAtPosition(n);
        if (this.mNeedSync && this.mSyncMode == 0 && n >= 0) {
            this.mSyncPosition = n;
            this.mSyncRowId = this.mNextSelectedRowId;
        }
    }

    private boolean touchModeDrawsInPressedState() {
        switch (this.mTouchMode) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    private void keyPressed() {
        if (!this.isEnabled() || !this.isClickable()) {
            return;
        }
        Drawable drawable2 = this.mSelector;
        Rect rect = this.mSelectorRect;
        if (drawable2 != null && (this.isFocused() || this.touchModeDrawsInPressedState()) && !rect.isEmpty()) {
            View view = this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
            if (view != null) {
                if (view.hasFocusable()) {
                    return;
                }
                view.setPressed(true);
            }
            this.setPressed(true);
            boolean bl = this.isLongClickable();
            Drawable drawable3 = drawable2.getCurrent();
            if (drawable3 != null && drawable3 instanceof TransitionDrawable) {
                if (bl) {
                    ((TransitionDrawable)drawable3).startTransition(ViewConfiguration.getLongPressTimeout());
                } else {
                    ((TransitionDrawable)drawable3).resetTransition();
                }
            }
            if (bl && !this.mDataChanged) {
                if (this.mPendingCheckForKeyLongPress == null) {
                    this.mPendingCheckForKeyLongPress = new CheckForKeyLongPress();
                }
                this.mPendingCheckForKeyLongPress.rememberWindowAttachCount();
                this.postDelayed(this.mPendingCheckForKeyLongPress, ViewConfiguration.getLongPressTimeout());
            }
        }
    }

    private void updateSelectorState() {
        if (this.mSelector != null) {
            if (this.shouldShowSelector()) {
                this.mSelector.setState(this.getDrawableState());
            } else {
                this.mSelector.setState(STATE_NOTHING);
            }
        }
    }

    private void checkSelectionChanged() {
        if (this.mSelectedPosition != this.mOldSelectedPosition || this.mSelectedRowId != this.mOldSelectedRowId) {
            this.selectionChanged();
            this.mOldSelectedPosition = this.mSelectedPosition;
            this.mOldSelectedRowId = this.mSelectedRowId;
        }
    }

    private void selectionChanged() {
        AdapterView.OnItemSelectedListener onItemSelectedListener = this.getOnItemSelectedListener();
        if (onItemSelectedListener == null) {
            return;
        }
        if (this.mInLayout || this.mBlockLayoutRequests) {
            if (this.mSelectionNotifier == null) {
                this.mSelectionNotifier = new SelectionNotifier();
            }
            this.post(this.mSelectionNotifier);
        } else {
            this.fireOnSelected();
            this.performAccessibilityActionsOnSelected();
        }
    }

    private void fireOnSelected() {
        AdapterView.OnItemSelectedListener onItemSelectedListener = this.getOnItemSelectedListener();
        if (onItemSelectedListener == null) {
            return;
        }
        int n = this.getSelectedItemPosition();
        if (n >= 0) {
            View view = this.getSelectedView();
            onItemSelectedListener.onItemSelected((AdapterView)this, view, n, this.mAdapter.getItemId(n));
        } else {
            onItemSelectedListener.onNothingSelected((AdapterView)this);
        }
    }

    private void performAccessibilityActionsOnSelected() {
        int n = this.getSelectedItemPosition();
        if (n >= 0) {
            this.sendAccessibilityEvent(4);
        }
    }

    private int lookForSelectablePosition(int n) {
        return this.lookForSelectablePosition(n, true);
    }

    private int lookForSelectablePosition(int n, boolean bl) {
        ListAdapter listAdapter = this.mAdapter;
        if (listAdapter == null || this.isInTouchMode()) {
            return -1;
        }
        int n2 = this.mItemCount;
        if (!this.mAreAllItemsSelectable) {
            if (bl) {
                for (n = Math.max(0, n); n < n2 && !listAdapter.isEnabled(n); ++n) {
                }
            } else {
                for (n = Math.min(n, n2 - 1); n >= 0 && !listAdapter.isEnabled(n); --n) {
                }
            }
            if (n < 0 || n >= n2) {
                return -1;
            }
            return n;
        }
        if (n < 0 || n >= n2) {
            return -1;
        }
        return n;
    }

    private int lookForSelectablePositionOnScreen(int n) {
        this.forceValidFocusDirection(n);
        int n2 = this.mFirstPosition;
        ListAdapter listAdapter = this.getAdapter();
        if (n == 130 || n == 66) {
            int n3;
            int n4 = n3 = this.mSelectedPosition != -1 ? this.mSelectedPosition + 1 : n2;
            if (n3 >= listAdapter.getCount()) {
                return -1;
            }
            if (n3 < n2) {
                n3 = n2;
            }
            int n5 = this.getLastVisiblePosition();
            for (int i = n3; i <= n5; ++i) {
                if (!listAdapter.isEnabled(i) || this.getChildAt(i - n2).getVisibility() != 0) continue;
                return i;
            }
        } else {
            int n6;
            int n7 = n2 + this.getChildCount() - 1;
            int n8 = n6 = this.mSelectedPosition != -1 ? this.mSelectedPosition - 1 : n2 + this.getChildCount() - 1;
            if (n6 < 0 || n6 >= listAdapter.getCount()) {
                return -1;
            }
            if (n6 > n7) {
                n6 = n7;
            }
            for (int i = n6; i >= n2; --i) {
                if (!listAdapter.isEnabled(i) || this.getChildAt(i - n2).getVisibility() != 0) continue;
                return i;
            }
        }
        return -1;
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.updateSelectorState();
    }

    protected int[] onCreateDrawableState(int n) {
        if (this.mIsChildViewEnabled) {
            return super.onCreateDrawableState(n);
        }
        int n2 = ENABLED_STATE_SET[0];
        int[] nArray = super.onCreateDrawableState(n + 1);
        int n3 = -1;
        for (int i = nArray.length - 1; i >= 0; --i) {
            if (nArray[i] != n2) continue;
            n3 = i;
            break;
        }
        if (n3 >= 0) {
            System.arraycopy(nArray, n3 + 1, nArray, n3, nArray.length - n3 - 1);
        }
        return nArray;
    }

    protected boolean canAnimate() {
        return super.canAnimate() && this.mItemCount > 0;
    }

    protected void dispatchDraw(Canvas canvas) {
        boolean bl = this.mDrawSelectorOnTop;
        if (!bl) {
            this.drawSelector(canvas);
        }
        super.dispatchDraw(canvas);
        if (bl) {
            this.drawSelector(canvas);
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        boolean bl = false;
        if (this.mStartEdge != null) {
            bl |= this.drawStartEdge(canvas);
        }
        if (this.mEndEdge != null) {
            bl |= this.drawEndEdge(canvas);
        }
        if (bl) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void requestLayout() {
        if (!this.mInLayout && !this.mBlockLayoutRequests) {
            super.requestLayout();
        }
    }

    public View getSelectedView() {
        if (this.mItemCount > 0 && this.mSelectedPosition >= 0) {
            return this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
        }
        return null;
    }

    public void setSelection(int n) {
        this.setSelectionFromOffset(n, 0);
    }

    public void setSelectionFromOffset(int n, int n2) {
        if (this.mAdapter == null) {
            return;
        }
        if (!this.isInTouchMode()) {
            if ((n = this.lookForSelectablePosition(n)) >= 0) {
                this.setNextSelectedPositionInt(n);
            }
        } else {
            this.mResurrectToPosition = n;
        }
        if (n >= 0) {
            this.mLayoutMode = 4;
            this.mSpecificStart = this.mIsVertical ? this.getPaddingTop() + n2 : this.getPaddingLeft() + n2;
            if (this.mNeedSync) {
                this.mSyncPosition = n;
                this.mSyncRowId = this.mAdapter.getItemId(n);
            }
            this.requestLayout();
        }
    }

    public void scrollBy(int n) {
        this.scrollListItemsBy(n);
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        View view;
        boolean bl = super.dispatchKeyEvent(keyEvent);
        if (!bl && (view = this.getFocusedChild()) != null && keyEvent.getAction() == 0) {
            bl = this.onKeyDown(keyEvent.getKeyCode(), keyEvent);
        }
        return bl;
    }

    protected void dispatchSetPressed(boolean bl) {
    }

    protected void onMeasure(int n, int n2) {
        if (this.mSelector == null) {
            this.useDefaultSelector();
        }
        int n3 = View.MeasureSpec.getMode((int)n);
        int n4 = View.MeasureSpec.getMode((int)n2);
        int n5 = View.MeasureSpec.getSize((int)n);
        int n6 = View.MeasureSpec.getSize((int)n2);
        int n7 = 0;
        int n8 = 0;
        int n9 = this.mItemCount = this.mAdapter == null ? 0 : this.mAdapter.getCount();
        if (this.mItemCount > 0 && (n3 == 0 || n4 == 0)) {
            View view = this.obtainView(0, this.mIsScrap);
            int n10 = this.mIsVertical ? n : n2;
            this.measureScrapChild(view, 0, n10);
            n7 = view.getMeasuredWidth();
            n8 = view.getMeasuredHeight();
            if (this.recycleOnMeasure()) {
                this.mRecycler.addScrapView(view, -1);
            }
        }
        if (n3 == 0) {
            n5 = this.getPaddingLeft() + this.getPaddingRight() + n7;
            if (this.mIsVertical) {
                n5 += this.getVerticalScrollbarWidth();
            }
        }
        if (n4 == 0) {
            n6 = this.getPaddingTop() + this.getPaddingBottom() + n8;
            if (!this.mIsVertical) {
                n6 += this.getHorizontalScrollbarHeight();
            }
        }
        if (this.mIsVertical && n4 == Integer.MIN_VALUE) {
            n6 = this.measureHeightOfChildren(n, 0, -1, n6, -1);
        }
        if (!this.mIsVertical && n3 == Integer.MIN_VALUE) {
            n5 = this.measureWidthOfChildren(n2, 0, -1, n5, -1);
        }
        this.setMeasuredDimension(n5, n6);
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        this.mInLayout = true;
        if (bl) {
            n6 = this.getChildCount();
            for (n5 = 0; n5 < n6; ++n5) {
                this.getChildAt(n5).forceLayout();
            }
            this.mRecycler.markChildrenDirty();
        }
        this.layoutChildren();
        this.mInLayout = false;
        n6 = n3 - n - this.getPaddingLeft() - this.getPaddingRight();
        n5 = n4 - n2 - this.getPaddingTop() - this.getPaddingBottom();
        if (this.mStartEdge != null && this.mEndEdge != null) {
            if (this.mIsVertical) {
                this.mStartEdge.setSize(n6, n5);
                this.mEndEdge.setSize(n6, n5);
            } else {
                this.mStartEdge.setSize(n5, n6);
                this.mEndEdge.setSize(n5, n6);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void layoutChildren() {
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        boolean bl = this.mBlockLayoutRequests;
        if (bl) {
            return;
        }
        this.mBlockLayoutRequests = true;
        try {
            int n;
            boolean bl2;
            this.invalidate();
            if (this.mAdapter == null) {
                this.resetState();
                return;
            }
            int n2 = this.getStartEdge();
            int n3 = this.getEndEdge();
            int n4 = this.getChildCount();
            int n5 = 0;
            int n6 = 0;
            View view = null;
            View view2 = null;
            View view3 = null;
            View view4 = null;
            View view5 = null;
            switch (this.mLayoutMode) {
                case 2: {
                    n5 = this.mNextSelectedPosition - this.mFirstPosition;
                    if (n5 < 0 || n5 >= n4) break;
                    view4 = this.getChildAt(n5);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    n5 = this.mSelectedPosition - this.mFirstPosition;
                    if (n5 >= 0 && n5 < n4) {
                        view3 = this.getChildAt(n5);
                    }
                    view5 = this.getChildAt(0);
                    if (this.mNextSelectedPosition >= 0) {
                        n6 = this.mNextSelectedPosition - this.mSelectedPosition;
                    }
                    view4 = this.getChildAt(n5 + n6);
                }
            }
            if (bl2 = this.mDataChanged) {
                this.handleDataChanged();
            }
            if (this.mItemCount == 0) {
                this.resetState();
                return;
            }
            if (this.mItemCount != this.mAdapter.getCount()) {
                throw new IllegalStateException("The content of the adapter has changed but TwoWayView did not receive a notification. Make sure the content of your adapter is not modified from a background thread, but only from the UI thread. [in TwoWayView(" + this.getId() + ", " + ((Object)((Object)this)).getClass() + ") with Adapter(" + this.mAdapter.getClass() + ")]");
            }
            this.setSelectedPositionInt(this.mNextSelectedPosition);
            View view6 = null;
            int n7 = this.mFirstPosition;
            RecycleBin recycleBin = this.mRecycler;
            if (bl2) {
                for (int i = 0; i < n4; ++i) {
                    recycleBin.addScrapView(this.getChildAt(i), n7 + i);
                }
            } else {
                recycleBin.fillActiveViews(n4, n7);
            }
            View view7 = this.getFocusedChild();
            if (view7 != null) {
                if (!bl2) {
                    view6 = view7;
                    view = this.findFocus();
                    if (view != null) {
                        view.onStartTemporaryDetach();
                    }
                }
                this.requestFocus();
            }
            this.detachAllViewsFromParent();
            switch (this.mLayoutMode) {
                case 2: {
                    if (view4 != null) {
                        n = this.mIsVertical ? view4.getTop() : view4.getLeft();
                        view2 = this.fillFromSelection(n, n2, n3);
                        break;
                    }
                    view2 = this.fillFromMiddle(n2, n3);
                    break;
                }
                case 5: {
                    view2 = this.fillSpecific(this.mSyncPosition, this.mSpecificStart);
                    break;
                }
                case 3: {
                    view2 = this.fillBefore(this.mItemCount - 1, n3);
                    this.adjustViewsStartOrEnd();
                    break;
                }
                case 1: {
                    this.mFirstPosition = 0;
                    view2 = this.fillFromOffset(n2);
                    this.adjustViewsStartOrEnd();
                    break;
                }
                case 4: {
                    view2 = this.fillSpecific(this.reconcileSelectedPosition(), this.mSpecificStart);
                    break;
                }
                case 6: {
                    view2 = this.moveSelection(view3, view4, n6, n2, n3);
                    break;
                }
                default: {
                    if (n4 == 0) {
                        n = this.lookForSelectablePosition(0);
                        this.setSelectedPositionInt(n);
                        view2 = this.fillFromOffset(n2);
                        break;
                    }
                    if (this.mSelectedPosition >= 0 && this.mSelectedPosition < this.mItemCount) {
                        n = n2;
                        if (view3 != null) {
                            n = this.mIsVertical ? view3.getTop() : view3.getLeft();
                        }
                        view2 = this.fillSpecific(this.mSelectedPosition, n);
                        break;
                    }
                    if (this.mFirstPosition < this.mItemCount) {
                        n = n2;
                        if (view5 != null) {
                            n = this.mIsVertical ? view5.getTop() : view5.getLeft();
                        }
                        view2 = this.fillSpecific(this.mFirstPosition, n);
                        break;
                    }
                    view2 = this.fillSpecific(0, n2);
                }
            }
            recycleBin.scrapActiveViews();
            if (view2 != null) {
                if (this.mItemsCanFocus && this.hasFocus() && !view2.hasFocus()) {
                    int n8 = n = view2 == view6 && view != null && view.requestFocus() || view2.requestFocus() ? 1 : 0;
                    if (n == 0) {
                        View view8 = this.getFocusedChild();
                        if (view8 != null) {
                            view8.clearFocus();
                        }
                        this.positionSelector(-1, view2);
                    } else {
                        view2.setSelected(false);
                        this.mSelectorRect.setEmpty();
                    }
                } else {
                    this.positionSelector(-1, view2);
                }
                this.mSelectedStart = this.mIsVertical ? view2.getTop() : view2.getLeft();
            } else {
                if (this.mTouchMode > 0 && this.mTouchMode < 3) {
                    View view9 = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
                    if (view9 != null) {
                        this.positionSelector(this.mMotionPosition, view9);
                    }
                } else {
                    this.mSelectedStart = 0;
                    this.mSelectorRect.setEmpty();
                }
                if (this.hasFocus() && view != null) {
                    view.requestFocus();
                }
            }
            if (view != null && view.getWindowToken() != null) {
                view.onFinishTemporaryDetach();
            }
            this.mLayoutMode = 0;
            this.mDataChanged = false;
            this.mNeedSync = false;
            this.setNextSelectedPositionInt(this.mSelectedPosition);
            if (this.mItemCount > 0) {
                this.checkSelectionChanged();
            }
            this.invokeOnItemScrollListener();
        }
        finally {
            if (!bl) {
                this.mBlockLayoutRequests = false;
                this.mDataChanged = false;
            }
        }
    }

    protected boolean recycleOnMeasure() {
        return true;
    }

    private void offsetChildren(int n) {
        int n2 = this.getChildCount();
        for (int i = 0; i < n2; ++i) {
            View view = this.getChildAt(i);
            if (this.mIsVertical) {
                view.offsetTopAndBottom(n);
                continue;
            }
            view.offsetLeftAndRight(n);
        }
    }

    private View moveSelection(View view, View view2, int n, int n2, int n3) {
        int n4 = this.mSelectedPosition;
        int n5 = this.getChildStartEdge(view);
        int n6 = this.getChildEndEdge(view);
        View view3 = null;
        if (n > 0) {
            view = this.makeAndAddView(n4 - 1, n5, true, false);
            int n7 = this.mItemMargin;
            view3 = this.makeAndAddView(n4, n6 + n7, true, true);
            int n8 = this.getChildStartEdge(view3);
            int n9 = this.getChildEndEdge(view3);
            if (n9 > n3) {
                int n10 = n8 - n2;
                int n11 = n9 - n3;
                int n12 = (n3 - n2) / 2;
                int n13 = Math.min(n10, n11);
                n13 = Math.min(n13, n12);
                if (this.mIsVertical) {
                    view.offsetTopAndBottom(-n13);
                    view3.offsetTopAndBottom(-n13);
                } else {
                    view.offsetLeftAndRight(-n13);
                    view3.offsetLeftAndRight(-n13);
                }
            }
            this.fillBefore(this.mSelectedPosition - 2, n8 - n7);
            this.adjustViewsStartOrEnd();
            this.fillAfter(this.mSelectedPosition + 1, n9 + n7);
        } else if (n < 0) {
            int n14;
            if (view2 != null) {
                n14 = this.mIsVertical ? view2.getTop() : view2.getLeft();
                view3 = this.makeAndAddView(n4, n14, true, true);
            } else {
                view3 = this.makeAndAddView(n4, n5, false, true);
            }
            n14 = this.getChildStartEdge(view3);
            int n15 = this.getChildEndEdge(view3);
            if (n14 < n2) {
                int n16 = n2 - n14;
                int n17 = n3 - n15;
                int n18 = (n3 - n2) / 2;
                int n19 = Math.min(n16, n17);
                n19 = Math.min(n19, n18);
                if (this.mIsVertical) {
                    view3.offsetTopAndBottom(n19);
                } else {
                    view3.offsetLeftAndRight(n19);
                }
            }
            this.fillBeforeAndAfter(view3, n4);
        } else {
            int n20;
            view3 = this.makeAndAddView(n4, n5, true, true);
            int n21 = this.getChildStartEdge(view3);
            int n22 = this.getChildEndEdge(view3);
            if (n5 < n2 && (n20 = n22) < n2 + 20) {
                if (this.mIsVertical) {
                    view3.offsetTopAndBottom(n2 - n21);
                } else {
                    view3.offsetLeftAndRight(n2 - n21);
                }
            }
            this.fillBeforeAndAfter(view3, n4);
        }
        return view3;
    }

    void confirmCheckedPositionsById() {
        this.mCheckStates.clear();
        for (int i = 0; i < this.mCheckedIdStates.size(); ++i) {
            int n;
            long l;
            long l2 = this.mCheckedIdStates.keyAt(i);
            if (l2 != (l = this.mAdapter.getItemId(n = ((Integer)this.mCheckedIdStates.valueAt(i)).intValue()))) {
                int n2 = Math.max(0, n - 20);
                int n3 = Math.min(n + 20, this.mItemCount);
                boolean bl = false;
                for (int j = n2; j < n3; ++j) {
                    long l3 = this.mAdapter.getItemId(j);
                    if (l2 != l3) continue;
                    bl = true;
                    this.mCheckStates.put(j, true);
                    this.mCheckedIdStates.setValueAt(i, (Object)j);
                    break;
                }
                if (bl) continue;
                this.mCheckedIdStates.delete(l2);
                --i;
                --this.mCheckedItemCount;
                continue;
            }
            this.mCheckStates.put(n, true);
        }
    }

    private void handleDataChanged() {
        if (this.mChoiceMode != ChoiceMode.NONE && this.mAdapter != null && this.mAdapter.hasStableIds()) {
            this.confirmCheckedPositionsById();
        }
        this.mRecycler.clearTransientStateViews();
        int n = this.mItemCount;
        if (n > 0) {
            int n2;
            int n3;
            if (this.mNeedSync) {
                this.mNeedSync = false;
                this.mPendingSync = null;
                switch (this.mSyncMode) {
                    case 0: {
                        if (this.isInTouchMode()) {
                            this.mLayoutMode = 5;
                            this.mSyncPosition = Math.min(Math.max(0, this.mSyncPosition), n - 1);
                            return;
                        }
                        n3 = this.findSyncPosition();
                        if (n3 < 0 || (n2 = this.lookForSelectablePosition(n3, true)) != n3) break;
                        this.mSyncPosition = n3;
                        this.mLayoutMode = this.mSyncHeight == (long)this.getHeight() ? 5 : 2;
                        this.setNextSelectedPositionInt(n3);
                        return;
                    }
                    case 1: {
                        this.mLayoutMode = 5;
                        this.mSyncPosition = Math.min(Math.max(0, this.mSyncPosition), n - 1);
                        return;
                    }
                }
            }
            if (!this.isInTouchMode()) {
                n3 = this.getSelectedItemPosition();
                if (n3 >= n) {
                    n3 = n - 1;
                }
                if (n3 < 0) {
                    n3 = 0;
                }
                if ((n2 = this.lookForSelectablePosition(n3, true)) >= 0) {
                    this.setNextSelectedPositionInt(n2);
                    return;
                }
                n2 = this.lookForSelectablePosition(n3, false);
                if (n2 >= 0) {
                    this.setNextSelectedPositionInt(n2);
                    return;
                }
            } else if (this.mResurrectToPosition >= 0) {
                return;
            }
        }
        this.mLayoutMode = 1;
        this.mSelectedPosition = -1;
        this.mSelectedRowId = Long.MIN_VALUE;
        this.mNextSelectedPosition = -1;
        this.mNextSelectedRowId = Long.MIN_VALUE;
        this.mNeedSync = false;
        this.mPendingSync = null;
        this.mSelectorPosition = -1;
        this.checkSelectionChanged();
    }

    private int reconcileSelectedPosition() {
        int n = this.mSelectedPosition;
        if (n < 0) {
            n = this.mResurrectToPosition;
        }
        n = Math.max(0, n);
        n = Math.min(n, this.mItemCount - 1);
        return n;
    }

    boolean resurrectSelection() {
        int n;
        int n2 = this.getChildCount();
        if (n2 <= 0) {
            return false;
        }
        int n3 = 0;
        int n4 = this.getStartEdge();
        int n5 = this.getEndEdge();
        int n6 = this.mFirstPosition;
        int n7 = this.mResurrectToPosition;
        boolean bl = true;
        if (n7 >= n6 && n7 < n6 + n2) {
            n = n7;
            View view = this.getChildAt(n - this.mFirstPosition);
            n3 = this.mIsVertical ? view.getTop() : view.getLeft();
        } else if (n7 < n6) {
            n = n6;
            for (int i = 0; i < n2; ++i) {
                int n8;
                View view = this.getChildAt(i);
                int n9 = n8 = this.mIsVertical ? view.getTop() : view.getLeft();
                if (i == 0) {
                    n3 = n8;
                }
                if (n8 < n4) continue;
                n = n6 + i;
                n3 = n8;
                break;
            }
        } else {
            n = n6 + n2 - 1;
            bl = false;
            for (int i = n2 - 1; i >= 0; --i) {
                View view = this.getChildAt(i);
                int n10 = this.getChildStartEdge(view);
                int n11 = this.getChildEndEdge(view);
                if (i == n2 - 1) {
                    n3 = n10;
                }
                if (n11 > n5) continue;
                n = n6 + i;
                n3 = n10;
                break;
            }
        }
        this.mResurrectToPosition = -1;
        this.mTouchMode = -1;
        this.reportScrollStateChange(0);
        this.mSpecificStart = n3;
        n = this.lookForSelectablePosition(n, bl);
        if (n >= n6 && n <= this.getLastVisiblePosition()) {
            this.mLayoutMode = 4;
            this.updateSelectorState();
            this.setSelectionInt(n);
            this.invokeOnItemScrollListener();
        } else {
            n = -1;
        }
        return n >= 0;
    }

    boolean resurrectSelectionIfNeeded() {
        if (this.mSelectedPosition < 0 && this.resurrectSelection()) {
            this.updateSelectorState();
            return true;
        }
        return false;
    }

    private int getChildWidthMeasureSpec(LayoutParams layoutParams) {
        if (!this.mIsVertical && layoutParams.width == -2) {
            return View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        }
        if (this.mIsVertical) {
            int n = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
            return View.MeasureSpec.makeMeasureSpec((int)n, (int)0x40000000);
        }
        return View.MeasureSpec.makeMeasureSpec((int)layoutParams.width, (int)0x40000000);
    }

    private int getChildHeightMeasureSpec(LayoutParams layoutParams) {
        if (this.mIsVertical && layoutParams.height == -2) {
            return View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        }
        if (!this.mIsVertical) {
            int n = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
            return View.MeasureSpec.makeMeasureSpec((int)n, (int)0x40000000);
        }
        return View.MeasureSpec.makeMeasureSpec((int)layoutParams.height, (int)0x40000000);
    }

    private void measureChild(View view) {
        this.measureChild(view, (LayoutParams)view.getLayoutParams());
    }

    private void measureChild(View view, LayoutParams layoutParams) {
        int n = this.getChildWidthMeasureSpec(layoutParams);
        int n2 = this.getChildHeightMeasureSpec(layoutParams);
        view.measure(n, n2);
    }

    private void relayoutMeasuredChild(View view) {
        int n = view.getMeasuredWidth();
        int n2 = view.getMeasuredHeight();
        int n3 = this.getPaddingLeft();
        int n4 = n3 + n;
        int n5 = view.getTop();
        int n6 = n5 + n2;
        view.layout(n3, n5, n4, n6);
    }

    private void measureScrapChild(View view, int n, int n2) {
        int n3;
        int n4;
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = this.generateDefaultLayoutParams();
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        layoutParams.viewType = this.mAdapter.getItemViewType(n);
        layoutParams.forceAdd = true;
        if (this.mIsVertical) {
            n4 = n2;
            n3 = this.getChildHeightMeasureSpec(layoutParams);
        } else {
            n4 = this.getChildWidthMeasureSpec(layoutParams);
            n3 = n2;
        }
        view.measure(n4, n3);
    }

    private int measureHeightOfChildren(int n, int n2, int n3, int n4, int n5) {
        int n6 = this.getPaddingTop();
        int n7 = this.getPaddingBottom();
        ListAdapter listAdapter = this.mAdapter;
        if (listAdapter == null) {
            return n6 + n7;
        }
        int n8 = n6 + n7;
        int n9 = this.mItemMargin;
        int n10 = 0;
        n3 = n3 == -1 ? listAdapter.getCount() - 1 : n3;
        RecycleBin recycleBin = this.mRecycler;
        boolean bl = this.recycleOnMeasure();
        boolean[] blArray = this.mIsScrap;
        for (int i = n2; i <= n3; ++i) {
            View view = this.obtainView(i, blArray);
            this.measureScrapChild(view, i, n);
            if (i > 0) {
                n8 += n9;
            }
            if (bl) {
                recycleBin.addScrapView(view, -1);
            }
            if ((n8 += view.getMeasuredHeight()) >= n4) {
                return n5 >= 0 && i > n5 && n10 > 0 && n8 != n4 ? n10 : n4;
            }
            if (n5 < 0 || i < n5) continue;
            n10 = n8;
        }
        return n8;
    }

    private int measureWidthOfChildren(int n, int n2, int n3, int n4, int n5) {
        int n6 = this.getPaddingLeft();
        int n7 = this.getPaddingRight();
        ListAdapter listAdapter = this.mAdapter;
        if (listAdapter == null) {
            return n6 + n7;
        }
        int n8 = n6 + n7;
        int n9 = this.mItemMargin;
        int n10 = 0;
        n3 = n3 == -1 ? listAdapter.getCount() - 1 : n3;
        RecycleBin recycleBin = this.mRecycler;
        boolean bl = this.recycleOnMeasure();
        boolean[] blArray = this.mIsScrap;
        for (int i = n2; i <= n3; ++i) {
            View view = this.obtainView(i, blArray);
            this.measureScrapChild(view, i, n);
            if (i > 0) {
                n8 += n9;
            }
            if (bl) {
                recycleBin.addScrapView(view, -1);
            }
            if ((n8 += view.getMeasuredWidth()) >= n4) {
                return n5 >= 0 && i > n5 && n10 > 0 && n8 != n4 ? n10 : n4;
            }
            if (n5 < 0 || i < n5) continue;
            n10 = n8;
        }
        return n8;
    }

    private View makeAndAddView(int n, int n2, boolean bl, boolean bl2) {
        View view;
        int n3;
        int n4;
        if (this.mIsVertical) {
            n4 = n2;
            n3 = this.getPaddingLeft();
        } else {
            n4 = this.getPaddingTop();
            n3 = n2;
        }
        if (!this.mDataChanged && (view = this.mRecycler.getActiveView(n)) != null) {
            this.setupChild(view, n, n4, n3, bl, bl2, true);
            return view;
        }
        view = this.obtainView(n, this.mIsScrap);
        this.setupChild(view, n, n4, n3, bl, bl2, this.mIsScrap[0]);
        return view;
    }

    @TargetApi(value=11)
    private void setupChild(View view, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        int n4;
        boolean bl4 = bl2 && this.shouldShowSelector();
        boolean bl5 = bl4 != view.isSelected();
        int n5 = this.mTouchMode;
        boolean bl6 = n5 > 0 && n5 < 3 && this.mMotionPosition == n;
        boolean bl7 = bl6 != view.isPressed();
        boolean bl8 = !bl3 || bl5 || view.isLayoutRequested();
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = this.generateDefaultLayoutParams();
        }
        layoutParams.viewType = this.mAdapter.getItemViewType(n);
        if (bl3 && !layoutParams.forceAdd) {
            this.attachViewToParent(view, bl ? -1 : 0, layoutParams);
        } else {
            layoutParams.forceAdd = false;
            this.addViewInLayout(view, bl ? -1 : 0, layoutParams, true);
        }
        if (bl5) {
            view.setSelected(bl4);
        }
        if (bl7) {
            view.setPressed(bl6);
        }
        if (this.mChoiceMode != ChoiceMode.NONE && this.mCheckStates != null) {
            if (view instanceof Checkable) {
                ((Checkable)view).setChecked(this.mCheckStates.get(n));
            } else if (Build.VERSION.SDK_INT >= 11) {
                view.setActivated(this.mCheckStates.get(n));
            }
        }
        if (bl8) {
            this.measureChild(view, layoutParams);
        } else {
            this.cleanupLayoutState(view);
        }
        int n6 = view.getMeasuredWidth();
        int n7 = view.getMeasuredHeight();
        int n8 = this.mIsVertical && !bl ? n2 - n7 : n2;
        int n9 = n4 = !this.mIsVertical && !bl ? n3 - n6 : n3;
        if (bl8) {
            int n10 = n4 + n6;
            int n11 = n8 + n7;
            view.layout(n4, n8, n10, n11);
        } else {
            view.offsetLeftAndRight(n4 - view.getLeft());
            view.offsetTopAndBottom(n8 - view.getTop());
        }
    }

    void fillGap(boolean bl) {
        int n = this.getChildCount();
        if (bl) {
            int n2 = this.mIsVertical ? this.getPaddingTop() : this.getPaddingLeft();
            int n3 = this.getChildEndEdge(this.getChildAt(n - 1));
            int n4 = n > 0 ? n3 + this.mItemMargin : n2;
            this.fillAfter(this.mFirstPosition + n, n4);
            this.correctTooHigh(this.getChildCount());
        } else {
            int n5 = this.getEndEdge();
            int n6 = this.mIsVertical ? this.getChildAt(0).getTop() : this.getChildAt(0).getLeft();
            int n7 = n > 0 ? n6 - this.mItemMargin : n5;
            this.fillBefore(this.mFirstPosition - 1, n7);
            this.correctTooLow(this.getChildCount());
        }
    }

    private View fillBefore(int n, int n2) {
        View view = null;
        int n3 = this.getStartEdge();
        while (n2 > n3 && n >= 0) {
            boolean bl = n == this.mSelectedPosition;
            View view2 = this.makeAndAddView(n, n2, false, bl);
            n2 = this.mIsVertical ? view2.getTop() - this.mItemMargin : view2.getLeft() - this.mItemMargin;
            if (bl) {
                view = view2;
            }
            --n;
        }
        this.mFirstPosition = n + 1;
        return view;
    }

    private View fillAfter(int n, int n2) {
        View view = null;
        int n3 = this.getEndEdge();
        while (n2 < n3 && n < this.mItemCount) {
            boolean bl = n == this.mSelectedPosition;
            View view2 = this.makeAndAddView(n, n2, true, bl);
            n2 = this.getChildEndEdge(view2) + this.mItemMargin;
            if (bl) {
                view = view2;
            }
            ++n;
        }
        return view;
    }

    private View fillSpecific(int n, int n2) {
        boolean bl = n == this.mSelectedPosition;
        View view = this.makeAndAddView(n, n2, true, bl);
        this.mFirstPosition = n;
        int n3 = this.getChildStartEdge(view) + this.mItemMargin;
        View view2 = this.fillBefore(n - 1, n3);
        this.adjustViewsStartOrEnd();
        int n4 = this.getChildEndEdge(view) + this.mItemMargin;
        View view3 = this.fillAfter(n + 1, n4);
        int n5 = this.getChildCount();
        if (n5 > 0) {
            this.correctTooHigh(n5);
        }
        if (bl) {
            return view;
        }
        if (view2 != null) {
            return view2;
        }
        return view3;
    }

    private View fillFromOffset(int n) {
        this.mFirstPosition = Math.min(this.mFirstPosition, this.mSelectedPosition);
        this.mFirstPosition = Math.min(this.mFirstPosition, this.mItemCount - 1);
        if (this.mFirstPosition < 0) {
            this.mFirstPosition = 0;
        }
        return this.fillAfter(this.mFirstPosition, n);
    }

    private View fillFromMiddle(int n, int n2) {
        int n3 = n2 - n;
        int n4 = this.reconcileSelectedPosition();
        View view = this.makeAndAddView(n4, n, true, true);
        this.mFirstPosition = n4;
        if (this.mIsVertical) {
            int n5 = view.getMeasuredHeight();
            if (n5 <= n3) {
                view.offsetTopAndBottom((n3 - n5) / 2);
            }
        } else {
            int n6 = view.getMeasuredWidth();
            if (n6 <= n3) {
                view.offsetLeftAndRight((n3 - n6) / 2);
            }
        }
        this.fillBeforeAndAfter(view, n4);
        this.correctTooHigh(this.getChildCount());
        return view;
    }

    private void fillBeforeAndAfter(View view, int n) {
        int n2 = this.getChildStartEdge(view) + this.mItemMargin;
        this.fillBefore(n - 1, n2);
        this.adjustViewsStartOrEnd();
        int n3 = this.getChildEndEdge(view) + this.mItemMargin;
        this.fillAfter(n + 1, n3);
    }

    private View fillFromSelection(int n, int n2, int n3) {
        int n4 = this.mSelectedPosition;
        View view = this.makeAndAddView(n4, n, true, true);
        int n5 = this.getChildStartEdge(view);
        int n6 = this.getChildEndEdge(view);
        if (n6 > n3) {
            int n7 = n5 - n2;
            int n8 = n6 - n3;
            int n9 = Math.min(n7, n8);
            view.offsetTopAndBottom(-n9);
        } else if (n5 < n2) {
            int n10 = n2 - n5;
            int n11 = n3 - n6;
            int n12 = Math.min(n10, n11);
            view.offsetTopAndBottom(n12);
        }
        this.fillBeforeAndAfter(view, n4);
        this.correctTooHigh(this.getChildCount());
        return view;
    }

    private void correctTooHigh(int n) {
        int n2 = this.mFirstPosition + n - 1;
        if (n2 != this.mItemCount - 1 || n == 0) {
            return;
        }
        int n3 = this.getChildEndEdge(this.getChildAt(n - 1));
        int n4 = this.getStartEdge();
        int n5 = this.getEndEdge();
        int n6 = n5 - n3;
        View view = this.getChildAt(0);
        int n7 = this.getChildStartEdge(view);
        if (n6 > 0 && (this.mFirstPosition > 0 || n7 < n4)) {
            if (this.mFirstPosition == 0) {
                n6 = Math.min(n6, n4 - n7);
            }
            this.offsetChildren(n6);
            if (this.mFirstPosition > 0) {
                n7 = this.getChildStartEdge(view);
                this.fillBefore(this.mFirstPosition - 1, n7 - this.mItemMargin);
                this.adjustViewsStartOrEnd();
            }
        }
    }

    private void correctTooLow(int n) {
        if (this.mFirstPosition != 0 || n == 0) {
            return;
        }
        View view = this.getChildAt(0);
        int n2 = this.mIsVertical ? view.getTop() : view.getLeft();
        int n3 = this.getStartEdge();
        int n4 = this.getEndEdge();
        int n5 = n2 - n3;
        View view2 = this.getChildAt(n - 1);
        int n6 = this.getChildEndEdge(view2);
        int n7 = this.mFirstPosition + n - 1;
        if (n5 > 0) {
            if (n7 < this.mItemCount - 1 || n6 > n4) {
                if (n7 == this.mItemCount - 1) {
                    n5 = Math.min(n5, n6 - n4);
                }
                this.offsetChildren(-n5);
                if (n7 < this.mItemCount - 1) {
                    n6 = this.getChildEndEdge(view2);
                    this.fillAfter(n7 + 1, n6 + this.mItemMargin);
                    this.adjustViewsStartOrEnd();
                }
            } else if (n7 == this.mItemCount - 1) {
                this.adjustViewsStartOrEnd();
            }
        }
    }

    private void adjustViewsStartOrEnd() {
        if (this.getChildCount() == 0) {
            return;
        }
        View view = this.getChildAt(0);
        int n = this.mIsVertical ? view.getTop() - this.getPaddingTop() - this.mItemMargin : view.getLeft() - this.getPaddingLeft() - this.mItemMargin;
        if (n < 0) {
            n = 0;
        }
        if (n != 0) {
            this.offsetChildren(-n);
        }
    }

    @TargetApi(value=14)
    private SparseBooleanArray cloneCheckStates() {
        SparseBooleanArray sparseBooleanArray;
        if (this.mCheckStates == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 14) {
            sparseBooleanArray = this.mCheckStates.clone();
        } else {
            sparseBooleanArray = new SparseBooleanArray();
            for (int i = 0; i < this.mCheckStates.size(); ++i) {
                sparseBooleanArray.put(this.mCheckStates.keyAt(i), this.mCheckStates.valueAt(i));
            }
        }
        return sparseBooleanArray;
    }

    private int findSyncPosition() {
        int n = this.mItemCount;
        if (n == 0) {
            return -1;
        }
        long l = this.mSyncRowId;
        if (l == Long.MIN_VALUE) {
            return -1;
        }
        int n2 = this.mSyncPosition;
        n2 = Math.max(0, n2);
        n2 = Math.min(n - 1, n2);
        long l2 = SystemClock.uptimeMillis() + 100L;
        int n3 = n2;
        int n4 = n2;
        boolean bl = false;
        ListAdapter listAdapter = this.mAdapter;
        if (listAdapter == null) {
            return -1;
        }
        while (SystemClock.uptimeMillis() <= l2) {
            boolean bl2;
            long l3 = listAdapter.getItemId(n2);
            if (l3 == l) {
                return n2;
            }
            boolean bl3 = n4 == n - 1;
            boolean bl4 = bl2 = n3 == 0;
            if (bl3 && bl2) break;
            if (bl2 || bl && !bl3) {
                n2 = ++n4;
                bl = false;
                continue;
            }
            if (!bl3 && (bl || bl2)) continue;
            n2 = --n3;
            bl = true;
        }
        return -1;
    }

    @TargetApi(value=16)
    private View obtainView(int n, boolean[] blArray) {
        View view;
        blArray[0] = false;
        View view2 = this.mRecycler.getTransientStateView(n);
        if (view2 != null) {
            return view2;
        }
        view2 = this.mRecycler.getScrapView(n);
        if (view2 != null) {
            view = this.mAdapter.getView(n, view2, (ViewGroup)this);
            if (view != view2) {
                this.mRecycler.addScrapView(view2, n);
            } else {
                blArray[0] = true;
            }
        } else {
            view = this.mAdapter.getView(n, null, (ViewGroup)this);
        }
        if (ViewCompat.getImportantForAccessibility((View)view) == 0) {
            ViewCompat.setImportantForAccessibility((View)view, (int)1);
        }
        if (this.mHasStableIds) {
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (layoutParams == null) {
                layoutParams = this.generateDefaultLayoutParams();
            } else if (!this.checkLayoutParams(layoutParams)) {
                layoutParams = this.generateLayoutParams(layoutParams);
            }
            layoutParams.id = this.mAdapter.getItemId(n);
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        if (this.mAccessibilityDelegate == null) {
            this.mAccessibilityDelegate = new ListItemAccessibilityDelegate();
        }
        ViewCompat.setAccessibilityDelegate((View)view, (AccessibilityDelegateCompat)this.mAccessibilityDelegate);
        return view;
    }

    void resetState() {
        this.mScroller.forceFinished(true);
        this.removeAllViewsInLayout();
        this.mSelectedStart = 0;
        this.mFirstPosition = 0;
        this.mDataChanged = false;
        this.mNeedSync = false;
        this.mPendingSync = null;
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        this.mOverScroll = 0;
        this.setSelectedPositionInt(-1);
        this.setNextSelectedPositionInt(-1);
        this.mSelectorPosition = -1;
        this.mSelectorRect.setEmpty();
        this.invalidate();
    }

    private void rememberSyncState() {
        if (this.getChildCount() == 0) {
            return;
        }
        this.mNeedSync = true;
        if (this.mSelectedPosition >= 0) {
            View view = this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
            this.mSyncRowId = this.mNextSelectedRowId;
            this.mSyncPosition = this.mNextSelectedPosition;
            if (view != null) {
                this.mSpecificStart = this.mIsVertical ? view.getTop() : view.getLeft();
            }
            this.mSyncMode = 0;
        } else {
            View view = this.getChildAt(0);
            ListAdapter listAdapter = this.getAdapter();
            this.mSyncRowId = this.mFirstPosition >= 0 && this.mFirstPosition < listAdapter.getCount() ? listAdapter.getItemId(this.mFirstPosition) : -1L;
            this.mSyncPosition = this.mFirstPosition;
            if (view != null) {
                this.mSpecificStart = this.mIsVertical ? view.getTop() : view.getLeft();
            }
            this.mSyncMode = 1;
        }
    }

    private ContextMenu.ContextMenuInfo createContextMenuInfo(View view, int n, long l) {
        return new AdapterView.AdapterContextMenuInfo(view, n, l);
    }

    @TargetApi(value=11)
    private void updateOnScreenCheckedViews() {
        int n = this.mFirstPosition;
        int n2 = this.getChildCount();
        for (int i = 0; i < n2; ++i) {
            View view = this.getChildAt(i);
            int n3 = n + i;
            if (view instanceof Checkable) {
                ((Checkable)view).setChecked(this.mCheckStates.get(n3));
                continue;
            }
            if (Build.VERSION.SDK_INT < 11) continue;
            view.setActivated(this.mCheckStates.get(n3));
        }
    }

    public boolean performItemClick(View view, int n, long l) {
        boolean bl = false;
        if (this.mChoiceMode == ChoiceMode.MULTIPLE) {
            boolean bl2 = !this.mCheckStates.get(n, false);
            this.mCheckStates.put(n, bl2);
            if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                if (bl2) {
                    this.mCheckedIdStates.put(this.mAdapter.getItemId(n), (Object)n);
                } else {
                    this.mCheckedIdStates.delete(this.mAdapter.getItemId(n));
                }
            }
            this.mCheckedItemCount = bl2 ? ++this.mCheckedItemCount : --this.mCheckedItemCount;
            bl = true;
        } else if (this.mChoiceMode == ChoiceMode.SINGLE) {
            boolean bl3;
            boolean bl4 = bl3 = !this.mCheckStates.get(n, false);
            if (bl3) {
                this.mCheckStates.clear();
                this.mCheckStates.put(n, true);
                if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                    this.mCheckedIdStates.clear();
                    this.mCheckedIdStates.put(this.mAdapter.getItemId(n), (Object)n);
                }
                this.mCheckedItemCount = 1;
            } else if (this.mCheckStates.size() == 0 || !this.mCheckStates.valueAt(0)) {
                this.mCheckedItemCount = 0;
            }
            bl = true;
        }
        if (bl) {
            this.updateOnScreenCheckedViews();
        }
        return super.performItemClick(view, n, l);
    }

    private boolean performLongPress(View view, int n, long l) {
        boolean bl = false;
        AdapterView.OnItemLongClickListener onItemLongClickListener = this.getOnItemLongClickListener();
        if (onItemLongClickListener != null) {
            bl = onItemLongClickListener.onItemLongClick((AdapterView)this, view, n, l);
        }
        if (!bl) {
            this.mContextMenuInfo = this.createContextMenuInfo(view, n, l);
            bl = super.showContextMenuForChild((View)this);
        }
        if (bl) {
            this.performHapticFeedback(0);
        }
        return bl;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        if (this.mIsVertical) {
            return new LayoutParams(-1, -2);
        }
        return new LayoutParams(-2, -1);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected ContextMenu.ContextMenuInfo getContextMenuInfo() {
        return this.mContextMenuInfo;
    }

    public Parcelable onSaveInstanceState() {
        int n;
        View view;
        long l;
        Parcelable parcelable = super.onSaveInstanceState();
        SavedState savedState = new SavedState(parcelable);
        if (this.mPendingSync != null) {
            savedState.selectedId = this.mPendingSync.selectedId;
            savedState.firstId = this.mPendingSync.firstId;
            savedState.viewStart = this.mPendingSync.viewStart;
            savedState.position = this.mPendingSync.position;
            savedState.height = this.mPendingSync.height;
            return savedState;
        }
        boolean bl = this.getChildCount() > 0 && this.mItemCount > 0;
        savedState.selectedId = l = this.getSelectedItemId();
        savedState.height = this.getHeight();
        if (l >= 0L) {
            savedState.viewStart = this.mSelectedStart;
            savedState.position = this.getSelectedItemPosition();
            savedState.firstId = -1L;
        } else if (bl && this.mFirstPosition > 0) {
            view = this.getChildAt(0);
            savedState.viewStart = this.mIsVertical ? view.getTop() : view.getLeft();
            n = this.mFirstPosition;
            if (n >= this.mItemCount) {
                n = this.mItemCount - 1;
            }
            savedState.position = n;
            savedState.firstId = this.mAdapter.getItemId(n);
        } else {
            savedState.viewStart = 0;
            savedState.firstId = -1L;
            savedState.position = 0;
        }
        if (this.mCheckStates != null) {
            savedState.checkState = this.cloneCheckStates();
        }
        if (this.mCheckedIdStates != null) {
            view = new LongSparseArray();
            n = this.mCheckedIdStates.size();
            for (int i = 0; i < n; ++i) {
                view.put(this.mCheckedIdStates.keyAt(i), this.mCheckedIdStates.valueAt(i));
            }
            savedState.checkIdState = view;
        }
        savedState.checkedItemCount = this.mCheckedItemCount;
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mDataChanged = true;
        this.mSyncHeight = savedState.height;
        if (savedState.selectedId >= 0L) {
            this.mNeedSync = true;
            this.mPendingSync = savedState;
            this.mSyncRowId = savedState.selectedId;
            this.mSyncPosition = savedState.position;
            this.mSpecificStart = savedState.viewStart;
            this.mSyncMode = 0;
        } else if (savedState.firstId >= 0L) {
            this.setSelectedPositionInt(-1);
            this.setNextSelectedPositionInt(-1);
            this.mSelectorPosition = -1;
            this.mNeedSync = true;
            this.mPendingSync = savedState;
            this.mSyncRowId = savedState.firstId;
            this.mSyncPosition = savedState.position;
            this.mSpecificStart = savedState.viewStart;
            this.mSyncMode = 1;
        }
        if (savedState.checkState != null) {
            this.mCheckStates = savedState.checkState;
        }
        if (savedState.checkIdState != null) {
            this.mCheckedIdStates = savedState.checkIdState;
        }
        this.mCheckedItemCount = savedState.checkedItemCount;
        this.requestLayout();
    }

    public void setEmptyView(View view) {
        super.setEmptyView(view);
        this.mEmptyView = view;
        this.updateEmptyStatus();
    }

    public void setFocusable(boolean bl) {
        ListAdapter listAdapter = this.getAdapter();
        boolean bl2 = listAdapter == null || listAdapter.getCount() == 0;
        this.mDesiredFocusableState = bl;
        if (!bl) {
            this.mDesiredFocusableInTouchModeState = false;
        }
        super.setFocusable(bl && !bl2);
    }

    public void setFocusableInTouchMode(boolean bl) {
        ListAdapter listAdapter = this.getAdapter();
        boolean bl2 = listAdapter == null || listAdapter.getCount() == 0;
        this.mDesiredFocusableInTouchModeState = bl;
        if (bl) {
            this.mDesiredFocusableState = true;
        }
        super.setFocusableInTouchMode(bl && !bl2);
    }

    private void checkFocus() {
        ListAdapter listAdapter = this.getAdapter();
        boolean bl = listAdapter != null && listAdapter.getCount() > 0;
        super.setFocusableInTouchMode(bl && this.mDesiredFocusableInTouchModeState);
        super.setFocusable(bl && this.mDesiredFocusableState);
        if (this.mEmptyView != null) {
            this.updateEmptyStatus();
        }
    }

    private void updateEmptyStatus() {
        boolean bl;
        boolean bl2 = bl = this.mAdapter == null || this.mAdapter.isEmpty();
        if (bl) {
            if (this.mEmptyView != null) {
                this.mEmptyView.setVisibility(0);
                this.setVisibility(8);
            } else {
                this.setVisibility(0);
            }
            if (this.mDataChanged) {
                this.layout(this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
            }
        } else {
            if (this.mEmptyView != null) {
                this.mEmptyView.setVisibility(8);
            }
            this.setVisibility(0);
        }
    }

    private class ListItemAccessibilityDelegate
    extends AccessibilityDelegateCompat {
        private ListItemAccessibilityDelegate() {
        }

        public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
            super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
            int n = TwoWayView.this.getPositionForView(view);
            ListAdapter listAdapter = TwoWayView.this.getAdapter();
            if (n == -1 || listAdapter == null) {
                return;
            }
            if (!TwoWayView.this.isEnabled() || !listAdapter.isEnabled(n)) {
                return;
            }
            if (n == TwoWayView.this.getSelectedItemPosition()) {
                accessibilityNodeInfoCompat.setSelected(true);
                accessibilityNodeInfoCompat.addAction(8);
            } else {
                accessibilityNodeInfoCompat.addAction(4);
            }
            if (TwoWayView.this.isClickable()) {
                accessibilityNodeInfoCompat.addAction(16);
                accessibilityNodeInfoCompat.setClickable(true);
            }
            if (TwoWayView.this.isLongClickable()) {
                accessibilityNodeInfoCompat.addAction(32);
                accessibilityNodeInfoCompat.setLongClickable(true);
            }
        }

        public boolean performAccessibilityAction(View view, int n, Bundle bundle) {
            if (super.performAccessibilityAction(view, n, bundle)) {
                return true;
            }
            int n2 = TwoWayView.this.getPositionForView(view);
            ListAdapter listAdapter = TwoWayView.this.getAdapter();
            if (n2 == -1 || listAdapter == null) {
                return false;
            }
            if (!TwoWayView.this.isEnabled() || !listAdapter.isEnabled(n2)) {
                return false;
            }
            long l = TwoWayView.this.getItemIdAtPosition(n2);
            switch (n) {
                case 8: {
                    if (TwoWayView.this.getSelectedItemPosition() == n2) {
                        TwoWayView.this.setSelection(-1);
                        return true;
                    }
                    return false;
                }
                case 4: {
                    if (TwoWayView.this.getSelectedItemPosition() != n2) {
                        TwoWayView.this.setSelection(n2);
                        return true;
                    }
                    return false;
                }
                case 16: {
                    return TwoWayView.this.isClickable() && TwoWayView.this.performItemClick(view, n2, l);
                }
                case 32: {
                    return TwoWayView.this.isLongClickable() && TwoWayView.this.performLongPress(view, n2, l);
                }
            }
            return false;
        }
    }

    private static class ArrowScrollFocusResult {
        private int mSelectedPosition;
        private int mAmountToScroll;

        private ArrowScrollFocusResult() {
        }

        void populate(int n, int n2) {
            this.mSelectedPosition = n;
            this.mAmountToScroll = n2;
        }

        public int getSelectedPosition() {
            return this.mSelectedPosition;
        }

        public int getAmountToScroll() {
            return this.mAmountToScroll;
        }
    }

    private class CheckForKeyLongPress
    extends WindowRunnnable
    implements Runnable {
        private CheckForKeyLongPress() {
        }

        public void run() {
            if (!TwoWayView.this.isPressed() || TwoWayView.this.mSelectedPosition < 0) {
                return;
            }
            int n = TwoWayView.this.mSelectedPosition - TwoWayView.this.mFirstPosition;
            View view = TwoWayView.this.getChildAt(n);
            if (!TwoWayView.this.mDataChanged) {
                boolean bl = false;
                if (this.sameWindow()) {
                    bl = TwoWayView.this.performLongPress(view, TwoWayView.this.mSelectedPosition, TwoWayView.this.mSelectedRowId);
                }
                if (bl) {
                    TwoWayView.this.setPressed(false);
                    view.setPressed(false);
                }
            } else {
                TwoWayView.this.setPressed(false);
                if (view != null) {
                    view.setPressed(false);
                }
            }
        }
    }

    private class CheckForLongPress
    extends WindowRunnnable
    implements Runnable {
        private CheckForLongPress() {
        }

        public void run() {
            int n = TwoWayView.this.mMotionPosition;
            View view = TwoWayView.this.getChildAt(n - TwoWayView.this.mFirstPosition);
            if (view != null) {
                long l = TwoWayView.this.mAdapter.getItemId(TwoWayView.this.mMotionPosition);
                boolean bl = false;
                if (this.sameWindow() && !TwoWayView.this.mDataChanged) {
                    bl = TwoWayView.this.performLongPress(view, n, l);
                }
                if (bl) {
                    TwoWayView.this.mTouchMode = -1;
                    TwoWayView.this.setPressed(false);
                    view.setPressed(false);
                } else {
                    TwoWayView.this.mTouchMode = 2;
                }
            }
        }
    }

    private final class CheckForTap
    implements Runnable {
        private CheckForTap() {
        }

        public void run() {
            if (TwoWayView.this.mTouchMode != 0) {
                return;
            }
            TwoWayView.this.mTouchMode = 1;
            View view = TwoWayView.this.getChildAt(TwoWayView.this.mMotionPosition - TwoWayView.this.mFirstPosition);
            if (view != null && !view.hasFocusable()) {
                TwoWayView.this.mLayoutMode = 0;
                if (!TwoWayView.this.mDataChanged) {
                    Drawable drawable2;
                    TwoWayView.this.setPressed(true);
                    view.setPressed(true);
                    TwoWayView.this.layoutChildren();
                    TwoWayView.this.positionSelector(TwoWayView.this.mMotionPosition, view);
                    TwoWayView.this.refreshDrawableState();
                    TwoWayView.this.positionSelector(TwoWayView.this.mMotionPosition, view);
                    TwoWayView.this.refreshDrawableState();
                    boolean bl = TwoWayView.this.isLongClickable();
                    if (TwoWayView.this.mSelector != null && (drawable2 = TwoWayView.this.mSelector.getCurrent()) != null && drawable2 instanceof TransitionDrawable) {
                        if (bl) {
                            int n = ViewConfiguration.getLongPressTimeout();
                            ((TransitionDrawable)drawable2).startTransition(n);
                        } else {
                            ((TransitionDrawable)drawable2).resetTransition();
                        }
                    }
                    if (bl) {
                        TwoWayView.this.triggerCheckForLongPress();
                    } else {
                        TwoWayView.this.mTouchMode = 2;
                    }
                } else {
                    TwoWayView.this.mTouchMode = 2;
                }
            }
        }
    }

    private class PerformClick
    extends WindowRunnnable
    implements Runnable {
        int mClickMotionPosition;

        private PerformClick() {
        }

        public void run() {
            View view;
            if (TwoWayView.this.mDataChanged) {
                return;
            }
            ListAdapter listAdapter = TwoWayView.this.mAdapter;
            int n = this.mClickMotionPosition;
            if (listAdapter != null && TwoWayView.this.mItemCount > 0 && n != -1 && n < listAdapter.getCount() && this.sameWindow() && (view = TwoWayView.this.getChildAt(n - TwoWayView.this.mFirstPosition)) != null) {
                TwoWayView.this.performItemClick(view, n, listAdapter.getItemId(n));
            }
        }
    }

    private class WindowRunnnable {
        private int mOriginalAttachCount;

        private WindowRunnnable() {
        }

        public void rememberWindowAttachCount() {
            this.mOriginalAttachCount = TwoWayView.this.getWindowAttachCount();
        }

        public boolean sameWindow() {
            return TwoWayView.this.hasWindowFocus() && TwoWayView.this.getWindowAttachCount() == this.mOriginalAttachCount;
        }
    }

    private class SelectionNotifier
    implements Runnable {
        private SelectionNotifier() {
        }

        public void run() {
            if (TwoWayView.this.mDataChanged) {
                if (TwoWayView.this.mAdapter != null) {
                    TwoWayView.this.post(this);
                }
            } else {
                TwoWayView.this.fireOnSelected();
                TwoWayView.this.performAccessibilityActionsOnSelected();
            }
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        long selectedId;
        long firstId;
        int viewStart;
        int position;
        int height;
        int checkedItemCount;
        SparseBooleanArray checkState;
        LongSparseArray<Integer> checkIdState;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };

        SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        private SavedState(Parcel parcel) {
            super(parcel);
            this.selectedId = parcel.readLong();
            this.firstId = parcel.readLong();
            this.viewStart = parcel.readInt();
            this.position = parcel.readInt();
            this.height = parcel.readInt();
            this.checkedItemCount = parcel.readInt();
            this.checkState = parcel.readSparseBooleanArray();
            int n = parcel.readInt();
            if (n > 0) {
                this.checkIdState = new LongSparseArray();
                for (int i = 0; i < n; ++i) {
                    long l = parcel.readLong();
                    int n2 = parcel.readInt();
                    this.checkIdState.put(l, (Object)n2);
                }
            }
        }

        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeLong(this.selectedId);
            parcel.writeLong(this.firstId);
            parcel.writeInt(this.viewStart);
            parcel.writeInt(this.position);
            parcel.writeInt(this.height);
            parcel.writeInt(this.checkedItemCount);
            parcel.writeSparseBooleanArray(this.checkState);
            int n2 = this.checkIdState != null ? this.checkIdState.size() : 0;
            parcel.writeInt(n2);
            for (int i = 0; i < n2; ++i) {
                parcel.writeLong(this.checkIdState.keyAt(i));
                parcel.writeInt(((Integer)this.checkIdState.valueAt(i)).intValue());
            }
        }

        public String toString() {
            return "TwoWayView.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " selectedId=" + this.selectedId + " firstId=" + this.firstId + " viewStart=" + this.viewStart + " height=" + this.height + " position=" + this.position + " checkState=" + this.checkState + "}";
        }
    }

    private class AdapterDataSetObserver
    extends DataSetObserver {
        private Parcelable mInstanceState = null;

        private AdapterDataSetObserver() {
        }

        public void onChanged() {
            TwoWayView.this.mDataChanged = true;
            TwoWayView.this.mOldItemCount = TwoWayView.this.mItemCount;
            TwoWayView.this.mItemCount = TwoWayView.this.getAdapter().getCount();
            if (TwoWayView.this.mHasStableIds && this.mInstanceState != null && TwoWayView.this.mOldItemCount == 0 && TwoWayView.this.mItemCount > 0) {
                TwoWayView.this.onRestoreInstanceState(this.mInstanceState);
                this.mInstanceState = null;
            } else {
                TwoWayView.this.rememberSyncState();
            }
            TwoWayView.this.checkFocus();
            TwoWayView.this.requestLayout();
        }

        public void onInvalidated() {
            TwoWayView.this.mDataChanged = true;
            if (TwoWayView.this.mHasStableIds) {
                this.mInstanceState = TwoWayView.this.onSaveInstanceState();
            }
            TwoWayView.this.mOldItemCount = TwoWayView.this.mItemCount;
            TwoWayView.this.mItemCount = 0;
            TwoWayView.this.mSelectedPosition = -1;
            TwoWayView.this.mSelectedRowId = Long.MIN_VALUE;
            TwoWayView.this.mNextSelectedPosition = -1;
            TwoWayView.this.mNextSelectedRowId = Long.MIN_VALUE;
            TwoWayView.this.mNeedSync = false;
            TwoWayView.this.checkFocus();
            TwoWayView.this.requestLayout();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RecycleBin {
        private RecyclerListener mRecyclerListener;
        private int mFirstActivePosition;
        private View[] mActiveViews = new View[0];
        private ArrayList<View>[] mScrapViews;
        private int mViewTypeCount;
        private ArrayList<View> mCurrentScrap;
        private SparseArrayCompat<View> mTransientStateViews;

        RecycleBin() {
        }

        public void setViewTypeCount(int n) {
            if (n < 1) {
                throw new IllegalArgumentException("Can't have a viewTypeCount < 1");
            }
            ArrayList[] arrayListArray = new ArrayList[n];
            for (int i = 0; i < n; ++i) {
                arrayListArray[i] = new ArrayList();
            }
            this.mViewTypeCount = n;
            this.mCurrentScrap = arrayListArray[0];
            this.mScrapViews = arrayListArray;
        }

        public void markChildrenDirty() {
            int n;
            if (this.mViewTypeCount == 1) {
                ArrayList<View> arrayList = this.mCurrentScrap;
                n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    arrayList.get(i).forceLayout();
                }
            } else {
                int n2 = this.mViewTypeCount;
                for (n = 0; n < n2; ++n) {
                    for (View view : this.mScrapViews[n]) {
                        view.forceLayout();
                    }
                }
            }
            if (this.mTransientStateViews != null) {
                int n3 = this.mTransientStateViews.size();
                for (n = 0; n < n3; ++n) {
                    ((View)this.mTransientStateViews.valueAt(n)).forceLayout();
                }
            }
        }

        public boolean shouldRecycleViewType(int n) {
            return n >= 0;
        }

        void clear() {
            if (this.mViewTypeCount == 1) {
                ArrayList<View> arrayList = this.mCurrentScrap;
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    TwoWayView.this.removeDetachedView(arrayList.remove(n - 1 - i), false);
                }
            } else {
                int n = this.mViewTypeCount;
                for (int i = 0; i < n; ++i) {
                    ArrayList<View> arrayList = this.mScrapViews[i];
                    int n2 = arrayList.size();
                    for (int j = 0; j < n2; ++j) {
                        TwoWayView.this.removeDetachedView(arrayList.remove(n2 - 1 - j), false);
                    }
                }
            }
            if (this.mTransientStateViews != null) {
                this.mTransientStateViews.clear();
            }
        }

        void fillActiveViews(int n, int n2) {
            if (this.mActiveViews.length < n) {
                this.mActiveViews = new View[n];
            }
            this.mFirstActivePosition = n2;
            View[] viewArray = this.mActiveViews;
            for (int i = 0; i < n; ++i) {
                View view;
                viewArray[i] = view = TwoWayView.this.getChildAt(i);
            }
        }

        View getActiveView(int n) {
            int n2 = n - this.mFirstActivePosition;
            View[] viewArray = this.mActiveViews;
            if (n2 >= 0 && n2 < viewArray.length) {
                View view = viewArray[n2];
                viewArray[n2] = null;
                return view;
            }
            return null;
        }

        View getTransientStateView(int n) {
            if (this.mTransientStateViews == null) {
                return null;
            }
            int n2 = this.mTransientStateViews.indexOfKey(n);
            if (n2 < 0) {
                return null;
            }
            View view = (View)this.mTransientStateViews.valueAt(n2);
            this.mTransientStateViews.removeAt(n2);
            return view;
        }

        void clearTransientStateViews() {
            if (this.mTransientStateViews != null) {
                this.mTransientStateViews.clear();
            }
        }

        View getScrapView(int n) {
            if (this.mViewTypeCount == 1) {
                return this.retrieveFromScrap(this.mCurrentScrap, n);
            }
            int n2 = TwoWayView.this.mAdapter.getItemViewType(n);
            if (n2 >= 0 && n2 < this.mScrapViews.length) {
                return this.retrieveFromScrap(this.mScrapViews[n2], n);
            }
            return null;
        }

        @TargetApi(value=14)
        void addScrapView(View view, int n) {
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (layoutParams == null) {
                return;
            }
            layoutParams.scrappedFromPosition = n;
            int n2 = layoutParams.viewType;
            boolean bl = ViewCompat.hasTransientState((View)view);
            if (!this.shouldRecycleViewType(n2) || bl) {
                if (bl) {
                    if (this.mTransientStateViews == null) {
                        this.mTransientStateViews = new SparseArrayCompat();
                    }
                    this.mTransientStateViews.put(n, (Object)view);
                }
                return;
            }
            if (this.mViewTypeCount == 1) {
                this.mCurrentScrap.add(view);
            } else {
                this.mScrapViews[n2].add(view);
            }
            if (Build.VERSION.SDK_INT >= 14) {
                view.setAccessibilityDelegate(null);
            }
            if (this.mRecyclerListener != null) {
                this.mRecyclerListener.onMovedToScrapHeap(view);
            }
        }

        @TargetApi(value=14)
        void scrapActiveViews() {
            View[] viewArray = this.mActiveViews;
            boolean bl = this.mViewTypeCount > 1;
            ArrayList<View> arrayList = this.mCurrentScrap;
            int n = viewArray.length;
            for (int i = n - 1; i >= 0; --i) {
                View view = viewArray[i];
                if (view == null) continue;
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                int n2 = layoutParams.viewType;
                viewArray[i] = null;
                boolean bl2 = ViewCompat.hasTransientState((View)view);
                if (!this.shouldRecycleViewType(n2) || bl2) {
                    if (!bl2) continue;
                    TwoWayView.this.removeDetachedView(view, false);
                    if (this.mTransientStateViews == null) {
                        this.mTransientStateViews = new SparseArrayCompat();
                    }
                    this.mTransientStateViews.put(this.mFirstActivePosition + i, (Object)view);
                    continue;
                }
                if (bl) {
                    arrayList = this.mScrapViews[n2];
                }
                layoutParams.scrappedFromPosition = this.mFirstActivePosition + i;
                arrayList.add(view);
                if (Build.VERSION.SDK_INT >= 14) {
                    view.setAccessibilityDelegate(null);
                }
                if (this.mRecyclerListener == null) continue;
                this.mRecyclerListener.onMovedToScrapHeap(view);
            }
            this.pruneScrapViews();
        }

        private void pruneScrapViews() {
            View view;
            int n;
            int n2 = this.mActiveViews.length;
            int n3 = this.mViewTypeCount;
            ArrayList<View>[] arrayListArray = this.mScrapViews;
            for (n = 0; n < n3; ++n) {
                view = arrayListArray[n];
                int n4 = view.size();
                int n5 = n4 - n2;
                --n4;
                for (int i = 0; i < n5; ++i) {
                    TwoWayView.this.removeDetachedView((View)view.remove(n4--), false);
                }
            }
            if (this.mTransientStateViews != null) {
                for (n = 0; n < this.mTransientStateViews.size(); ++n) {
                    view = (View)this.mTransientStateViews.valueAt(n);
                    if (ViewCompat.hasTransientState((View)view)) continue;
                    this.mTransientStateViews.removeAt(n);
                    --n;
                }
            }
        }

        void reclaimScrapViews(List<View> list) {
            if (this.mViewTypeCount == 1) {
                list.addAll(this.mCurrentScrap);
            } else {
                int n = this.mViewTypeCount;
                ArrayList<View>[] arrayListArray = this.mScrapViews;
                for (int i = 0; i < n; ++i) {
                    ArrayList<View> arrayList = arrayListArray[i];
                    list.addAll(arrayList);
                }
            }
        }

        View retrieveFromScrap(ArrayList<View> arrayList, int n) {
            int n2 = arrayList.size();
            if (n2 <= 0) {
                return null;
            }
            for (int i = 0; i < n2; ++i) {
                View view = arrayList.get(i);
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                if (layoutParams.scrappedFromPosition != n) continue;
                arrayList.remove(i);
                return view;
            }
            return arrayList.remove(n2 - 1);
        }
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        int viewType;
        long id = -1L;
        int scrappedFromPosition;
        boolean forceAdd;

        public LayoutParams(int n, int n2) {
            super(n, n2);
            if (this.width == -1) {
                Log.w((String)TwoWayView.LOGTAG, (String)"Constructing LayoutParams with width FILL_PARENT does not make much sense as the view might change orientation. Falling back to WRAP_CONTENT");
                this.width = -2;
            }
            if (this.height == -1) {
                Log.w((String)TwoWayView.LOGTAG, (String)"Constructing LayoutParams with height FILL_PARENT does not make much sense as the view might change orientation. Falling back to WRAP_CONTENT");
                this.height = -2;
            }
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            if (this.width == -1) {
                Log.w((String)TwoWayView.LOGTAG, (String)"Inflation setting LayoutParams width to MATCH_PARENT - does not make much sense as the view might change orientation. Falling back to WRAP_CONTENT");
                this.width = -1;
            }
            if (this.height == -1) {
                Log.w((String)TwoWayView.LOGTAG, (String)"Inflation setting LayoutParams height to MATCH_PARENT - does not make much sense as the view might change orientation. Falling back to WRAP_CONTENT");
                this.height = -2;
            }
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            if (this.width == -1) {
                Log.w((String)TwoWayView.LOGTAG, (String)"Constructing LayoutParams with width MATCH_PARENT - does not make much sense as the view might change orientation. Falling back to WRAP_CONTENT");
                this.width = -2;
            }
            if (this.height == -1) {
                Log.w((String)TwoWayView.LOGTAG, (String)"Constructing LayoutParams with height MATCH_PARENT - does not make much sense as the view might change orientation. Falling back to WRAP_CONTENT");
                this.height = -2;
            }
        }
    }

    public static interface RecyclerListener {
        public void onMovedToScrapHeap(View var1);
    }

    public static interface OnScrollListener {
        public static final int SCROLL_STATE_IDLE = 0;
        public static final int SCROLL_STATE_TOUCH_SCROLL = 1;
        public static final int SCROLL_STATE_FLING = 2;

        public void onScrollStateChanged(TwoWayView var1, int var2);

        public void onScroll(TwoWayView var1, int var2, int var3, int var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChoiceMode {
        NONE,
        SINGLE,
        MULTIPLE;

    }
}

