/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import org.mozilla.gecko.ActionModeCompat;
import org.mozilla.gecko.R;
import org.mozilla.gecko.animation.AnimationUtils;
import org.mozilla.gecko.menu.GeckoMenu;
import org.mozilla.gecko.widget.GeckoPopupMenu;

class ActionModeCompatView
extends LinearLayout
implements GeckoMenu.ActionItemBarPresenter {
    private final String LOGTAG = "GeckoActionModeCompatPresenter";
    private static final int SPEC = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
    private Button mTitleView;
    private ImageButton mMenuButton;
    private ViewGroup mActionButtonBar;
    private GeckoPopupMenu mPopupMenu;
    private static final int MAX_ACTION_ITEMS = 4;
    private int mActionButtonsWidth = 0;

    public ActionModeCompatView(Context context) {
        super(context);
        this.init(context);
    }

    public ActionModeCompatView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    public ActionModeCompatView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(context);
    }

    public void init(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.actionbar, (ViewGroup)this);
        this.mTitleView = (Button)this.findViewById(R.id.actionmode_title);
        this.mMenuButton = (ImageButton)this.findViewById(R.id.actionbar_menu);
        this.mActionButtonBar = (ViewGroup)this.findViewById(R.id.actionbar_buttons);
        this.mPopupMenu = new GeckoPopupMenu(this.getContext(), (View)this.mMenuButton);
        ((GeckoMenu)this.mPopupMenu.getMenu()).setActionItemBarPresenter(this);
        this.mMenuButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ActionModeCompatView.this.openMenu();
            }
        });
    }

    public void initForMode(ActionModeCompat actionModeCompat) {
        this.mTitleView.setOnClickListener((View.OnClickListener)actionModeCompat);
        this.mPopupMenu.setOnMenuItemClickListener(actionModeCompat);
        this.mPopupMenu.setOnMenuItemLongClickListener(actionModeCompat);
    }

    public CharSequence getTitle() {
        return this.mTitleView.getText();
    }

    public void setTitle(CharSequence charSequence) {
        this.mTitleView.setText(charSequence);
    }

    public void setTitle(int n) {
        this.mTitleView.setText(n);
    }

    public Menu getMenu() {
        return this.mPopupMenu.getMenu();
    }

    public void invalidate() {
        if (this.mPopupMenu != null && this.mMenuButton != null) {
            this.mMenuButton.setVisibility(this.mPopupMenu.getMenu().hasVisibleItems() ? 0 : 8);
        }
        super.invalidate();
    }

    public boolean addActionItem(View view) {
        int n;
        int n2 = this.mActionButtonBar.getChildCount();
        if (n2 >= 4) {
            return false;
        }
        int n3 = this.mActionButtonBar.getMeasuredWidth();
        if (n3 == 0) {
            this.mActionButtonBar.measure(SPEC, SPEC);
            n3 = this.mActionButtonBar.getMeasuredWidth();
        }
        if (this.mMenuButton.getVisibility() == 8) {
            this.mMenuButton.measure(SPEC, SPEC);
            n3 -= this.mMenuButton.getMeasuredWidth();
        }
        if (this.mActionButtonsWidth <= 0) {
            this.mActionButtonsWidth = 0;
            for (n = 0; n < n2; ++n) {
                View view2 = this.mActionButtonBar.getChildAt(n);
                view2.measure(SPEC, SPEC);
                this.mActionButtonsWidth += view2.getMeasuredWidth();
            }
        }
        view.measure(SPEC, SPEC);
        n = view.getMeasuredWidth();
        if (this.mActionButtonsWidth + n < n3) {
            this.mActionButtonsWidth += n;
            this.mActionButtonBar.addView(view);
            return true;
        }
        return false;
    }

    public void removeActionItem(View view) {
        view.measure(SPEC, SPEC);
        this.mActionButtonsWidth -= view.getMeasuredWidth();
        this.mActionButtonBar.removeView(view);
    }

    public void openMenu() {
        this.mPopupMenu.openMenu();
    }

    public void closeMenu() {
        this.mPopupMenu.dismiss();
    }

    public void animateIn() {
        long l = AnimationUtils.getShortDuration(this.getContext());
        TranslateAnimation translateAnimation = new TranslateAnimation(1, -0.5f, 1, 0.0f, 1, 0.0f, 1, 0.0f);
        translateAnimation.setDuration(l);
        ScaleAnimation scaleAnimation = new ScaleAnimation(1.0f, 1.0f, 0.0f, 1.0f, 1, 0.5f, 1, 0.5f);
        scaleAnimation.setDuration((long)((float)l * 1.5f));
        this.mTitleView.startAnimation((Animation)translateAnimation);
        this.mActionButtonBar.startAnimation((Animation)scaleAnimation);
        this.mMenuButton.startAnimation((Animation)scaleAnimation);
    }
}

