/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.hardware.input.InputManager;
import android.os.Build;
import android.view.InputDevice;
import android.view.KeyEvent;
import android.view.MotionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.util.GamepadUtils;
import org.mozilla.gecko.util.ThreadUtils;

public class AndroidGamepadManager {
    private static final float TRIGGER_PRESSED_THRESHOLD = 0.25f;
    private static final long POLL_TIMER_PERIOD = 1000L;
    private static final int FIRST_DPAD_BUTTON = 12;
    private static boolean sStarted = false;
    private static HashMap<Integer, Gamepad> sGamepads = null;
    private static HashMap<Integer, List<KeyEvent>> sPendingGamepads = null;
    private static InputManager.InputDeviceListener sListener = null;
    private static Timer sPollTimer = null;

    private AndroidGamepadManager() {
    }

    public static void startup() {
        ThreadUtils.assertOnUiThread();
        if (!sStarted) {
            sGamepads = new HashMap();
            sPendingGamepads = new HashMap();
            AndroidGamepadManager.scanForGamepads();
            AndroidGamepadManager.addDeviceListener();
            sStarted = true;
        }
    }

    public static void shutdown() {
        ThreadUtils.assertOnUiThread();
        if (sStarted) {
            AndroidGamepadManager.removeDeviceListener();
            sPendingGamepads = null;
            sGamepads = null;
            sStarted = false;
        }
    }

    public static void gamepadAdded(int n, int n2) {
        ThreadUtils.assertOnUiThread();
        if (!sStarted) {
            return;
        }
        if (!sPendingGamepads.containsKey(n)) {
            AndroidGamepadManager.removeGamepad(n);
            return;
        }
        List<KeyEvent> list = sPendingGamepads.get(n);
        sPendingGamepads.remove(n);
        sGamepads.put(n, new Gamepad(n2, n));
        for (KeyEvent keyEvent : list) {
            AndroidGamepadManager.handleKeyEvent(keyEvent);
        }
    }

    private static float deadZone(MotionEvent motionEvent, int n) {
        if (GamepadUtils.isValueInDeadZone((MotionEvent)motionEvent, (int)n)) {
            return 0.0f;
        }
        return motionEvent.getAxisValue(n);
    }

    private static void mapDpadAxis(Gamepad gamepad, boolean bl, float f, int n) {
        if (bl != gamepad.dpad[n]) {
            gamepad.dpad[n] = bl;
            GeckoAppShell.sendEventToGecko(GeckoEvent.createGamepadButtonEvent(gamepad.id, 12 + n, bl, Math.abs(f)));
        }
    }

    public static boolean handleMotionEvent(MotionEvent motionEvent) {
        int n;
        ThreadUtils.assertOnUiThread();
        if (!sStarted) {
            return false;
        }
        if (!sGamepads.containsKey(motionEvent.getDeviceId())) {
            return false;
        }
        Gamepad gamepad = sGamepads.get(motionEvent.getDeviceId());
        boolean[] blArray = new boolean[Axis.values().length];
        float[] fArray = new float[Axis.values().length];
        boolean bl = false;
        for (Axis enum_ : Axis.values()) {
            float f = AndroidGamepadManager.deadZone(motionEvent, enum_.axis);
            if (f == gamepad.axes[n = enum_.ordinal()]) continue;
            fArray[n] = f;
            gamepad.axes[n] = f;
            blArray[n] = true;
            bl = true;
        }
        if (bl) {
            GeckoAppShell.sendEventToGecko(GeckoEvent.createGamepadAxisEvent(gamepad.id, blArray, fArray));
        }
        if (gamepad.triggerAxes != null) {
            for (Enum enum_ : Trigger.values()) {
                int n2 = enum_.ordinal();
                n = gamepad.triggerAxes[n2];
                float f = AndroidGamepadManager.deadZone(motionEvent, n);
                if (f == gamepad.triggers[n2]) continue;
                gamepad.triggers[n2] = f;
                boolean bl2 = f > 0.25f;
                GeckoAppShell.sendEventToGecko(GeckoEvent.createGamepadButtonEvent(gamepad.id, ((Trigger)enum_).button, bl2, f));
            }
        }
        for (Enum enum_ : DpadAxis.values()) {
            float f = AndroidGamepadManager.deadZone(motionEvent, ((DpadAxis)enum_).axis);
            AndroidGamepadManager.mapDpadAxis(gamepad, f < 0.0f, f, ((DpadAxis)enum_).negativeButton);
            AndroidGamepadManager.mapDpadAxis(gamepad, f > 0.0f, f, ((DpadAxis)enum_).positiveButton);
        }
        return true;
    }

    public static boolean handleKeyEvent(KeyEvent keyEvent) {
        ThreadUtils.assertOnUiThread();
        if (!sStarted) {
            return false;
        }
        int n = keyEvent.getDeviceId();
        if (sPendingGamepads.containsKey(n)) {
            sPendingGamepads.get(n).add(keyEvent);
            return true;
        }
        if (!sGamepads.containsKey(n)) {
            InputDevice inputDevice = keyEvent.getDevice();
            if (inputDevice != null && (inputDevice.getSources() & 0x401) == 1025) {
                AndroidGamepadManager.addGamepad(inputDevice);
                sPendingGamepads.get(n).add(keyEvent);
                return true;
            }
            return false;
        }
        int n2 = -1;
        for (Button button : Button.values()) {
            if (button.button != keyEvent.getKeyCode()) continue;
            n2 = button.ordinal();
            break;
        }
        if (n2 == -1) {
            return false;
        }
        if (keyEvent.getRepeatCount() > 0) {
            return true;
        }
        Gamepad gamepad = sGamepads.get(n);
        int n3 = keyEvent.getAction() == 0 ? 1 : 0;
        GeckoAppShell.sendEventToGecko(GeckoEvent.createGamepadButtonEvent(gamepad.id, n2, n3 != 0, n3 != 0 ? 1.0f : 0.0f));
        return true;
    }

    private static void scanForGamepads() {
        int[] nArray = InputDevice.getDeviceIds();
        if (nArray == null) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            InputDevice inputDevice = InputDevice.getDevice((int)nArray[i]);
            if (inputDevice == null || (inputDevice.getSources() & 0x401) != 1025) continue;
            AndroidGamepadManager.addGamepad(inputDevice);
        }
    }

    private static void addGamepad(InputDevice inputDevice) {
        sPendingGamepads.put(inputDevice.getId(), new ArrayList());
        GeckoAppShell.sendEventToGecko(GeckoEvent.createGamepadAddRemoveEvent(inputDevice.getId(), true));
    }

    private static void removeGamepad(int n) {
        Gamepad gamepad = sGamepads.get(n);
        GeckoAppShell.sendEventToGecko(GeckoEvent.createGamepadAddRemoveEvent(gamepad.id, false));
        sGamepads.remove(n);
    }

    private static void addDeviceListener() {
        if (Build.VERSION.SDK_INT < 16) {
            sPollTimer = new Timer();
            sPollTimer.scheduleAtFixedRate(new TimerTask(){

                public void run() {
                    for (Integer n : sGamepads.keySet()) {
                        if (InputDevice.getDevice((int)n) != null) continue;
                        AndroidGamepadManager.removeGamepad(n);
                    }
                }
            }, 1000L, 1000L);
            return;
        }
        sListener = new InputManager.InputDeviceListener(){

            public void onInputDeviceAdded(int n) {
                InputDevice inputDevice = InputDevice.getDevice((int)n);
                if (inputDevice == null) {
                    return;
                }
                if ((inputDevice.getSources() & 0x401) == 1025) {
                    AndroidGamepadManager.addGamepad(inputDevice);
                }
            }

            public void onInputDeviceRemoved(int n) {
                if (sPendingGamepads.containsKey(n)) {
                    sPendingGamepads.remove(n);
                    return;
                }
                if (sGamepads.containsKey(n)) {
                    AndroidGamepadManager.removeGamepad(n);
                }
            }

            public void onInputDeviceChanged(int n) {
            }
        };
        ((InputManager)GeckoAppShell.getContext().getSystemService("input")).registerInputDeviceListener(sListener, ThreadUtils.getUiHandler());
    }

    private static void removeDeviceListener() {
        if (Build.VERSION.SDK_INT < 16) {
            if (sPollTimer != null) {
                sPollTimer.cancel();
                sPollTimer = null;
            }
            return;
        }
        ((InputManager)GeckoAppShell.getContext().getSystemService("input")).unregisterInputDeviceListener(sListener);
        sListener = null;
    }

    private static class Gamepad {
        public int id;
        public float[] axes;
        public boolean[] dpad;
        public int[] triggerAxes;
        public float[] triggers;

        public Gamepad(int n, int n2) {
            this.id = n;
            this.axes = new float[Axis.values().length];
            this.dpad = new boolean[4];
            this.triggers = new float[2];
            InputDevice inputDevice = InputDevice.getDevice((int)n2);
            if (inputDevice != null) {
                this.triggerAxes = inputDevice.getMotionRange(17) != null && inputDevice.getMotionRange(18) != null ? new int[]{17, 18} : (int[])(inputDevice.getMotionRange(23) != null && inputDevice.getMotionRange(22) != null ? new int[]{23, 22} : null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Button {
        A(96),
        B(97),
        X(99),
        Y(100),
        L1(102),
        R1(103),
        L2(104),
        R2(105),
        SELECT(109),
        START(108),
        THUMBL(106),
        THUMBR(107),
        DPAD_UP(19),
        DPAD_DOWN(20),
        DPAD_LEFT(21),
        DPAD_RIGHT(22);

        public final int button;

        private Button(int n2) {
            this.button = n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DpadAxis {
        UpDown(16, 0, 1),
        LeftRight(15, 2, 3);

        public final int axis;
        public final int negativeButton;
        public final int positiveButton;

        private DpadAxis(int n2, int n3, int n4) {
            this.axis = n2;
            this.negativeButton = n3;
            this.positiveButton = n4;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Trigger {
        Left(6),
        Right(7);

        public final int button;

        private Trigger(int n2) {
            this.button = n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Axis {
        X(0),
        Y(1),
        Z(11),
        RZ(14);

        public final int axis;

        private Axis(int n2) {
            this.axis = n2;
        }
    }
}

