/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.util.Log;

class Envelope {
    protected int mId;
    protected int mMessageId;
    protected long mMessageTimestamp;
    protected int[] mRemainingParts;
    protected boolean[] mFailing;
    protected int mError;

    public Envelope(int n, int n2) {
        this.mId = n;
        this.mMessageId = -1;
        this.mMessageTimestamp = 0L;
        this.mError = 0;
        int n3 = SubParts.values().length;
        this.mRemainingParts = new int[n3];
        this.mFailing = new boolean[n3];
        for (int i = 0; i < n3; ++i) {
            this.mRemainingParts[i] = n2;
            this.mFailing[i] = false;
        }
    }

    public void decreaseRemainingParts(SubParts subParts) {
        int n = subParts.ordinal();
        this.mRemainingParts[n] = this.mRemainingParts[n] - 1;
        if (this.mRemainingParts[SubParts.SENT_PART.ordinal()] > this.mRemainingParts[SubParts.DELIVERED_PART.ordinal()]) {
            Log.e((String)"GeckoSmsManager", (String)"Delivered more parts than we sent!?");
        }
    }

    public boolean arePartsRemaining(SubParts subParts) {
        return this.mRemainingParts[subParts.ordinal()] != 0;
    }

    public void markAsFailed(SubParts subParts) {
        this.mFailing[subParts.ordinal()] = true;
    }

    public boolean isFailing(SubParts subParts) {
        return this.mFailing[subParts.ordinal()];
    }

    public int getMessageId() {
        return this.mMessageId;
    }

    public void setMessageId(int n) {
        this.mMessageId = n;
    }

    public long getMessageTimestamp() {
        return this.mMessageTimestamp;
    }

    public void setMessageTimestamp(long l) {
        this.mMessageTimestamp = l;
    }

    public int getError() {
        return this.mError;
    }

    public void setError(int n) {
        this.mError = n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SubParts {
        SENT_PART,
        DELIVERED_PART;

    }
}

