/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import org.mozilla.gecko.GeckoAppShell;

public class GeckoBatteryManager
extends BroadcastReceiver {
    private static final String LOGTAG = "GeckoBatteryManager";
    private static final double kDefaultLevel = 1.0;
    private static final boolean kDefaultCharging = true;
    private static final double kDefaultRemainingTime = 0.0;
    private static final double kUnknownRemainingTime = -1.0;
    private static long sLastLevelChange = 0L;
    private static boolean sNotificationsEnabled = false;
    private static double sLevel = 1.0;
    private static boolean sCharging = true;
    private static double sRemainingTime = 0.0;
    private static GeckoBatteryManager sInstance = new GeckoBatteryManager();
    private final IntentFilter mFilter = new IntentFilter();
    private Context mApplicationContext;
    private boolean mIsEnabled;

    public static GeckoBatteryManager getInstance() {
        return sInstance;
    }

    private GeckoBatteryManager() {
        this.mFilter.addAction("android.intent.action.BATTERY_CHANGED");
    }

    public synchronized void start(Context context) {
        if (this.mIsEnabled) {
            Log.w((String)LOGTAG, (String)"Already started!");
            return;
        }
        this.mApplicationContext = context.getApplicationContext();
        if (this.mApplicationContext.registerReceiver((BroadcastReceiver)this, this.mFilter) == null) {
            Log.e((String)LOGTAG, (String)"Registering receiver failed");
        } else {
            this.mIsEnabled = true;
        }
    }

    public synchronized void stop() {
        if (!this.mIsEnabled) {
            Log.w((String)LOGTAG, (String)"Already stopped!");
            return;
        }
        this.mApplicationContext.unregisterReceiver((BroadcastReceiver)this);
        this.mApplicationContext = null;
        this.mIsEnabled = false;
    }

    public void onReceive(Context context, Intent intent) {
        if (!intent.getAction().equals("android.intent.action.BATTERY_CHANGED")) {
            Log.e((String)LOGTAG, (String)"Got an unexpected intent!");
            return;
        }
        boolean bl = GeckoBatteryManager.isCharging();
        double d = GeckoBatteryManager.getLevel();
        if (intent.getBooleanExtra("present", false) || Build.MODEL.equals("Galaxy Nexus")) {
            int n = intent.getIntExtra("plugged", -1);
            if (n == -1) {
                sCharging = true;
                Log.e((String)LOGTAG, (String)"Failed to get the plugged status!");
            } else {
                boolean bl2 = sCharging = n != 0;
            }
            if (sCharging != bl) {
                sRemainingTime = -1.0;
                sLastLevelChange = 0L;
            }
            double d2 = intent.getIntExtra("level", -1);
            double d3 = intent.getIntExtra("scale", -1);
            if (d2 == -1.0 || d3 == -1.0) {
                Log.e((String)LOGTAG, (String)"Failed to get battery level!");
                sLevel = 1.0;
            } else {
                sLevel = d2 / d3;
            }
            if (sLevel == 1.0 && sCharging) {
                sRemainingTime = 0.0;
            } else if (sLevel != d) {
                if (sLastLevelChange != 0L) {
                    long l = SystemClock.elapsedRealtime();
                    long l2 = (l - sLastLevelChange) / 1000L;
                    double d4 = sLevel - d;
                    if (sCharging) {
                        if (d4 < 0.0) {
                            Log.w((String)LOGTAG, (String)"When charging, level should increase!");
                            sRemainingTime = -1.0;
                        } else {
                            sRemainingTime = Math.round((double)l2 / d4 * (1.0 - sLevel));
                        }
                    } else if (d4 > 0.0) {
                        Log.w((String)LOGTAG, (String)"When discharging, level should decrease!");
                        sRemainingTime = -1.0;
                    } else {
                        sRemainingTime = Math.round((double)l2 / -d4 * sLevel);
                    }
                    sLastLevelChange = l;
                } else {
                    sLastLevelChange = SystemClock.elapsedRealtime();
                }
            }
        } else {
            sLevel = 1.0;
            sCharging = true;
            sRemainingTime = 0.0;
        }
        if (sNotificationsEnabled && (bl != GeckoBatteryManager.isCharging() || d != GeckoBatteryManager.getLevel())) {
            GeckoAppShell.notifyBatteryChange(GeckoBatteryManager.getLevel(), GeckoBatteryManager.isCharging(), GeckoBatteryManager.getRemainingTime());
        }
    }

    public static boolean isCharging() {
        return sCharging;
    }

    public static double getLevel() {
        return sLevel;
    }

    public static double getRemainingTime() {
        return sRemainingTime;
    }

    public static void enableNotifications() {
        sNotificationsEnabled = true;
    }

    public static void disableNotifications() {
        sNotificationsEnabled = false;
    }

    public static double[] getCurrentInformation() {
        return new double[]{GeckoBatteryManager.getLevel(), GeckoBatteryManager.isCharging() ? 1.0 : 0.0, GeckoBatteryManager.getRemainingTime()};
    }
}

