/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.healthreport;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.SortedSet;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.apache.commons.codec.binary.Base64;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.healthreport.HealthReportUtils;
import org.mozilla.gecko.background.nativecode.NativeCrypto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnvironmentV1 {
    private static final String LOG_TAG = "GeckoEnvironment";
    private static final int VERSION = 1;
    protected final Class<? extends EnvironmentAppender> appenderClass;
    protected volatile String hash = null;
    protected volatile int id = -1;
    public int version = 1;
    public int profileCreation;
    public int cpuCount;
    public int memoryMB;
    public String architecture;
    public String sysName;
    public String sysVersion;
    public String vendor;
    public String appName;
    public String appID;
    public String appVersion;
    public String appBuildID;
    public String platformVersion;
    public String platformBuildID;
    public String os;
    public String xpcomabi;
    public String updateChannel;
    public int isBlocklistEnabled;
    public int isTelemetryEnabled;
    public JSONObject addons = null;
    public int extensionCount;
    public int pluginCount;
    public int themeCount;

    public abstract int register();

    protected EnvironmentAppender getAppender() {
        EnvironmentAppender environmentAppender = null;
        try {
            environmentAppender = this.appenderClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
            Logger.warn(LOG_TAG, "Could not compute hash.", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.warn(LOG_TAG, "Could not compute hash.", illegalAccessException);
        }
        return environmentAppender;
    }

    protected void appendHash(EnvironmentAppender environmentAppender) {
        environmentAppender.append(this.profileCreation);
        environmentAppender.append(this.cpuCount);
        environmentAppender.append(this.memoryMB);
        environmentAppender.append(this.architecture);
        environmentAppender.append(this.sysName);
        environmentAppender.append(this.sysVersion);
        environmentAppender.append(this.vendor);
        environmentAppender.append(this.appName);
        environmentAppender.append(this.appID);
        environmentAppender.append(this.appVersion);
        environmentAppender.append(this.appBuildID);
        environmentAppender.append(this.platformVersion);
        environmentAppender.append(this.platformBuildID);
        environmentAppender.append(this.os);
        environmentAppender.append(this.xpcomabi);
        environmentAppender.append(this.updateChannel);
        environmentAppender.append(this.isBlocklistEnabled);
        environmentAppender.append(this.isTelemetryEnabled);
        environmentAppender.append(this.extensionCount);
        environmentAppender.append(this.pluginCount);
        environmentAppender.append(this.themeCount);
        if (this.addons != null) {
            EnvironmentV1.appendSortedAddons(this.getNonIgnoredAddons(), environmentAppender);
        }
    }

    public String getHash() {
        if (this.hash != null) {
            return this.hash;
        }
        EnvironmentAppender environmentAppender = this.getAppender();
        if (environmentAppender == null) {
            return null;
        }
        this.appendHash(environmentAppender);
        this.hash = environmentAppender.toString();
        return this.hash;
    }

    public EnvironmentV1(Class<? extends EnvironmentAppender> clazz) {
        this.appenderClass = clazz;
    }

    public JSONObject getNonIgnoredAddons() {
        if (this.addons == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        Iterator iterator = this.addons.keys();
        while (iterator.hasNext()) {
            try {
                String string2 = (String)iterator.next();
                Object object = this.addons.get(string2);
                if (object != null && object instanceof JSONObject && ((JSONObject)object).optBoolean("ignore", false)) continue;
                jSONObject.put(string2, object);
            }
            catch (JSONException jSONException) {}
        }
        return jSONObject;
    }

    public static void appendSortedAddons(JSONObject jSONObject, EnvironmentAppender environmentAppender) {
        SortedSet<String> sortedSet = HealthReportUtils.sortedKeySet(jSONObject);
        for (String string2 : sortedSet) {
            try {
                JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
                environmentAppender.append(string2);
                environmentAppender.append("={");
                for (String string3 : HealthReportUtils.sortedKeySet(jSONObject2)) {
                    environmentAppender.append(string3);
                    environmentAppender.append("==");
                    try {
                        environmentAppender.append(jSONObject2.get(string3).toString());
                    }
                    catch (JSONException jSONException) {
                        environmentAppender.append("_e_");
                    }
                }
                environmentAppender.append("}");
            }
            catch (Exception exception) {
                Logger.warn(LOG_TAG, "Invalid add-on for ID " + string2);
            }
        }
    }

    public void setJSONForAddons(byte[] byArray) throws Exception {
        this.setJSONForAddons(new String(byArray, "UTF-8"));
    }

    public void setJSONForAddons(String string2) throws Exception {
        if (string2 == null || "null".equals(string2)) {
            this.addons = null;
            return;
        }
        this.addons = new JSONObject(string2);
    }

    public void setJSONForAddons(JSONObject jSONObject) {
        this.addons = jSONObject;
    }

    public String getNormalizedAddonsJSON() {
        return this.addons == null ? "null" : this.addons.toString();
    }

    public static class HashAppender
    extends EnvironmentAppender {
        private final StringBuilder builder = new StringBuilder();

        public void append(String string2) {
            this.builder.append(string2 == null ? "null" : string2);
        }

        public void append(int n) {
            this.append(Integer.toString(n, 10));
        }

        public String toString() {
            byte[] byArray;
            try {
                byArray = this.builder.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Logger.warn(EnvironmentV1.LOG_TAG, "Invalid charset String passed to getBytes", unsupportedEncodingException);
                return null;
            }
            byte[] byArray2 = NativeCrypto.sha1(byArray);
            return new Base64(-1, null, false).encodeAsString(byArray2);
        }
    }

    public static abstract class EnvironmentAppender {
        public abstract void append(String var1);

        public abstract void append(int var1);
    }
}

