/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentUris;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.text.TextUtils;
import org.mozilla.gecko.db.DBUtils;
import org.mozilla.gecko.db.SharedBrowserDatabaseProvider;
import org.mozilla.gecko.sync.Utils;

public class ReadingListProvider
extends SharedBrowserDatabaseProvider {
    static final String TABLE_READING_LIST = "reading_list";
    static final int ITEMS = 101;
    static final int ITEMS_ID = 102;
    static final UriMatcher URI_MATCHER = new UriMatcher(-1);

    public int updateOrInsertItem(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        int n = this.updateItems(uri, contentValues, string2, stringArray);
        if (n <= 0) {
            n = this.insertItem(uri, contentValues) != -1L ? 1 : 0;
        }
        return n;
    }

    public int updateItems(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        ReadingListProvider.trace("Updating ReadingListItems on URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        if (!contentValues.containsKey("modified")) {
            contentValues.put("modified", Long.valueOf(System.currentTimeMillis()));
        }
        return sQLiteDatabase.update(TABLE_READING_LIST, contentValues, string2, stringArray);
    }

    long insertItem(Uri uri, ContentValues contentValues) {
        long l = System.currentTimeMillis();
        if (!contentValues.containsKey("created")) {
            contentValues.put("created", Long.valueOf(l));
        }
        if (!contentValues.containsKey("modified")) {
            contentValues.put("modified", Long.valueOf(l));
        }
        if (!contentValues.containsKey("guid")) {
            contentValues.put("guid", Utils.generateGuid());
        }
        String string2 = contentValues.getAsString("url");
        ReadingListProvider.debug("Inserting item in database with URL: " + string2);
        return this.getWritableDatabase(uri).insertOrThrow(TABLE_READING_LIST, null, contentValues);
    }

    int deleteItems(Uri uri, String string2, String[] stringArray) {
        ReadingListProvider.debug("Deleting item entry for URI: " + uri);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase(uri);
        if (ReadingListProvider.isCallerSync(uri)) {
            return sQLiteDatabase.delete(TABLE_READING_LIST, string2, stringArray);
        }
        ReadingListProvider.debug("Marking item entry as deleted for URI: " + uri);
        ContentValues contentValues = new ContentValues();
        contentValues.put("deleted", Integer.valueOf(1));
        this.cleanUpSomeDeletedRecords(uri, TABLE_READING_LIST);
        return this.updateItems(uri, contentValues, string2, stringArray);
    }

    public int updateInTransaction(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        ReadingListProvider.trace("Calling update in transaction on URI: " + uri);
        int n = 0;
        int n2 = URI_MATCHER.match(uri);
        switch (n2) {
            case 102: {
                ReadingListProvider.debug("Update on ITEMS_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, "reading_list._id = ?");
                stringArray = DBUtils.appendSelectionArgs(stringArray, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 101: {
                ReadingListProvider.debug("Updating ITEMS: " + uri);
                n = ReadingListProvider.shouldUpdateOrInsert(uri) ? this.updateOrInsertItem(uri, contentValues, string2, stringArray) : this.updateItems(uri, contentValues, string2, stringArray);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown update URI " + uri);
            }
        }
        ReadingListProvider.debug("Updated " + n + " rows for URI: " + uri);
        return n;
    }

    public int deleteInTransaction(Uri uri, String string2, String[] stringArray) {
        ReadingListProvider.trace("Calling delete in transaction on URI: " + uri);
        int n = 0;
        int n2 = URI_MATCHER.match(uri);
        switch (n2) {
            case 102: {
                ReadingListProvider.debug("Deleting on ITEMS_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, "reading_list._id = ?");
                stringArray = DBUtils.appendSelectionArgs(stringArray, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 101: {
                ReadingListProvider.debug("Deleting ITEMS: " + uri);
                n = this.deleteItems(uri, string2, stringArray);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown update URI " + uri);
            }
        }
        ReadingListProvider.debug("Deleted " + n + " rows for URI: " + uri);
        return n;
    }

    public Uri insertInTransaction(Uri uri, ContentValues contentValues) {
        ReadingListProvider.trace("Calling insert in transaction on URI: " + uri);
        long l = -1L;
        int n = URI_MATCHER.match(uri);
        switch (n) {
            case 101: {
                ReadingListProvider.trace("Insert on ITEMS: " + uri);
                l = this.insertItem(uri, contentValues);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown insert URI " + uri);
            }
        }
        ReadingListProvider.debug("Inserted ID in database: " + l);
        if (l >= 0L) {
            return ContentUris.withAppendedId((Uri)uri, (long)l);
        }
        return null;
    }

    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        String string4 = null;
        SQLiteDatabase sQLiteDatabase = this.getReadableDatabase(uri);
        SQLiteQueryBuilder sQLiteQueryBuilder = new SQLiteQueryBuilder();
        String string5 = uri.getQueryParameter("limit");
        int n = URI_MATCHER.match(uri);
        switch (n) {
            case 102: {
                ReadingListProvider.trace("Query on ITEMS_ID: " + uri);
                string2 = DBUtils.concatenateWhere(string2, "_id = ?");
                stringArray2 = DBUtils.appendSelectionArgs(stringArray2, new String[]{Long.toString(ContentUris.parseId((Uri)uri))});
            }
            case 101: {
                ReadingListProvider.trace("Query on ITEMS: " + uri);
                if (ReadingListProvider.shouldShowDeleted(uri)) break;
                string2 = DBUtils.concatenateWhere("deleted = 0", string2);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown query URI " + uri);
            }
        }
        if (TextUtils.isEmpty((CharSequence)string3)) {
            string3 = "modified DESC";
        }
        ReadingListProvider.trace("Running built query.");
        sQLiteQueryBuilder.setTables(TABLE_READING_LIST);
        Cursor cursor = sQLiteQueryBuilder.query(sQLiteDatabase, stringArray, string2, stringArray2, string4, null, string3, string5);
        cursor.setNotificationUri(this.getContext().getContentResolver(), uri);
        return cursor;
    }

    public String getType(Uri uri) {
        ReadingListProvider.trace("Getting URI type: " + uri);
        int n = URI_MATCHER.match(uri);
        switch (n) {
            case 101: {
                ReadingListProvider.trace("URI is ITEMS: " + uri);
                return "vnd.android.cursor.dir/readinglistitem";
            }
            case 102: {
                ReadingListProvider.trace("URI is ITEMS_ID: " + uri);
                return "vnd.android.cursor.item/readinglistitem";
            }
        }
        ReadingListProvider.debug("URI has unrecognized type: " + uri);
        return null;
    }

    static {
        URI_MATCHER.addURI("org.mozilla.fennec.db.readinglist", "items", 101);
        URI_MATCHER.addURI("org.mozilla.fennec.db.readinglist", "items/#", 102);
    }
}

