/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.accounts.Account;
import android.annotation.TargetApi;
import android.app.ActionBar;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.MenuItem;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.fxa.activities.FxAccountGetStartedActivity;
import org.mozilla.gecko.fxa.activities.FxAccountStatusFragment;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.sync.setup.activities.LocaleAware;

public class FxAccountStatusActivity
extends LocaleAware.LocaleAwareFragmentActivity {
    private static final String LOG_TAG = FxAccountStatusActivity.class.getSimpleName();
    protected FxAccountStatusFragment statusFragment;

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.statusFragment = new FxAccountStatusFragment();
        this.getSupportFragmentManager().beginTransaction().replace(0x1020002, (Fragment)this.statusFragment).commit();
        this.maybeSetHomeButtonEnabled();
    }

    @TargetApi(value=14)
    protected void maybeSetHomeButtonEnabled() {
        if (Build.VERSION.SDK_INT < 14) {
            Logger.debug(LOG_TAG, "Not enabling home button; version too low.");
            return;
        }
        ActionBar actionBar = this.getActionBar();
        if (actionBar != null) {
            Logger.debug(LOG_TAG, "Enabling home button.");
            actionBar.setHomeButtonEnabled(true);
            return;
        }
        Logger.debug(LOG_TAG, "Not enabling home button.");
    }

    public void onResume() {
        super.onResume();
        AndroidFxAccount androidFxAccount = this.getAndroidFxAccount();
        if (androidFxAccount == null) {
            Logger.warn(LOG_TAG, "Could not get Firefox Account.");
            Intent intent = new Intent((Context)this, FxAccountGetStartedActivity.class);
            intent.setFlags(65536);
            this.startActivity(intent);
            this.setResult(0);
            this.finish();
            return;
        }
        this.statusFragment.refresh(androidFxAccount);
    }

    protected AndroidFxAccount getAndroidFxAccount() {
        Account account = FirefoxAccounts.getFirefoxAccount((Context)this);
        if (account == null) {
            return null;
        }
        return new AndroidFxAccount((Context)this, account);
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        int n = menuItem.getItemId();
        switch (n) {
            case 16908332: {
                this.finish();
                return true;
            }
        }
        return super.onOptionsItemSelected(menuItem);
    }
}

