/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.sync;

import android.content.ContentResolver;
import android.content.SyncStatusObserver;
import java.util.Map;
import java.util.WeakHashMap;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;

public class FxAccountSyncStatusHelper
implements SyncStatusObserver {
    private static final String LOG_TAG = FxAccountSyncStatusHelper.class.getSimpleName();
    protected static FxAccountSyncStatusHelper sInstance = null;
    protected Object handle = null;
    protected Map<FirefoxAccounts.SyncStatusListener, Boolean> delegates = new WeakHashMap<FirefoxAccounts.SyncStatusListener, Boolean>();

    public static synchronized FxAccountSyncStatusHelper getInstance() {
        if (sInstance == null) {
            sInstance = new FxAccountSyncStatusHelper();
        }
        return sInstance;
    }

    public synchronized void onStatusChanged(int n) {
        for (Map.Entry<FirefoxAccounts.SyncStatusListener, Boolean> entry : this.delegates.entrySet()) {
            FirefoxAccounts.SyncStatusListener syncStatusListener = entry.getKey();
            AndroidFxAccount androidFxAccount = new AndroidFxAccount(syncStatusListener.getContext(), syncStatusListener.getAccount());
            boolean bl = androidFxAccount.isCurrentlySyncing();
            boolean bl2 = entry.getValue();
            entry.setValue(bl);
            if (bl && !bl2) {
                syncStatusListener.onSyncStarted();
            }
            if (bl || !bl2) continue;
            syncStatusListener.onSyncFinished();
        }
    }

    protected void addListener() {
        if (this.handle != null) {
            throw new IllegalStateException("Already registered this as an observer?");
        }
        this.handle = ContentResolver.addStatusChangeListener((int)4, (SyncStatusObserver)this);
    }

    protected void removeListener() {
        Object object = this.handle;
        this.handle = null;
        if (object != null) {
            ContentResolver.removeStatusChangeListener((Object)object);
        }
    }

    public synchronized void startObserving(FirefoxAccounts.SyncStatusListener syncStatusListener) {
        if (syncStatusListener == null) {
            throw new IllegalArgumentException("delegate must not be null");
        }
        if (this.delegates.containsKey(syncStatusListener)) {
            return;
        }
        if (this.delegates.isEmpty()) {
            this.addListener();
        }
        this.delegates.put(syncStatusListener, Boolean.FALSE);
    }

    public synchronized void stopObserving(FirefoxAccounts.SyncStatusListener syncStatusListener) {
        this.delegates.remove(syncStatusListener);
        if (this.delegates.isEmpty()) {
            this.removeListener();
        }
    }
}

