/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.util.Log;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.gfx.EGLPreloadingThread;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.mozglue.generatorannotations.WrapElementForJNI;
import org.mozilla.gecko.util.ThreadUtils;

public class GLController {
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private static final String LOGTAG = "GeckoGLController";
    private static GLController sInstance;
    private LayerView mView;
    private boolean mServerSurfaceValid;
    private int mWidth;
    private int mHeight;
    private volatile boolean mCompositorCreated;
    private EGL10 mEGL;
    private EGLDisplay mEGLDisplay;
    private EGLConfig mEGLConfig;
    private EGLPreloadingThread mEGLPreloadingThread = new EGLPreloadingThread();
    private EGLSurface mEGLSurfaceForCompositor;
    private static final int LOCAL_EGL_OPENGL_ES2_BIT = 4;
    private static final int[] CONFIG_SPEC_16BPP;
    private static final int[] CONFIG_SPEC_24BPP;

    private GLController() {
        this.mEGLPreloadingThread.start();
    }

    static GLController getInstance(LayerView layerView) {
        if (sInstance == null) {
            sInstance = new GLController();
        }
        GLController.sInstance.mView = layerView;
        return sInstance;
    }

    synchronized void serverSurfaceDestroyed() {
        ThreadUtils.assertOnUiThread();
        this.mServerSurfaceValid = false;
        if (this.mEGLSurfaceForCompositor != null) {
            this.mEGL.eglDestroySurface(this.mEGLDisplay, this.mEGLSurfaceForCompositor);
            this.mEGLSurfaceForCompositor = null;
        }
        if (this.mCompositorCreated) {
            GeckoAppShell.sendEventToGeckoSync(GeckoEvent.createCompositorPauseEvent());
        }
    }

    synchronized void serverSurfaceChanged(int n, int n2) {
        ThreadUtils.assertOnUiThread();
        this.mWidth = n;
        this.mHeight = n2;
        this.mServerSurfaceValid = true;
        this.mView.post(new Runnable(){

            public void run() {
                GLController.this.updateCompositor();
            }
        });
    }

    void updateCompositor() {
        ThreadUtils.assertOnUiThread();
        if (this.mCompositorCreated) {
            this.resumeCompositor(this.mWidth, this.mHeight);
            return;
        }
        if (!this.AttemptPreallocateEGLSurfaceForCompositor()) {
            return;
        }
        if (GeckoThread.checkLaunchState(GeckoThread.LaunchState.GeckoRunning)) {
            GeckoAppShell.sendEventToGeckoSync(GeckoEvent.createCompositorCreateEvent(this.mWidth, this.mHeight));
        }
    }

    void compositorCreated() {
        this.mCompositorCreated = true;
    }

    public boolean isServerSurfaceValid() {
        return this.mServerSurfaceValid;
    }

    public boolean isCompositorCreated() {
        return this.mCompositorCreated;
    }

    private void initEGL() {
        if (this.mEGL != null) {
            return;
        }
        try {
            this.mEGLPreloadingThread.join();
        }
        catch (InterruptedException interruptedException) {
            Log.w((String)LOGTAG, (String)"EGLPreloadingThread interrupted", (Throwable)interruptedException);
        }
        this.mEGL = (EGL10)EGLContext.getEGL();
        this.mEGLDisplay = this.mEGL.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (this.mEGLDisplay == EGL10.EGL_NO_DISPLAY) {
            Log.w((String)LOGTAG, (String)"Can't get EGL display!");
            return;
        }
        int[] nArray = new int[2];
        if (!this.mEGL.eglInitialize(this.mEGLDisplay, nArray)) {
            Log.w((String)LOGTAG, (String)"eglInitialize failed");
            return;
        }
        this.mEGLConfig = this.chooseConfig();
    }

    private EGLConfig chooseConfig() {
        int n;
        int n2;
        int n3;
        int[] nArray;
        int[] nArray2 = new int[1];
        switch (GeckoAppShell.getScreenDepth()) {
            case 24: {
                nArray = CONFIG_SPEC_24BPP;
                n3 = 8;
                n2 = 8;
                n = 8;
                break;
            }
            default: {
                nArray = CONFIG_SPEC_16BPP;
                n = 5;
                n2 = 6;
                n3 = 5;
            }
        }
        if (!this.mEGL.eglChooseConfig(this.mEGLDisplay, nArray, null, 0, nArray2) || nArray2[0] <= 0) {
            throw new GLControllerException("No available EGL configurations " + this.getEGLError());
        }
        EGLConfig[] eGLConfigArray = new EGLConfig[nArray2[0]];
        if (!this.mEGL.eglChooseConfig(this.mEGLDisplay, nArray, eGLConfigArray, nArray2[0], nArray2)) {
            throw new GLControllerException("No EGL configuration for that specification " + this.getEGLError());
        }
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        for (EGLConfig eGLConfig : eGLConfigArray) {
            this.mEGL.eglGetConfigAttrib(this.mEGLDisplay, eGLConfig, 12324, nArray3);
            this.mEGL.eglGetConfigAttrib(this.mEGLDisplay, eGLConfig, 12323, nArray4);
            this.mEGL.eglGetConfigAttrib(this.mEGLDisplay, eGLConfig, 12322, nArray5);
            if (nArray3[0] != n || nArray4[0] != n2 || nArray5[0] != n3) continue;
            return eGLConfig;
        }
        throw new GLControllerException("No suitable EGL configuration found");
    }

    private synchronized boolean AttemptPreallocateEGLSurfaceForCompositor() {
        if (this.mEGLSurfaceForCompositor == null) {
            this.initEGL();
            try {
                this.mEGLSurfaceForCompositor = this.mEGL.eglCreateWindowSurface(this.mEGLDisplay, this.mEGLConfig, this.mView.getNativeWindow(), null);
                if (this.mEGLSurfaceForCompositor == EGL10.EGL_NO_SURFACE) {
                    this.mEGLSurfaceForCompositor = null;
                }
            }
            catch (Exception exception) {
                Log.e((String)LOGTAG, (String)"eglCreateWindowSurface threw", (Throwable)exception);
            }
        }
        if (this.mEGLSurfaceForCompositor == null) {
            Log.w((String)LOGTAG, (String)"eglCreateWindowSurface returned no surface!");
        }
        return this.mEGLSurfaceForCompositor != null;
    }

    @WrapElementForJNI(allowMultithread=true, stubName="CreateEGLSurfaceForCompositorWrapper")
    private synchronized EGLSurface createEGLSurfaceForCompositor() {
        this.AttemptPreallocateEGLSurfaceForCompositor();
        EGLSurface eGLSurface = this.mEGLSurfaceForCompositor;
        this.mEGLSurfaceForCompositor = null;
        return eGLSurface;
    }

    private String getEGLError() {
        return "Error " + (this.mEGL == null ? "(no mEGL)" : Integer.valueOf(this.mEGL.eglGetError()));
    }

    void resumeCompositor(int n, int n2) {
        if (this.mCompositorCreated) {
            GeckoAppShell.scheduleResumeComposition(n, n2);
            GeckoAppShell.sendEventToGecko(GeckoEvent.createCompositorResumeEvent());
        }
    }

    static {
        CONFIG_SPEC_16BPP = new int[]{12324, 5, 12323, 6, 12322, 5, 12339, 4, 12352, 4, 12344};
        CONFIG_SPEC_24BPP = new int[]{12324, 8, 12323, 8, 12322, 8, 12339, 4, 12352, 4, 12344};
    }

    public static class GLControllerException
    extends RuntimeException {
        public static final long serialVersionUID = 1L;

        GLControllerException(String string2) {
            super(string2);
        }
    }
}

