/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import java.util.ArrayList;
import org.mozilla.gecko.AboutPages;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.R;
import org.mozilla.gecko.SessionParser;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.home.HomeContextMenuInfo;
import org.mozilla.gecko.home.HomeFragment;
import org.mozilla.gecko.home.HomeListView;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.MultiTypeCursorAdapter;
import org.mozilla.gecko.home.SimpleCursorLoader;
import org.mozilla.gecko.home.TwoLinePageRow;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSObject;
import org.mozilla.gecko.util.ThreadUtils;

public class RecentTabsPanel
extends HomeFragment
implements NativeEventListener {
    private static final String LOGTAG = "GeckoRecentTabsPanel";
    private static final int LOADER_ID_RECENT_TABS = 0;
    private RecentTabsAdapter mAdapter;
    private HomeListView mList;
    private View mEmptyView;
    private CursorLoaderCallbacks mCursorLoaderCallbacks;
    private HomePager.OnNewTabsListener mNewTabsListener;
    private ClosedTab[] mClosedTabs;

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.mNewTabsListener = (HomePager.OnNewTabsListener)activity;
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException(activity.toString() + " must implement HomePager.OnNewTabsListener");
        }
    }

    public void onDetach() {
        super.onDetach();
        this.mNewTabsListener = null;
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        return layoutInflater.inflate(R.layout.home_recent_tabs_panel, viewGroup, false);
    }

    public void onViewCreated(View view, Bundle bundle) {
        this.mList = (HomeListView)view.findViewById(R.id.list);
        this.mList.setTag("recent_tabs");
        this.mList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                Cursor cursor = RecentTabsPanel.this.mAdapter.getCursor();
                if (cursor == null || !cursor.moveToPosition(n)) {
                    return;
                }
                int n2 = cursor.getInt(cursor.getColumnIndexOrThrow("type"));
                if (n2 == 3) {
                    RecentTabsPanel.this.openTabsWithType(1);
                    return;
                }
                if (n2 == 4) {
                    RecentTabsPanel.this.openTabsWithType(2);
                    return;
                }
                Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.LIST_ITEM);
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(cursor.getString(cursor.getColumnIndexOrThrow("url")));
                RecentTabsPanel.this.mNewTabsListener.onNewTabs(arrayList);
            }
        });
        this.mList.setContextMenuInfoFactory(new HomeContextMenuInfo.Factory(){

            public HomeContextMenuInfo makeInfoForCursor(View view, int n, long l, Cursor cursor) {
                int n2 = cursor.getInt(cursor.getColumnIndexOrThrow("type"));
                if (n2 == 3 || n2 == 4) {
                    return null;
                }
                HomeContextMenuInfo homeContextMenuInfo = new HomeContextMenuInfo(view, n, l);
                homeContextMenuInfo.url = cursor.getString(cursor.getColumnIndexOrThrow("url"));
                homeContextMenuInfo.title = cursor.getString(cursor.getColumnIndexOrThrow("title"));
                return homeContextMenuInfo;
            }
        });
        this.registerForContextMenu((View)this.mList);
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "ClosedTabs:Data");
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("ClosedTabs:StartNotifications", null));
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mList = null;
        this.mEmptyView = null;
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "ClosedTabs:Data");
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("ClosedTabs:StopNotifications", null));
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        if (this.isVisible()) {
            this.getFragmentManager().beginTransaction().detach((Fragment)this).attach((Fragment)this).commitAllowingStateLoss();
        }
    }

    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        this.mAdapter = new RecentTabsAdapter((Context)this.getActivity());
        this.mList.setAdapter((ListAdapter)this.mAdapter);
        this.mCursorLoaderCallbacks = new CursorLoaderCallbacks();
        this.loadIfVisible();
    }

    private void updateUiFromCursor(Cursor cursor) {
        if (cursor != null && cursor.getCount() > 0) {
            return;
        }
        if (this.mEmptyView == null) {
            ViewStub viewStub = (ViewStub)this.getView().findViewById(R.id.home_empty_view_stub);
            this.mEmptyView = viewStub.inflate();
            ImageView imageView = (ImageView)this.mEmptyView.findViewById(R.id.home_empty_image);
            imageView.setImageResource(R.drawable.icon_last_tabs_empty);
            TextView textView = (TextView)this.mEmptyView.findViewById(R.id.home_empty_text);
            textView.setText(R.string.home_last_tabs_empty);
            this.mList.setEmptyView(this.mEmptyView);
        }
    }

    protected void load() {
        this.getLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)this.mCursorLoaderCallbacks);
    }

    public void handleMessage(String string2, NativeJSObject nativeJSObject, EventCallback eventCallback) {
        NativeJSObject[] nativeJSObjectArray = nativeJSObject.getObjectArray("tabs");
        int n = nativeJSObjectArray.length;
        final ClosedTab[] closedTabArray = new ClosedTab[n];
        for (int i = 0; i < n; ++i) {
            NativeJSObject nativeJSObject2 = nativeJSObjectArray[i];
            closedTabArray[i] = new ClosedTab(nativeJSObject2.getString("url"), nativeJSObject2.getString("title"));
        }
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                RecentTabsPanel.access$402(RecentTabsPanel.this, closedTabArray);
                if (RecentTabsPanel.this.getActivity() != null) {
                    RecentTabsPanel.this.getLoaderManager().restartLoader(0, null, (LoaderManager.LoaderCallbacks)RecentTabsPanel.this.mCursorLoaderCallbacks);
                }
            }
        });
    }

    private void openTabsWithType(int n) {
        Cursor cursor = this.mAdapter.getCursor();
        if (cursor == null || !cursor.moveToFirst()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        do {
            if (cursor.getInt(cursor.getColumnIndexOrThrow("type")) != n) continue;
            arrayList.add(cursor.getString(cursor.getColumnIndexOrThrow("url")));
        } while (cursor.moveToNext());
        Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.BUTTON);
        this.mNewTabsListener.onNewTabs(arrayList);
    }

    static /* synthetic */ ClosedTab[] access$402(RecentTabsPanel recentTabsPanel, ClosedTab[] closedTabArray) {
        recentTabsPanel.mClosedTabs = closedTabArray;
        return closedTabArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CursorLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Cursor> {
        private CursorLoaderCallbacks() {
        }

        public Loader<Cursor> onCreateLoader(int n, Bundle bundle) {
            return new RecentTabsCursorLoader((Context)RecentTabsPanel.this.getActivity(), RecentTabsPanel.this.mClosedTabs);
        }

        public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
            RecentTabsPanel.this.mAdapter.swapCursor(cursor);
            RecentTabsPanel.this.updateUiFromCursor(cursor);
        }

        public void onLoaderReset(Loader<Cursor> loader) {
            RecentTabsPanel.this.mAdapter.swapCursor(null);
        }
    }

    private static class RecentTabsAdapter
    extends MultiTypeCursorAdapter {
        private static final int ROW_HEADER = 0;
        private static final int ROW_STANDARD = 1;
        private static final int ROW_OPEN_ALL = 2;
        private static final int[] VIEW_TYPES = new int[]{1, 0, 2};
        private static final int[] LAYOUT_TYPES = new int[]{R.layout.home_item_row, R.layout.home_header_row, R.layout.home_open_all_row};

        public RecentTabsAdapter(Context context) {
            super(context, null, VIEW_TYPES, LAYOUT_TYPES);
        }

        public int getItemViewType(int n) {
            Cursor cursor = this.getCursor(n);
            int n2 = cursor.getInt(cursor.getColumnIndexOrThrow("type"));
            if (n2 == 0) {
                return 0;
            }
            if (n2 == 3 || n2 == 4) {
                return 2;
            }
            return 1;
        }

        public boolean isEnabled(int n) {
            return this.getItemViewType(n) != 0;
        }

        public void bindView(View view, Context context, int n) {
            int n2 = this.getItemViewType(n);
            if (n2 == 2) {
                return;
            }
            Cursor cursor = this.getCursor(n);
            if (n2 == 0) {
                String string2 = cursor.getString(cursor.getColumnIndexOrThrow("title"));
                TextView textView = (TextView)view;
                textView.setText((CharSequence)string2);
            } else if (n2 == 1) {
                TwoLinePageRow twoLinePageRow = (TwoLinePageRow)view;
                twoLinePageRow.updateFromCursor(cursor);
            }
        }
    }

    private static class RecentTabsCursorLoader
    extends SimpleCursorLoader {
        private final ClosedTab[] closedTabs;

        public RecentTabsCursorLoader(Context context, ClosedTab[] closedTabArray) {
            super(context);
            this.closedTabs = closedTabArray;
        }

        private void addRow(MatrixCursor matrixCursor, String string2, String string3, int n) {
            MatrixCursor.RowBuilder rowBuilder = matrixCursor.newRow();
            rowBuilder.add((Object)-1);
            rowBuilder.add((Object)string2);
            rowBuilder.add((Object)string3);
            rowBuilder.add((Object)n);
        }

        public Cursor loadCursor() {
            String string2;
            int n;
            final Context context = this.getContext();
            final MatrixCursor matrixCursor = new MatrixCursor(new String[]{"_id", "url", "title", "type"});
            if (this.closedTabs != null && this.closedTabs.length > 0) {
                int n2 = 0;
                n = this.closedTabs.length;
                for (int i = 0; i < n; ++i) {
                    String string3 = this.closedTabs[i].url;
                    if (AboutPages.isTitlelessAboutPage(string3)) continue;
                    if (n2 == 0) {
                        this.addRow(matrixCursor, null, context.getString(R.string.home_closed_tabs_title), 0);
                    }
                    this.addRow(matrixCursor, string3, this.closedTabs[i].title, 2);
                    ++n2;
                }
                if (n2 > 1) {
                    this.addRow(matrixCursor, null, null, 4);
                }
            }
            if ((string2 = GeckoProfile.get(context).readSessionFile(true)) == null) {
                return matrixCursor;
            }
            n = matrixCursor.getCount();
            new SessionParser(){

                public void onTabRead(SessionParser.SessionTab sessionTab) {
                    String string2 = sessionTab.getUrl();
                    if (AboutPages.isAboutHome(string2)) {
                        return;
                    }
                    if (matrixCursor.getCount() == n) {
                        RecentTabsCursorLoader.this.addRow(matrixCursor, null, context.getString(R.string.home_last_tabs_title), 0);
                    }
                    RecentTabsCursorLoader.this.addRow(matrixCursor, string2, sessionTab.getTitle(), 1);
                }
            }.parse(string2);
            if (matrixCursor.getCount() - n > 2) {
                this.addRow(matrixCursor, null, null, 3);
            }
            return matrixCursor;
        }
    }

    public static final class RecentTabs
    implements BrowserContract.URLColumns,
    BrowserContract.CommonColumns {
        public static final String TYPE = "type";
        public static final int TYPE_HEADER = 0;
        public static final int TYPE_LAST_TIME = 1;
        public static final int TYPE_CLOSED = 2;
        public static final int TYPE_OPEN_ALL_LAST_TIME = 3;
        public static final int TYPE_OPEN_ALL_CLOSED = 4;
    }

    private static final class ClosedTab {
        public final String url;
        public final String title;

        public ClosedTab(String string2, String string3) {
            this.url = string2;
            this.title = string3;
        }
    }
}

