/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.Button;
import java.util.Set;
import org.mozilla.gecko.GeckoSharedPrefs;
import org.mozilla.gecko.R;
import org.mozilla.gecko.preferences.MultiChoicePreference;
import org.mozilla.gecko.util.ThreadUtils;

class MultiPrefMultiChoicePreference
extends MultiChoicePreference {
    private static final String LOGTAG = "GeckoMultiPrefPreference";
    private static final String IMPORT_SUFFIX = "_imported_";
    private final CharSequence[] keys;

    public MultiPrefMultiChoicePreference(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.MultiPrefMultiChoicePreference);
        this.keys = typedArray.getTextArray(0);
        typedArray.recycle();
        this.loadPersistedValues();
    }

    private boolean getPersistedBoolean(SharedPreferences sharedPreferences, String string2, boolean bl) {
        if (!this.isPersistent()) {
            return bl;
        }
        return sharedPreferences.getBoolean(string2, bl);
    }

    protected synchronized void loadPersistedValues() {
        super.loadPersistedValues();
        final SharedPreferences sharedPreferences = GeckoSharedPrefs.forApp(this.getContext());
        boolean bl = this.getPersistedBoolean(sharedPreferences, this.getKey() + IMPORT_SUFFIX, false);
        if (bl) {
            return;
        }
        final CharSequence[] charSequenceArray = this.getInitialValues();
        CharSequence[] charSequenceArray2 = this.getEntries();
        if (this.keys == null || charSequenceArray == null) {
            return;
        }
        final int n = this.keys.length;
        if (n != charSequenceArray2.length || n != charSequenceArray.length) {
            throw new IllegalStateException("MultiChoicePreference entryKeys and initialValues arrays must be the same length");
        }
        final SharedPreferences.Editor editor = sharedPreferences.edit();
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                try {
                    for (int i = 0; i < n; ++i) {
                        String string2 = ((Object)MultiPrefMultiChoicePreference.this.keys[i]).toString();
                        boolean bl = "true".equals(charSequenceArray[i]);
                        boolean bl2 = MultiPrefMultiChoicePreference.this.getPersistedBoolean(sharedPreferences, string2, bl);
                        MultiPrefMultiChoicePreference.this.setValue(i, bl2);
                        editor.remove(string2);
                    }
                    MultiPrefMultiChoicePreference.this.persist(editor);
                    editor.putBoolean(MultiPrefMultiChoicePreference.this.getKey() + MultiPrefMultiChoicePreference.IMPORT_SUFFIX, true);
                    editor.apply();
                }
                catch (Exception exception) {
                    Log.i((String)MultiPrefMultiChoicePreference.LOGTAG, (String)"Err", (Throwable)exception);
                }
            }
        });
    }

    public void onClick(DialogInterface dialogInterface, int n, boolean bl) {
        boolean bl2 = false;
        Set<String> set = this.getValues();
        bl2 = set.size() > 0;
        Button button = ((AlertDialog)dialogInterface).getButton(-1);
        if (button.isEnabled() != bl2) {
            button.setEnabled(bl2);
        }
    }
}

