/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.preferences.CustomListCategory;
import org.mozilla.gecko.preferences.CustomListPreference;
import org.mozilla.gecko.preferences.PanelsPreferenceCategory;

public class PanelsPreference
extends CustomListPreference {
    protected String LOGTAG = "PanelsPreference";
    private static final int STATE_IS_FIRST = 0;
    private static final int STATE_IS_LAST = 1;
    private static final int INDEX_DISPLAY_BUTTON = 1;
    private static final int INDEX_REORDER_BUTTON = 2;
    private static final int INDEX_MOVE_UP_BUTTON = 0;
    private static final int INDEX_MOVE_DOWN_BUTTON = 1;
    private String LABEL_HIDE;
    private String LABEL_SHOW;
    private View preferenceView;
    protected boolean mIsHidden = false;
    private boolean mIsRemovable;
    private boolean mAnimate;
    private static final int ANIMATION_DURATION_MS = 400;
    private int mPositionState = -1;
    private final int mIndex;

    public PanelsPreference(Context context, CustomListCategory customListCategory, boolean bl, int n, boolean bl2) {
        super(context, customListCategory);
        this.mIsRemovable = bl;
        this.mIndex = n;
        this.mAnimate = bl2;
    }

    protected int getPreferenceLayoutResource() {
        return R.layout.preference_panels;
    }

    protected void onBindView(View view) {
        Object object;
        super.onBindView(view);
        view.setEnabled(!this.mIsHidden);
        if (view instanceof ViewGroup) {
            object = (ViewGroup)view;
            for (int i = 0; i < object.getChildCount(); ++i) {
                object.getChildAt(i).setEnabled(!this.mIsHidden);
            }
            this.preferenceView = object;
        }
        if (this.mAnimate) {
            ViewHelper.setAlpha(this.preferenceView, 0.0f);
            object = new PropertyAnimator(400L);
            ((PropertyAnimator)object).attach(this.preferenceView, PropertyAnimator.Property.ALPHA, 1.0f);
            ((PropertyAnimator)object).start();
            this.mAnimate = false;
        }
    }

    protected String[] createDialogItems() {
        Resources resources = this.getContext().getResources();
        String string2 = resources.getString(R.string.pref_panels_reorder);
        if (this.mIsRemovable) {
            return new String[]{this.LABEL_SET_AS_DEFAULT, this.LABEL_REMOVE, string2};
        }
        this.LABEL_HIDE = resources.getString(R.string.pref_panels_hide);
        this.LABEL_SHOW = resources.getString(R.string.pref_panels_show);
        return new String[]{this.LABEL_SET_AS_DEFAULT, this.LABEL_HIDE, string2};
    }

    public void setIsDefault(boolean bl) {
        this.mIsDefault = bl;
        if (bl) {
            this.setSummary(this.LABEL_IS_DEFAULT);
            if (this.mIsHidden) {
                this.setHidden(false);
            }
        } else {
            this.setSummary("");
        }
    }

    protected void onDialogIndexClicked(int n) {
        switch (n) {
            case 0: {
                this.mParentCategory.setDefault(this);
                break;
            }
            case 1: {
                if (this.mIsRemovable) {
                    this.mParentCategory.uninstall(this);
                    break;
                }
                ((PanelsPreferenceCategory)this.mParentCategory).setHidden(this, !this.mIsHidden);
                break;
            }
            case 2: {
                Dialog dialog = this.makeReorderDialog();
                dialog.show();
                break;
            }
            default: {
                Log.w((String)this.LOGTAG, (String)("Selected index out of range: " + n));
            }
        }
    }

    protected void configureShownDialog() {
        super.configureShownDialog();
        if (!this.mIsRemovable) {
            TextView textView = (TextView)this.mDialog.getListView().getChildAt(1);
            textView.setText((CharSequence)(this.mIsHidden ? this.LABEL_SHOW : this.LABEL_HIDE));
        }
    }

    private Dialog makeReorderDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
        Resources resources = this.getContext().getResources();
        String string2 = resources.getString(R.string.pref_panels_move_up);
        String string3 = resources.getString(R.string.pref_panels_move_down);
        builder.setTitle(this.getTitle());
        builder.setItems((CharSequence[])new String[]{string2, string3}, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                dialogInterface.dismiss();
                switch (n) {
                    case 0: {
                        ((PanelsPreferenceCategory)PanelsPreference.this.mParentCategory).moveUp(PanelsPreference.this);
                        break;
                    }
                    case 1: {
                        ((PanelsPreferenceCategory)PanelsPreference.this.mParentCategory).moveDown(PanelsPreference.this);
                    }
                }
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialogInterface) {
                PanelsPreference.this.setReorderItemsEnabled(dialogInterface);
            }
        });
        return alertDialog;
    }

    public void setIsFirst() {
        this.mPositionState = 0;
    }

    public void setIsLast() {
        this.mPositionState = 1;
    }

    private void setReorderItemsEnabled(DialogInterface dialogInterface) {
        switch (this.mPositionState) {
            case 0: {
                TextView textView = (TextView)((AlertDialog)dialogInterface).getListView().getChildAt(0);
                textView.setEnabled(false);
                textView.setOnClickListener(null);
                break;
            }
            case 1: {
                TextView textView = (TextView)((AlertDialog)dialogInterface).getListView().getChildAt(1);
                textView.setEnabled(false);
                textView.setOnClickListener(null);
                break;
            }
        }
    }

    public void setHidden(boolean bl) {
        if (bl) {
            this.setIsDefault(false);
        }
        if (this.mIsHidden != bl) {
            this.mIsHidden = bl;
            this.notifyChanged();
        }
    }

    public boolean isHidden() {
        return this.mIsHidden;
    }

    public int getIndex() {
        return this.mIndex;
    }
}

