/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.receivers;

import android.accounts.AccountManager;
import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.Sync11Configuration;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.config.AccountPickler;
import org.mozilla.gecko.sync.config.ClientRecordTerminator;
import org.mozilla.gecko.sync.net.BasicAuthHeaderProvider;
import org.mozilla.gecko.sync.setup.SyncAccounts;

public class SyncAccountDeletedService
extends IntentService {
    public static final String LOG_TAG = "SyncAccountDeletedService";

    public SyncAccountDeletedService() {
        super(LOG_TAG);
    }

    protected void onHandleIntent(Intent intent) {
        SyncAccounts.SyncAccountParameters syncAccountParameters;
        long l;
        if (intent == null) {
            Logger.debug(LOG_TAG, "Short-circuiting on null intent.");
            return;
        }
        SyncAccountDeletedService syncAccountDeletedService = this;
        long l2 = intent.getLongExtra("version", 0L);
        if (l2 != (l = 1L)) {
            Logger.warn(LOG_TAG, "Intent malformed: version " + l2 + " given but version " + l + "expected. " + "Not cleaning up after deleted Account.");
            return;
        }
        String string2 = intent.getStringExtra("account");
        if (string2 == null) {
            Logger.warn(LOG_TAG, "Intent malformed: no account name given. Not cleaning up after deleted Account.");
            return;
        }
        Logger.info(LOG_TAG, "Sync account named " + string2 + " being removed; " + "deleting saved pickle file '" + "sync.account.json" + "'.");
        SyncAccountDeletedService.deletePickle((Context)syncAccountDeletedService);
        try {
            String string3 = intent.getStringExtra("payload");
            if (string3 == null) {
                Logger.warn(LOG_TAG, "Intent malformed: no payload given. Not deleting client record.");
                return;
            }
            ExtendedJSONObject extendedJSONObject = ExtendedJSONObject.parseJSONObject(string3);
            syncAccountParameters = new SyncAccounts.SyncAccountParameters((Context)syncAccountDeletedService, AccountManager.get((Context)syncAccountDeletedService), extendedJSONObject);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception fetching account parameters from intent data; not deleting client record.");
            return;
        }
        Logger.info(LOG_TAG, "Account named " + string2 + " being removed; " + "deleting client record from server.");
        SyncAccountDeletedService.deleteClientRecord((Context)syncAccountDeletedService, string2, syncAccountParameters.password, syncAccountParameters.serverURL);
    }

    public static void deletePickle(Context context) {
        try {
            AccountPickler.deletePickle(context, "sync.account.json");
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception deleting saved pickle file; ignoring.", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteClientRecord(Context context, String string2, String string3, String string4) {
        SharedPreferences sharedPreferences;
        String string5;
        try {
            string5 = Utils.usernameFromAccount(string2);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Got exception deleting client record from server; ignoring.", exception);
            return;
        }
        if (string2 == null || string5 == null || string3 == null || string4 == null) {
            Logger.warn(LOG_TAG, "Account parameters were null; not deleting client record from server.");
            return;
        }
        try {
            sharedPreferences = Utils.getSharedPreferences(context, "org.mozilla.fennec", string5, string4, "default", 1L);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Caught exception fetching preferences; not deleting client record from server.", exception);
            return;
        }
        try {
            String string6 = sharedPreferences.getString("account.guid", null);
            if (string6 == null) {
                Logger.warn(LOG_TAG, "Client GUID was null; not deleting client record from server.");
                return;
            }
            BasicAuthHeaderProvider basicAuthHeaderProvider = new BasicAuthHeaderProvider(string5, string3);
            Sync11Configuration sync11Configuration = new Sync11Configuration(string5, basicAuthHeaderProvider, sharedPreferences);
            if (sync11Configuration.getClusterURL() == null) {
                Logger.warn(LOG_TAG, "Cluster URL was null; not deleting client record from server.");
                return;
            }
            try {
                ClientRecordTerminator.deleteClientRecord(sync11Configuration, string6);
            }
            catch (Exception exception) {
                Logger.warn(LOG_TAG, "Got exception deleting client record from server; ignoring.", exception);
            }
        }
        finally {
            sharedPreferences.edit().clear().commit();
        }
    }
}

