/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.stage;

import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.CollectionKeys;
import org.mozilla.gecko.sync.CryptoRecord;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.InfoCollections;
import org.mozilla.gecko.sync.NoCollectionKeysSetException;
import org.mozilla.gecko.sync.crypto.KeyBundle;
import org.mozilla.gecko.sync.crypto.PersistedCrypto5Keys;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;
import org.mozilla.gecko.sync.net.SyncStorageRecordRequest;
import org.mozilla.gecko.sync.net.SyncStorageRequest;
import org.mozilla.gecko.sync.net.SyncStorageRequestDelegate;
import org.mozilla.gecko.sync.net.SyncStorageResponse;
import org.mozilla.gecko.sync.stage.AbstractNonRepositorySyncStage;
import org.mozilla.gecko.sync.stage.GlobalSyncStage;
import org.mozilla.gecko.sync.stage.NoSuchStageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnsureCrypto5KeysStage
extends AbstractNonRepositorySyncStage
implements SyncStorageRequestDelegate {
    private static final String LOG_TAG = "EnsureC5KeysStage";
    private static final String CRYPTO_COLLECTION = "crypto";
    protected boolean retrying = false;

    @Override
    public void execute() throws NoSuchStageException {
        Object object;
        InfoCollections infoCollections = this.session.config.infoCollections;
        if (infoCollections == null) {
            this.session.abort(null, "No info/collections set in EnsureCrypto5KeysStage.");
            return;
        }
        PersistedCrypto5Keys persistedCrypto5Keys = this.session.config.persistedCryptoKeys();
        long l = persistedCrypto5Keys.lastModified();
        if (this.retrying || !infoCollections.updateNeeded(CRYPTO_COLLECTION, l)) {
            Logger.debug(LOG_TAG, "Trying to use persisted collection keys for this session.");
            object = persistedCrypto5Keys.keys();
            if (object != null) {
                Logger.trace(LOG_TAG, "Using persisted collection keys for this session.");
                this.session.config.setCollectionKeys((CollectionKeys)object);
                this.session.advance();
                return;
            }
            Logger.trace(LOG_TAG, "Failed to use persisted collection keys for this session.");
        }
        Logger.debug(LOG_TAG, "Fetching fresh collection keys for this session.");
        try {
            object = new SyncStorageRecordRequest(this.session.wboURI(CRYPTO_COLLECTION, "keys"));
            ((SyncStorageRecordRequest)object).delegate = this;
            ((SyncStorageRequest)object).get();
        }
        catch (URISyntaxException uRISyntaxException) {
            this.session.abort(uRISyntaxException, "Invalid URI.");
        }
    }

    @Override
    public AuthHeaderProvider getAuthHeaderProvider() {
        return this.session.getAuthHeaderProvider();
    }

    @Override
    public String ifUnmodifiedSince() {
        return null;
    }

    protected void setAndPersist(PersistedCrypto5Keys persistedCrypto5Keys, CollectionKeys collectionKeys, long l) {
        this.session.config.setCollectionKeys(collectionKeys);
        persistedCrypto5Keys.persistKeys(collectionKeys);
        persistedCrypto5Keys.persistLastModified(l);
    }

    protected Set<String> collectionsToUpdate(CollectionKeys collectionKeys, CollectionKeys collectionKeys2) {
        HashSet<String> hashSet = new HashSet<String>(CollectionKeys.differences(collectionKeys, collectionKeys2));
        boolean bl = true;
        KeyBundle keyBundle = null;
        try {
            KeyBundle keyBundle2 = collectionKeys.defaultKeyBundle();
            keyBundle = collectionKeys2.defaultKeyBundle();
            bl = !keyBundle2.equals(keyBundle);
        }
        catch (NoCollectionKeysSetException noCollectionKeysSetException) {
            Logger.warn(LOG_TAG, "NoCollectionKeysSetException in EnsureCrypto5KeysStage.", noCollectionKeysSetException);
        }
        if (keyBundle == null) {
            Logger.trace(LOG_TAG, "New default key not provided; returning changed individual keys.");
            return hashSet;
        }
        if (!bl) {
            Logger.trace(LOG_TAG, "New default key is the same as old default key; returning changed individual keys.");
            return hashSet;
        }
        Logger.debug(LOG_TAG, "New default key is not the same as old default key.");
        for (GlobalSyncStage.Stage stage : GlobalSyncStage.Stage.getNamedStages()) {
            String string2 = stage.getRepositoryName();
            if (collectionKeys2.keyBundleForCollectionIsNotDefault(string2)) continue;
            hashSet.add(string2);
        }
        return hashSet;
    }

    @Override
    public void handleRequestSuccess(SyncStorageResponse syncStorageResponse) {
        Object object;
        long l = syncStorageResponse.normalizedWeaveTimestamp();
        CollectionKeys collectionKeys = new CollectionKeys();
        try {
            object = syncStorageResponse.jsonObjectBody();
            if (Logger.LOG_PERSONAL_INFORMATION) {
                Logger.pii(LOG_TAG, "Fetched keys: " + ((ExtendedJSONObject)object).toJSONString());
            }
            collectionKeys.setKeyPairsFromWBO(CryptoRecord.fromJSONRecord((ExtendedJSONObject)object), this.session.config.syncKeyBundle);
        }
        catch (Exception exception) {
            this.session.abort(exception, "Invalid keys WBO.");
            return;
        }
        object = this.session.config.persistedCryptoKeys();
        if (!((PersistedCrypto5Keys)object).persistedKeysExist()) {
            Logger.trace(LOG_TAG, "Setting fetched keys for this session; persisting fetched keys and last modified.");
            this.setAndPersist((PersistedCrypto5Keys)object, collectionKeys, l);
            this.session.advance();
            return;
        }
        CollectionKeys collectionKeys2 = ((PersistedCrypto5Keys)object).keys();
        Set<String> set = this.collectionsToUpdate(collectionKeys2, collectionKeys);
        if (!set.isEmpty()) {
            Logger.trace(LOG_TAG, "Fetched keys are not the same as persisted keys; setting fetched keys for this session before resetting changed engines.");
            this.setAndPersist((PersistedCrypto5Keys)object, collectionKeys, l);
            this.session.resetStagesByName(set);
            this.session.abort(null, "crypto/keys changed on server.");
            return;
        }
        Logger.trace(LOG_TAG, "Fetched keys are the same as persisted keys; persisting only last modified.");
        this.session.config.setCollectionKeys(collectionKeys2);
        ((PersistedCrypto5Keys)object).persistLastModified(syncStorageResponse.normalizedWeaveTimestamp());
        this.session.advance();
    }

    @Override
    public void handleRequestFailure(SyncStorageResponse syncStorageResponse) {
        if (this.retrying) {
            this.session.handleHTTPError(syncStorageResponse, "Failure while re-downloading already uploaded keys.");
            return;
        }
        int n = syncStorageResponse.getStatusCode();
        if (n == 404) {
            Logger.info(LOG_TAG, "Got 404 fetching keys.  Fresh starting since keys are missing on server.");
            this.session.freshStart();
            return;
        }
        this.session.handleHTTPError(syncStorageResponse, "Failure fetching keys: got response status code " + n);
    }

    @Override
    public void handleRequestError(Exception exception) {
        this.session.abort(exception, "Failure fetching keys.");
    }
}

