/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.syncadapter;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.content.AbstractThreadedSyncAdapter;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.SyncResult;
import android.database.sqlite.SQLiteConstraintException;
import android.database.sqlite.SQLiteException;
import android.os.Bundle;
import java.io.IOException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.simple.parser.ParseException;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.AlreadySyncingException;
import org.mozilla.gecko.sync.BackoffHandler;
import org.mozilla.gecko.sync.CredentialException;
import org.mozilla.gecko.sync.GlobalSession;
import org.mozilla.gecko.sync.NonObjectJSONException;
import org.mozilla.gecko.sync.PrefsBackoffHandler;
import org.mozilla.gecko.sync.SharedPreferencesClientsDataDelegate;
import org.mozilla.gecko.sync.SharedPreferencesNodeAssignmentCallback;
import org.mozilla.gecko.sync.Sync11Configuration;
import org.mozilla.gecko.sync.SyncConfiguration;
import org.mozilla.gecko.sync.SyncConfigurationException;
import org.mozilla.gecko.sync.SyncException;
import org.mozilla.gecko.sync.ThreadPool;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.config.AccountPickler;
import org.mozilla.gecko.sync.crypto.CryptoException;
import org.mozilla.gecko.sync.crypto.KeyBundle;
import org.mozilla.gecko.sync.delegates.BaseGlobalSessionCallback;
import org.mozilla.gecko.sync.delegates.ClientsDataDelegate;
import org.mozilla.gecko.sync.net.BasicAuthHeaderProvider;
import org.mozilla.gecko.sync.net.ConnectionMonitorThread;
import org.mozilla.gecko.sync.setup.SyncAccounts;
import org.mozilla.gecko.sync.stage.GlobalSyncStage;

public class SyncAdapter
extends AbstractThreadedSyncAdapter
implements BaseGlobalSessionCallback {
    private static final String LOG_TAG = "SyncAdapter";
    private static final int BACKOFF_PAD_SECONDS = 5;
    public static final int MULTI_DEVICE_INTERVAL_MILLISECONDS = 300000;
    public static final int SINGLE_DEVICE_INTERVAL_MILLISECONDS = 86400000;
    private final Context mContext;
    protected long syncStartTimestamp;
    protected volatile BackoffHandler backoffHandler;
    public Object syncMonitor = new Object();
    private SyncResult syncResult;
    protected Account localAccount;
    protected boolean thisSyncIsForced = false;
    protected SharedPreferences accountSharedPreferences;
    protected SharedPreferencesClientsDataDelegate clientsDataDelegate;
    protected SharedPreferencesNodeAssignmentCallback nodeAssignmentDelegate;

    public SyncAdapter(Context context, boolean bl) {
        super(context, bl);
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processException(GlobalSession globalSession, Exception exception) {
        try {
            if (exception instanceof SQLiteConstraintException) {
                Logger.error(LOG_TAG, "Constraint exception. Aborting sync.", exception);
                ++this.syncResult.stats.numParseExceptions;
                return;
            }
            if (exception instanceof SQLiteException) {
                Logger.error(LOG_TAG, "Couldn't open database (locked?). Aborting sync.", exception);
                ++this.syncResult.stats.numIoExceptions;
                return;
            }
            if (exception instanceof OperationCanceledException) {
                Logger.error(LOG_TAG, "Operation canceled. Aborting sync.", exception);
                return;
            }
            if (exception instanceof AuthenticatorException) {
                ++this.syncResult.stats.numParseExceptions;
                Logger.error(LOG_TAG, "AuthenticatorException. Aborting sync.", exception);
                return;
            }
            if (exception instanceof IOException) {
                ++this.syncResult.stats.numIoExceptions;
                Logger.error(LOG_TAG, "IOException. Aborting sync.", exception);
                exception.printStackTrace();
                return;
            }
            if (exception instanceof SyncException) {
                ((SyncException)exception).updateStats(globalSession, this.syncResult);
            } else {
                ++this.syncResult.stats.numIoExceptions;
            }
            if (exception instanceof CredentialException.MissingAllCredentialsException) {
                if (this.localAccount == null) {
                    Logger.error(LOG_TAG, "No credentials attached to account. Aborting sync.");
                    return;
                }
                Logger.error(LOG_TAG, "No credentials attached to account " + this.localAccount.name + ". Aborting sync.");
                try {
                    SyncAccounts.setSyncAutomatically(this.localAccount, false);
                }
                catch (Exception exception2) {
                    Logger.error(LOG_TAG, "Unable to disable account " + this.localAccount.name + ".", exception2);
                }
                return;
            }
            if (exception instanceof CredentialException.MissingCredentialException) {
                Logger.error(LOG_TAG, "Credentials attached to account, but missing " + ((CredentialException.MissingCredentialException)exception).missingCredential + ". Aborting sync.");
                return;
            }
            if (exception instanceof CredentialException) {
                Logger.error(LOG_TAG, "Credentials attached to account were bad.");
                return;
            }
            if (exception instanceof SecurityException) {
                Logger.error(LOG_TAG, "SecurityException, multiple Fennecs. Disabling this instance.", exception);
                SyncAccounts.backgroundSetSyncAutomatically(this.localAccount, false);
                return;
            }
            Logger.error(LOG_TAG, "Unknown exception. Aborting sync.", exception);
        }
        finally {
            this.notifyMonitor();
        }
    }

    public void onSyncCanceled() {
        super.onSyncCanceled();
    }

    public void requestBackoff(long l) {
        if (this.backoffHandler == null) {
            throw new IllegalStateException("No backoff handler: requesting backoff outside run()?");
        }
        if (l > 0L) {
            long l2 = l + Math.round((double)l * 0.25 * Math.random());
            this.backoffHandler.extendEarliestNextRequest(System.currentTimeMillis() + l2);
        }
    }

    public boolean shouldBackOffStorage() {
        if (this.thisSyncIsForced) {
            return false;
        }
        if (this.nodeAssignmentDelegate.wantNodeAssignment()) {
            return false;
        }
        if (this.backoffHandler == null) {
            throw new IllegalStateException("No backoff handler: checking backoff outside run()?");
        }
        return this.backoffHandler.delayMilliseconds() > 0L;
    }

    public static void requestImmediateSync(Account account, String[] stringArray) {
        SyncAdapter.requestImmediateSync(account, stringArray, null);
    }

    public static void requestImmediateSync(Account account, String[] stringArray, Bundle bundle) {
        if (account == null) {
            Logger.warn(LOG_TAG, "Not requesting immediate sync because Android Account is null.");
            return;
        }
        Bundle bundle2 = new Bundle();
        Utils.putStageNamesToSync(bundle2, stringArray, null);
        bundle2.putBoolean("force", true);
        if (bundle != null) {
            bundle2.putAll(bundle);
        }
        ContentResolver.requestSync((Account)account, (String)"org.mozilla.fennec.db.browser", (Bundle)bundle2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPerformSync(final Account account, final Bundle bundle, final String string2, final ContentProviderClient contentProviderClient, final SyncResult syncResult) {
        SyncAccounts.SyncAccountParameters syncAccountParameters;
        this.syncStartTimestamp = System.currentTimeMillis();
        Logger.setThreadLogTag("FxSync");
        Logger.resetLogging();
        Utils.reseedSharedRandom();
        this.syncResult = syncResult;
        this.localAccount = account;
        try {
            syncAccountParameters = SyncAccounts.blockingFromAndroidAccountV0(this.mContext, AccountManager.get((Context)this.mContext), this.localAccount);
        }
        catch (Exception exception) {
            this.processException(null, exception);
            return;
        }
        final String string3 = syncAccountParameters.username;
        final String string4 = syncAccountParameters.password;
        final String string5 = syncAccountParameters.serverURL;
        final String string6 = syncAccountParameters.syncKey;
        final AtomicBoolean atomicBoolean = new AtomicBoolean(true);
        final SyncAdapter syncAdapter = this;
        Runnable runnable = new Runnable(){

            public void run() {
                Logger.trace(SyncAdapter.LOG_TAG, "AccountManagerCallback invoked.");
                try {
                    boolean bl;
                    if (Logger.LOG_PERSONAL_INFORMATION) {
                        Logger.pii(SyncAdapter.LOG_TAG, "Syncing account named " + account.name + " for authority " + string2 + ".");
                    } else {
                        Logger.info(SyncAdapter.LOG_TAG, "Syncing account named like " + Utils.obfuscateEmail(account.name) + " for authority " + string2 + ".");
                    }
                    Logger.debug(SyncAdapter.LOG_TAG, "Username: " + string3);
                    Logger.debug(SyncAdapter.LOG_TAG, "Server:   " + string5);
                    if (Logger.LOG_PERSONAL_INFORMATION) {
                        Logger.debug(SyncAdapter.LOG_TAG, "Password: " + string4);
                        Logger.debug(SyncAdapter.LOG_TAG, "Sync key: " + string6);
                    } else {
                        Logger.debug(SyncAdapter.LOG_TAG, "Password? " + (string4 != null));
                        Logger.debug(SyncAdapter.LOG_TAG, "Sync key? " + (string6 != null));
                    }
                    syncAdapter.accountSharedPreferences = Utils.getSharedPreferences(SyncAdapter.this.mContext, "org.mozilla.fennec", string3, string5, "default", 1L);
                    syncAdapter.clientsDataDelegate = new SharedPreferencesClientsDataDelegate(SyncAdapter.this.accountSharedPreferences, SyncAdapter.this.mContext);
                    syncAdapter.backoffHandler = new PrefsBackoffHandler(SyncAdapter.this.accountSharedPreferences, "sync");
                    String string22 = Utils.nodeWeaveURL(string5, string3);
                    syncAdapter.nodeAssignmentDelegate = new SharedPreferencesNodeAssignmentCallback(SyncAdapter.this.accountSharedPreferences, string22);
                    Logger.info(SyncAdapter.LOG_TAG, "Client is named '" + SyncAdapter.this.clientsDataDelegate.getClientName() + "'" + ", has client guid " + SyncAdapter.this.clientsDataDelegate.getAccountGUID() + ", and has " + SyncAdapter.this.clientsDataDelegate.getClientsCount() + " clients.");
                    boolean bl2 = bundle != null && bundle.getBoolean("force", false);
                    long l = SyncAdapter.this.backoffHandler.delayMilliseconds();
                    boolean bl3 = bl = bl2 || l <= 0L;
                    if (!bl) {
                        long l2 = l / 1000L;
                        syncResult.delayUntil = l2 + 5L;
                        atomicBoolean.set(false);
                        syncAdapter.notifyMonitor();
                        return;
                    }
                    String string32 = Utils.getPrefsPath("org.mozilla.fennec", string3, string5, "default", 1L);
                    syncAdapter.performSync(account, bundle, string2, contentProviderClient, syncResult, string3, string4, string32, string5, string6);
                }
                catch (Exception exception) {
                    syncAdapter.processException(null, exception);
                    return;
                }
            }
        };
        Object object = this.syncMonitor;
        synchronized (object) {
            new Thread(runnable).start();
            ConnectionMonitorThread connectionMonitorThread = new ConnectionMonitorThread();
            connectionMonitorThread.start();
            Logger.trace(LOG_TAG, "Waiting on sync monitor.");
            try {
                this.syncMonitor.wait();
                if (atomicBoolean.get()) {
                    long l = this.getSyncInterval(this.clientsDataDelegate);
                    long l2 = System.currentTimeMillis() + l;
                    if (this.thisSyncIsForced) {
                        Logger.info(LOG_TAG, "Setting minimum next sync time to " + l2 + " (" + l + "ms from now).");
                        syncAdapter.backoffHandler.setEarliestNextRequest(l2);
                    } else {
                        Logger.info(LOG_TAG, "Extending minimum next sync time to " + l2 + " (" + l + "ms from now).");
                        syncAdapter.backoffHandler.extendEarliestNextRequest(l2);
                    }
                }
                Logger.info(LOG_TAG, "Sync took " + Utils.formatDuration(this.syncStartTimestamp, System.currentTimeMillis()) + ".");
            }
            catch (InterruptedException interruptedException) {
                Logger.warn(LOG_TAG, "Waiting on sync monitor interrupted.", interruptedException);
            }
            finally {
                connectionMonitorThread.shutdown();
            }
        }
    }

    public int getSyncInterval(ClientsDataDelegate clientsDataDelegate) {
        if (this.localAccount == null) {
            return 86400000;
        }
        int n = clientsDataDelegate.getClientsCount();
        if (n <= 1) {
            return 86400000;
        }
        return 300000;
    }

    protected void performSync(final Account account, Bundle bundle, final String string2, ContentProviderClient contentProviderClient, SyncResult syncResult, String string3, String string4, String string5, String string6, String string7) throws NoSuchAlgorithmException, SyncConfigurationException, IllegalArgumentException, AlreadySyncingException, IOException, ParseException, NonObjectJSONException, CryptoException {
        Object object;
        Logger.trace(LOG_TAG, "Performing sync.");
        try {
            object = new SyncAccounts.SyncAccountParameters(this.mContext, null, account.name, string7, string4, string6, null, this.clientsDataDelegate.getClientName(), this.clientsDataDelegate.getAccountGUID());
            ThreadPool.run(new Runnable((SyncAccounts.SyncAccountParameters)object){
                final /* synthetic */ SyncAccounts.SyncAccountParameters val$params;
                {
                    this.val$params = syncAccountParameters;
                }

                public void run() {
                    boolean bl = ContentResolver.getSyncAutomatically((Account)account, (String)string2);
                    try {
                        AccountPickler.pickle(SyncAdapter.this.mContext, "sync.account.json", this.val$params, bl);
                    }
                    catch (Exception exception) {
                        Logger.warn(SyncAdapter.LOG_TAG, "Got exception pickling current account details; ignoring.", exception);
                    }
                }
            });
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (string3 == null) {
            throw new IllegalArgumentException("username must not be null.");
        }
        if (string7 == null) {
            throw new SyncConfigurationException();
        }
        object = new KeyBundle(string3, string7);
        if (object == null || ((KeyBundle)object).getEncryptionKey() == null || ((KeyBundle)object).getHMACKey() == null) {
            throw new SyncConfigurationException();
        }
        BasicAuthHeaderProvider basicAuthHeaderProvider = new BasicAuthHeaderProvider(string3, string4);
        SharedPreferences sharedPreferences = this.getContext().getSharedPreferences(string5, 0);
        Sync11Configuration sync11Configuration = new Sync11Configuration(string3, basicAuthHeaderProvider, sharedPreferences, (KeyBundle)object);
        Set<String> set = SyncConfiguration.validEngineNames();
        sync11Configuration.stagesToSync = Utils.getStagesToSyncFromBundle(set, bundle);
        GlobalSession globalSession = new GlobalSession(sync11Configuration, this, this.mContext, this.clientsDataDelegate, this.nodeAssignmentDelegate);
        globalSession.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyMonitor() {
        Object object = this.syncMonitor;
        synchronized (object) {
            Logger.trace(LOG_TAG, "Notifying sync monitor.");
            this.syncMonitor.notifyAll();
        }
    }

    public void handleError(GlobalSession globalSession, Exception exception) {
        Logger.info(LOG_TAG, "GlobalSession indicated error.");
        this.processException(globalSession, exception);
    }

    public void handleAborted(GlobalSession globalSession, String string2) {
        Logger.warn(LOG_TAG, "Sync aborted: " + string2);
        this.notifyMonitor();
    }

    public void handleSuccess(GlobalSession globalSession) {
        Logger.info(LOG_TAG, "GlobalSession indicated success.");
        globalSession.config.persistToPrefs();
        this.notifyMonitor();
    }

    public void handleStageCompleted(GlobalSyncStage.Stage stage, GlobalSession globalSession) {
        Logger.trace(LOG_TAG, "Stage completed: " + (Object)((Object)stage));
    }

    public void informUnauthorizedResponse(GlobalSession globalSession, URI uRI) {
        this.nodeAssignmentDelegate.setClusterURLIsStale(true);
    }

    public void informUpgradeRequiredResponse(GlobalSession globalSession) {
        final AccountManager accountManager = AccountManager.get((Context)this.mContext);
        final Account account = this.localAccount;
        if (account == null || accountManager == null) {
            Logger.warn(LOG_TAG, "Attempting to disable account, but null found.");
            return;
        }
        ThreadPool.run(new Runnable(){

            public void run() {
                accountManager.setUserData(account, "data.enableOnUpgrade", "1");
                SyncAccounts.setSyncAutomatically(account, false);
            }
        });
    }
}

