/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabspanel;

import android.content.Context;
import android.text.TextUtils;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.SimpleExpandableListAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.TabsAccessor;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.tabspanel.TabsPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemoteTabsList
extends ExpandableListView
implements ExpandableListView.OnGroupClickListener,
ExpandableListView.OnChildClickListener,
TabsAccessor.OnQueryTabsCompleteListener {
    private static final String[] CLIENT_KEY = new String[]{"name", "last_synced"};
    private static final String[] TAB_KEY = new String[]{"title", "url"};
    private static final int[] CLIENT_RESOURCE = new int[]{R.id.client, R.id.last_synced};
    private static final int[] TAB_RESOURCE = new int[]{R.id.tab, R.id.url};
    private final Context context;
    private TabsPanel tabsPanel;
    private ArrayList<HashMap<String, String>> clients;
    private ArrayList<ArrayList<HashMap<String, String>>> tabsList;
    private List<String> expandedClientList;
    private String clientScrollPosition;

    public RemoteTabsList(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.context = context;
        this.setOnGroupClickListener(this);
        this.setOnChildClickListener(this);
    }

    public void setTabsPanel(TabsPanel tabsPanel) {
        this.tabsPanel = tabsPanel;
    }

    private void autoHidePanel() {
        this.tabsPanel.autoHidePanel();
    }

    public boolean onGroupClick(ExpandableListView expandableListView, View view, int n, long l) {
        String string2 = this.clients.get(n).get("guid");
        if (this.isGroupExpanded(n)) {
            this.collapseGroup(n);
            this.expandedClientList.remove(string2);
        } else {
            this.expandGroup(n);
            this.expandedClientList.add(string2);
        }
        this.clientScrollPosition = string2;
        return true;
    }

    public boolean onChildClick(ExpandableListView expandableListView, View view, int n, int n2, long l) {
        HashMap<String, String> hashMap = this.tabsList.get(n).get(n2);
        if (hashMap == null) {
            this.autoHidePanel();
            return true;
        }
        Telemetry.sendUIEvent(TelemetryContract.Event.LOAD_URL, TelemetryContract.Method.LIST_ITEM, "remote");
        Tabs.getInstance().loadUrl(hashMap.get("url"), 1);
        this.autoHidePanel();
        this.clientScrollPosition = this.clients.get(n).get("guid");
        return true;
    }

    @Override
    public void onQueryTabsComplete(List<TabsAccessor.RemoteTab> list) {
        String string2;
        ArrayList<TabsAccessor.RemoteTab> arrayList = new ArrayList<TabsAccessor.RemoteTab>(list);
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        this.clients = new ArrayList();
        this.tabsList = new ArrayList();
        String string3 = null;
        ArrayList<HashMap<String, String>> arrayList2 = null;
        long l = System.currentTimeMillis();
        for (TabsAccessor.RemoteTab remoteTab : arrayList) {
            string2 = remoteTab.guid;
            if (string3 == null || !TextUtils.equals(string3, (CharSequence)string2)) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("name", remoteTab.name);
                hashMap.put("last_synced", this.getLastSyncedString(l, remoteTab.lastModified));
                hashMap.put("guid", string2);
                this.clients.add(hashMap);
                arrayList2 = new ArrayList<HashMap<String, String>>();
                this.tabsList.add(arrayList2);
                string3 = new String(string2);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("title", TextUtils.isEmpty((CharSequence)remoteTab.title) ? remoteTab.url : remoteTab.title);
            hashMap.put("url", remoteTab.url);
            arrayList2.add(hashMap);
        }
        this.setAdapter((ExpandableListAdapter)new SimpleExpandableListAdapter(this.context, this.clients, R.layout.remote_tabs_group, CLIENT_KEY, CLIENT_RESOURCE, this.tabsList, R.layout.remote_tabs_child, TAB_KEY, TAB_RESOURCE));
        ArrayList arrayList3 = new ArrayList();
        for (int i = 0; i < this.clients.size(); ++i) {
            string2 = this.clients.get(i).get("guid");
            if (this.expandedClientList == null) {
                arrayList3.add(string2);
                this.expandGroup(i);
                continue;
            }
            if (this.expandedClientList.contains(string2)) {
                arrayList3.add(string2);
                this.expandGroup(i);
            }
            if (!string2.equals(this.clientScrollPosition)) continue;
            this.setSelectedGroup(i);
        }
        this.expandedClientList = arrayList3;
    }

    protected String getLastSyncedString(long l, long l2) {
        CharSequence charSequence = DateUtils.getRelativeTimeSpanString((long)l2, (long)l, (long)60000L);
        return this.getResources().getString(R.string.remote_tabs_last_synced, new Object[]{charSequence});
    }
}

