/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabspanel;

import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import java.util.Locale;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.fxa.FirefoxAccounts;
import org.mozilla.gecko.fxa.activities.FxAccountCreateAccountActivity;
import org.mozilla.gecko.tabspanel.TabsPanel;

class RemoteTabsSetupPanel
extends ScrollView
implements TabsPanel.PanelView {
    private final LinearLayout containingLayout;
    private TabsPanel tabsPanel;

    public RemoteTabsSetupPanel(Context context) {
        super(context);
        LayoutInflater.from((Context)context).inflate(R.layout.remote_tabs_setup_panel, (ViewGroup)this);
        this.containingLayout = (LinearLayout)this.findViewById(R.id.remote_tabs_setup_containing_layout);
        View view = this.containingLayout.findViewById(R.id.remote_tabs_setup_get_started);
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Context context = RemoteTabsSetupPanel.this.getContext();
                Intent intent = new Intent(context, FxAccountCreateAccountActivity.class);
                intent.setFlags(0x10000000);
                context.startActivity(intent);
            }
        });
        View view2 = this.containingLayout.findViewById(R.id.remote_tabs_setup_old_sync_link);
        view2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String string2 = FirefoxAccounts.getOldSyncUpgradeURL(RemoteTabsSetupPanel.this.getResources(), Locale.getDefault());
                Tabs.getInstance().loadUrlInTab(string2);
                if (RemoteTabsSetupPanel.this.tabsPanel != null) {
                    RemoteTabsSetupPanel.this.tabsPanel.autoHidePanel();
                }
            }
        });
    }

    public void setTabsPanel(TabsPanel tabsPanel) {
        this.tabsPanel = tabsPanel;
    }

    public void show() {
        this.setVisibility(0);
    }

    public void hide() {
        this.setVisibility(8);
    }

    public boolean shouldExpand() {
        return this.containingLayout.getOrientation() == 1;
    }
}

