/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.client.protocol;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HeaderElement;
import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpException;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.HttpResponseInterceptor;
import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.client.entity.DeflateDecompressingEntity;
import ch.boye.httpclientandroidlib.client.entity.GzipDecompressingEntity;
import ch.boye.httpclientandroidlib.protocol.HttpContext;
import java.io.IOException;
import java.util.Locale;

@Immutable
public class ResponseContentEncoding
implements HttpResponseInterceptor {
    public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        HeaderElement[] headerElementArray;
        HeaderElement[] headerElementArray2;
        int n;
        int n2;
        Header header;
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity != null && (header = httpEntity.getContentEncoding()) != null && (n2 = 0) < (n = (headerElementArray2 = (headerElementArray = header.getElements())).length)) {
            HeaderElement headerElement = headerElementArray2[n2];
            String string = headerElement.getName().toLowerCase(Locale.US);
            if ("gzip".equals(string) || "x-gzip".equals(string)) {
                httpResponse.setEntity(new GzipDecompressingEntity(httpResponse.getEntity()));
                return;
            }
            if ("deflate".equals(string)) {
                httpResponse.setEntity(new DeflateDecompressingEntity(httpResponse.getEntity()));
                return;
            }
            if ("identity".equals(string)) {
                return;
            }
            throw new HttpException("Unsupported Content-Coding: " + headerElement.getName());
        }
    }
}

