/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.client;

import ch.boye.httpclientandroidlib.HttpHost;
import ch.boye.httpclientandroidlib.annotation.NotThreadSafe;
import ch.boye.httpclientandroidlib.auth.AuthScheme;
import ch.boye.httpclientandroidlib.client.AuthCache;
import java.util.HashMap;

@NotThreadSafe
public class BasicAuthCache
implements AuthCache {
    private final HashMap<HttpHost, AuthScheme> map = new HashMap();

    public void put(HttpHost httpHost, AuthScheme authScheme) {
        if (httpHost == null) {
            throw new IllegalArgumentException("HTTP host may not be null");
        }
        this.map.put(httpHost, authScheme);
    }

    public AuthScheme get(HttpHost httpHost) {
        if (httpHost == null) {
            throw new IllegalArgumentException("HTTP host may not be null");
        }
        return this.map.get(httpHost);
    }

    public void remove(HttpHost httpHost) {
        if (httpHost == null) {
            throw new IllegalArgumentException("HTTP host may not be null");
        }
        this.map.remove(httpHost);
    }

    public void clear() {
        this.map.clear();
    }

    public String toString() {
        return this.map.toString();
    }
}

