/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.client;

import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.auth.AuthScheme;
import ch.boye.httpclientandroidlib.auth.AuthState;
import ch.boye.httpclientandroidlib.auth.Credentials;
import ch.boye.httpclientandroidlib.client.UserTokenHandler;
import ch.boye.httpclientandroidlib.conn.HttpRoutedConnection;
import ch.boye.httpclientandroidlib.protocol.HttpContext;
import java.security.Principal;
import javax.net.ssl.SSLSession;

@Immutable
public class DefaultUserTokenHandler
implements UserTokenHandler {
    public Object getUserToken(HttpContext httpContext) {
        SSLSession sSLSession;
        Object object;
        Principal principal = null;
        AuthState authState = (AuthState)httpContext.getAttribute("http.auth.target-scope");
        if (authState != null && (principal = DefaultUserTokenHandler.getAuthPrincipal(authState)) == null) {
            object = (AuthState)httpContext.getAttribute("http.auth.proxy-scope");
            principal = DefaultUserTokenHandler.getAuthPrincipal((AuthState)object);
        }
        if (principal == null && (object = (HttpRoutedConnection)httpContext.getAttribute("http.connection")).isOpen() && (sSLSession = object.getSSLSession()) != null) {
            principal = sSLSession.getLocalPrincipal();
        }
        return principal;
    }

    private static Principal getAuthPrincipal(AuthState authState) {
        Credentials credentials;
        AuthScheme authScheme = authState.getAuthScheme();
        if (authScheme != null && authScheme.isComplete() && authScheme.isConnectionBased() && (credentials = authState.getCredentials()) != null) {
            return credentials.getUserPrincipal();
        }
        return null;
    }
}

