/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.conn;

import ch.boye.httpclientandroidlib.HttpException;
import ch.boye.httpclientandroidlib.HttpHost;
import ch.boye.httpclientandroidlib.HttpRequest;
import ch.boye.httpclientandroidlib.annotation.ThreadSafe;
import ch.boye.httpclientandroidlib.conn.params.ConnRouteParams;
import ch.boye.httpclientandroidlib.conn.routing.HttpRoute;
import ch.boye.httpclientandroidlib.conn.routing.HttpRoutePlanner;
import ch.boye.httpclientandroidlib.conn.scheme.Scheme;
import ch.boye.httpclientandroidlib.conn.scheme.SchemeRegistry;
import ch.boye.httpclientandroidlib.protocol.HttpContext;
import java.net.InetAddress;

@ThreadSafe
public class DefaultHttpRoutePlanner
implements HttpRoutePlanner {
    protected final SchemeRegistry schemeRegistry;

    public DefaultHttpRoutePlanner(SchemeRegistry schemeRegistry) {
        if (schemeRegistry == null) {
            throw new IllegalArgumentException("SchemeRegistry must not be null.");
        }
        this.schemeRegistry = schemeRegistry;
    }

    public HttpRoute determineRoute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws HttpException {
        Scheme scheme;
        if (httpRequest == null) {
            throw new IllegalStateException("Request must not be null.");
        }
        HttpRoute httpRoute = ConnRouteParams.getForcedRoute(httpRequest.getParams());
        if (httpRoute != null) {
            return httpRoute;
        }
        if (httpHost == null) {
            throw new IllegalStateException("Target host must not be null.");
        }
        InetAddress inetAddress = ConnRouteParams.getLocalAddress(httpRequest.getParams());
        HttpHost httpHost2 = ConnRouteParams.getDefaultProxy(httpRequest.getParams());
        try {
            scheme = this.schemeRegistry.getScheme(httpHost.getSchemeName());
        }
        catch (IllegalStateException illegalStateException) {
            throw new HttpException(illegalStateException.getMessage());
        }
        boolean bl = scheme.isLayered();
        httpRoute = httpHost2 == null ? new HttpRoute(httpHost, inetAddress, bl) : new HttpRoute(httpHost, inetAddress, httpHost2, bl);
        return httpRoute;
    }
}

