/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.mozglue;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Environment;
import android.os.Process;
import android.util.Log;
import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.mozilla.gecko.mozglue.RobocopTarget;

public final class GeckoLoader {
    private static final String LOGTAG = "GeckoLoader";
    private static final String ANDROID_PACKAGE_NAME = "org.mozilla.fennec";
    private static volatile Intent sIntent;
    private static File sCacheFile;
    private static File sGREDir;
    private static final Object sLibLoadingLock;
    private static boolean sSQLiteLibsLoaded;
    private static boolean sNSSLibsLoaded;
    private static boolean sMozGlueLoaded;
    private static boolean sLibsSetup;

    private GeckoLoader() {
    }

    public static File getCacheDir(Context context) {
        if (sCacheFile == null) {
            sCacheFile = context.getCacheDir();
        }
        return sCacheFile;
    }

    public static File getGREDir(Context context) {
        if (sGREDir == null) {
            sGREDir = new File(context.getApplicationInfo().dataDir);
        }
        return sGREDir;
    }

    private static void setupPluginEnvironment(Context context, String[] stringArray) {
        try {
            if (stringArray == null) {
                GeckoLoader.putenv("MOZ_PLUGINS_BLOCKED=1");
                GeckoLoader.putenv("MOZ_PLUGIN_PATH=");
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append(stringArray[i]);
                stringBuilder.append(":");
            }
            GeckoLoader.putenv("MOZ_PLUGIN_PATH=" + stringBuilder);
            File file = context.getDir("plugins", 0);
            GeckoLoader.putenv("ANDROID_PLUGIN_DATADIR=" + file.getPath());
            File file2 = context.getDir("plugins_private", 0);
            GeckoLoader.putenv("ANDROID_PLUGIN_DATADIR_PRIVATE=" + file2.getPath());
        }
        catch (Exception exception) {
            Log.w((String)LOGTAG, (String)"Caught exception getting plugin dirs.", (Throwable)exception);
        }
    }

    private static void setupDownloadEnvironment(Context context) {
        try {
            File file = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
            File file2 = context.getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS);
            if (file == null) {
                file = new File(Environment.getExternalStorageDirectory().getPath(), "download");
            }
            if (file2 == null) {
                file2 = file;
            }
            GeckoLoader.putenv("DOWNLOADS_DIRECTORY=" + file.getPath());
            GeckoLoader.putenv("UPDATES_DIRECTORY=" + file2.getPath());
        }
        catch (Exception exception) {
            Log.w((String)LOGTAG, (String)"No download directory found.", (Throwable)exception);
        }
    }

    private static void delTree(File file) {
        if (file.isDirectory()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                GeckoLoader.delTree(file2);
            }
        }
        file.delete();
    }

    private static File getTmpDir(Context context) {
        File file = context.getDir("tmpdir", 0);
        File file2 = new File(file.getParentFile(), "app_tmp");
        if (file2.exists()) {
            GeckoLoader.delTree(file2);
        }
        return file;
    }

    public static void setLastIntent(Intent intent) {
        sIntent = intent;
    }

    public static void setupGeckoEnvironment(Context context, String[] stringArray, String string) {
        Object object;
        Intent intent = sIntent;
        if (intent != null) {
            object = intent.getStringExtra("env0");
            Log.d((String)LOGTAG, (String)("Gecko environment env0: " + (String)object));
            int n = 1;
            while (object != null) {
                GeckoLoader.putenv((String)object);
                object = intent.getStringExtra("env" + n);
                Log.d((String)LOGTAG, (String)("env" + n + ": " + (String)object));
                ++n;
            }
        }
        GeckoLoader.setupPluginEnvironment(context, stringArray);
        GeckoLoader.setupDownloadEnvironment(context);
        GeckoLoader.putenv("HOME=" + string);
        object = GeckoLoader.getTmpDir(context);
        if (!((File)object).exists()) {
            ((File)object).mkdirs();
        }
        GeckoLoader.putenv("TMPDIR=" + ((File)object).getPath());
        object = Environment.getDownloadCacheDirectory();
        GeckoLoader.putenv("EXTERNAL_STORAGE=" + ((File)object).getPath());
        object = context.getCacheDir();
        GeckoLoader.putenv("CACHE_DIRECTORY=" + ((File)object).getPath());
        try {
            Object object2 = context.getSystemService("user");
            if (object2 != null) {
                Object object3 = Process.class.getMethod("myUserHandle", null).invoke(null, new Object[0]);
                Object object4 = object2.getClass().getMethod("getSerialNumberForUser", object3.getClass()).invoke(object2, object3);
                GeckoLoader.putenv("MOZ_ANDROID_USER_SERIAL_NUMBER=" + object4.toString());
            }
        }
        catch (Exception exception) {
            Log.d((String)LOGTAG, (String)"Unable to set the user serial number", (Throwable)exception);
        }
        GeckoLoader.setupLocaleEnvironment();
        sIntent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLibsSetup(Context context) {
        String string;
        Object object = sLibLoadingLock;
        synchronized (object) {
            if (sLibsSetup) {
                return;
            }
            sLibsSetup = true;
        }
        object = GeckoLoader.getCacheDir(context);
        GeckoLoader.putenv("GRE_HOME=" + GeckoLoader.getGREDir(context).getPath());
        String string2 = System.getenv("MOZ_LINKER_CACHE");
        if (string2 == null) {
            string2 = ((File)object).getPath();
            GeckoLoader.putenv("MOZ_LINKER_CACHE=" + string2);
        }
        if ((string = System.getenv("MOZ_LINKER_ONDEMAND")) == null && "HTC".equals(Build.MANUFACTURER) && "HTC Vision".equals(Build.MODEL)) {
            GeckoLoader.putenv("MOZ_LINKER_ONDEMAND=0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RobocopTarget
    public static void loadSQLiteLibs(Context context, String string) {
        Object object = sLibLoadingLock;
        synchronized (object) {
            if (sSQLiteLibsLoaded) {
                return;
            }
            sSQLiteLibsLoaded = true;
        }
        GeckoLoader.loadMozGlue(context);
        GeckoLoader.loadLibsSetup(context);
        GeckoLoader.loadSQLiteLibsNative(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadNSSLibs(Context context, String string) {
        Object object = sLibLoadingLock;
        synchronized (object) {
            if (sNSSLibsLoaded) {
                return;
            }
            sNSSLibsLoaded = true;
        }
        GeckoLoader.loadMozGlue(context);
        GeckoLoader.loadLibsSetup(context);
        GeckoLoader.loadNSSLibsNative(string, false);
    }

    private static String getLoadDiagnostics(Context context, String string) {
        boolean bl;
        boolean bl2;
        StringBuilder stringBuilder = new StringBuilder("LOAD ");
        stringBuilder.append(string);
        stringBuilder.append(": Data: " + context.getApplicationInfo().dataDir);
        try {
            boolean bl3 = new File("/data/app-lib/org.mozilla.fennec/lib" + string + ".so").exists();
            bl2 = new File("/data/data/org.mozilla.fennec/lib/lib" + string + ".so").exists();
            stringBuilder.append(", ax=" + bl3);
            stringBuilder.append(", ddx=" + bl2);
        }
        catch (Throwable throwable) {
            stringBuilder.append(": ax/ddx fail, ");
        }
        try {
            bl = new File("/data/data/org.mozilla.fennec-1").exists();
            boolean bl4 = new File("/data/data/org.mozilla.fennec-2").exists();
            stringBuilder.append(", -1x=" + bl);
            stringBuilder.append(", -2x=" + bl4);
        }
        catch (Throwable throwable) {
            stringBuilder.append(", dash fail, ");
        }
        try {
            if (Build.VERSION.SDK_INT >= 9) {
                String string2 = context.getApplicationInfo().nativeLibraryDir;
                bl2 = new File(string2).exists();
                bl = new File(string2 + "/lib" + string + ".so").exists();
                stringBuilder.append(", nativeLib: " + string2);
                stringBuilder.append(", dirx=" + bl2);
                stringBuilder.append(", libx=" + bl);
            } else {
                stringBuilder.append(", <pre-9>");
            }
        }
        catch (Throwable throwable) {
            stringBuilder.append(", nativeLib fail.");
        }
        return stringBuilder.toString();
    }

    private static final boolean attemptLoad(String string) {
        try {
            System.load(string);
            return true;
        }
        catch (Throwable throwable) {
            Log.wtf((String)LOGTAG, (String)("Couldn't load " + string + ": " + throwable));
            return false;
        }
    }

    private static final Throwable doLoadLibraryExpected(Context context, String string) {
        try {
            System.loadLibrary(string);
            return null;
        }
        catch (Throwable throwable) {
            Log.wtf((String)LOGTAG, (String)("Couldn't load " + string + ". Trying native library dir."));
            if (Build.VERSION.SDK_INT < 9) {
                return throwable;
            }
            String string2 = context.getApplicationInfo().nativeLibraryDir;
            if (GeckoLoader.attemptLoad(string2 + "/lib" + string + ".so")) {
                return null;
            }
            return throwable;
        }
    }

    public static void doLoadLibrary(Context context, String string) {
        Throwable throwable = GeckoLoader.doLoadLibraryExpected(context, string);
        if (throwable == null) {
            return;
        }
        String string2 = context.getApplicationInfo().dataDir + "/lib/lib" + string + ".so";
        if (GeckoLoader.attemptLoad(string2)) {
            return;
        }
        if (GeckoLoader.attemptLoad("/data/app-lib/org.mozilla.fennec/lib" + string + ".so")) {
            return;
        }
        if (GeckoLoader.attemptLoad("/data/data/org.mozilla.fennec/lib/lib" + string + ".so")) {
            return;
        }
        String string3 = GeckoLoader.getLoadDiagnostics(context, string);
        Log.e((String)LOGTAG, (String)("Load diagnostics: " + string3));
        throw new RuntimeException(string3, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadMozGlue(Context context) {
        Object object = sLibLoadingLock;
        synchronized (object) {
            if (sMozGlueLoaded) {
                return;
            }
            sMozGlueLoaded = true;
        }
        GeckoLoader.doLoadLibrary(context, "mozglue");
    }

    public static void loadGeckoLibs(Context context, String string) {
        GeckoLoader.loadLibsSetup(context);
        GeckoLoader.loadGeckoLibsNative(string);
    }

    private static void setupLocaleEnvironment() {
        GeckoLoader.putenv("LANG=" + Locale.getDefault().toString());
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
            DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
            GeckoLoader.putenv("LOCALE_DECIMAL_POINT=" + decimalFormatSymbols.getDecimalSeparator());
            GeckoLoader.putenv("LOCALE_THOUSANDS_SEP=" + decimalFormatSymbols.getGroupingSeparator());
            GeckoLoader.putenv("LOCALE_GROUPING=" + (char)decimalFormat.getGroupingSize());
        }
    }

    private static native void putenv(String var0);

    public static native void nativeRun(String var0);

    private static native void loadGeckoLibsNative(String var0);

    private static native void loadSQLiteLibsNative(String var0, boolean var1);

    private static native void loadNSSLibsNative(String var0, boolean var1);

    static {
        sLibLoadingLock = new Object();
    }
}

