/*
 * Decompiled with CFR 0.152.
 */
package com.nineoldandroids.animation;

import android.view.animation.Interpolator;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Animator
implements Cloneable {
    ArrayList<AnimatorListener> mListeners = null;

    public void start() {
    }

    public void cancel() {
    }

    public void end() {
    }

    public abstract long getStartDelay();

    public abstract void setStartDelay(long var1);

    public abstract Animator setDuration(long var1);

    public abstract long getDuration();

    public abstract void setInterpolator(Interpolator var1);

    public abstract boolean isRunning();

    public boolean isStarted() {
        return this.isRunning();
    }

    public void addListener(AnimatorListener animatorListener) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        this.mListeners.add(animatorListener);
    }

    public void removeListener(AnimatorListener animatorListener) {
        if (this.mListeners == null) {
            return;
        }
        this.mListeners.remove(animatorListener);
        if (this.mListeners.size() == 0) {
            this.mListeners = null;
        }
    }

    public ArrayList<AnimatorListener> getListeners() {
        return this.mListeners;
    }

    public void removeAllListeners() {
        if (this.mListeners != null) {
            this.mListeners.clear();
            this.mListeners = null;
        }
    }

    public Animator clone() {
        try {
            Animator animator = (Animator)super.clone();
            if (this.mListeners != null) {
                ArrayList<AnimatorListener> arrayList = this.mListeners;
                animator.mListeners = new ArrayList();
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    animator.mListeners.add(arrayList.get(i));
                }
            }
            return animator;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    public void setupStartValues() {
    }

    public void setupEndValues() {
    }

    public void setTarget(Object object) {
    }

    public static interface AnimatorListener {
        public void onAnimationStart(Animator var1);

        public void onAnimationEnd(Animator var1);

        public void onAnimationCancel(Animator var1);

        public void onAnimationRepeat(Animator var1);
    }
}

