/*
 * Decompiled with CFR 0.152.
 */
package com.nineoldandroids.animation;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.util.Xml;
import android.view.animation.AnimationUtils;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorSet;
import com.nineoldandroids.animation.ArgbEvaluator;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.animation.ValueAnimator;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatorInflater {
    private static final int[] AnimatorSet = new int[]{16843490};
    private static final int AnimatorSet_ordering = 0;
    private static final int[] PropertyAnimator = new int[]{16843489};
    private static final int PropertyAnimator_propertyName = 0;
    private static final int[] Animator = new int[]{0x1010141, 16843160, 16843198, 16843199, 0x10101C0, 16843486, 16843487, 16843488};
    private static final int Animator_interpolator = 0;
    private static final int Animator_duration = 1;
    private static final int Animator_startOffset = 2;
    private static final int Animator_repeatCount = 3;
    private static final int Animator_repeatMode = 4;
    private static final int Animator_valueFrom = 5;
    private static final int Animator_valueTo = 6;
    private static final int Animator_valueType = 7;
    private static final int TOGETHER = 0;
    private static final int VALUE_TYPE_FLOAT = 0;

    public static Animator loadAnimator(Context context, int n) throws Resources.NotFoundException {
        XmlResourceParser xmlResourceParser = null;
        try {
            xmlResourceParser = context.getResources().getAnimation(n);
            Animator animator = AnimatorInflater.createAnimatorFromXml(context, (XmlPullParser)xmlResourceParser);
            return animator;
        }
        catch (XmlPullParserException xmlPullParserException) {
            Resources.NotFoundException notFoundException = new Resources.NotFoundException("Can't load animation resource ID #0x" + Integer.toHexString(n));
            notFoundException.initCause((Throwable)xmlPullParserException);
            throw notFoundException;
        }
        catch (IOException iOException) {
            Resources.NotFoundException notFoundException = new Resources.NotFoundException("Can't load animation resource ID #0x" + Integer.toHexString(n));
            notFoundException.initCause((Throwable)iOException);
            throw notFoundException;
        }
        finally {
            if (xmlResourceParser != null) {
                xmlResourceParser.close();
            }
        }
    }

    private static Animator createAnimatorFromXml(Context context, XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return AnimatorInflater.createAnimatorFromXml(context, xmlPullParser, Xml.asAttributeSet((XmlPullParser)xmlPullParser), null, 0);
    }

    private static Animator createAnimatorFromXml(Context context, XmlPullParser xmlPullParser, AttributeSet attributeSet, AnimatorSet animatorSet, int n) throws XmlPullParserException, IOException {
        Animator[] animatorArray;
        int n2;
        Animator animator = null;
        ArrayList<ObjectAnimator> arrayList = null;
        int n3 = xmlPullParser.getDepth();
        while (((n2 = xmlPullParser.next()) != 3 || xmlPullParser.getDepth() > n3) && n2 != 1) {
            if (n2 != 2) continue;
            animatorArray = xmlPullParser.getName();
            if (animatorArray.equals("objectAnimator")) {
                animator = AnimatorInflater.loadObjectAnimator(context, attributeSet);
            } else if (animatorArray.equals("animator")) {
                animator = AnimatorInflater.loadAnimator(context, attributeSet, null);
            } else if (animatorArray.equals("set")) {
                animator = new AnimatorSet();
                TypedArray typedArray = context.obtainStyledAttributes(attributeSet, AnimatorSet);
                TypedValue typedValue = new TypedValue();
                typedArray.getValue(0, typedValue);
                int n4 = typedValue.type == 16 ? typedValue.data : 0;
                AnimatorInflater.createAnimatorFromXml(context, xmlPullParser, attributeSet, (AnimatorSet)animator, n4);
                typedArray.recycle();
            } else {
                throw new RuntimeException("Unknown animator name: " + xmlPullParser.getName());
            }
            if (animatorSet == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<ObjectAnimator>();
            }
            arrayList.add((ObjectAnimator)animator);
        }
        if (animatorSet != null && arrayList != null) {
            animatorArray = new Animator[arrayList.size()];
            int n5 = 0;
            for (Animator animator2 : arrayList) {
                animatorArray[n5++] = animator2;
            }
            if (n == 0) {
                animatorSet.playTogether(animatorArray);
            } else {
                animatorSet.playSequentially(animatorArray);
            }
        }
        return animator;
    }

    private static ObjectAnimator loadObjectAnimator(Context context, AttributeSet attributeSet) throws Resources.NotFoundException {
        ObjectAnimator objectAnimator = new ObjectAnimator();
        AnimatorInflater.loadAnimator(context, attributeSet, objectAnimator);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, PropertyAnimator);
        String string = typedArray.getString(0);
        objectAnimator.setPropertyName(string);
        typedArray.recycle();
        return objectAnimator;
    }

    private static ValueAnimator loadAnimator(Context context, AttributeSet attributeSet, ValueAnimator valueAnimator) throws Resources.NotFoundException {
        int n;
        int n2;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, Animator);
        long l = typedArray.getInt(1, 0);
        long l2 = typedArray.getInt(2, 0);
        int n3 = typedArray.getInt(7, 0);
        if (valueAnimator == null) {
            valueAnimator = new ValueAnimator();
        }
        int n4 = 5;
        int n5 = 6;
        boolean bl = n3 == 0;
        TypedValue typedValue = typedArray.peekValue(n4);
        boolean bl2 = typedValue != null;
        int n6 = bl2 ? typedValue.type : 0;
        TypedValue typedValue2 = typedArray.peekValue(n5);
        boolean bl3 = typedValue2 != null;
        int n7 = n2 = bl3 ? typedValue2.type : 0;
        if (bl2 && n6 >= 28 && n6 <= 31 || bl3 && n2 >= 28 && n2 <= 31) {
            bl = false;
            valueAnimator.setEvaluator(new ArgbEvaluator());
        }
        if (bl) {
            if (bl2) {
                float f = n6 == 5 ? typedArray.getDimension(n4, 0.0f) : typedArray.getFloat(n4, 0.0f);
                if (bl3) {
                    float f2 = n2 == 5 ? typedArray.getDimension(n5, 0.0f) : typedArray.getFloat(n5, 0.0f);
                    valueAnimator.setFloatValues(f, f2);
                } else {
                    valueAnimator.setFloatValues(f);
                }
            } else {
                float f = n2 == 5 ? typedArray.getDimension(n5, 0.0f) : typedArray.getFloat(n5, 0.0f);
                valueAnimator.setFloatValues(f);
            }
        } else if (bl2) {
            int n8 = n6 == 5 ? (int)typedArray.getDimension(n4, 0.0f) : (n6 >= 28 && n6 <= 31 ? typedArray.getColor(n4, 0) : typedArray.getInt(n4, 0));
            if (bl3) {
                int n9 = n2 == 5 ? (int)typedArray.getDimension(n5, 0.0f) : (n2 >= 28 && n2 <= 31 ? typedArray.getColor(n5, 0) : typedArray.getInt(n5, 0));
                valueAnimator.setIntValues(n8, n9);
            } else {
                valueAnimator.setIntValues(n8);
            }
        } else if (bl3) {
            int n10 = n2 == 5 ? (int)typedArray.getDimension(n5, 0.0f) : (n2 >= 28 && n2 <= 31 ? typedArray.getColor(n5, 0) : typedArray.getInt(n5, 0));
            valueAnimator.setIntValues(n10);
        }
        valueAnimator.setDuration(l);
        valueAnimator.setStartDelay(l2);
        if (typedArray.hasValue(3)) {
            valueAnimator.setRepeatCount(typedArray.getInt(3, 0));
        }
        if (typedArray.hasValue(4)) {
            valueAnimator.setRepeatMode(typedArray.getInt(4, 1));
        }
        if ((n = typedArray.getResourceId(0, 0)) > 0) {
            valueAnimator.setInterpolator(AnimationUtils.loadInterpolator((Context)context, (int)n));
        }
        typedArray.recycle();
        return valueAnimator;
    }
}

