/*
 * Decompiled with CFR 0.152.
 */
package com.nineoldandroids.animation;

import android.view.animation.Interpolator;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorListenerAdapter;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.animation.ValueAnimator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnimatorSet
extends Animator {
    private ArrayList<Animator> mPlayingSet = new ArrayList();
    private HashMap<Animator, Node> mNodeMap = new HashMap();
    private ArrayList<Node> mNodes = new ArrayList();
    private ArrayList<Node> mSortedNodes = new ArrayList();
    private boolean mNeedsSort = true;
    private AnimatorSetListener mSetListener = null;
    boolean mTerminated = false;
    private boolean mStarted = false;
    private long mStartDelay = 0L;
    private ValueAnimator mDelayAnim = null;
    private long mDuration = -1L;

    public void playTogether(Animator ... animatorArray) {
        if (animatorArray != null) {
            this.mNeedsSort = true;
            Builder builder = this.play(animatorArray[0]);
            for (int i = 1; i < animatorArray.length; ++i) {
                builder.with(animatorArray[i]);
            }
        }
    }

    public void playTogether(Collection<Animator> collection) {
        if (collection != null && collection.size() > 0) {
            this.mNeedsSort = true;
            Builder builder = null;
            for (Animator animator : collection) {
                if (builder == null) {
                    builder = this.play(animator);
                    continue;
                }
                builder.with(animator);
            }
        }
    }

    public void playSequentially(Animator ... animatorArray) {
        if (animatorArray != null) {
            this.mNeedsSort = true;
            if (animatorArray.length == 1) {
                this.play(animatorArray[0]);
            } else {
                for (int i = 0; i < animatorArray.length - 1; ++i) {
                    this.play(animatorArray[i]).before(animatorArray[i + 1]);
                }
            }
        }
    }

    public void playSequentially(List<Animator> list) {
        if (list != null && list.size() > 0) {
            this.mNeedsSort = true;
            if (list.size() == 1) {
                this.play(list.get(0));
            } else {
                for (int i = 0; i < list.size() - 1; ++i) {
                    this.play(list.get(i)).before(list.get(i + 1));
                }
            }
        }
    }

    public ArrayList<Animator> getChildAnimations() {
        ArrayList<Animator> arrayList = new ArrayList<Animator>();
        for (Node node : this.mNodes) {
            arrayList.add(node.animation);
        }
        return arrayList;
    }

    @Override
    public void setTarget(Object object) {
        for (Node node : this.mNodes) {
            Animator animator = node.animation;
            if (animator instanceof AnimatorSet) {
                ((AnimatorSet)animator).setTarget(object);
                continue;
            }
            if (!(animator instanceof ObjectAnimator)) continue;
            ((ObjectAnimator)animator).setTarget(object);
        }
    }

    @Override
    public void setInterpolator(Interpolator interpolator) {
        for (Node node : this.mNodes) {
            node.animation.setInterpolator(interpolator);
        }
    }

    public Builder play(Animator animator) {
        if (animator != null) {
            this.mNeedsSort = true;
            return new Builder(animator);
        }
        return null;
    }

    @Override
    public void cancel() {
        this.mTerminated = true;
        if (this.isStarted()) {
            ArrayList arrayList = null;
            if (this.mListeners != null) {
                arrayList = (ArrayList)this.mListeners.clone();
                for (Animator.AnimatorListener object : arrayList) {
                    object.onAnimationCancel(this);
                }
            }
            if (this.mDelayAnim != null && this.mDelayAnim.isRunning()) {
                this.mDelayAnim.cancel();
            } else if (this.mSortedNodes.size() > 0) {
                for (Node node : this.mSortedNodes) {
                    node.animation.cancel();
                }
            }
            if (arrayList != null) {
                for (Animator.AnimatorListener animatorListener : arrayList) {
                    animatorListener.onAnimationEnd(this);
                }
            }
            this.mStarted = false;
        }
    }

    @Override
    public void end() {
        this.mTerminated = true;
        if (this.isStarted()) {
            if (this.mSortedNodes.size() != this.mNodes.size()) {
                this.sortNodes();
                for (Node object : this.mSortedNodes) {
                    if (this.mSetListener == null) {
                        this.mSetListener = new AnimatorSetListener(this);
                    }
                    object.animation.addListener(this.mSetListener);
                }
            }
            if (this.mDelayAnim != null) {
                this.mDelayAnim.cancel();
            }
            if (this.mSortedNodes.size() > 0) {
                for (Node node : this.mSortedNodes) {
                    node.animation.end();
                }
            }
            if (this.mListeners != null) {
                ArrayList arrayList = (ArrayList)this.mListeners.clone();
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Animator.AnimatorListener animatorListener = (Animator.AnimatorListener)iterator.next();
                    animatorListener.onAnimationEnd(this);
                }
            }
            this.mStarted = false;
        }
    }

    @Override
    public boolean isRunning() {
        for (Node node : this.mNodes) {
            if (!node.animation.isRunning()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStarted() {
        return this.mStarted;
    }

    @Override
    public long getStartDelay() {
        return this.mStartDelay;
    }

    @Override
    public void setStartDelay(long l) {
        this.mStartDelay = l;
    }

    @Override
    public long getDuration() {
        return this.mDuration;
    }

    @Override
    public AnimatorSet setDuration(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("duration must be a value of zero or greater");
        }
        for (Node node : this.mNodes) {
            node.animation.setDuration(l);
        }
        this.mDuration = l;
        return this;
    }

    @Override
    public void setupStartValues() {
        for (Node node : this.mNodes) {
            node.animation.setupStartValues();
        }
    }

    @Override
    public void setupEndValues() {
        for (Node node : this.mNodes) {
            node.animation.setupEndValues();
        }
    }

    @Override
    public void start() {
        Cloneable cloneable22;
        this.mTerminated = false;
        this.mStarted = true;
        this.sortNodes();
        int n = this.mSortedNodes.size();
        for (int i = 0; i < n; ++i) {
            Node node = this.mSortedNodes.get(i);
            cloneable22 = node.animation.getListeners();
            if (cloneable22 == null || cloneable22.size() <= 0) continue;
            ArrayList<Animator.AnimatorListener> arrayList = new ArrayList<Animator.AnimatorListener>((Collection<Animator.AnimatorListener>)((Object)cloneable22));
            for (Animator.AnimatorListener object : arrayList) {
                if (!(object instanceof DependencyListener) && !(object instanceof AnimatorSetListener)) continue;
                node.animation.removeListener(object);
            }
        }
        final ArrayList<ArrayList<Animator.AnimatorListener>> arrayList = new ArrayList<ArrayList<Animator.AnimatorListener>>();
        for (int i = 0; i < n; ++i) {
            cloneable22 = this.mSortedNodes.get(i);
            if (this.mSetListener == null) {
                this.mSetListener = new AnimatorSetListener(this);
            }
            if (((Node)cloneable22).dependencies == null || ((Node)cloneable22).dependencies.size() == 0) {
                arrayList.add((ArrayList<Animator.AnimatorListener>)cloneable22);
            } else {
                int n2 = ((Node)cloneable22).dependencies.size();
                for (int j = 0; j < n2; ++j) {
                    Dependency dependency = ((Node)cloneable22).dependencies.get(j);
                    dependency.node.animation.addListener(new DependencyListener(this, (Node)cloneable22, dependency.rule));
                }
                ((Node)cloneable22).tmpDependencies = (ArrayList)((Node)cloneable22).dependencies.clone();
            }
            ((Node)cloneable22).animation.addListener(this.mSetListener);
        }
        if (this.mStartDelay <= 0L) {
            for (Cloneable cloneable22 : arrayList) {
                ((Node)cloneable22).animation.start();
                this.mPlayingSet.add(((Node)cloneable22).animation);
            }
        } else {
            this.mDelayAnim = ValueAnimator.ofFloat(0.0f, 1.0f);
            this.mDelayAnim.setDuration(this.mStartDelay);
            this.mDelayAnim.addListener(new AnimatorListenerAdapter(){
                boolean canceled = false;

                public void onAnimationCancel(Animator animator) {
                    this.canceled = true;
                }

                public void onAnimationEnd(Animator animator) {
                    if (!this.canceled) {
                        int n = arrayList.size();
                        for (int i = 0; i < n; ++i) {
                            Node node = (Node)arrayList.get(i);
                            node.animation.start();
                            AnimatorSet.this.mPlayingSet.add(node.animation);
                        }
                    }
                }
            });
            this.mDelayAnim.start();
        }
        if (this.mListeners != null) {
            ArrayList arrayList2 = (ArrayList)this.mListeners.clone();
            int n3 = arrayList2.size();
            for (int i = 0; i < n3; ++i) {
                ((Animator.AnimatorListener)arrayList2.get(i)).onAnimationStart(this);
            }
        }
        if (this.mNodes.size() == 0 && this.mStartDelay == 0L) {
            this.mStarted = false;
            if (this.mListeners != null) {
                ArrayList arrayList3 = (ArrayList)this.mListeners.clone();
                int n4 = arrayList3.size();
                for (int i = 0; i < n4; ++i) {
                    ((Animator.AnimatorListener)arrayList3.get(i)).onAnimationEnd(this);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AnimatorSet clone() {
        Node node;
        AnimatorSet animatorSet = (AnimatorSet)super.clone();
        animatorSet.mNeedsSort = true;
        animatorSet.mTerminated = false;
        animatorSet.mStarted = false;
        animatorSet.mPlayingSet = new ArrayList();
        animatorSet.mNodeMap = new HashMap();
        animatorSet.mNodes = new ArrayList();
        animatorSet.mSortedNodes = new ArrayList();
        HashMap<Node, Node> hashMap = new HashMap<Node, Node>();
        for (Node node2 : this.mNodes) {
            void object2;
            node = node2.clone();
            hashMap.put(node2, node);
            animatorSet.mNodes.add(node);
            animatorSet.mNodeMap.put(node.animation, node);
            node.dependencies = null;
            node.tmpDependencies = null;
            node.nodeDependents = null;
            node.nodeDependencies = null;
            ArrayList<Animator.AnimatorListener> arrayList = node.animation.getListeners();
            if (arrayList == null) continue;
            Object var7_8 = null;
            for (Animator.AnimatorListener animatorListener : arrayList) {
                if (!(animatorListener instanceof AnimatorSetListener)) continue;
                if (object2 == null) {
                    ArrayList arrayList2 = new ArrayList();
                }
                object2.add(animatorListener);
            }
            if (object2 == null) continue;
            for (Animator.AnimatorListener animatorListener : object2) {
                arrayList.remove(animatorListener);
            }
        }
        for (Node node2 : this.mNodes) {
            node = (Node)hashMap.get(node2);
            if (node2.dependencies == null) continue;
            for (Dependency dependency : node2.dependencies) {
                Iterator iterator = (Node)hashMap.get(dependency.node);
                Dependency dependency2 = new Dependency((Node)((Object)iterator), dependency.rule);
                node.addDependency(dependency2);
            }
        }
        return animatorSet;
    }

    private void sortNodes() {
        if (this.mNeedsSort) {
            this.mSortedNodes.clear();
            ArrayList<Node> arrayList = new ArrayList<Node>();
            int n = this.mNodes.size();
            for (int i = 0; i < n; ++i) {
                Node node = this.mNodes.get(i);
                if (node.dependencies != null && node.dependencies.size() != 0) continue;
                arrayList.add(node);
            }
            ArrayList<Node> arrayList2 = new ArrayList<Node>();
            while (arrayList.size() > 0) {
                int n2 = arrayList.size();
                for (int i = 0; i < n2; ++i) {
                    Node node = (Node)arrayList.get(i);
                    this.mSortedNodes.add(node);
                    if (node.nodeDependents == null) continue;
                    int n3 = node.nodeDependents.size();
                    for (int j = 0; j < n3; ++j) {
                        Node node2 = node.nodeDependents.get(j);
                        node2.nodeDependencies.remove(node);
                        if (node2.nodeDependencies.size() != 0) continue;
                        arrayList2.add(node2);
                    }
                }
                arrayList.clear();
                arrayList.addAll(arrayList2);
                arrayList2.clear();
            }
            this.mNeedsSort = false;
            if (this.mSortedNodes.size() != this.mNodes.size()) {
                throw new IllegalStateException("Circular dependencies cannot exist in AnimatorSet");
            }
        } else {
            int n = this.mNodes.size();
            for (int i = 0; i < n; ++i) {
                Node node = this.mNodes.get(i);
                if (node.dependencies != null && node.dependencies.size() > 0) {
                    int n4 = node.dependencies.size();
                    for (int j = 0; j < n4; ++j) {
                        Dependency dependency = node.dependencies.get(j);
                        if (node.nodeDependencies == null) {
                            node.nodeDependencies = new ArrayList();
                        }
                        if (node.nodeDependencies.contains(dependency.node)) continue;
                        node.nodeDependencies.add(dependency.node);
                    }
                }
                node.done = false;
            }
        }
    }

    public class Builder {
        private Node mCurrentNode;

        Builder(Animator animator) {
            this.mCurrentNode = (Node)AnimatorSet.this.mNodeMap.get(animator);
            if (this.mCurrentNode == null) {
                this.mCurrentNode = new Node(animator);
                AnimatorSet.this.mNodeMap.put(animator, this.mCurrentNode);
                AnimatorSet.this.mNodes.add(this.mCurrentNode);
            }
        }

        public Builder with(Animator animator) {
            Node node = (Node)AnimatorSet.this.mNodeMap.get(animator);
            if (node == null) {
                node = new Node(animator);
                AnimatorSet.this.mNodeMap.put(animator, node);
                AnimatorSet.this.mNodes.add(node);
            }
            Dependency dependency = new Dependency(this.mCurrentNode, 0);
            node.addDependency(dependency);
            return this;
        }

        public Builder before(Animator animator) {
            Node node = (Node)AnimatorSet.this.mNodeMap.get(animator);
            if (node == null) {
                node = new Node(animator);
                AnimatorSet.this.mNodeMap.put(animator, node);
                AnimatorSet.this.mNodes.add(node);
            }
            Dependency dependency = new Dependency(this.mCurrentNode, 1);
            node.addDependency(dependency);
            return this;
        }

        public Builder after(Animator animator) {
            Node node = (Node)AnimatorSet.this.mNodeMap.get(animator);
            if (node == null) {
                node = new Node(animator);
                AnimatorSet.this.mNodeMap.put(animator, node);
                AnimatorSet.this.mNodes.add(node);
            }
            Dependency dependency = new Dependency(node, 1);
            this.mCurrentNode.addDependency(dependency);
            return this;
        }

        public Builder after(long l) {
            ValueAnimator valueAnimator = ValueAnimator.ofFloat(0.0f, 1.0f);
            valueAnimator.setDuration(l);
            this.after(valueAnimator);
            return this;
        }
    }

    private static class Node
    implements Cloneable {
        public Animator animation;
        public ArrayList<Dependency> dependencies = null;
        public ArrayList<Dependency> tmpDependencies = null;
        public ArrayList<Node> nodeDependencies = null;
        public ArrayList<Node> nodeDependents = null;
        public boolean done = false;

        public Node(Animator animator) {
            this.animation = animator;
        }

        public void addDependency(Dependency dependency) {
            if (this.dependencies == null) {
                this.dependencies = new ArrayList();
                this.nodeDependencies = new ArrayList();
            }
            this.dependencies.add(dependency);
            if (!this.nodeDependencies.contains(dependency.node)) {
                this.nodeDependencies.add(dependency.node);
            }
            Node node = dependency.node;
            if (node.nodeDependents == null) {
                node.nodeDependents = new ArrayList();
            }
            node.nodeDependents.add(this);
        }

        public Node clone() {
            try {
                Node node = (Node)super.clone();
                node.animation = this.animation.clone();
                return node;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError();
            }
        }
    }

    private static class Dependency {
        static final int WITH = 0;
        static final int AFTER = 1;
        public Node node;
        public int rule;

        public Dependency(Node node, int n) {
            this.node = node;
            this.rule = n;
        }
    }

    private class AnimatorSetListener
    implements Animator.AnimatorListener {
        private AnimatorSet mAnimatorSet;

        AnimatorSetListener(AnimatorSet animatorSet2) {
            this.mAnimatorSet = animatorSet2;
        }

        public void onAnimationCancel(Animator animator) {
            if (!AnimatorSet.this.mTerminated && AnimatorSet.this.mPlayingSet.size() == 0 && AnimatorSet.this.mListeners != null) {
                int n = AnimatorSet.this.mListeners.size();
                for (int i = 0; i < n; ++i) {
                    ((Animator.AnimatorListener)AnimatorSet.this.mListeners.get(i)).onAnimationCancel(this.mAnimatorSet);
                }
            }
        }

        public void onAnimationEnd(Animator animator) {
            animator.removeListener(this);
            AnimatorSet.this.mPlayingSet.remove(animator);
            Node node = (Node)this.mAnimatorSet.mNodeMap.get(animator);
            node.done = true;
            if (!AnimatorSet.this.mTerminated) {
                ArrayList arrayList = this.mAnimatorSet.mSortedNodes;
                boolean bl = true;
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    if (((Node)arrayList.get((int)i)).done) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    if (AnimatorSet.this.mListeners != null) {
                        ArrayList arrayList2 = (ArrayList)AnimatorSet.this.mListeners.clone();
                        int n2 = arrayList2.size();
                        for (int i = 0; i < n2; ++i) {
                            ((Animator.AnimatorListener)arrayList2.get(i)).onAnimationEnd(this.mAnimatorSet);
                        }
                    }
                    this.mAnimatorSet.mStarted = false;
                }
            }
        }

        public void onAnimationRepeat(Animator animator) {
        }

        public void onAnimationStart(Animator animator) {
        }
    }

    private static class DependencyListener
    implements Animator.AnimatorListener {
        private AnimatorSet mAnimatorSet;
        private Node mNode;
        private int mRule;

        public DependencyListener(AnimatorSet animatorSet, Node node, int n) {
            this.mAnimatorSet = animatorSet;
            this.mNode = node;
            this.mRule = n;
        }

        public void onAnimationCancel(Animator animator) {
        }

        public void onAnimationEnd(Animator animator) {
            if (this.mRule == 1) {
                this.startIfReady(animator);
            }
        }

        public void onAnimationRepeat(Animator animator) {
        }

        public void onAnimationStart(Animator animator) {
            if (this.mRule == 0) {
                this.startIfReady(animator);
            }
        }

        private void startIfReady(Animator animator) {
            if (this.mAnimatorSet.mTerminated) {
                return;
            }
            Dependency dependency = null;
            int n = this.mNode.tmpDependencies.size();
            for (int i = 0; i < n; ++i) {
                Dependency dependency2 = this.mNode.tmpDependencies.get(i);
                if (dependency2.rule != this.mRule || dependency2.node.animation != animator) continue;
                dependency = dependency2;
                animator.removeListener(this);
                break;
            }
            this.mNode.tmpDependencies.remove(dependency);
            if (this.mNode.tmpDependencies.size() == 0) {
                this.mNode.animation.start();
                this.mAnimatorSet.mPlayingSet.add(this.mNode.animation);
            }
        }
    }
}

