/*
 * Decompiled with CFR 0.152.
 */
package com.nineoldandroids.animation;

import android.view.animation.Interpolator;
import com.nineoldandroids.animation.Keyframe;
import com.nineoldandroids.animation.KeyframeSet;
import java.util.ArrayList;

class IntKeyframeSet
extends KeyframeSet {
    private int firstValue;
    private int lastValue;
    private int deltaValue;
    private boolean firstTime = true;

    public IntKeyframeSet(Keyframe.IntKeyframe ... intKeyframeArray) {
        super(intKeyframeArray);
    }

    public Object getValue(float f) {
        return this.getIntValue(f);
    }

    public IntKeyframeSet clone() {
        ArrayList arrayList = this.mKeyframes;
        int n = this.mKeyframes.size();
        Keyframe.IntKeyframe[] intKeyframeArray = new Keyframe.IntKeyframe[n];
        for (int i = 0; i < n; ++i) {
            intKeyframeArray[i] = (Keyframe.IntKeyframe)((Keyframe)arrayList.get(i)).clone();
        }
        IntKeyframeSet intKeyframeSet = new IntKeyframeSet(intKeyframeArray);
        return intKeyframeSet;
    }

    public int getIntValue(float f) {
        if (this.mNumKeyframes == 2) {
            if (this.firstTime) {
                this.firstTime = false;
                this.firstValue = ((Keyframe.IntKeyframe)this.mKeyframes.get(0)).getIntValue();
                this.lastValue = ((Keyframe.IntKeyframe)this.mKeyframes.get(1)).getIntValue();
                this.deltaValue = this.lastValue - this.firstValue;
            }
            if (this.mInterpolator != null) {
                f = this.mInterpolator.getInterpolation(f);
            }
            if (this.mEvaluator == null) {
                return this.firstValue + (int)(f * (float)this.deltaValue);
            }
            return ((Number)this.mEvaluator.evaluate(f, this.firstValue, this.lastValue)).intValue();
        }
        if (f <= 0.0f) {
            Keyframe.IntKeyframe intKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(0);
            Keyframe.IntKeyframe intKeyframe2 = (Keyframe.IntKeyframe)this.mKeyframes.get(1);
            int n = intKeyframe.getIntValue();
            int n2 = intKeyframe2.getIntValue();
            float f2 = intKeyframe.getFraction();
            float f3 = intKeyframe2.getFraction();
            Interpolator interpolator = intKeyframe2.getInterpolator();
            if (interpolator != null) {
                f = interpolator.getInterpolation(f);
            }
            float f4 = (f - f2) / (f3 - f2);
            return this.mEvaluator == null ? n + (int)(f4 * (float)(n2 - n)) : ((Number)this.mEvaluator.evaluate(f4, n, n2)).intValue();
        }
        if (f >= 1.0f) {
            Keyframe.IntKeyframe intKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(this.mNumKeyframes - 2);
            Keyframe.IntKeyframe intKeyframe3 = (Keyframe.IntKeyframe)this.mKeyframes.get(this.mNumKeyframes - 1);
            int n = intKeyframe.getIntValue();
            int n3 = intKeyframe3.getIntValue();
            float f5 = intKeyframe.getFraction();
            float f6 = intKeyframe3.getFraction();
            Interpolator interpolator = intKeyframe3.getInterpolator();
            if (interpolator != null) {
                f = interpolator.getInterpolation(f);
            }
            float f7 = (f - f5) / (f6 - f5);
            return this.mEvaluator == null ? n + (int)(f7 * (float)(n3 - n)) : ((Number)this.mEvaluator.evaluate(f7, n, n3)).intValue();
        }
        Keyframe.IntKeyframe intKeyframe = (Keyframe.IntKeyframe)this.mKeyframes.get(0);
        for (int i = 1; i < this.mNumKeyframes; ++i) {
            Keyframe.IntKeyframe intKeyframe4 = (Keyframe.IntKeyframe)this.mKeyframes.get(i);
            if (f < intKeyframe4.getFraction()) {
                Interpolator interpolator = intKeyframe4.getInterpolator();
                if (interpolator != null) {
                    f = interpolator.getInterpolation(f);
                }
                float f8 = (f - intKeyframe.getFraction()) / (intKeyframe4.getFraction() - intKeyframe.getFraction());
                int n = intKeyframe.getIntValue();
                int n4 = intKeyframe4.getIntValue();
                return this.mEvaluator == null ? n + (int)(f8 * (float)(n4 - n)) : ((Number)this.mEvaluator.evaluate(f8, n, n4)).intValue();
            }
            intKeyframe = intKeyframe4;
        }
        return ((Number)((Keyframe)this.mKeyframes.get(this.mNumKeyframes - 1)).getValue()).intValue();
    }
}

