/*
 * Decompiled with CFR 0.152.
 */
package com.nineoldandroids.animation;

import android.view.animation.Interpolator;

public abstract class Keyframe
implements Cloneable {
    float mFraction;
    Class mValueType;
    private Interpolator mInterpolator = null;
    boolean mHasValue = false;

    public static Keyframe ofInt(float f, int n) {
        return new IntKeyframe(f, n);
    }

    public static Keyframe ofInt(float f) {
        return new IntKeyframe(f);
    }

    public static Keyframe ofFloat(float f, float f2) {
        return new FloatKeyframe(f, f2);
    }

    public static Keyframe ofFloat(float f) {
        return new FloatKeyframe(f);
    }

    public static Keyframe ofObject(float f, Object object) {
        return new ObjectKeyframe(f, object);
    }

    public static Keyframe ofObject(float f) {
        return new ObjectKeyframe(f, null);
    }

    public boolean hasValue() {
        return this.mHasValue;
    }

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public float getFraction() {
        return this.mFraction;
    }

    public void setFraction(float f) {
        this.mFraction = f;
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    public Class getType() {
        return this.mValueType;
    }

    public abstract Keyframe clone();

    static class FloatKeyframe
    extends Keyframe {
        float mValue;

        FloatKeyframe(float f, float f2) {
            this.mFraction = f;
            this.mValue = f2;
            this.mValueType = Float.TYPE;
            this.mHasValue = true;
        }

        FloatKeyframe(float f) {
            this.mFraction = f;
            this.mValueType = Float.TYPE;
        }

        public float getFloatValue() {
            return this.mValue;
        }

        public Object getValue() {
            return Float.valueOf(this.mValue);
        }

        public void setValue(Object object) {
            if (object != null && object.getClass() == Float.class) {
                this.mValue = ((Float)object).floatValue();
                this.mHasValue = true;
            }
        }

        public FloatKeyframe clone() {
            FloatKeyframe floatKeyframe = new FloatKeyframe(this.getFraction(), this.mValue);
            floatKeyframe.setInterpolator(this.getInterpolator());
            return floatKeyframe;
        }
    }

    static class IntKeyframe
    extends Keyframe {
        int mValue;

        IntKeyframe(float f, int n) {
            this.mFraction = f;
            this.mValue = n;
            this.mValueType = Integer.TYPE;
            this.mHasValue = true;
        }

        IntKeyframe(float f) {
            this.mFraction = f;
            this.mValueType = Integer.TYPE;
        }

        public int getIntValue() {
            return this.mValue;
        }

        public Object getValue() {
            return this.mValue;
        }

        public void setValue(Object object) {
            if (object != null && object.getClass() == Integer.class) {
                this.mValue = (Integer)object;
                this.mHasValue = true;
            }
        }

        public IntKeyframe clone() {
            IntKeyframe intKeyframe = new IntKeyframe(this.getFraction(), this.mValue);
            intKeyframe.setInterpolator(this.getInterpolator());
            return intKeyframe;
        }
    }

    static class ObjectKeyframe
    extends Keyframe {
        Object mValue;

        ObjectKeyframe(float f, Object object) {
            this.mFraction = f;
            this.mValue = object;
            this.mHasValue = object != null;
            this.mValueType = this.mHasValue ? object.getClass() : Object.class;
        }

        public Object getValue() {
            return this.mValue;
        }

        public void setValue(Object object) {
            this.mValue = object;
            this.mHasValue = object != null;
        }

        public ObjectKeyframe clone() {
            ObjectKeyframe objectKeyframe = new ObjectKeyframe(this.getFraction(), this.mValue);
            objectKeyframe.setInterpolator(this.getInterpolator());
            return objectKeyframe;
        }
    }
}

